package com.gmei.data.gateway.server.service.impl;

import com.gmei.data.gateway.server.common.Constants;
import com.gmei.data.gateway.server.service.EmailService;
import com.gmei.data.gateway.server.utils.DateUtils;
import com.gmei.data.gateway.server.utils.ProperUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.io.FileSystemResource;
import org.springframework.mail.javamail.JavaMailSender;
import org.springframework.mail.javamail.MimeMessageHelper;
import org.springframework.stereotype.Component;

import javax.mail.MessagingException;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeUtility;
import java.io.File;


@Component
public class EmailServiceImpl implements EmailService {
    @Value("${mail.fromMail.addr}")
    private String from;
    @Value("${mail.fromMail.content}")
    private String content;
    @Value("${mail.toMail.bcc}")
    private String bcc;
    @Value("${excel.output.path}")
    private String filePath;
    @Value("${proper.file.path}")
    private String properFilePath;
    @Autowired
    private JavaMailSender mailSender;
    private static final Logger logger = LoggerFactory.getLogger(EmailServiceImpl.class);

    @Override
    public int sendAttachmentsMail(String to,String cc,String name){
        int rs = Constants.SUCCESS;

        String subject = "";
        String value = ProperUtils.getValue(properFilePath, name);
        if(null != value){
            subject = value;
        }else{
            subject = name;
        }

        MimeMessage message = mailSender.createMimeMessage();
        try {
            //MimeMessageHelper helper = new MimeMessageHelper(message, true);
            MimeMessageHelper helper = new MimeMessageHelper(message, true,"UTF-8");
            helper.setFrom(from);
            String[] toUsers = to.split(",");
            helper.setTo(toUsers);
            helper.setSubject(subject);
            helper.setText(content, true);
            if (cc != null && !"".equals(cc.trim())) {
                helper.setCc(cc);
            }
            if (bcc != null && !"".equals(bcc.trim())) {
                helper.setBcc(bcc);
            }
            String fileName = subject + "-" + DateUtils.getCurrentDateSimpleStr() + ".xlsx";
            String fileNameSrc = name + "-" + DateUtils.getCurrentDateSimpleStr() + ".xlsx";
            FileSystemResource file = new FileSystemResource(new File(filePath + fileNameSrc));
            helper.addAttachment(fileName, file);
            //helper.addAttachment(MimeUtility.encodeWord(file.getFilename(),"utf-8","B"), file);
            mailSender.send(message);
            logger.info("带附件的邮件已经发送。");
        } catch (Exception e) {
            logger.error("发送带附件的邮件时发生异常！", e);
            rs = Constants.FAIL;
        }
        return rs;
    }
}
