package com.gmei.data.gateway.server.service.impl;

import com.gmei.data.gateway.server.common.Constants;
import com.gmei.data.gateway.server.dto.ExcelGenDto;
import com.gmei.data.gateway.server.service.ExcelService;
import com.gmei.data.gateway.server.utils.DateUtils;
import com.gmei.data.gateway.server.utils.ProperUtils;
import org.apache.poi.ss.usermodel.BorderStyle;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.VerticalAlignment;
import org.apache.poi.xssf.usermodel.*;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

import java.io.ByteArrayOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;

/**
 * ClassName: ExcelServiceImpl
 * Function: Excel业务处理类.
 * Date: 2020-04-28 20:57
 *
 * @since JDK 1.8
 */
@Service
public class ExcelServiceImpl implements ExcelService {

    @Value("${excel.output.path}")
    private String filePath;
    @Value("${proper.file.path}")
    private String properFilePath;
    private static final Logger logger = LoggerFactory.getLogger(ExcelServiceImpl.class);

    /**
     * Excel流输出
     * @return
     */
    @Override
    public int genExcel(ExcelGenDto excelGenDto, String name) {
        int rs = Constants.SUCCESS;
        List<String> sheetNameList = excelGenDto.getSheetNameList();
        List<List<String>> headersList = excelGenDto.getHeadersList();
        List<List<List>> rowsList = excelGenDto.getRowsList();
        XSSFWorkbook wb = new XSSFWorkbook();
        if(null != sheetNameList && sheetNameList.size() > 0){
            List<XSSFSheet> sheets = new ArrayList<XSSFSheet>();
            for(int i=0;i<sheetNameList.size();i++){
                XSSFSheet sheet = wb.createSheet(sheetNameList.get(i));
                sheets.add(sheet);
            }
            this.output(wb,sheets,headersList,rowsList);
        }else{
            rs = Constants.FAIL;
            logger.error("Error!");
        }
//        String subject = "";
//        String value = ProperUtils.getValue(properFilePath, name);
//        if(null != value){
//            subject = value;
//        }else{
//            subject = name;
//        }
        try {
            FileOutputStream out = new FileOutputStream(filePath + name + "-" + DateUtils.getCurrentDateSimpleStr() + ".xlsx");
            wb.write(out);
            out.close();
        } catch (IOException e) {
            rs = Constants.FAIL;
            e.printStackTrace();
        }
        return rs;
    }

    /**
     * 输出包含多个sheet的excel文件
     * @param sheetList
     */
    public void output(XSSFWorkbook wb,List<XSSFSheet> sheetList,List<List<String>> headersList, List<List<List>> rowsList){
        XSSFCellStyle cellStyle=wb.createCellStyle();
        cellStyle.setVerticalAlignment(VerticalAlignment.CENTER);
        cellStyle.setAlignment(HorizontalAlignment.CENTER);
        cellStyle.setBorderBottom(BorderStyle.THIN);
        cellStyle.setBorderLeft(BorderStyle.THIN);
        cellStyle.setBorderRight(BorderStyle.THIN);
        cellStyle.setBorderTop(BorderStyle.THIN);
        for(int i =0;i<sheetList.size();i++){
            XSSFSheet sheet = sheetList.get(i);
            List<String> headers = headersList.get(i);
            List<List> rows = rowsList.get(i);

            XSSFRow header = sheet.createRow(0);
            //设置sheet头部列宽
            for(int ii=0;ii<headers.size();ii++){
                sheet.setColumnWidth(ii,20*256);
            }
            //给sheet头部赋值以及设置样式
            Integer columIndex = 0;
            for(String str: headers){
                XSSFCell cell = header.createCell(columIndex);
                cell.setCellValue(str);
                cell.setCellStyle(cellStyle);
                columIndex++;
            }
            Integer rowIndex = 1;
            for(List row: rows){
                XSSFRow hssfRow = sheet.createRow(rowIndex);
                //设置单元格长度
                for(int ii=0;ii<row.size();ii++){
                    sheet.setColumnWidth(ii,20*256);
                }
                //依次给单元格赋值
                Integer j = 0;
                for(Object value: row){
                    XSSFCell cell = hssfRow.createCell(j);
                    cell.setCellStyle(cellStyle);
                    this.setCellValue(cell, value);
                    j++;
                }
                rowIndex ++;
            }
        }
    }

    /**
     * Excel单元格赋值
     * @param cell
     * @param value
     */
    private void setCellValue(XSSFCell cell, Object value) {
        if (value instanceof String) {
            cell.setCellValue((String) value);
        } else if (value instanceof Integer) {
            cell.setCellValue((Integer) value);
        } else if (value instanceof Float) {
            cell.setCellValue((Float) value);
        } else if (value instanceof Double){
            cell.setCellValue((Double)value);
        } else if (value instanceof Date) {
            cell.setCellValue((Date) value);
        } else if (value instanceof Boolean) {
            cell.setCellValue((Boolean) value);
        } else {
            throw new RuntimeException(" not support type " + value.getClass().toString());
        }
    }
}

