SELECT `日期`,`设备类型`,`活跃类型`,`渠道`
     ,`美购详情页浏览pv`
     ,(`加购物车点击pv`+`评价列表页点击pv`+`立即支付点击pv`+`私信及电话咨询pv` +`选择美购项目点击pv`
    +`机构主页点击pv`+`机构的其他美购点击pv`+`推荐美购点击pv`+`收藏点击pv`
    +`右上角购物车点击pv`+`医生主页点击pv`+`分享点击pv`+`机构导航点击pv`) as `美购详情页分发pv加总`
     ,concat(round((`加购物车点击pv`+`评价列表页点击pv`+`立即支付点击pv`+`私信及电话咨询pv` +`选择美购项目点击pv`
    +`机构主页点击pv`+`机构的其他美购点击pv`+`推荐美购点击pv`+`收藏点击pv`
    +`右上角购物车点击pv`+`医生主页点击pv`+`分享点击pv`+`机构导航点击pv`)/`美购详情页浏览pv`*100,2),'%') as `美购详情页分发pv占比加总`
     ,`加购物车点击pv`
     ,concat(round(`加购物车点击pv`/`美购详情页浏览pv`*100,2),'%') as `加购物车点击pv占比`
     ,`评价列表页点击pv`
     ,concat(round(`评价列表页点击pv`/`美购详情页浏览pv`*100,2),'%') as `评价列表页点击pv占比`
     ,`立即支付点击pv`
     ,concat(round(`立即支付点击pv`/`美购详情页浏览pv`*100,2),'%') as `立即支付点击pv占比`
     ,`私信及电话咨询pv`
     ,concat(round(`私信及电话咨询pv`/`美购详情页浏览pv`*100,2),'%') as `私信及电话咨询pv占比`
     ,`选择美购项目点击pv`
     ,concat(round(`选择美购项目点击pv`/`美购详情页浏览pv`*100,2),'%') as `选择美购项目点击pv占比`
     ,`机构主页点击pv`
     ,concat(round(`机构主页点击pv`/`美购详情页浏览pv`*100,2),'%') as `机构主页点击pv占比`
     ,`机构的其他美购点击pv`
     ,concat(round(`机构的其他美购点击pv`/`美购详情页浏览pv`*100,2),'%') as `机构的其他美购点击pv占比`
     ,`推荐美购点击pv`
     ,concat(round(`推荐美购点击pv`/`美购详情页浏览pv`*100,2),'%') as `推荐美购点击pv占比`
     ,`收藏点击pv`
     ,concat(round(`收藏点击pv`/`美购详情页浏览pv`*100,2),'%') as `收藏点击pv占比`
     ,`右上角购物车点击pv`
     ,concat(round(`右上角购物车点击pv`/`美购详情页浏览pv`*100,2),'%') as `右上角购物车点击pv占比`
     ,`医生主页点击pv`
     ,concat(round(`医生主页点击pv`/`美购详情页浏览pv`*100,2),'%') as `医生主页点击pv占比`
     ,`分享点击pv`
     ,concat(round(`分享点击pv`/`美购详情页浏览pv`*100,2),'%') as `分享点击pv占比`
     ,`机构导航点击pv`
     ,concat(round(`机构导航点击pv`/`美购详情页浏览pv`*100,2),'%') as `机构导航点击pv占比`

FROM
    (
        SELECT t1.partition_date as `日期`
             ,t1.device_os_type as `设备类型`
             ,t1.active_type as `活跃类型`
             ,t2.channel as `渠道`
             ,count(case when type='美购详情页' then cl_id end ) as `美购详情页浏览pv`
             ,count(case when type='加购物车' then cl_id end ) as `加购物车点击pv`
             ,count(case when type='评价列表页' then cl_id end ) as `评价列表页点击pv`
             ,count(case when type='立即支付' then cl_id end ) as `立即支付点击pv`
             ,count(case when type='私信及电话咨询' then cl_id end ) as `私信及电话咨询pv`
             ,count(case when type='选择美购项目' then cl_id end ) as `选择美购项目点击pv`
             ,count(case when type='机构主页' then cl_id end ) as `机构主页点击pv`
             ,count(case when type='机构的其他美购' then cl_id end ) as `机构的其他美购点击pv`
             ,count(case when type='推荐美购' then cl_id end ) as `推荐美购点击pv`
             ,count(case when type='收藏' then cl_id end ) as `收藏点击pv`
             ,count(case when type='右上角购物车' then cl_id end ) as `右上角购物车点击pv`
             ,count(case when type='医生主页' then cl_id end ) as `医生主页点击pv`
             ,count(case when type='分享' then cl_id end ) as `分享点击pv`
             ,count(case when type='机构导航' then cl_id end ) as `机构导航点击pv`

        FROM
            (
                SELECT click.partition_date,click.cl_id,click.type,mas.active_type,mas.device_os_type,mas.channel
                FROM
                    (	--浏览需要去掉疑似机构刷量的设备
			SELECT  pv.partition_date as partition_date,pv.cl_id as cl_id,type
			FROM
			(
				SELECT partition_date,cl_id,'美购详情页' as type
				FROM online.bl_hdfs_maidian_updates
				WHERE partition_date>=regexp_replace(DATE_SUB(current_date,90) ,'-','')
                AND partition_date<regexp_replace((current_date),'-','')
			    AND page_name = 'welfare_detail'
				AND action='page_view'
			)pv
			LEFT JOIN
			( -- 去掉疑似机构刷量的PV和UV
		        SELECT cl_id
		        FROM online.ml_hospital_spam_pv_day
		        WHERE partition_date>='20180402' AND partition_date<regexp_replace((current_date),'-','')
		        AND pv_ratio>=0.95
		        UNION ALL
		        SELECT cl_id
		        FROM online.ml_hospital_spam_pv_month
		        WHERE partition_date>='20171101' AND partition_date<regexp_replace((current_date),'-','')
		        AND pv_ratio>=0.95
		    )spam_pv
		    on pv.cl_id=spam_pv.cl_id
		    WHERE spam_pv.cl_id IS NULL

			UNION ALL

			SELECT partition_date,cl_id, '加购物车' as type
			FROM online.bl_hdfs_maidian_updates
			WHERE partition_date>=regexp_replace(DATE_SUB(current_date,90) ,'-','')
            AND partition_date<regexp_replace((current_date),'-','')
		    AND page_name = 'welfare_detail'
			AND action='welfare_multiattribute_click_add'

			UNION ALL

			SELECT partition_date,cl_id, '右上角购物车' as type
			FROM online.bl_hdfs_maidian_updates
			WHERE partition_date>=regexp_replace(DATE_SUB(current_date,90) ,'-','')
            AND partition_date<regexp_replace((current_date),'-','')
		    AND page_name = 'welfare_detail'
			AND action='on_click_navbar_cart'

			UNION ALL
			--点击查看更多评论
			SELECT partition_date,cl_id, '评价列表页' as type
			FROM online.bl_hdfs_maidian_updates
			WHERE partition_date >= regexp_replace(DATE_SUB(current_date,90) ,'-','')
			AND partition_date < regexp_replace((current_date),'-','')
		    --AND page_name = 'welfare_detail'
			AND action='welfare_detail_click_comment'

			UNION ALL
			--点击外显的评价标签
			SELECT partition_date,cl_id, '评价列表页' as type
			FROM online.bl_hdfs_maidian_updates
			WHERE partition_date >= regexp_replace(DATE_SUB(current_date,90) ,'-','')
			AND partition_date < regexp_replace((current_date),'-','')
		    AND page_name = 'welfare_detail'
			AND action='service_comment_click_tag'

			UNION ALL
			--点击外显的日记卡片
			SELECT partition_date,cl_id, '评价列表页' as type
			FROM online.bl_hdfs_maidian_updates
			WHERE partition_date >= regexp_replace(DATE_SUB(current_date,90) ,'-','')
			AND partition_date < regexp_replace((current_date),'-','')
		    AND page_name = 'welfare_detail'
			AND action='welfare_detail_comment_click_diary_card'

			UNION ALL

			SELECT partition_date,cl_id, '立即支付' as type
			FROM online.bl_hdfs_maidian_updates
			WHERE partition_date >= regexp_replace(DATE_SUB(current_date,90) ,'-','')
			AND partition_date < regexp_replace((current_date),'-','')
		    AND page_name = 'welfare_detail'
			AND action='welfare_multiattribute_click_buy'

			UNION ALL
			--点击选择更美项目
			SELECT partition_date,cl_id, '选择美购项目' as type
			FROM online.bl_hdfs_maidian_updates
			WHERE partition_date >= regexp_replace(DATE_SUB(current_date,90) ,'-','')
			AND partition_date < regexp_replace((current_date),'-','')
		    AND page_name = 'welfare_detail'
			AND action='on_click_button'
			AND params['button_name']='sku_choose'

			UNION ALL
			--7.22新版本--点击外露的美购项目
			SELECT partition_date,cl_id, '选择美购项目' as type
			FROM online.bl_hdfs_maidian_updates
			WHERE partition_date >= regexp_replace(DATE_SUB(current_date,90) ,'-','')
			AND partition_date < regexp_replace((current_date),'-','')
		    AND page_name = 'welfare_detail'
			AND action='on_click_button'
			AND params['button_name']='service_sku'

			UNION ALL
			--7.22新版本--点击查看更多
			SELECT partition_date,cl_id, '选择美购项目' as type
			FROM online.bl_hdfs_maidian_updates
			WHERE partition_date >= regexp_replace(DATE_SUB(current_date,90) ,'-','')
			AND partition_date < regexp_replace((current_date),'-','')
		    AND page_name = 'welfare_detail'
			AND action='on_click_button'
			AND params['button_name']='sku_all'

			UNION ALL
			--点击私信按钮
			SELECT partition_date,cl_id, '私信及电话咨询' as type
			FROM online.bl_hdfs_maidian_updates
			WHERE partition_date >= regexp_replace(DATE_SUB(current_date,90) ,'-','')
			AND partition_date < regexp_replace((current_date),'-','')
		    --AND page_name = 'welfare_detail'
			AND action='welfare_detail_click_message'

			UNION ALL
			--7.20之后灰度上线的快捷咨询按钮和预约面诊按钮
			SELECT partition_date,cl_id, '私信及电话咨询' as type
			FROM online.bl_hdfs_maidian_updates
			WHERE partition_date >= regexp_replace(DATE_SUB(current_date,90) ,'-','')
			AND partition_date < regexp_replace((current_date),'-','')
		    AND page_name = 'welfare_detail'
			AND action='on_click_button'
			AND params['button_name'] in ('question_tag','appointment')

			UNION ALL
			--点击机构下面的在线咨询和电话咨询
			SELECT partition_date,cl_id, '私信及电话咨询' as type
			FROM online.bl_hdfs_maidian_updates
			WHERE partition_date >= regexp_replace(DATE_SUB(current_date,90) ,'-','')
			AND partition_date < regexp_replace((current_date),'-','')
		    --AND page_name = 'welfare_detail'
			AND action='welfare_detail_click_curearea_contact'
			AND params['connect_type'] in ('onlineconsult','phone')

			UNION ALL

			SELECT partition_date,cl_id, '机构主页' as type
			FROM online.bl_hdfs_maidian_updates
			WHERE partition_date >= regexp_replace(DATE_SUB(current_date,90) ,'-','')
			AND partition_date < regexp_replace((current_date),'-','')
		    --AND page_name = 'welfare_detail'
			AND action='welfare_detail_click_curearea'
			AND params['cure_type']='organization'

			UNION ALL

			SELECT partition_date,cl_id, '机构的其他美购' as type
			FROM online.bl_hdfs_maidian_updates
			WHERE partition_date >= regexp_replace(DATE_SUB(current_date,90) ,'-','')
			AND partition_date < regexp_replace((current_date),'-','')
		    --AND page_name = 'welfare_detail'
			AND action='welfare_detail_click_seller_service_item'

			UNION ALL

			SELECT partition_date,cl_id, '机构导航' as type
			FROM online.bl_hdfs_maidian_updates
			WHERE partition_date >= regexp_replace(DATE_SUB(current_date,90) ,'-','')
			AND partition_date < regexp_replace((current_date),'-','')
		    --AND page_name = 'welfare_detail'
			AND action='welfare_detail_click_address'

			UNION ALL

			SELECT partition_date,cl_id, '推荐美购' as type
			FROM online.bl_hdfs_maidian_updates
			WHERE partition_date >= regexp_replace(DATE_SUB(current_date,90) ,'-','')
			AND partition_date <regexp_replace((current_date),'-','')
		    AND page_name = 'welfare_detail'
			AND action='on_click_card'
			AND params['card_content_type']='service'
			AND params['tab_name']='推荐'

			UNION ALL

			SELECT partition_date,cl_id, '收藏' as type
			FROM online.bl_hdfs_maidian_updates
			WHERE partition_date >= regexp_replace(DATE_SUB(current_date,90) ,'-','')
			AND partition_date < regexp_replace((current_date),'-','')
		    AND page_name = 'welfare_detail'
			AND action='on_click_favor'
			AND params['favor_type']='service'
			AND params['motion']='do'

			UNION ALL

			SELECT partition_date,cl_id, '医生主页' as type
			FROM online.bl_hdfs_maidian_updates
			WHERE partition_date >= regexp_replace(DATE_SUB(current_date,90) ,'-','')
			AND partition_date < regexp_replace((current_date),'-','')
		    --AND page_name = 'welfare_detail'
			AND action='welfare_detail_click_curearea'
			AND params['cure_type']='doctor'

			UNION ALL

			SELECT partition_date,cl_id, '分享' as type
			FROM online.bl_hdfs_maidian_updates
			WHERE partition_date >= regexp_replace(DATE_SUB(current_date,90) ,'-','')
			AND partition_date < regexp_replace((current_date),'-','')
		    AND page_name = 'welfare_detail'
			AND action='page_click_share'
		)click
         JOIN
        (
            SELECT
                partition_date
                ,m.device_id, device_os_type
                ,case WHEN active_type = '4'  THEN '老活跃设备'
                      WHEN active_type  in ('1','2')  then '新增设备' END as active_type
                ,array(CASE WHEN first_channel_source_type like '%xinyouxingkong%' or a.device_id is not NULL THEN '可疑'
            				WHEN (partition_date>='20190601' and tmp.col2 = 'AI')
                    				or (partition_date < '20200301' AND partition_date>='20190601' and first_channel_source_type like 'promotion_toutiao_jy%')
                    				or (partition_date>='20200601' and ((first_channel_source_type like 'promotion_toutiao_jy%') or (first_channel_source_type like 'dyand%') or (first_channel_source_type like 'douyin%')))
                    				THEN 'AI'  ELSE '其他' END , '合计') as channel
                FROM online.ml_device_day_active_status m
                	LEFT JOIN
                    (SELECT col1,col2  --col1:子渠道，col2：是否属于AI，col3:标识
                       FROM pm.tl_pm_ydl
                       WHERE col3='0204_danlei_channel')tmp
                    on first_channel_source_type=tmp.col1
                    LEFT JOIN
            	    (SELECT DISTINCT device_id
            	    	FROM al.al_pm_ct_dv_deviceappversionrollbackfrom20200101_d
            	    	WHERE partition_day = regexp_replace(DATE_SUB(current_date,2) ,'-',''))a
            	    ON m.device_id = a.device_id
                where partition_date>=regexp_replace(DATE_SUB(current_date,90) ,'-','')
            	AND partition_date<regexp_replace((current_date),'-','')
                AND active_type in ('1','2','4')
                and first_channel_source_type not in ('yqxiu1','yqxiu2','yqxiu3','yqxiu4','yqxiu5','mxyc1','mxyc2','mxyc3'
                ,'wanpu','jinshan','jx','maimai','zhuoyi','huatian','suopingjingling','mocha','mizhe','meika','lamabang'
                ,'js-az1','js-az2','js-az3','js-az4','js-az5','jfq-az1','jfq-az2','jfq-az3','jfq-az4','jfq-az5','toufang1'
                ,'toufang2','toufang3','toufang4','toufang5','toufang6','TF-toufang1','TF-toufang2','TF-toufang3','TF-toufang4'
                ,'TF-toufang5','tf-toufang1','tf-toufang2','tf-toufang3','tf-toufang4','tf-toufang5','benzhan','promotion_aso100'
                ,'promotion_qianka','promotion_xiaoyu','promotion_dianru','promotion_malioaso','promotion_malioaso-shequ'
                ,'promotion_shike','promotion_julang_jl03','promotion_zuimei','','unknown')
                AND first_channel_source_type not like 'promotion\_jf\_%'
        )mas
        ON click.cl_id=mas.device_id
            AND click.partition_date=mas.partition_date
    )t1
    LATERAL VIEW explode(t1.channel) t2 AS channel
    GROUP BY t1.partition_date,t1.device_os_type,t1.active_type,t2.channel
)T1
ORDER BY `日期` desc,`设备类型`,`活跃类型`,`渠道`

