--***************************************************************
--*脚本名称: create_pm_c_op_co_content_dimen_d.sql
--*功能: 内容日报
--*业务名称: pm
--*输入数据:
--*作者: weiyimin@igengmei.com
--*更新时间: 2020-5-25 11:00
--***************************************************************

--设置全局变量&UDF
SET mapreduce.job.queuename=data;

--使用bl数据库
USE pm;

--创建BL层内部表
CREATE TABLE IF NOT EXISTS pm.tl_pm_meigou_source_pv_d
(
 day_id string comment '{"chs_name":"当天日期","description":"","etl":"","value":"","remark":""}',
 device_os_type string comment '{"chs_name":"设备类型","description":"","etl":"","value":"","remark":""}',
 active_type string comment '{"chs_name":"活跃类型","description":"","etl":"","value":"","remark":""}',
 is_ai_channel string comment '{"chs_name":"是否AI渠道","description":"","etl":"","value":"","remark":""}',
 welfare_pv int comment '{"chs_name":"美购详情页pv","description":"","etl":"","value":"","remark":""}',
 to_welfare_pv int comment '{"chs_name":"从上级页面转化到美购详情页的pv总量","description":"","etl":"","value":"","remark":""}',
 total_conversion_rate double comment '{"chs_name":"从上级页面转化到美购详情页的pv比美购详情页总pv","description":"","etl":"","value":"","remark":""}',
 search_result_welfare_pv int comment '{"chs_name":"搜索结果美购页pv","description":"","etl":"","value":"","remark":""}',
 search_result_welfare_to_welfare_pv int comment '{"chs_name":"从搜索结果美购页转化到美购详情页pv","description":"","etl":"","value":"","remark":""}',
 result_wel_add_pv int comment '{"chs_name":"搜索结果美购页-转化点击加车pv","description":"","etl":"","value":"","remark":""}',
 result_wel_buy_pv int comment '{"chs_name":"内容用户APP7留","description":"","etl":"","value":"","remark":""}',
 result_wel_msg_pv int comment '{"chs_name":"内容用户APP30留","description":"","etl":"","value":"","remark":""}',
 avg_app_duration double comment '{"chs_name":"内容用户单设备App时长(m)","description":"","etl":"","value":"","remark":""}',
 avg_content_stay double comment '{"chs_name":"内容用户单设备内容时长(m)","description":"","etl":"","value":"","remark":""}',
 avg_open_times double comment '{"chs_name":"内容用户单设备打开次数","description":"","etl":"","value":"","remark":""}',
 search_related_stay double comment '{"chs_name":"内容用户搜索相关页面单设备页面时长(m)","description":"","etl":"","value":"","remark":""}',
 welfare_stay double comment '{"chs_name":"内容用户美购详情页单设备页面时长(m)","description":"","etl":"","value":"","remark":""}',
 content_question_stay double comment '{"chs_name":"内容用户问题详情页单设备页面时长(m)","description":"","etl":"","value":"","remark":""}',
 ai_related_stay double comment '{"chs_name":"内容用户AI相关页面单设备页面时长(m)","description":"","etl":"","value":"","remark":""}',
 content_diary_stay double comment '{"chs_name":"内容用户日记详情页单设备页面时长(m)","description":"","etl":"","value":"","remark":""}',
 home_stay double comment '{"chs_name":"内容用户首页单设备页面时长(m)","description":"","etl":"","value":"","remark":""}',
 conv_related_stay double comment '{"chs_name":"内容用户咨询相关页面单设备页面时长(m)","description":"","etl":"","value":"","remark":""}',
 recommend_rate double comment '{"chs_name":"首页feeds推荐进入内容UV/内容UV","description":"","etl":"","value":"","remark":""}',
 per_recommend_pv double comment '{"chs_name":"首页feeds推荐进入内容PV/UV","description":"","etl":"","value":"","remark":""}',
 feeds_rate double comment '{"chs_name":"首页feeds非推荐进入内容UV/内容UV","description":"","etl":"","value":"","remark":""}',
 per_feeds_pv double comment '{"chs_name":"首页feeds非推荐进入内容PV/UV","description":"","etl":"","value":"","remark":""}',
 search_rate double comment '{"chs_name":"搜索进入内容UV/内容UV","description":"","etl":"","value":"","remark":""}',
 per_search_pv double comment '{"chs_name":"搜索进入内容PV/UV","description":"","etl":"","value":"","remark":""}',
 zone_rate double comment '{"chs_name":"内容聚合页进入内容UV/内容UV","description":"","etl":"","value":"","remark":""}',
 per_zone_pv double comment '{"chs_name":"内容聚合页进入内容PV/UV","description":"","etl":"","value":"","remark":""}',
 content_rate double comment '{"chs_name":"内容详情页推荐板块进入内容UV/内容UV","description":"","etl":"","value":"","remark":""}',
 per_from_content_pv double comment '{"chs_name":"内容详情页推荐板块进入内容PV/UV","description":"","etl":"","value":"","remark":""}',
 blank_rate double comment '{"chs_name":"无来源页面(大多数为push)进入内容UV/内容UV","description":"","etl":"","value":"","remark":""}',
 per_blank_pv double comment '{"chs_name":"无来源页面(大多数为push)进入内容PV/UV","description":"","etl":"","value":"","remark":""}',
 comment_rate double comment '{"chs_name":"评论列表页进入内容UV/内容UV","description":"","etl":"","value":"","remark":""}',
 per_comment_pv double comment '{"chs_name":"评论列表页进入内容PV/UV","description":"","etl":"","value":"","remark":""}',
 org_rate double comment '{"chs_name":"医生医院主页进入内容UV/内容UV","description":"","etl":"","value":"","remark":""}',
 per_org_pv double comment '{"chs_name":"医生医院主页进入内容PV/UV","description":"","etl":"","value":"","remark":""}',
 category_rate double comment '{"chs_name":"品类聚合页进入内容UV/内容UV","description":"","etl":"","value":"","remark":""}',
 per_category_pv double comment '{"chs_name":"品类聚合页进入内容PV/UV","description":"","etl":"","value":"","remark":""}',
 my_diary_rate double comment '{"chs_name":"我的日记页进入内容UV/内容UV","description":"","etl":"","value":"","remark":""}',
 per_my_diary_pv double comment '{"chs_name":"我的日记页进入内容PV/UV","description":"","etl":"","value":"","remark":""}',
 ai_rate double comment  '{"chs_name":"AI报告页进入内容UV/内容UV","description":"","etl":"","value":"","remark":""}',
 per_ai_pv double comment '{"chs_name":"AI报告页进入内容PV/UV","description":"","etl":"","value":"","remark":""}',
 create_topic_num int comment '{"chs_name":"真实发帖数","description":"","etl":"","value":"","remark":""}',
 create_reply_num int comment '{"chs_name":"真实评论数","description":"","etl":"","value":"","remark":""}',
 diary_uv int comment '{"chs_name":"日记UV","description":"","etl":"","value":"","remark":""}',
 diary_pv int comment '{"chs_name":"日记PV","description":"","etl":"","value":"","remark":""}',
 diary_rate double comment '{"chs_name":"日记UV/内容UV","description":"","etl":"","value":"","remark":""}',
 per_diary_pv double comment '{"chs_name":"日记PV/日记UV","description":"","etl":"","value":"","remark":""}',
 diary_stay double comment '{"chs_name":"日记单设备时长(m)","description":"","etl":"","value":"","remark":""}',
 post_uv int comment '{"chs_name":"帖子UV","description":"","etl":"","value":"","remark":""}',
 post_pv int comment '{"chs_name":"帖子PV","description":"","etl":"","value":"","remark":""}',
 post_rate double comment '{"chs_name":"帖子UV/内容UV","description":"","etl":"","value":"","remark":""}',
 per_post_pv double comment '{"chs_name":"帖子PV/帖子UV","description":"","etl":"","value":"","remark":""}',
 post_stay double comment '{"chs_name":"帖子单设备时长(m)","description":"","etl":"","value":"","remark":""}',
 question_uv int comment '{"chs_name":"问题UV","description":"","etl":"","value":"","remark":""}',
 question_pv int comment '{"chs_name":"问题PV","description":"","etl":"","value":"","remark":""}',
 question_rate double comment '{"chs_name":"问题UV/内容UV","description":"","etl":"","value":"","remark":""}',
 per_question_pv double comment '{"chs_name":"问题PV/问题UV","description":"","etl":"","value":"","remark":""}',
 question_stay double comment '{"chs_name":"问题单设备时长(m)","description":"","etl":"","value":"","remark":""}',
 question_answer_uv int comment '{"chs_name":"问答UV","description":"","etl":"","value":"","remark":""}',
 question_answer_pv int comment '{"chs_name":"问答PV","description":"","etl":"","value":"","remark":""}',
 question_answer_rate double comment '{"chs_name":"问答UV/问答UV","description":"","etl":"","value":"","remark":""}',
 per_question_answer_pv double comment '{"chs_name":"问答PV/问答UV","description":"","etl":"","value":"","remark":""}',
 question_answer_stay double comment '{"chs_name":"问答单设备时长(m)","description":"","etl":"","value":"","remark":""}',
 answer_uv int comment '{"chs_name":"回答UV","description":"","etl":"","value":"","remark":""}',
 answer_pv int comment '{"chs_name":"回答PV","description":"","etl":"","value":"","remark":""}',
 answer_rate double comment '{"chs_name":"回答UV/内容UV","description":"","etl":"","value":"","remark":""}',
 per_answer_pv double comment '{"chs_name":"回答PV/回答UV","description":"","etl":"","value":"","remark":""}',
 answer_stay double comment '{"chs_name":"回答单设备时长(m)","description":"","etl":"","value":"","remark":""}',
 video_uv int comment '{"chs_name":"视频UV","description":"","etl":"","value":"","remark":""}',
 video_pv int comment '{"chs_name":"视频PV","description":"","etl":"","value":"","remark":""}',
 video_rate double comment '{"chs_name":"视频UV/内容UV","description":"","etl":"","value":"","remark":""}',
 per_video_pv double comment '{"chs_name":"视频PV/视频UV","description":"","etl":"","value":"","remark":""}',
 video_stay double comment '{"chs_name":"视频单设备时长(m)","description":"","etl":"","value":"","remark":""}',
 wiki_uv int comment '{"chs_name":"百科UV","description":"","etl":"","value":"","remark":""}',
 wiki_pv int comment '{"chs_name":"百科PV","description":"","etl":"","value":"","remark":""}',
 wiki_rate double comment '{"chs_name":"百科UV/内容UV","description":"","etl":"","value":"","remark":""}',
 per_wiki_pv double comment '{"chs_name":"百科PV/百科UV","description":"","etl":"","value":"","remark":""}',
 wiki_stay double comment '{"chs_name":"百科单设备时长(m)","description":"","etl":"","value":"","remark":""}',
 article_uv int comment '{"chs_name":"专栏UV","description":"","etl":"","value":"","remark":""}',
 article_pv int comment '{"chs_name":"专栏PV","description":"","etl":"","value":"","remark":""}',
 article_rate double comment '{"chs_name":"专栏UV/内容UV","description":"","etl":"","value":"","remark":""}',
 per_article_pv double comment '{"chs_name":"专栏PV/专栏UV","description":"","etl":"","value":"","remark":""}',
 article_stay double comment '{"chs_name":"专栏单设备时长(m)","description":"","etl":"","value":"","remark":""}'
)comment '内容日报'
PARTITIONED BY (PARTITION_DAY STRING comment '分区日期')
ROW FORMAT DELIMITED
FIELDS TERMINATED BY '\t'
COLLECTION ITEMS TERMINATED BY '\002'
MAP KEYS TERMINATED BY '\003'
LINES TERMINATED BY '\n'
STORED AS TEXTFILE;