SET mapreduce.job.queuename=data;
SET mapreduce.map.memory.mb=8192;
SET mapreduce.map.java.opts=-Xmx8000m;
SET mapreduce.reduce.memory.mb=8192;
SET mapreduce.reduce.java.opts=-Xmx8000m;
set hive.auto.convert.join=true;
SET mapred.reduce.tasks=20;
SET role admin;


--线索日报
ADD JAR hdfs:///user/hive/share/lib/udf/hive-udf-1.0-SNAPSHOT.jar;
CREATE TEMPORARY FUNCTION convup AS 'com.gmei.hive.common.udf.UDFConvUpgrade';
CREATE TEMPORARY FUNCTION setencryption AS 'com.gmei.hive.common.udf.UDFStringSetEncryption';


INSERT OVERWRITE TABLE pm.tl_pm_userclue_d PARTITION (PARTITION_DAY = ${partition_day})

SELECT T1.partition_date as day_id
		,T1.device_os_type
		,T1.active_type
		,T1.grey_type
		,T1.channel
		,dau
		,user_num
		,phone_user_num
		,nvl(total_clue_dev,0)
		,nvl(total_clue_num,0)
		,nvl(total_valid_dev,0)
		,nvl(total_valid_num,0)
		,msg_dev
		,msg_num
		,valid_msg_dev
		,valid_msg_num
		,clue_dev
		,clue_num
		,nvl(call_dev,0)
		,nvl(call_num,0)
		,nvl(valid_call_dev,0)
		,nvl(valid_call_num,0)
		,nvl(call_dev_d,0)
		,nvl(call_num_d,0)
		,nvl(valid_call_dev_d,0)
		,nvl(valid_call_num_d,0)

		,msg_dev_3
		,msg_num_3
		,valid_msg_dev_3
		,valid_msg_num_3
		,clue_dev_3
		,clue_num_3
		,nvl(call_dev_3,0)
		,nvl(call_num_3,0)
		,nvl(valid_call_dev_3,0)
		,nvl(valid_call_num_3,0)
		,nvl(call_dev_3_d,0)
		,nvl(call_num_3_d,0)
		,nvl(valid_call_dev_3_d,0)
		,nvl(valid_call_num_3_d,0)

		,msg_dev_kyc
		,msg_num_kyc
		,valid_msg_dev_kyc
		,valid_msg_num_kyc
		,clue_dev_kyc
		,clue_num_kyc
		,nvl(call_dev_kyc,0)
		,nvl(call_num_kyc,0)
		,nvl(valid_call_dev_kyc,0)
		,nvl(valid_call_num_kyc,0)
		,nvl(call_dev_kyc_d,0)
		,nvl(call_num_kyc_d,0)
		,nvl(valid_call_dev_kyc_d,0)
		,nvl(valid_call_num_kyc_d,0)

		,msg_dev_qa
		,msg_num_qa
		,valid_msg_dev_qa
		,valid_msg_num_qa
		,clue_dev_qa
		,clue_num_qa
		,nvl(call_dev_qa,0)
		,nvl(call_num_qa,0)
		,nvl(valid_call_dev_qa,0)
		,nvl(valid_call_num_qa,0)
		,nvl(call_dev_qa_d,0)
		,nvl(call_num_qa_d,0)
		,nvl(valid_call_dev_qa_d,0)
		,nvl(valid_call_num_qa_d,0)
FROM
(
	SELECT mas.partition_date  as partition_date
		,device_os_type
		,active_type
		,grey_type
		,channel
		,count(distinct mas.device_id) as dau
		,count(distinct a.user_id) as user_num
		,count(distinct b.user_id) as phone_user_num

		,nvl(count(distinct case when t13.total_clue_num>0 then t13.user_id end),0) total_clue_dev
		,nvl(sum(t13.total_clue_num),0) total_clue_num
		,nvl(count(distinct case when t13_v.total_valid_num>0 then t13_v.user_id end),0) total_valid_dev
		,nvl(sum(t13_v.total_valid_num),0) total_valid_num

		,nvl(count(distinct case when t1.msg_num>0 then t1.user_id end),0) msg_dev
		,nvl(sum(t1.msg_num),0) msg_num
		,nvl(count(distinct case when t1_v.valid_msg_num>0 then t1_v.user_id end),0) valid_msg_dev
		,nvl(sum(t1_v.valid_msg_num),0) as valid_msg_num
		,nvl(count(distinct case when t2.clue_num>0 then t2.user_id end),0) as clue_dev
		,nvl(sum(t2.clue_num),0) as clue_num

		,nvl(count(distinct case when t10.msg_num>0 then t10.user_id end),0) msg_dev_3
		,nvl(sum(t10.msg_num),0) msg_num_3
		,nvl(count(distinct case when t10_v.valid_msg_num>0 then t10_v.user_id end),0) valid_msg_dev_3
		,nvl(sum(t10_v.valid_msg_num),0) as valid_msg_num_3
		,nvl(count(distinct case when t11.clue_num>0 then t11.user_id end),0) as clue_dev_3
		,nvl(sum(t11.clue_num),0) as clue_num_3

		,nvl(count(distinct case when t4.msg_num>0 then t4.user_id end),0) msg_dev_kyc
		,nvl(sum(t4.msg_num),0) msg_num_kyc
		,nvl(count(distinct case when t4_v.valid_msg_num>0 then t4_v.user_id end),0) valid_msg_dev_kyc
		,nvl(sum(t4_v.valid_msg_num),0) as valid_msg_num_kyc
		,nvl(count(distinct case when t5.clue_num>0 then t5.user_id end),0) as clue_dev_kyc
		,nvl(sum(t5.clue_num),0) as clue_num_kyc

		,nvl(count(distinct case when t7.msg_num>0 then t7.user_id end),0) msg_dev_qa
		,nvl(sum(t7.msg_num),0) msg_num_qa
		,nvl(count(distinct case when t7_v.valid_msg_num>0 then t7_v.user_id end),0) valid_msg_dev_qa
		,nvl(sum(t7_v.valid_msg_num),0) as valid_msg_num_qa
		,nvl(count(distinct case when t8.clue_num>0 then t8.user_id end),0) as clue_dev_qa
		,nvl(sum(t8.clue_num),0) as clue_num_qa

		,nvl(count(distinct case when t3.call_num>0 then t3.user_id end),0) as call_dev
		,nvl(sum(t3.call_num),0) as call_num
		,nvl(count(distinct case when t3_v.valid_call_num>0 then t3_v.user_id end),0) as valid_call_dev
		,nvl(sum(t3_v.valid_call_num),0) as valid_call_num

		,nvl(count(distinct case when t12.call_num>0 then t12.user_id end),0) as call_dev_3
		,nvl(sum(t12.call_num),0) as call_num_3
		,nvl(count(distinct case when t12_v.valid_call_num>0 then t12_v.user_id end),0) as valid_call_dev_3
		,nvl(sum(t12_v.valid_call_num),0) as valid_call_num_3

		,nvl(count(distinct case when t6.call_num>0 then t6.user_id end),0) as call_dev_kyc
		,nvl(sum(t6.call_num),0) as call_num_kyc
		,nvl(count(distinct case when t6_v.valid_call_num>0 then t6_v.user_id end),0) as valid_call_dev_kyc
		,nvl(sum(t6_v.valid_call_num),0) as valid_call_num_kyc

		,nvl(count(distinct case when t9.call_num>0 then t9.user_id end),0) as call_dev_qa
		,nvl(sum(t9.call_num),0) as call_num_qa
		,nvl(count(distinct case when t9_v.valid_call_num>0 then t9_v.user_id end),0) as valid_call_dev_qa
		,nvl(sum(t9_v.valid_call_num),0) as valid_call_num_qa

	FROM
	(
		SELECT partition_date,device_id,device_os_type,b.active_type,b.grey_type,b.channel
		FROM
		(
			SELECT
			partition_date
			,m.device_id,device_os_type
			,array(case when active_type in ('1','2') then '新增设备'
		                      when active_type ='4' then '老活跃设备' end,'合计')  as active_type
		    ,array(case when substr(convup(setencryption(m.device_id,'sha-1'),16,10),-2,2)%20 = 0 then 'kyc灰度' else '非灰' end,'合计') as grey_type
		    ,array(CASE WHEN (a.device_id is not null or b.device_id is not null
							or first_channel_source_type like '%xinyouxingkong%'
							or first_channel_source_type like '%jingmeng%'
							or first_channel_source_type like '%longyuzhixing%'
							or first_channel_source_type like '%mailuo%') THEN '渠道可疑'
					WHEN tmp.is_ai_channel='true' THEN 'AI' ELSE '其他' END , '合计') as channel
			FROM online.ml_device_day_active_status m
				LEFT JOIN
		        (SELECT code,is_spam,is_ai_channel,partition_day
                	FROM DIM.DIM_AI_CHANNEL_ZP_NEW
                	WHERE partition_day >=REGEXP_REPLACE(trunc(date_sub(current_date(),1),'MM'),'-','')
                	and partition_day<=regexp_replace(date_sub(current_date,1),'-',''))tmp
		        on first_channel_source_type=tmp.code and m.partition_date=tmp.partition_day
		        LEFT JOIN
		        (SELECT DISTINCT device_id
			       FROM al.al_pm_ct_dv_deviceappversionrollbackfrom20190101_d
			       WHERE partition_day = regexp_replace(date_sub(current_date,2),'-',''))a
	    		ON m.device_id = a.device_id
	    		LEFT JOIN
	    		(SELECT device_id,day_id
	    			FROM pm.tl_pm_channel_d
	    			WHERE partition_day =regexp_replace(date_sub(current_date,1),'-','')
	    			GROUP BY device_id,day_id)b
	    		ON m.device_id = b.device_id AND m.partition_date = b.day_id
			where partition_date>=REGEXP_REPLACE(trunc(date_sub(current_date(),1),'MM'),'-','')
			AND partition_date<=regexp_replace(date_sub(current_date,1),'-','')
			AND active_type in ('1','2','4')
			and m.device_id IS NOT NULL
		)a
		LATERAL VIEW explode(a.grey_type) b AS grey_type
		LATERAL VIEW explode(a.active_type) b AS active_type
		LATERAL VIEW explode(a.channel) b AS channel
	)mas
	left join
	(--找出user_id当天活跃的第一个设备id
		SELECT user_id,partition_date,
	        if(size(device_list) > 0, device_list [ 0 ], '') AS device_id
	    FROM online.ml_user_updates
	    WHERE partition_date>=REGEXP_REPLACE(trunc(date_sub(current_date(),1),'MM'),'-','')
	    AND partition_date<= regexp_replace(date_sub(current_date,1),'-','')
	)a
	on mas.partition_date=a.partition_date and mas.device_id=a.device_id
	left join
	(
		SELECT distinct user_id
		FROM online.tl_hdfs_userextra_view
		WHERE partition_date = regexp_replace(date_sub(current_date,1),'-','')
		AND auth_type = '1'
	)b
	on a.user_id=b.user_id
	left join
	(--私信线索总数
		SELECT msg.partition_date,user_id
				,count(msg.merchant_id) as msg_num
		FROM
		(
			SELECT user_id,merchant_id,SUBSTR(partition_day,1,6) AS MONTH,min(partition_day) as partition_date
			FROM ml.ml_c_et_msg_conversation_dimen_inc_d --新仓库私信表
			WHERE partition_day >=REGEXP_REPLACE(trunc(date_sub(current_date(),1),'MM'),'-','')
			AND partition_day <= regexp_replace(date_sub(current_date,1),'-','')
			GROUP BY user_id,merchant_id,SUBSTR(partition_day,1,6)
		)msg
		GROUP BY msg.partition_date,user_id
	)t1
	    ON a.partition_date = t1.partition_date and a.user_id=t1.user_id
	left join
	(--有效私信线索总数
		SELECT msg.partition_date,user_id
				,count(msg.merchant_id) as valid_msg_num
		FROM
		(
			SELECT user_id,merchant_id,SUBSTR(partition_day,1,6) AS MONTH,min(partition_day) as partition_date
			FROM ml.ml_c_et_msg_conversation_dimen_inc_d --新仓库私信表
			WHERE partition_day >=REGEXP_REPLACE(trunc(date_sub(current_date(),1),'MM'),'-','')
			AND partition_day <= regexp_replace(date_sub(current_date,1),'-','')
			and is_valid='true'
			GROUP BY user_id,merchant_id,SUBSTR(partition_day,1,6)
		)msg
		GROUP BY msg.partition_date,user_id
	)t1_v
	    ON a.partition_date = t1_v.partition_date and a.user_id=t1_v.user_id
	LEFT JOIN
	( --电话线索总数
		SELECT partition_date,user_id,count(1) AS clue_num
		FROM
		(
			SELECT user_id,merchant_id,MIN(REGEXP_REPLACE(SUBSTR(last_issue_time,1,10), '-', '')) as partition_date,regexp_replace(SUBSTR(last_issue_time,1,7),'-','') AS CALL_MONTH
			FROM tl.tl_gm_sl_lead_task  --线索任务表（用户点击授权后记入该表）
			WHERE partition_day>=REGEXP_REPLACE(trunc(date_sub(current_date(),1),'MM'),'-','')
			AND partition_day<=regexp_replace(date_sub(current_date(),1),'-','')
			AND source='2' --用户行为电话授权
			and (user_id is NOT NULL or USER_ID <> '')
			GROUP BY user_id,merchant_id,regexp_replace(SUBSTR(last_issue_time,1,7),'-','')
		)a
		GROUP BY partition_date,user_id
	)t2
		ON a.partition_date = t2.partition_date and a.user_id=t2.user_id
	LEFT JOIN
	( ---拨打电话线索
		SELECT partition_date,user_id
				,count(1) as call_num
		FROM
		(
			SELECT user_id,merchant_id,regexp_replace(SUBSTR(a.partition_date,1,6),'-','') AS CALL_MONTH,
					MIN(partition_date) as partition_date,
					1 as call_num
			FROM
			(
				SELECT sub_id,REGEXP_REPLACE(SUBSTR(call_time,0,10), '-', '') as partition_date
				FROM  tl.tl_gm_sl_ali_virtual_phone_call_detail --通话记录表，call_type呼叫类型
				WHERE partition_day=regexp_replace(date_sub(current_date,1),'-','')
				AND REGEXP_REPLACE(SUBSTR(call_time,0,10), '-', '')>=REGEXP_REPLACE(trunc(date_sub(current_date(),1),'MM'),'-','')
				AND REGEXP_REPLACE(SUBSTR(call_time,0,10), '-', '')<=regexp_replace(date_sub(current_date(),1),'-','')
				and start_time>call_time
			)a
			LEFT JOIN
			(
				SELECT id,sub_id
				FROM tl.tl_gm_sl_ali_virtual_phone_binding --阿里记录表
				WHERE partition_day=regexp_replace(date_sub(current_date,1),'-','')
			)b
			ON a.sub_id = b.sub_id
			LEFT JOIN
			(
				SELECT id,platform_binding_id
				FROM tl.tl_gm_sl_virtual_phone_binding
				WHERE partition_day=regexp_replace(date_sub(current_date,1),'-','')
			)c
			ON b.id = c.platform_binding_id
			LEFT JOIN
			(
				SELECT phone_binding_id,lead_task_id
				FROM tl.tl_gm_sl_lead_task_phone_binding
				WHERE partition_day=regexp_replace(date_sub(current_date,1),'-','')
			)d
			ON c.id = d.phone_binding_id
			JOIN
			(
				SELECT id,user_id,merchant_id
				FROM tl.tl_gm_sl_lead_task  --线索任务表（用户点击授权后记入该表）
				WHERE partition_day=regexp_replace(date_sub(current_date,1),'-','')
				AND source='2' --用户行为电话授权
				and (user_id is NOT NULL or USER_ID <> '')
			)e
			ON d.lead_task_id = e.id
			GROUP BY user_id,merchant_id,regexp_replace(SUBSTR(a.partition_date,1,6),'-','')
		)t1
		GROUP BY user_id,partition_date
	)t3
		ON a.partition_date = t3.partition_date and a.user_id=t3.user_id
	LEFT JOIN
	( ---有效电话线索
		SELECT partition_date,user_id
				,count(1) as valid_call_num
		FROM
		(
			SELECT user_id,merchant_id,regexp_replace(SUBSTR(a.partition_date,1,6),'-','') AS CALL_MONTH,
					MIN(partition_date) as partition_date,
					1 as call_num
			FROM
			(
				SELECT sub_id,REGEXP_REPLACE(SUBSTR(call_time,0,10), '-', '') as partition_date
				FROM  tl.tl_gm_sl_ali_virtual_phone_call_detail --通话记录表，call_type呼叫类型
				WHERE partition_day=regexp_replace(date_sub(current_date,1),'-','')
				AND REGEXP_REPLACE(SUBSTR(call_time,0,10), '-', '')>=REGEXP_REPLACE(trunc(date_sub(current_date(),1),'MM'),'-','')
				AND REGEXP_REPLACE(SUBSTR(call_time,0,10), '-', '')<=regexp_replace(date_sub(current_date(),1),'-','')
				and start_time>call_time
				and start_time<release_time
			)a
			LEFT JOIN
			(
				SELECT id,sub_id
				FROM tl.tl_gm_sl_ali_virtual_phone_binding --阿里记录表
				WHERE partition_day=regexp_replace(date_sub(current_date,1),'-','')
			)b
			ON a.sub_id = b.sub_id
			LEFT JOIN
			(
				SELECT id,platform_binding_id
				FROM tl.tl_gm_sl_virtual_phone_binding
				WHERE partition_day=regexp_replace(date_sub(current_date,1),'-','')
			)c
			ON b.id = c.platform_binding_id
			LEFT JOIN
			(
				SELECT phone_binding_id,lead_task_id
				FROM tl.tl_gm_sl_lead_task_phone_binding
				WHERE partition_day=regexp_replace(date_sub(current_date,1),'-','')
			)d
			ON c.id = d.phone_binding_id
			JOIN
			(
				SELECT id,user_id,merchant_id
				FROM tl.tl_gm_sl_lead_task  --线索任务表（用户点击授权后记入该表）
				WHERE partition_day=regexp_replace(date_sub(current_date,1),'-','')
				AND source='2' --用户行为电话授权
				and (user_id is NOT NULL or USER_ID <> '')
			)e
			ON d.lead_task_id = e.id
			GROUP BY user_id,merchant_id,regexp_replace(SUBSTR(a.partition_date,1,6),'-','')
		)t1
		GROUP BY user_id,partition_date
	)t3_v
		ON a.partition_date = t3_v.partition_date and a.user_id=t3_v.user_id
	left join
	(--kyc私信
		SELECT msg.partition_date,user_id
				,count(msg.merchant_id) as msg_num
		FROM
		(
			SELECT user_id,merchant_id,SUBSTR(partition_day,1,6) AS MONTH,min(partition_day) as partition_date
			FROM
			(
				SELECT distinct conversation_id
			    FROM online.tl_hdfs_message_view
			    WHERE partition_date =regexp_replace(DATE_SUB(current_date,1) ,'-','')
			    and regexp_replace(to_date(send_time) ,'-','')>=REGEXP_REPLACE(trunc(date_sub(current_date(),1),'MM'),'-','')
			    and regexp_replace(to_date(send_time) ,'-','') <= regexp_replace(date_sub(current_date,1),'-','')
			    and content like '%对%感兴趣'
			)a
			join
			(
				SELECT user_id,merchant_id,conversation_id,partition_day
				FROM ml.ml_c_et_msg_conversation_dimen_inc_d --新仓库私信表
				WHERE partition_day >= REGEXP_REPLACE(trunc(date_sub(current_date(),1),'MM'),'-','')
				AND partition_day <= regexp_replace(date_sub(current_date,1),'-','')
				GROUP BY user_id,merchant_id,conversation_id,partition_day
			)b
			on a.conversation_id=b.conversation_id
			group by user_id,merchant_id,SUBSTR(partition_day,1,6)
		)msg
		group by msg.partition_date,user_id
	)t4
		on a.partition_date=t4.partition_date and a.user_id=t4.user_id
	left join
	(--kyc有效私信
		SELECT msg.partition_date,user_id
				,count(msg.merchant_id) as valid_msg_num
		FROM
		(
			SELECT user_id,merchant_id,SUBSTR(partition_day,1,6) AS MONTH,min(partition_day) as partition_date
			FROM
			(
				SELECT distinct conversation_id
			    FROM online.tl_hdfs_message_view
			    WHERE partition_date =regexp_replace(DATE_SUB(current_date,1) ,'-','')
			    and regexp_replace(to_date(send_time) ,'-','')>=REGEXP_REPLACE(trunc(date_sub(current_date(),1),'MM'),'-','')
			    and regexp_replace(to_date(send_time) ,'-','') <= regexp_replace(date_sub(current_date,1),'-','')
			    and content like '%对%感兴趣'
			)a
			join
			(
				SELECT user_id,merchant_id,conversation_id,partition_day
				FROM ml.ml_c_et_msg_conversation_dimen_inc_d --新仓库私信表
				WHERE partition_day >= REGEXP_REPLACE(trunc(date_sub(current_date(),1),'MM'),'-','')
				AND partition_day <= regexp_replace(date_sub(current_date,1),'-','')
				and is_valid='true'
				GROUP BY user_id,merchant_id,conversation_id,partition_day
			)b
			on a.conversation_id=b.conversation_id
			group by user_id,merchant_id,SUBSTR(partition_day,1,6)
		)msg
		group by msg.partition_date,user_id
	)t4_v
		on a.partition_date=t4_v.partition_date and a.user_id=t4_v.user_id
	LEFT JOIN
	( --kyc电话线索总数
		SELECT partition_date,user_id,count(1) as clue_num
		FROM
		(
			SELECT a.user_id,a.merchant_id,substr(a.partition_date,1,6) as month,min(a.partition_date) as partition_date
			FROM
			(
				SELECT user_id,merchant_id,REGEXP_REPLACE(SUBSTR(last_issue_time,1,10), '-', '') as partition_date
				FROM tl.tl_gm_sl_lead_task  --线索任务表（用户点击授权后记入该表）
				WHERE partition_day>=REGEXP_REPLACE(trunc(date_sub(current_date(),1),'MM'),'-','')
				AND partition_day<=regexp_replace(date_sub(current_date(),1),'-','')
				AND source='2' --用户行为电话授权
				and (user_id is NOT NULL or USER_ID <> '')
				GROUP BY user_id,merchant_id,regexp_replace(SUBSTR(last_issue_time,1,10),'-','')
			)a
			join
			(
				SELECT partition_date,user_id,merchant_id
				from
				(
			     	SELECT partition_date,cl_id,user_id,hospital_id
					from
					(
						SELECT partition_date,cl_id,user_id,json_split(params['hospital_id'],'string') as hospital_ids
						FROM online.bl_hdfs_maidian_updates
						where partition_date>=REGEXP_REPLACE(trunc(date_sub(current_date(),1),'MM'),'-','')
						AND partition_date <= regexp_replace(date_sub(current_date,1),'-','')
						and page_name in ('kyc_phone')
						and action='on_click_button'
						and params['button_name']='agree'
				        and params['hospital_id'] like '%[%'--其实传的是doctor_id
					)a
					LATERAL VIEW explode(hospital_ids) b AS hospital_id
					group by partition_date,cl_id,user_id,hospital_id
			     )a
			     join
			     (
			     	SELECT doctor_id,merchant_id
					FROM online.ml_doctor_relation_dimen_day
					WHERE partition_date = regexp_replace(date_sub(current_date,1),'-','')
					AND doctor_is_merchant='true' --医生是商户
					GROUP BY doctor_id,merchant_id
			     )b
			     on a.hospital_id=b.doctor_id
			)kyc
			on a.user_id=kyc.user_id and a.merchant_id=kyc.merchant_id and a.partition_date=kyc.partition_date
			GROUP BY a.user_id,a.merchant_id,substr(a.partition_date,1,6)
		)a
		group by partition_date,user_id
	)t5
		ON a.partition_date = t5.partition_date and a.user_id=t5.user_id
	LEFT JOIN
	( --拨打电话线索
		SELECT partition_date,user_id
				,count(1) as call_num
		FROM
		(
			SELECT e.user_id,e.merchant_id,regexp_replace(SUBSTR(a.partition_date,1,6),'-','') AS CALL_MONTH,
					MIN(a.partition_date) as partition_date,
					1 as call_num
			FROM
			(
				SELECT sub_id,REGEXP_REPLACE(SUBSTR(call_time,0,10), '-', '') as partition_date
				FROM  tl.tl_gm_sl_ali_virtual_phone_call_detail --通话记录表，call_type呼叫类型
				WHERE partition_day=regexp_replace(date_sub(current_date,1),'-','')
				AND REGEXP_REPLACE(SUBSTR(call_time,0,10), '-', '')>=REGEXP_REPLACE(trunc(date_sub(current_date(),1),'MM'),'-','')
				AND REGEXP_REPLACE(SUBSTR(call_time,0,10), '-', '')<=regexp_replace(date_sub(current_date(),1),'-','')
				and start_time>call_time
			)a
			LEFT JOIN
			(
				SELECT id,sub_id
				FROM tl.tl_gm_sl_ali_virtual_phone_binding --阿里记录表
				WHERE partition_day=regexp_replace(date_sub(current_date,1),'-','')
			)b
			ON a.sub_id = b.sub_id
			LEFT JOIN
			(
				SELECT id,platform_binding_id
				FROM tl.tl_gm_sl_virtual_phone_binding
				WHERE partition_day=regexp_replace(date_sub(current_date,1),'-','')
			)c
			ON b.id = c.platform_binding_id
			LEFT JOIN
			(
				SELECT phone_binding_id,lead_task_id
				FROM tl.tl_gm_sl_lead_task_phone_binding
				WHERE partition_day=regexp_replace(date_sub(current_date,1),'-','')
			)d
			ON c.id = d.phone_binding_id
			JOIN
			(
				SELECT id,user_id,merchant_id,REGEXP_REPLACE(SUBSTR(last_issue_time,1,10), '-', '') as partition_date
				FROM tl.tl_gm_sl_lead_task  --线索任务表（用户点击授权后记入该表）
				WHERE partition_day>=REGEXP_REPLACE(trunc(date_sub(current_date(),1),'MM'),'-','')
				AND partition_day<=regexp_replace(date_sub(current_date(),1),'-','')
				AND source='2' --用户行为电话授权
				and (user_id is NOT NULL or USER_ID <> '')
				group by id,user_id,merchant_id,last_issue_time
			)e
			ON d.lead_task_id = e.id
			join
			(
				SELECT partition_date,user_id,merchant_id
				from
				(
			     	SELECT partition_date,cl_id,user_id,hospital_id
					from
					(
						SELECT partition_date,cl_id,user_id,json_split(params['hospital_id'],'string') as hospital_ids
						FROM online.bl_hdfs_maidian_updates
						where partition_date>=REGEXP_REPLACE(trunc(date_sub(current_date(),1),'MM'),'-','')
						AND partition_date <= regexp_replace(date_sub(current_date,1),'-','')
						and page_name in ('kyc_phone')
						and action='on_click_button'
						and params['button_name']='agree'
				        and params['hospital_id'] like '%[%'--其实传的是doctor_id
					)a
					LATERAL VIEW explode(hospital_ids) b AS hospital_id
					group by partition_date,cl_id,user_id,hospital_id
			     )a
			     join
			     (
			     	SELECT doctor_id,merchant_id
					FROM online.ml_doctor_relation_dimen_day
					WHERE partition_date = regexp_replace(date_sub(current_date,1),'-','')
					AND doctor_is_merchant='true' --医生是商户
					GROUP BY doctor_id,merchant_id
			     )b
			     on a.hospital_id=b.doctor_id
			)kyc
			on e.user_id=kyc.user_id and e.merchant_id=kyc.merchant_id and e.partition_date=kyc.partition_date
			GROUP BY e.user_id,e.merchant_id,regexp_replace(SUBSTR(a.partition_date,1,6),'-','')
		)t1
		GROUP BY user_id,partition_date
	)t6
		ON a.partition_date = t6.partition_date and a.user_id=t6.user_id
	LEFT JOIN
	( ---拨打电话线索
		SELECT partition_date,user_id
				,count(1) as valid_call_num
		FROM
		(
			SELECT e.user_id,e.merchant_id,regexp_replace(SUBSTR(a.partition_date,1,6),'-','') AS CALL_MONTH,
					MIN(a.partition_date) as partition_date,
					1 as call_num
			FROM
			(
				SELECT sub_id,REGEXP_REPLACE(SUBSTR(call_time,0,10), '-', '') as partition_date
				FROM  tl.tl_gm_sl_ali_virtual_phone_call_detail --通话记录表，call_type呼叫类型
				WHERE partition_day=regexp_replace(date_sub(current_date,1),'-','')
				AND REGEXP_REPLACE(SUBSTR(call_time,0,10), '-', '')>=REGEXP_REPLACE(trunc(date_sub(current_date(),1),'MM'),'-','')
				AND REGEXP_REPLACE(SUBSTR(call_time,0,10), '-', '')<=regexp_replace(date_sub(current_date(),1),'-','')
				and start_time>call_time
				and start_time<release_time
			)a
			LEFT JOIN
			(
				SELECT id,sub_id
				FROM tl.tl_gm_sl_ali_virtual_phone_binding --阿里记录表
				WHERE partition_day=regexp_replace(date_sub(current_date,1),'-','')
			)b
			ON a.sub_id = b.sub_id
			LEFT JOIN
			(
				SELECT id,platform_binding_id
				FROM tl.tl_gm_sl_virtual_phone_binding
				WHERE partition_day=regexp_replace(date_sub(current_date,1),'-','')
			)c
			ON b.id = c.platform_binding_id
			LEFT JOIN
			(
				SELECT phone_binding_id,lead_task_id
				FROM tl.tl_gm_sl_lead_task_phone_binding
				WHERE partition_day=regexp_replace(date_sub(current_date,1),'-','')
			)d
			ON c.id = d.phone_binding_id
			JOIN
			(
				SELECT id,user_id,merchant_id,REGEXP_REPLACE(SUBSTR(last_issue_time,1,10), '-', '') as created_date
				FROM tl.tl_gm_sl_lead_task  --线索任务表（用户点击授权后记入该表）
				WHERE partition_day>=REGEXP_REPLACE(trunc(date_sub(current_date(),1),'MM'),'-','')
				AND partition_day<=regexp_replace(date_sub(current_date(),1),'-','')
				AND source='2' --用户行为电话授权
				and (user_id is NOT NULL or USER_ID <> '')
				group by id,user_id,merchant_id,last_issue_time
			)e
			ON d.lead_task_id = e.id
			join
			(
				SELECT partition_date,user_id,merchant_id
				from
				(
			     	SELECT partition_date,cl_id,user_id,hospital_id
					from
					(
						SELECT partition_date,cl_id,user_id,json_split(params['hospital_id'],'string') as hospital_ids
						FROM online.bl_hdfs_maidian_updates
						where partition_date>=REGEXP_REPLACE(trunc(date_sub(current_date(),1),'MM'),'-','')
						AND partition_date <= regexp_replace(date_sub(current_date,1),'-','')
						and page_name in ('kyc_phone')
						and action='on_click_button'
						and params['button_name']='agree'
				        and params['hospital_id'] like '%[%'--其实传的是doctor_id
					)a
					LATERAL VIEW explode(hospital_ids) b AS hospital_id
					group by partition_date,cl_id,user_id,hospital_id
			     )a
			     join
			     (
			     	SELECT doctor_id,merchant_id
					FROM online.ml_doctor_relation_dimen_day
					WHERE partition_date = regexp_replace(date_sub(current_date,1),'-','')
					AND doctor_is_merchant='true' --医生是商户
					GROUP BY doctor_id,merchant_id
			     )b
			     on a.hospital_id=b.doctor_id
			)kyc
			on e.user_id=kyc.user_id and e.merchant_id=kyc.merchant_id and e.created_date=kyc.partition_date
			GROUP BY e.user_id,e.merchant_id,regexp_replace(SUBSTR(a.partition_date,1,6),'-','')
		)t1
		GROUP BY user_id,partition_date
	)t6_v
		ON a.partition_date = t6_v.partition_date and a.user_id=t6_v.user_id
	left join
	(--需求自测私信
		SELECT msg.partition_date,user_id
				,count(msg.merchant_id) as msg_num
		FROM
		(
			SELECT a.user_id,a.merchant_id,substr(partition_day,1,6) as month,min(partition_day) as partition_date
			FROM
			(
				SELECT partition_date,user_id,merchant_id
				from
				(--点击发送
					SELECT a.partition_date,user_id,cl_id
						        ,json_map(b.hospital_id,'string,string')['hospital_id'] hospital_id
					FROM
					(
						SELECT partition_date,user_id,cl_id,json_split(params['hospital_id_list']) as hospital_id_list
						FROM online.bl_hdfs_maidian_updates
						where partition_date>=REGEXP_REPLACE(trunc(date_sub(current_date(),1),'MM'),'-','')
						AND partition_date <= regexp_replace(date_sub(current_date,1),'-','')
						and page_name='ai_plan_consult_list'
						and referrer in ('plan_service_list','ai_plan_list')
						and params['button_name'] in ('send')
						and action='on_click_button'
						and int(split(app_version,'\\.')[1]) >= 31
						group by partition_date,user_id,cl_id,params['hospital_id_list']
					)a
					LATERAL VIEW EXPLODE(a.hospital_id_list) b as hospital_id
				)b
				join
				(
			     	SELECT hospital_id,merchant_id
					FROM online.ml_doctor_relation_dimen_day
					WHERE partition_date = regexp_replace(date_sub(current_date,1),'-','')
					AND doctor_is_merchant='true' --医生是商户
					GROUP BY hospital_id,merchant_id
			     )c
			     on c.hospital_id=b.hospital_id
			     group by partition_date,user_id,merchant_id
			)a
			join
			(
				SELECT user_id,merchant_id,partition_day
				FROM ml.ml_c_et_msg_conversation_dimen_inc_d --新仓库私信表
				WHERE partition_day >=REGEXP_REPLACE(trunc(date_sub(current_date(),1),'MM'),'-','')
				AND partition_day <= regexp_replace(date_sub(current_date,1),'-','')
				GROUP BY user_id,merchant_id,partition_day
			)b
			on a.user_id=b.user_id and a.merchant_id=b.merchant_id and a.partition_date=b.partition_day
			group by a.user_id,a.merchant_id,substr(partition_day,1,6)
		)msg
		group by msg.partition_date,user_id
	)t7
		on a.partition_date=t7.partition_date and a.user_id=t7.user_id
	left join
	(--需求自测有效私信
		SELECT msg.partition_date,user_id
				,count(msg.merchant_id) as valid_msg_num
		FROM
		(
			SELECT a.user_id,a.merchant_id,substr(partition_day,1,6) as month,min(partition_day) as partition_date
			FROM
			(
				SELECT partition_date,user_id,merchant_id
				from
				(--点击发送
					SELECT a.partition_date,user_id,cl_id
						        ,json_map(b.hospital_id,'string,string')['hospital_id'] hospital_id
					FROM
					(
						SELECT partition_date,user_id,cl_id,json_split(params['hospital_id_list']) as hospital_id_list
						FROM online.bl_hdfs_maidian_updates
						where partition_date>=REGEXP_REPLACE(trunc(date_sub(current_date(),1),'MM'),'-','')
						AND partition_date <= regexp_replace(date_sub(current_date,1),'-','')
						and page_name='ai_plan_consult_list'
						and params['button_name'] in ('send')
						and referrer in ('plan_service_list','ai_plan_list')
						and action='on_click_button'
						and int(split(app_version,'\\.')[1]) >= 31
						group by partition_date,user_id,cl_id,params['hospital_id_list']
					)a
					LATERAL VIEW EXPLODE(a.hospital_id_list) b as hospital_id
				)b
				join
				(
			     	SELECT hospital_id,merchant_id
					FROM online.ml_doctor_relation_dimen_day
					WHERE partition_date = regexp_replace(date_sub(current_date,1),'-','')
					AND doctor_is_merchant='true' --医生是商户
					GROUP BY hospital_id,merchant_id
			     )c
			     on c.hospital_id=b.hospital_id
			     group by partition_date,user_id,merchant_id
			)a
			join
			(
				SELECT user_id,merchant_id,partition_day
				FROM ml.ml_c_et_msg_conversation_dimen_inc_d --新仓库私信表
				WHERE partition_day >= REGEXP_REPLACE(trunc(date_sub(current_date(),1),'MM'),'-','')
				AND partition_day <= regexp_replace(date_sub(current_date,1),'-','')
				and is_valid='true'
				GROUP BY user_id,merchant_id,partition_day
			)b
			on a.user_id=b.user_id and a.merchant_id=b.merchant_id and a.partition_date=b.partition_day
			group by a.user_id,a.merchant_id,substr(partition_day,1,6)
		)msg
		group by msg.partition_date,user_id
	)t7_v
		on a.partition_date=t7_v.partition_date and a.user_id=t7_v.user_id
	LEFT JOIN
	( --需求自测电话线索总数
		SELECT partition_date,user_id,count(1) as clue_num
		FROM
		(
			SELECT a.user_id,a.merchant_id,substr(a.partition_date,1,6) as month,min(a.partition_date) as partition_date
			FROM
			(
				SELECT user_id,merchant_id,REGEXP_REPLACE(SUBSTR(last_issue_time,1,10), '-', '') as partition_date
				FROM tl.tl_gm_sl_lead_task  --线索任务表（用户点击授权后记入该表）
				WHERE partition_day>=REGEXP_REPLACE(trunc(date_sub(current_date(),1),'MM'),'-','')
				AND partition_day<=regexp_replace(date_sub(current_date(),1),'-','')
				AND source='2' --用户行为电话授权
				and (user_id is NOT NULL or USER_ID <> '')
				GROUP BY user_id,merchant_id,regexp_replace(SUBSTR(last_issue_time,1,10),'-','')
			)a
			join
			(
				SELECT partition_date,cl_id,user_id
				FROM online.bl_hdfs_maidian_updates
				where partition_date>=REGEXP_REPLACE(trunc(date_sub(current_date(),1),'MM'),'-','')
				AND partition_date <= regexp_replace(date_sub(current_date,1),'-','')
				and params['popup_name']='bargain_phone'
				and page_name in ('plan_service_list','ai_plan_list')
				and params['button_name'] in ('confirm')
				and action='on_click_button'
				and int(split(app_version,'\\.')[1]) >= 31
			)ai
			on a.user_id=ai.user_id and a.partition_date=ai.partition_date
			GROUP BY a.user_id,a.merchant_id,substr(a.partition_date,1,6)
		)a
		group by partition_date,user_id
	)t8
		ON a.partition_date = t8.partition_date and a.user_id=t8.user_id
	LEFT JOIN
	( ---拨打电话线索
		SELECT partition_date,user_id
				,count(1) as call_num
		FROM
		(
			SELECT e.user_id,e.merchant_id,regexp_replace(SUBSTR(a.partition_date,1,6),'-','') AS CALL_MONTH,
					MIN(a.partition_date) as partition_date,
					1 as call_num
			FROM
			(
				SELECT sub_id,REGEXP_REPLACE(SUBSTR(call_time,0,10), '-', '') as partition_date
				FROM  tl.tl_gm_sl_ali_virtual_phone_call_detail --通话记录表，call_type呼叫类型
				WHERE partition_day=regexp_replace(date_sub(current_date,1),'-','')
				AND REGEXP_REPLACE(SUBSTR(call_time,0,10), '-', '')>=REGEXP_REPLACE(trunc(date_sub(current_date(),1),'MM'),'-','')
				AND REGEXP_REPLACE(SUBSTR(call_time,0,10), '-', '')<=regexp_replace(date_sub(current_date(),1),'-','')
				and start_time>call_time
			)a
			LEFT JOIN
			(
				SELECT id,sub_id
				FROM tl.tl_gm_sl_ali_virtual_phone_binding --阿里记录表
				WHERE partition_day=regexp_replace(date_sub(current_date,1),'-','')
			)b
			ON a.sub_id = b.sub_id
			LEFT JOIN
			(
				SELECT id,platform_binding_id
				FROM tl.tl_gm_sl_virtual_phone_binding
				WHERE partition_day=regexp_replace(date_sub(current_date,1),'-','')
			)c
			ON b.id = c.platform_binding_id
			LEFT JOIN
			(
				SELECT phone_binding_id,lead_task_id
				FROM tl.tl_gm_sl_lead_task_phone_binding
				WHERE partition_day=regexp_replace(date_sub(current_date,1),'-','')
			)d
			ON c.id = d.phone_binding_id
			JOIN
			(
				SELECT id,user_id,merchant_id,REGEXP_REPLACE(SUBSTR(last_issue_time,1,10), '-', '') as created_date
				FROM tl.tl_gm_sl_lead_task  --线索任务表（用户点击授权后记入该表）
				WHERE partition_day>=REGEXP_REPLACE(trunc(date_sub(current_date(),1),'MM'),'-','')
				AND partition_day<=regexp_replace(date_sub(current_date(),1),'-','')
				AND source='2' --用户行为电话授权
				and (user_id is NOT NULL or USER_ID <> '')
				group by id,user_id,merchant_id,last_issue_time
			)e
			ON d.lead_task_id = e.id
			join
			(
				SELECT partition_date,cl_id,user_id
				FROM online.bl_hdfs_maidian_updates
				where partition_date>=REGEXP_REPLACE(trunc(date_sub(current_date(),1),'MM'),'-','')
				AND partition_date <= regexp_replace(date_sub(current_date,1),'-','')
				and params['popup_name']='bargain_phone'
				and page_name in ('plan_service_list','ai_plan_list')
				and params['button_name'] in ('confirm')
				and action='on_click_button'
				and int(split(app_version,'\\.')[1]) >= 31
			)ai
			on e.user_id=ai.user_id and e.created_date=ai.partition_date
			GROUP BY e.user_id,e.merchant_id,regexp_replace(SUBSTR(a.partition_date,1,6),'-','')
		)t1
		GROUP BY user_id,partition_date
	)t9
		ON a.partition_date = t9.partition_date and a.user_id=t9.user_id
	LEFT JOIN
	( ---拨打电话线索
		SELECT partition_date,user_id
				,count(1) as valid_call_num
		FROM
		(
			SELECT e.user_id,e.merchant_id,regexp_replace(SUBSTR(a.partition_date,1,6),'-','') AS CALL_MONTH,
					MIN(a.partition_date) as partition_date,
					1 as call_num
			FROM
			(
				SELECT sub_id,REGEXP_REPLACE(SUBSTR(call_time,0,10), '-', '') as partition_date
				FROM  tl.tl_gm_sl_ali_virtual_phone_call_detail --通话记录表，call_type呼叫类型
				WHERE partition_day=regexp_replace(date_sub(current_date,1),'-','')
				AND REGEXP_REPLACE(SUBSTR(call_time,0,10), '-', '')>=REGEXP_REPLACE(trunc(date_sub(current_date(),1),'MM'),'-','')
				AND REGEXP_REPLACE(SUBSTR(call_time,0,10), '-', '')<=regexp_replace(date_sub(current_date(),1),'-','')
				and start_time>call_time
				and start_time<release_time
			)a
			LEFT JOIN
			(
				SELECT id,sub_id
				FROM tl.tl_gm_sl_ali_virtual_phone_binding --阿里记录表
				WHERE partition_day=regexp_replace(date_sub(current_date,1),'-','')
			)b
			ON a.sub_id = b.sub_id
			LEFT JOIN
			(
				SELECT id,platform_binding_id
				FROM tl.tl_gm_sl_virtual_phone_binding
				WHERE partition_day=regexp_replace(date_sub(current_date,1),'-','')
			)c
			ON b.id = c.platform_binding_id
			LEFT JOIN
			(
				SELECT phone_binding_id,lead_task_id
				FROM tl.tl_gm_sl_lead_task_phone_binding
				WHERE partition_day=regexp_replace(date_sub(current_date,1),'-','')
			)d
			ON c.id = d.phone_binding_id
			JOIN
			(
				SELECT id,user_id,merchant_id,REGEXP_REPLACE(SUBSTR(last_issue_time,1,10), '-', '') as created_date
				FROM tl.tl_gm_sl_lead_task  --线索任务表（用户点击授权后记入该表）
				WHERE partition_day>=REGEXP_REPLACE(trunc(date_sub(current_date(),1),'MM'),'-','')
				AND partition_day<=regexp_replace(date_sub(current_date(),1),'-','')
				AND source='2' --用户行为电话授权
				and (user_id is NOT NULL or USER_ID <> '')
				group by id,user_id,merchant_id,last_issue_time
			)e
			ON d.lead_task_id = e.id
			join
			(
				SELECT partition_date,cl_id,user_id
				FROM online.bl_hdfs_maidian_updates
				where partition_date>=REGEXP_REPLACE(trunc(date_sub(current_date(),1),'MM'),'-','')
				AND partition_date <= regexp_replace(date_sub(current_date,1),'-','')
				and params['popup_name']='bargain_phone'
				and page_name in ('plan_service_list','ai_plan_list')
				and params['button_name'] in ('confirm')
				and action='on_click_button'
				and int(split(app_version,'\\.')[1]) >= 31
			)ai
			on e.user_id=ai.user_id and e.created_date=ai.partition_date
			GROUP BY e.user_id,e.merchant_id,regexp_replace(SUBSTR(a.partition_date,1,6),'-','')
		)t1
		GROUP BY user_id,partition_date
	)t9_v
		ON a.partition_date = t9_v.partition_date and a.user_id=t9_v.user_id
	left join
	(--t3以上商户私信线索总数
		SELECT msg.partition_date,user_id
				,count(msg.merchant_id) as msg_num
		FROM
		(
			SELECT user_id,merchant_id,SUBSTR(partition_day,1,6) AS MONTH,min(partition_day) as partition_date
			FROM ml.ml_c_et_msg_conversation_dimen_inc_d --新仓库私信表
			WHERE partition_day >=REGEXP_REPLACE(trunc(date_sub(current_date(),1),'MM'),'-','')
			AND partition_day <= regexp_replace(date_sub(current_date,1),'-','')
			group by user_id,merchant_id,SUBSTR(partition_day,1,6)
		)msg
		join
		(
			SELECT distinct merchant_id
			FROM
			(
				SELECT merchant_id,merchant_level
						,row_number() over(partition by merchant_id order by data_month desc) as rn
				FROM online.al_business_merchant_grade_day_repo
				where partition_date=regexp_replace(date_sub(current_date,1),'-','')
			)a
			where rn=1 and merchant_level>=3
		)b
		on msg.merchant_id=b.merchant_id
		GROUP BY msg.partition_date,user_id
	)t10
		ON a.partition_date = t10.partition_date and a.user_id=t10.user_id
	left join
	(--t3以上商户有效私信线索总数
		SELECT msg.partition_date,user_id
				,count(msg.merchant_id) as valid_msg_num
		FROM
		(
			SELECT user_id,merchant_id,SUBSTR(partition_day,1,6) AS MONTH,min(partition_day) as partition_date
			FROM ml.ml_c_et_msg_conversation_dimen_inc_d --新仓库私信表
			WHERE partition_day >=REGEXP_REPLACE(trunc(date_sub(current_date(),1),'MM'),'-','')
			AND partition_day <= regexp_replace(date_sub(current_date,1),'-','')
			and is_valid='true'
			GROUP BY user_id,merchant_id,SUBSTR(partition_day,1,6)
		)msg
		join
		(
			SELECT distinct merchant_id
			FROM
			(
				SELECT merchant_id,merchant_level
						,row_number() over(partition by merchant_id order by data_month desc) as rn
				FROM online.al_business_merchant_grade_day_repo
				where partition_date=regexp_replace(date_sub(current_date,1),'-','')
			)a
			where rn=1 and merchant_level>=3
		)b
		on msg.merchant_id=b.merchant_id
		GROUP BY msg.partition_date,user_id
	)t10_v
	    ON a.partition_date = t10_v.partition_date and a.user_id=t10_v.user_id
	left join
	(--t3以上商户电话线索总数
		SELECT partition_date,user_id,count(1) AS clue_num
		FROM
		(
			SELECT user_id,merchant_id,MIN(REGEXP_REPLACE(SUBSTR(last_issue_time,1,10), '-', '')) as partition_date,regexp_replace(SUBSTR(last_issue_time,1,7),'-','') AS CALL_MONTH
			FROM tl.tl_gm_sl_lead_task  --线索任务表（用户点击授权后记入该表）
			WHERE partition_day>=REGEXP_REPLACE(trunc(date_sub(current_date(),1),'MM'),'-','')
			AND partition_day<=regexp_replace(date_sub(current_date(),1),'-','')
			AND source='2' --用户行为电话授权
			and (user_id is NOT NULL or USER_ID <> '')
			GROUP BY user_id,merchant_id,regexp_replace(SUBSTR(last_issue_time,1,7),'-','')
		)a
		join
		(
			SELECT distinct merchant_id
			FROM
			(
				SELECT merchant_id,merchant_level
						,row_number() over(partition by merchant_id order by data_month desc) as rn
				FROM online.al_business_merchant_grade_day_repo
				where partition_date=regexp_replace(date_sub(current_date,1),'-','')
			)a
			where rn=1 and merchant_level>=3
		)b
		on a.merchant_id=b.merchant_id
		GROUP BY partition_date,user_id
	)t11
		ON a.partition_date = t11.partition_date and a.user_id=t11.user_id
	LEFT JOIN
	( ---拨打电话线索
		SELECT partition_date,user_id
				,count(1) as call_num
		FROM
		(
			SELECT user_id,merchant_id,regexp_replace(SUBSTR(a.partition_date,1,6),'-','') AS CALL_MONTH,
					MIN(partition_date) as partition_date,
					1 as call_num
			FROM
			(
				SELECT sub_id,REGEXP_REPLACE(SUBSTR(call_time,0,10), '-', '') as partition_date
				FROM  tl.tl_gm_sl_ali_virtual_phone_call_detail --通话记录表，call_type呼叫类型
				WHERE partition_day=regexp_replace(date_sub(current_date,1),'-','')
				AND REGEXP_REPLACE(SUBSTR(call_time,0,10), '-', '')>=REGEXP_REPLACE(trunc(date_sub(current_date(),1),'MM'),'-','')
				AND REGEXP_REPLACE(SUBSTR(call_time,0,10), '-', '')<=regexp_replace(date_sub(current_date(),1),'-','')
				and start_time>call_time
			)a
			LEFT JOIN
			(
				SELECT id,sub_id
				FROM tl.tl_gm_sl_ali_virtual_phone_binding --阿里记录表
				WHERE partition_day=regexp_replace(date_sub(current_date,1),'-','')
			)b
			ON a.sub_id = b.sub_id
			LEFT JOIN
			(
				SELECT id,platform_binding_id
				FROM tl.tl_gm_sl_virtual_phone_binding
				WHERE partition_day=regexp_replace(date_sub(current_date,1),'-','')
			)c
			ON b.id = c.platform_binding_id
			LEFT JOIN
			(
				SELECT phone_binding_id,lead_task_id
				FROM tl.tl_gm_sl_lead_task_phone_binding
				WHERE partition_day=regexp_replace(date_sub(current_date,1),'-','')
			)d
			ON c.id = d.phone_binding_id
			JOIN
			(
				SELECT id,user_id,merchant_id
				FROM tl.tl_gm_sl_lead_task  --线索任务表（用户点击授权后记入该表）
				WHERE partition_day=regexp_replace(date_sub(current_date,1),'-','')
				AND source='2' --用户行为电话授权
				and (user_id is NOT NULL or USER_ID <> '')
			)e
			ON d.lead_task_id = e.id
			GROUP BY user_id,merchant_id,regexp_replace(SUBSTR(a.partition_date,1,6),'-','')
		)t1
		join
		(
			SELECT distinct merchant_id
			FROM
			(
				SELECT merchant_id,merchant_level
						,row_number() over(partition by merchant_id order by data_month desc) as rn
				FROM online.al_business_merchant_grade_day_repo
				where partition_date=regexp_replace(date_sub(current_date,1),'-','')
			)a
			where rn=1 and merchant_level>=3
		)b
		on t1.merchant_id=b.merchant_id
		GROUP BY user_id,partition_date
	)t12
		ON a.partition_date = t12.partition_date and a.user_id=t12.user_id
	LEFT JOIN
	( ---拨打有效电话线索
		SELECT partition_date,user_id
				,count(1) as valid_call_num
		FROM
		(
			SELECT user_id,merchant_id,regexp_replace(SUBSTR(a.partition_date,1,6),'-','') AS CALL_MONTH,
					MIN(partition_date) as partition_date,
					1 as call_num
			FROM
			(
				SELECT sub_id,REGEXP_REPLACE(SUBSTR(call_time,0,10), '-', '') as partition_date
				FROM  tl.tl_gm_sl_ali_virtual_phone_call_detail --通话记录表，call_type呼叫类型
				WHERE partition_day=regexp_replace(date_sub(current_date,1),'-','')
				AND REGEXP_REPLACE(SUBSTR(call_time,0,10), '-', '')>=REGEXP_REPLACE(trunc(date_sub(current_date(),1),'MM'),'-','')
				AND REGEXP_REPLACE(SUBSTR(call_time,0,10), '-', '')<=regexp_replace(date_sub(current_date(),1),'-','')
				and start_time>call_time
				and start_time<release_time
			)a
			LEFT JOIN
			(
				SELECT id,sub_id
				FROM tl.tl_gm_sl_ali_virtual_phone_binding --阿里记录表
				WHERE partition_day=regexp_replace(date_sub(current_date,1),'-','')
			)b
			ON a.sub_id = b.sub_id
			LEFT JOIN
			(
				SELECT id,platform_binding_id
				FROM tl.tl_gm_sl_virtual_phone_binding
				WHERE partition_day=regexp_replace(date_sub(current_date,1),'-','')
			)c
			ON b.id = c.platform_binding_id
			LEFT JOIN
			(
				SELECT phone_binding_id,lead_task_id
				FROM tl.tl_gm_sl_lead_task_phone_binding
				WHERE partition_day=regexp_replace(date_sub(current_date,1),'-','')
			)d
			ON c.id = d.phone_binding_id
			JOIN
			(
				SELECT id,user_id,merchant_id
				FROM tl.tl_gm_sl_lead_task  --线索任务表（用户点击授权后记入该表）
				WHERE partition_day=regexp_replace(date_sub(current_date,1),'-','')
				AND source='2' --用户行为电话授权
				and (user_id is NOT NULL or USER_ID <> '')
			)e
			ON d.lead_task_id = e.id
			GROUP BY user_id,merchant_id,regexp_replace(SUBSTR(a.partition_date,1,6),'-','')
		)t1
		join
		(
			SELECT distinct merchant_id
			FROM
			(
				SELECT merchant_id,merchant_level
						,row_number() over(partition by merchant_id order by data_month desc) as rn
				FROM online.al_business_merchant_grade_day_repo
				where partition_date=regexp_replace(date_sub(current_date,1),'-','')
			)a
			where rn=1 and merchant_level>=3
		)b
		on t1.merchant_id=b.merchant_id
		GROUP BY user_id,partition_date
	)t12_v
		ON a.partition_date = t12_v.partition_date and a.user_id=t12_v.user_id
	left join
	(
		SELECT partition_date,user_id,sum(clue_num) as total_clue_num
		FROM
		(
			SELECT msg.partition_date,user_id,count(1) as clue_num
			FROM
			(
				SELECT user_id,merchant_id,SUBSTR(partition_day,1,6) AS MONTH,min(partition_day) as partition_date
				FROM ml.ml_c_et_msg_conversation_dimen_inc_d --新仓库私信表
				WHERE partition_day >=REGEXP_REPLACE(trunc(date_sub(current_date(),1),'MM'),'-','')
				AND partition_day <= regexp_replace(date_sub(current_date,1),'-','')
				GROUP BY user_id,merchant_id,SUBSTR(partition_day,1,6)
			)msg
			GROUP BY msg.partition_date,user_id

			union all
		    --电话线索总数
			SELECT partition_date,user_id,count(1) AS clue_num
			FROM
			(
				SELECT user_id,merchant_id,MIN(REGEXP_REPLACE(SUBSTR(last_issue_time,1,10), '-', '')) as partition_date,regexp_replace(SUBSTR(last_issue_time,1,7),'-','') AS CALL_MONTH
				FROM tl.tl_gm_sl_lead_task  --线索任务表（用户点击授权后记入该表）
				WHERE partition_day>=REGEXP_REPLACE(trunc(date_sub(current_date(),1),'MM'),'-','')
				AND partition_day<=regexp_replace(date_sub(current_date(),1),'-','')
				AND source='2' --用户行为电话授权
				and (user_id is NOT NULL or USER_ID <> '')
				GROUP BY user_id,merchant_id,regexp_replace(SUBSTR(last_issue_time,1,7),'-','')
			)a
			GROUP BY partition_date,user_id
		)a
		group by partition_date,user_id
	)t13
		ON a.partition_date = t13.partition_date and a.user_id=t13.user_id
	left join
	(
		SELECT partition_date,user_id,sum(valid_num) as total_valid_num
		from
		( 	---拨打有效电话线索
			SELECT partition_date,user_id,count(1) as valid_num
			FROM
			(
				SELECT user_id,merchant_id,regexp_replace(SUBSTR(a.partition_date,1,6),'-','') AS CALL_MONTH,
						MIN(partition_date) as partition_date,
						1 as call_num
				FROM
				(
					SELECT sub_id,REGEXP_REPLACE(SUBSTR(call_time,0,10), '-', '') as partition_date
					FROM  tl.tl_gm_sl_ali_virtual_phone_call_detail --通话记录表，call_type呼叫类型
					WHERE partition_day=regexp_replace(date_sub(current_date,1),'-','')
					AND REGEXP_REPLACE(SUBSTR(call_time,0,10), '-', '')>=REGEXP_REPLACE(trunc(date_sub(current_date(),1),'MM'),'-','')
					AND REGEXP_REPLACE(SUBSTR(call_time,0,10), '-', '')<=regexp_replace(date_sub(current_date(),1),'-','')
					and start_time>call_time
					and start_time<release_time
				)a
				LEFT JOIN
				(
					SELECT id,sub_id
					FROM tl.tl_gm_sl_ali_virtual_phone_binding --阿里记录表
					WHERE partition_day=regexp_replace(date_sub(current_date,1),'-','')
				)b
				ON a.sub_id = b.sub_id
				LEFT JOIN
				(
					SELECT id,platform_binding_id
					FROM tl.tl_gm_sl_virtual_phone_binding
					WHERE partition_day=regexp_replace(date_sub(current_date,1),'-','')
				)c
				ON b.id = c.platform_binding_id
				LEFT JOIN
				(
					SELECT phone_binding_id,lead_task_id
					FROM tl.tl_gm_sl_lead_task_phone_binding
					WHERE partition_day=regexp_replace(date_sub(current_date,1),'-','')
				)d
				ON c.id = d.phone_binding_id
				JOIN
				(
					SELECT id,user_id,merchant_id
					FROM tl.tl_gm_sl_lead_task  --线索任务表（用户点击授权后记入该表）
					WHERE partition_day=regexp_replace(date_sub(current_date,1),'-','')
					AND source='2' --用户行为电话授权
					and (user_id is NOT NULL or USER_ID <> '')
				)e
				ON d.lead_task_id = e.id
				GROUP BY user_id,merchant_id,regexp_replace(SUBSTR(a.partition_date,1,6),'-','')
			)t1
			join
			(
				SELECT distinct merchant_id
				FROM
				(
					SELECT merchant_id,merchant_level
							,row_number() over(partition by merchant_id order by data_month desc) as rn
					FROM online.al_business_merchant_grade_day_repo
					where partition_date=regexp_replace(date_sub(current_date,1),'-','')
				)a
				where rn=1 and merchant_level>=3
			)b
			on t1.merchant_id=b.merchant_id
			GROUP BY user_id,partition_date

			union all

			SELECT msg.partition_date,user_id,count(msg.merchant_id) as valid_num
			FROM
			(
				SELECT user_id,merchant_id,SUBSTR(partition_day,1,6) AS MONTH,min(partition_day) as partition_date
				FROM ml.ml_c_et_msg_conversation_dimen_inc_d --新仓库私信表
				WHERE partition_day >=REGEXP_REPLACE(trunc(date_sub(current_date(),1),'MM'),'-','')
				AND partition_day <= regexp_replace(date_sub(current_date,1),'-','')
				and is_valid='true'
				GROUP BY user_id,merchant_id,SUBSTR(partition_day,1,6)
			)msg
			GROUP BY msg.partition_date,user_id
		)a
		group by partition_date,user_id
	)t13_v
		ON a.partition_date = t13_v.partition_date and a.user_id=t13_v.user_id
	group by mas.partition_date,device_os_type,active_type,grey_type,channel
)T1
LEFT JOIN
(
	SELECT t3_d.partition_date,a.device_os_type,a.grey_type
			,a.active_type,a.channel
		    ,nvl(count(distinct case when t3_d.call_num>0 then t3_d.user_id end),0) as call_dev_d
			,nvl(sum(t3_d.call_num),0) as call_num_d

			,nvl(count(distinct case when t3_v_d.valid_call_num>0 then t3_v_d.user_id end),0) as valid_call_dev_d
			,nvl(sum(t3_v_d.valid_call_num),0) as valid_call_num_d

			,nvl(count(distinct case when t12_d.call_num>0 then t12_d.user_id end),0) as call_dev_3_d
			,nvl(sum(t12_d.call_num),0) as call_num_3_d

			,nvl(count(distinct case when t12_v_d.valid_call_num>0 then t12_v_d.user_id end),0) as valid_call_dev_3_d
			,nvl(sum(t12_v_d.valid_call_num),0) as valid_call_num_3_d

			,nvl(count(distinct case when t6_d.call_num>0 then t6_d.user_id end),0) as call_dev_kyc_d
			,nvl(sum(t6_d.call_num),0) as call_num_kyc_d

			,nvl(count(distinct case when t6_v_d.valid_call_num>0 then t6_v_d.user_id end),0) as valid_call_dev_kyc_d
			,nvl(sum(t6_v_d.valid_call_num),0) as valid_call_num_kyc_d

			,nvl(count(distinct case when t9_d.call_num>0 then t9_d.user_id end),0) as call_dev_qa_d
			,nvl(sum(t9_d.call_num),0) as call_num_qa_d

			,nvl(count(distinct case when t9_v_d.valid_call_num>0 then t9_v_d.user_id end),0) as valid_call_dev_qa_d
			,nvl(sum(t9_v_d.valid_call_num),0) as valid_call_num_qa_d
	FROM
	(
		SELECT device_id,device_os_type,user_id,v.grey_type,v.active_type,v.channel
		FROM
		(
			SELECT c.device_id,device_os_type,user_id
			    ,array(case when substr(convup(setencryption(c.device_id,'sha-1'),16,10),-2,2)%20 = 0 then 'kyc灰度' else '非灰' end,'合计') as grey_type
			    ,array('老活跃设备','合计') as active_type
			    ,array(CASE WHEN (a.device_id is not null or b.device_id is not null
							or first_channel_source_type like '%xinyouxingkong%'
							or first_channel_source_type like '%jingmeng%'
							or first_channel_source_type like '%longyuzhixing%'
							or first_channel_source_type like '%mailuo%') THEN '渠道可疑'
					WHEN tmp.is_ai_channel='true' THEN 'AI' ELSE '其他' END , '合计') as channel
			FROM
			(
				SELECT device_id,device_os_type,a.user_id,a.partition_date,first_channel_source_type
						,row_number() over(partition by device_id order by a.partition_date desc) as rn
				FROM
				(
					SELECT device_id,v.device_os_type,v.user_id,partition_date
							,if(size(channel_source_type_list) > 0, channel_source_type_list [ 0 ], '') AS first_channel_source_type
					FROM online.ml_device_updates
					LATERAL VIEW EXPLODE(user_list) v as user_id
					LATERAL VIEW EXPLODE(device_os_type) v as device_os_type
					where partition_date>='20200801' and partition_date<=regexp_replace(date_sub(current_date(),1),'-','')
				)a--由于要取近期该设备用过的user_id，故时间取的较长，避免用公式而将月末数据少算
				join
				(
					SELECT partition_date,user_id
					FROM online.ml_user_updates
					where partition_date>='20200801' and partition_date<=regexp_replace(date_sub(current_date(),1),'-','')
					and phone is not null and phone <>''
					group by partition_date,user_id
				)b
				on a.partition_date=b.partition_date and a.user_id=b.user_id
			)c
			LEFT JOIN
	        (
	        	SELECT code,is_spam,is_ai_channel,partition_day
            	FROM DIM.DIM_AI_CHANNEL_ZP_NEW
            	WHERE partition_day >=REGEXP_REPLACE(trunc(date_sub(current_date(),1),'MM'),'-','')
            	and partition_day<=regexp_replace(date_sub(current_date,1),'-','')
            )tmp
	        on c.first_channel_source_type=tmp.code and c.partition_date=tmp.partition_day
	        LEFT JOIN
	        (
	        	SELECT DISTINCT device_id
		        FROM al.al_pm_ct_dv_deviceappversionrollbackfrom20190101_d
		        WHERE partition_day = regexp_replace(date_sub(current_date,2),'-','')
		    )a
    		ON c.device_id = a.device_id
    		LEFT JOIN
    		(
    			SELECT device_id,day_id
    			FROM pm.tl_pm_channel_d
    			WHERE partition_day =regexp_replace(date_sub(current_date,1),'-','')
    			GROUP BY device_id,day_id
    		)b
    		ON c.device_id = b.device_id AND c.partition_date = b.day_id
		    where rn=1
		)d
		LATERAL VIEW EXPLODE(d.grey_type)v as grey_type
		LATERAL VIEW EXPLODE(d.active_type)v as active_type
		LATERAL VIEW explode(d.channel) v AS channel
	)a
	JOIN
	( ---非当天拨打电话线索
		SELECT partition_date,user_id
				,count(1) as call_num
		FROM
		(
			SELECT user_id,merchant_id,regexp_replace(SUBSTR(a.partition_date,1,6),'-','') AS CALL_MONTH,
					MIN(partition_date) as partition_date,
					1 as call_num
			FROM
			(
				SELECT sub_id,REGEXP_REPLACE(SUBSTR(call_time,0,10), '-', '') as partition_date
				FROM  tl.tl_gm_sl_ali_virtual_phone_call_detail --通话记录表，call_type呼叫类型
				WHERE partition_day=regexp_replace(date_sub(current_date,1),'-','')
				AND REGEXP_REPLACE(SUBSTR(call_time,0,10), '-', '')>=REGEXP_REPLACE(trunc(date_sub(current_date(),1),'MM'),'-','')
				AND REGEXP_REPLACE(SUBSTR(call_time,0,10), '-', '')<=regexp_replace(date_sub(current_date(),1),'-','')
				and start_time>call_time
			)a
			LEFT JOIN
			(
				SELECT id,sub_id
				FROM tl.tl_gm_sl_ali_virtual_phone_binding --阿里记录表
				WHERE partition_day=regexp_replace(date_sub(current_date,1),'-','')
			)b
			ON a.sub_id = b.sub_id
			LEFT JOIN
			(
				SELECT id,platform_binding_id
				FROM tl.tl_gm_sl_virtual_phone_binding
				WHERE partition_day=regexp_replace(date_sub(current_date,1),'-','')
			)c
			ON b.id = c.platform_binding_id
			LEFT JOIN
			(
				SELECT phone_binding_id,lead_task_id
				FROM tl.tl_gm_sl_lead_task_phone_binding
				WHERE partition_day=regexp_replace(date_sub(current_date,1),'-','')
			)d
			ON c.id = d.phone_binding_id
			JOIN
			(
				SELECT id,user_id,merchant_id,REGEXP_REPLACE(SUBSTR(last_issue_time,1,10), '-', '') as created_date
				FROM tl.tl_gm_sl_lead_task  --线索任务表（用户点击授权后记入该表）
				WHERE partition_day=regexp_replace(date_sub(current_date,1),'-','')
				AND source='2' --用户行为电话授权
				and (user_id is NOT NULL or USER_ID <> '')
			)e
			ON d.lead_task_id = e.id
			where a.partition_date<>e.created_date
			GROUP BY user_id,merchant_id,regexp_replace(SUBSTR(a.partition_date,1,6),'-','')
		)t1
		GROUP BY user_id,partition_date
	)t3_d
		ON  a.user_id=t3_d.user_id
	LEFT JOIN
	( ---非当天拨打有效电话线索
		SELECT partition_date,user_id
				,count(1) as valid_call_num
		FROM
		(
			SELECT user_id,merchant_id,regexp_replace(SUBSTR(a.partition_date,1,6),'-','') AS CALL_MONTH,
					MIN(partition_date) as partition_date,
					1 as call_num
			FROM
			(
				SELECT sub_id,REGEXP_REPLACE(SUBSTR(call_time,0,10), '-', '') as partition_date
				FROM  tl.tl_gm_sl_ali_virtual_phone_call_detail --通话记录表，call_type呼叫类型
				WHERE partition_day=regexp_replace(date_sub(current_date,1),'-','')
				AND REGEXP_REPLACE(SUBSTR(call_time,0,10), '-', '')>=REGEXP_REPLACE(trunc(date_sub(current_date(),1),'MM'),'-','')
				AND REGEXP_REPLACE(SUBSTR(call_time,0,10), '-', '')<=regexp_replace(date_sub(current_date(),1),'-','')
				and start_time>call_time
				and start_time<release_time
			)a
			LEFT JOIN
			(
				SELECT id,sub_id
				FROM tl.tl_gm_sl_ali_virtual_phone_binding --阿里记录表
				WHERE partition_day=regexp_replace(date_sub(current_date,1),'-','')
			)b
			ON a.sub_id = b.sub_id
			LEFT JOIN
			(
				SELECT id,platform_binding_id
				FROM tl.tl_gm_sl_virtual_phone_binding
				WHERE partition_day=regexp_replace(date_sub(current_date,1),'-','')
			)c
			ON b.id = c.platform_binding_id
			LEFT JOIN
			(
				SELECT phone_binding_id,lead_task_id
				FROM tl.tl_gm_sl_lead_task_phone_binding
				WHERE partition_day=regexp_replace(date_sub(current_date,1),'-','')
			)d
			ON c.id = d.phone_binding_id
			JOIN
			(
				SELECT id,user_id,merchant_id,REGEXP_REPLACE(SUBSTR(last_issue_time,1,10), '-', '') as created_date
				FROM tl.tl_gm_sl_lead_task  --线索任务表（用户点击授权后记入该表）
				WHERE partition_day=regexp_replace(date_sub(current_date,1),'-','')
				AND source='2' --用户行为电话授权
				and (user_id is NOT NULL or USER_ID <> '')
			)e
			ON d.lead_task_id = e.id
			where a.partition_date<>e.created_date
			GROUP BY user_id,merchant_id,regexp_replace(SUBSTR(a.partition_date,1,6),'-','')
		)t1
		GROUP BY user_id,partition_date
	)t3_v_d
		ON t3_d.partition_date = t3_v_d.partition_date and t3_d.user_id=t3_v_d.user_id

	LEFT JOIN
	( --拨打电话线索
		SELECT partition_date,user_id
				,count(1) as call_num
		FROM
		(
			SELECT e.user_id,e.merchant_id,regexp_replace(SUBSTR(a.partition_date,1,6),'-','') AS CALL_MONTH,
					MIN(a.partition_date) as partition_date,
					1 as call_num
			FROM
			(
				SELECT sub_id,REGEXP_REPLACE(SUBSTR(call_time,0,10), '-', '') as partition_date
				FROM  tl.tl_gm_sl_ali_virtual_phone_call_detail --通话记录表，call_type呼叫类型
				WHERE partition_day=regexp_replace(date_sub(current_date,1),'-','')
				AND REGEXP_REPLACE(SUBSTR(call_time,0,10), '-', '')>=REGEXP_REPLACE(trunc(date_sub(current_date(),1),'MM'),'-','')
				AND REGEXP_REPLACE(SUBSTR(call_time,0,10), '-', '')<=regexp_replace(date_sub(current_date(),1),'-','')
				and start_time>call_time
			)a
			LEFT JOIN
			(
				SELECT id,sub_id
				FROM tl.tl_gm_sl_ali_virtual_phone_binding --阿里记录表
				WHERE partition_day=regexp_replace(date_sub(current_date,1),'-','')
			)b
			ON a.sub_id = b.sub_id
			LEFT JOIN
			(
				SELECT id,platform_binding_id
				FROM tl.tl_gm_sl_virtual_phone_binding
				WHERE partition_day=regexp_replace(date_sub(current_date,1),'-','')
			)c
			ON b.id = c.platform_binding_id
			LEFT JOIN
			(
				SELECT phone_binding_id,lead_task_id
				FROM tl.tl_gm_sl_lead_task_phone_binding
				WHERE partition_day=regexp_replace(date_sub(current_date,1),'-','')
			)d
			ON c.id = d.phone_binding_id
			JOIN
			(
				SELECT id,user_id,merchant_id,REGEXP_REPLACE(SUBSTR(last_issue_time,1,10), '-', '') as created_date
				FROM tl.tl_gm_sl_lead_task  --线索任务表（用户点击授权后记入该表）
				WHERE partition_day>=REGEXP_REPLACE(trunc(date_sub(current_date(),1),'MM'),'-','')
				AND partition_day<=regexp_replace(date_sub(current_date(),1),'-','')
				AND source='2' --用户行为电话授权
				and (user_id is NOT NULL or USER_ID <> '')
				group by id,user_id,merchant_id,last_issue_time
			)e
			ON d.lead_task_id = e.id
			join
			(
				SELECT partition_date,user_id,merchant_id
				from
				(
			     	SELECT partition_date,cl_id,user_id,hospital_id
					from
					(
						SELECT partition_date,cl_id,user_id,json_split(params['hospital_id'],'string') as hospital_ids
						FROM online.bl_hdfs_maidian_updates
						where partition_date>=REGEXP_REPLACE(trunc(date_sub(current_date(),1),'MM'),'-','')
						AND partition_date <= regexp_replace(date_sub(current_date,1),'-','')
						and page_name in ('kyc_phone')
						and action='on_click_button'
						and params['button_name']='agree'
				        and params['hospital_id'] like '%[%'--其实传的是doctor_id
					)a
					LATERAL VIEW explode(hospital_ids) b AS hospital_id
					group by partition_date,cl_id,user_id,hospital_id
			     )a
			     join
			     (
			     	SELECT doctor_id,merchant_id
					FROM online.ml_doctor_relation_dimen_day
					WHERE partition_date = regexp_replace(date_sub(current_date,1),'-','')
					AND doctor_is_merchant='true' --医生是商户
					GROUP BY doctor_id,merchant_id
			     )b
			     on a.hospital_id=b.doctor_id
			)kyc
			on e.user_id=kyc.user_id and e.merchant_id=kyc.merchant_id and e.created_date=kyc.partition_date
			where a.partition_date<>e.created_date
			GROUP BY e.user_id,e.merchant_id,regexp_replace(SUBSTR(a.partition_date,1,6),'-','')
		)t1
		GROUP BY user_id,partition_date
	)t6_d
		ON t3_d.partition_date = t6_d.partition_date and t3_d.user_id=t6_d.user_id

	LEFT JOIN
	( ---拨打电话线索
		SELECT partition_date,user_id
				,count(1) as valid_call_num
		FROM
		(
			SELECT e.user_id,e.merchant_id,regexp_replace(SUBSTR(a.partition_date,1,6),'-','') AS CALL_MONTH,
					MIN(a.partition_date) as partition_date,
					1 as call_num
			FROM
			(
				SELECT sub_id,REGEXP_REPLACE(SUBSTR(call_time,0,10), '-', '') as partition_date
				FROM  tl.tl_gm_sl_ali_virtual_phone_call_detail --通话记录表，call_type呼叫类型
				WHERE partition_day=regexp_replace(date_sub(current_date,1),'-','')
				AND REGEXP_REPLACE(SUBSTR(call_time,0,10), '-', '')>=REGEXP_REPLACE(trunc(date_sub(current_date(),1),'MM'),'-','')
				AND REGEXP_REPLACE(SUBSTR(call_time,0,10), '-', '')<=regexp_replace(date_sub(current_date(),1),'-','')
				and start_time>call_time
				and start_time<release_time
			)a
			LEFT JOIN
			(
				SELECT id,sub_id
				FROM tl.tl_gm_sl_ali_virtual_phone_binding --阿里记录表
				WHERE partition_day=regexp_replace(date_sub(current_date,1),'-','')
			)b
			ON a.sub_id = b.sub_id
			LEFT JOIN
			(
				SELECT id,platform_binding_id
				FROM tl.tl_gm_sl_virtual_phone_binding
				WHERE partition_day=regexp_replace(date_sub(current_date,1),'-','')
			)c
			ON b.id = c.platform_binding_id
			LEFT JOIN
			(
				SELECT phone_binding_id,lead_task_id
				FROM tl.tl_gm_sl_lead_task_phone_binding
				WHERE partition_day=regexp_replace(date_sub(current_date,1),'-','')
			)d
			ON c.id = d.phone_binding_id
			JOIN
			(
				SELECT id,user_id,merchant_id,REGEXP_REPLACE(SUBSTR(last_issue_time,1,10), '-', '') as created_date
				FROM tl.tl_gm_sl_lead_task  --线索任务表（用户点击授权后记入该表）
				WHERE partition_day>=REGEXP_REPLACE(trunc(date_sub(current_date(),1),'MM'),'-','')
				AND partition_day<=regexp_replace(date_sub(current_date(),1),'-','')
				AND source='2' --用户行为电话授权
				and (user_id is NOT NULL or USER_ID <> '')
				group by id,user_id,merchant_id,last_issue_time
			)e
			ON d.lead_task_id = e.id
			join
			(
				SELECT partition_date,user_id,merchant_id
				from
				(
			     	SELECT partition_date,cl_id,user_id,hospital_id
					from
					(
						SELECT partition_date,cl_id,user_id,json_split(params['hospital_id'],'string') as hospital_ids
						FROM online.bl_hdfs_maidian_updates
						where partition_date>=REGEXP_REPLACE(trunc(date_sub(current_date(),1),'MM'),'-','')
						AND partition_date <= regexp_replace(date_sub(current_date,1),'-','')
						and page_name in ('kyc_phone')
						and action='on_click_button'
						and params['button_name']='agree'
				        and params['hospital_id'] like '%[%'--其实传的是doctor_id
					)a
					LATERAL VIEW explode(hospital_ids) b AS hospital_id
					group by partition_date,cl_id,user_id,hospital_id
			     )a
			     join
			     (
			     	SELECT doctor_id,merchant_id
					FROM online.ml_doctor_relation_dimen_day
					WHERE partition_date = regexp_replace(date_sub(current_date,1),'-','')
					AND doctor_is_merchant='true' --医生是商户
					GROUP BY doctor_id,merchant_id
			     )b
			     on a.hospital_id=b.doctor_id
			)kyc
			on e.user_id=kyc.user_id and e.merchant_id=kyc.merchant_id and e.created_date=kyc.partition_date
			where a.partition_date<>e.created_date
			GROUP BY e.user_id,e.merchant_id,regexp_replace(SUBSTR(a.partition_date,1,6),'-','')
		)t1
		GROUP BY user_id,partition_date
	)t6_v_d
		ON t3_d.partition_date = t6_v_d.partition_date and t3_d.user_id=t6_v_d.user_id

	LEFT JOIN
	( ---拨打电话线索
		SELECT partition_date,user_id
				,count(1) as call_num
		FROM
		(
			SELECT e.user_id,e.merchant_id,regexp_replace(SUBSTR(a.partition_date,1,6),'-','') AS CALL_MONTH,
					MIN(a.partition_date) as partition_date,
					1 as call_num
			FROM
			(
				SELECT sub_id,REGEXP_REPLACE(SUBSTR(call_time,0,10), '-', '') as partition_date
				FROM  tl.tl_gm_sl_ali_virtual_phone_call_detail --通话记录表，call_type呼叫类型
				WHERE partition_day=regexp_replace(date_sub(current_date,1),'-','')
				AND REGEXP_REPLACE(SUBSTR(call_time,0,10), '-', '')>=REGEXP_REPLACE(trunc(date_sub(current_date(),1),'MM'),'-','')
				AND REGEXP_REPLACE(SUBSTR(call_time,0,10), '-', '')<=regexp_replace(date_sub(current_date(),1),'-','')
				and start_time>call_time
			)a
			LEFT JOIN
			(
				SELECT id,sub_id
				FROM tl.tl_gm_sl_ali_virtual_phone_binding --阿里记录表
				WHERE partition_day=regexp_replace(date_sub(current_date,1),'-','')
			)b
			ON a.sub_id = b.sub_id
			LEFT JOIN
			(
				SELECT id,platform_binding_id
				FROM tl.tl_gm_sl_virtual_phone_binding
				WHERE partition_day=regexp_replace(date_sub(current_date,1),'-','')
			)c
			ON b.id = c.platform_binding_id
			LEFT JOIN
			(
				SELECT phone_binding_id,lead_task_id
				FROM tl.tl_gm_sl_lead_task_phone_binding
				WHERE partition_day=regexp_replace(date_sub(current_date,1),'-','')
			)d
			ON c.id = d.phone_binding_id
			JOIN
			(
				SELECT id,user_id,merchant_id,REGEXP_REPLACE(SUBSTR(last_issue_time,1,10), '-', '') as created_date
				FROM tl.tl_gm_sl_lead_task  --线索任务表（用户点击授权后记入该表）
				WHERE partition_day>=REGEXP_REPLACE(trunc(date_sub(current_date(),1),'MM'),'-','')
				AND partition_day<=regexp_replace(date_sub(current_date(),1),'-','')
				AND source='2' --用户行为电话授权
				and (user_id is NOT NULL or USER_ID <> '')
				group by id,user_id,merchant_id,last_issue_time
			)e
			ON d.lead_task_id = e.id
			join
			(
				SELECT partition_date,cl_id,user_id
				FROM online.bl_hdfs_maidian_updates
				where partition_date>=REGEXP_REPLACE(trunc(date_sub(current_date(),1),'MM'),'-','')
				AND partition_date <= regexp_replace(date_sub(current_date,1),'-','')
				and params['popup_name']='bargain_phone'
				and page_name in ('plan_service_list','ai_plan_list')
				and params['button_name'] in ('confirm')
				and action='on_click_button'
				and int(split(app_version,'\\.')[1]) >= 31
			)ai
			on e.user_id=ai.user_id and e.created_date=ai.partition_date
			where a.partition_date<>e.created_date
			GROUP BY e.user_id,e.merchant_id,regexp_replace(SUBSTR(a.partition_date,1,6),'-','')
		)t1
		GROUP BY user_id,partition_date
	)t9_d
		ON t3_d.partition_date = t9_d.partition_date and t3_d.user_id=t9_d.user_id

	LEFT JOIN
	( ---拨打电话线索
		SELECT partition_date,user_id
				,count(1) as valid_call_num
		FROM
		(
			SELECT e.user_id,e.merchant_id,regexp_replace(SUBSTR(a.partition_date,1,6),'-','') AS CALL_MONTH,
					MIN(a.partition_date) as partition_date,
					1 as call_num
			FROM
			(
				SELECT sub_id,REGEXP_REPLACE(SUBSTR(call_time,0,10), '-', '') as partition_date
				FROM  tl.tl_gm_sl_ali_virtual_phone_call_detail --通话记录表，call_type呼叫类型
				WHERE partition_day=regexp_replace(date_sub(current_date,1),'-','')
				AND REGEXP_REPLACE(SUBSTR(call_time,0,10), '-', '')>=REGEXP_REPLACE(trunc(date_sub(current_date(),1),'MM'),'-','')
				AND REGEXP_REPLACE(SUBSTR(call_time,0,10), '-', '')<=regexp_replace(date_sub(current_date(),1),'-','')
				and start_time>call_time
				and start_time<release_time
			)a
			LEFT JOIN
			(
				SELECT id,sub_id
				FROM tl.tl_gm_sl_ali_virtual_phone_binding --阿里记录表
				WHERE partition_day=regexp_replace(date_sub(current_date,1),'-','')
			)b
			ON a.sub_id = b.sub_id
			LEFT JOIN
			(
				SELECT id,platform_binding_id
				FROM tl.tl_gm_sl_virtual_phone_binding
				WHERE partition_day=regexp_replace(date_sub(current_date,1),'-','')
			)c
			ON b.id = c.platform_binding_id
			LEFT JOIN
			(
				SELECT phone_binding_id,lead_task_id
				FROM tl.tl_gm_sl_lead_task_phone_binding
				WHERE partition_day=regexp_replace(date_sub(current_date,1),'-','')
			)d
			ON c.id = d.phone_binding_id
			JOIN
			(
				SELECT id,user_id,merchant_id,REGEXP_REPLACE(SUBSTR(last_issue_time,1,10), '-', '') as created_date
				FROM tl.tl_gm_sl_lead_task  --线索任务表（用户点击授权后记入该表）
				WHERE partition_day>=REGEXP_REPLACE(trunc(date_sub(current_date(),1),'MM'),'-','')
				AND partition_day<=regexp_replace(date_sub(current_date(),1),'-','')
				AND source='2' --用户行为电话授权
				and (user_id is NOT NULL or USER_ID <> '')
				group by id,user_id,merchant_id,last_issue_time
			)e
			ON d.lead_task_id = e.id
			join
			(
				SELECT partition_date,cl_id,user_id
				FROM online.bl_hdfs_maidian_updates
				where partition_date>=REGEXP_REPLACE(trunc(date_sub(current_date(),1),'MM'),'-','')
				AND partition_date <= regexp_replace(date_sub(current_date,1),'-','')
				and params['popup_name']='bargain_phone'
				and page_name in ('plan_service_list','ai_plan_list')
				and params['button_name'] in ('confirm')
				and action='on_click_button'
				and int(split(app_version,'\\.')[1]) >= 31
			)ai
			on e.user_id=ai.user_id and e.created_date=ai.partition_date
			where a.partition_date<>e.created_date
			GROUP BY e.user_id,e.merchant_id,regexp_replace(SUBSTR(a.partition_date,1,6),'-','')
		)t1
		GROUP BY user_id,partition_date
	)t9_v_d
		ON t3_d.partition_date = t9_v_d.partition_date and t3_d.user_id=t9_v_d.user_id

	LEFT JOIN
	( ---拨打电话线索
		SELECT partition_date,user_id
				,count(1) as call_num
		FROM
		(
			SELECT user_id,merchant_id,regexp_replace(SUBSTR(a.partition_date,1,6),'-','') AS CALL_MONTH,
					MIN(partition_date) as partition_date,
					1 as call_num
			FROM
			(
				SELECT sub_id,REGEXP_REPLACE(SUBSTR(call_time,0,10), '-', '') as partition_date
				FROM  tl.tl_gm_sl_ali_virtual_phone_call_detail --通话记录表，call_type呼叫类型
				WHERE partition_day=regexp_replace(date_sub(current_date,1),'-','')
				AND REGEXP_REPLACE(SUBSTR(call_time,0,10), '-', '')>=REGEXP_REPLACE(trunc(date_sub(current_date(),1),'MM'),'-','')
				AND REGEXP_REPLACE(SUBSTR(call_time,0,10), '-', '')<=regexp_replace(date_sub(current_date(),1),'-','')
				and start_time>call_time
			)a
			LEFT JOIN
			(
				SELECT id,sub_id
				FROM tl.tl_gm_sl_ali_virtual_phone_binding --阿里记录表
				WHERE partition_day=regexp_replace(date_sub(current_date,1),'-','')
			)b
			ON a.sub_id = b.sub_id
			LEFT JOIN
			(
				SELECT id,platform_binding_id
				FROM tl.tl_gm_sl_virtual_phone_binding
				WHERE partition_day=regexp_replace(date_sub(current_date,1),'-','')
			)c
			ON b.id = c.platform_binding_id
			LEFT JOIN
			(
				SELECT phone_binding_id,lead_task_id
				FROM tl.tl_gm_sl_lead_task_phone_binding
				WHERE partition_day=regexp_replace(date_sub(current_date,1),'-','')
			)d
			ON c.id = d.phone_binding_id
			JOIN
			(
				SELECT id,user_id,merchant_id,REGEXP_REPLACE(SUBSTR(last_issue_time,1,10), '-', '') as created_date
				FROM tl.tl_gm_sl_lead_task  --线索任务表（用户点击授权后记入该表）
				WHERE partition_day=regexp_replace(date_sub(current_date,1),'-','')
				AND source='2' --用户行为电话授权
				and (user_id is NOT NULL or USER_ID <> '')
			)e
			ON d.lead_task_id = e.id
			where a.partition_date<>e.created_date
			GROUP BY user_id,merchant_id,regexp_replace(SUBSTR(a.partition_date,1,6),'-','')
		)t1
		join
		(
			SELECT distinct merchant_id
			FROM
			(
				SELECT merchant_id,merchant_level
						,row_number() over(partition by merchant_id order by data_month desc) as rn
				FROM online.al_business_merchant_grade_day_repo
				where partition_date=regexp_replace(date_sub(current_date,1),'-','')
			)a
			where rn=1 and merchant_level>=3
		)b
		on t1.merchant_id=b.merchant_id
		GROUP BY user_id,partition_date
	)t12_d
		ON t3_d.partition_date = t12_d.partition_date and t3_d.user_id=t12_d.user_id

	LEFT JOIN
	( ---拨打有效电话线索
		SELECT partition_date,user_id
				,count(1) as valid_call_num
		FROM
		(
			SELECT user_id,merchant_id,regexp_replace(SUBSTR(a.partition_date,1,6),'-','') AS CALL_MONTH,
					MIN(partition_date) as partition_date,
					1 as call_num
			FROM
			(
				SELECT sub_id,REGEXP_REPLACE(SUBSTR(call_time,0,10), '-', '') as partition_date
				FROM  tl.tl_gm_sl_ali_virtual_phone_call_detail --通话记录表，call_type呼叫类型
				WHERE partition_day=regexp_replace(date_sub(current_date,1),'-','')
				AND REGEXP_REPLACE(SUBSTR(call_time,0,10), '-', '')>=REGEXP_REPLACE(trunc(date_sub(current_date(),1),'MM'),'-','')
				AND REGEXP_REPLACE(SUBSTR(call_time,0,10), '-', '')<=regexp_replace(date_sub(current_date(),1),'-','')
				and start_time>call_time
				and start_time<release_time
			)a
			LEFT JOIN
			(
				SELECT id,sub_id
				FROM tl.tl_gm_sl_ali_virtual_phone_binding --阿里记录表
				WHERE partition_day=regexp_replace(date_sub(current_date,1),'-','')
			)b
			ON a.sub_id = b.sub_id
			LEFT JOIN
			(
				SELECT id,platform_binding_id
				FROM tl.tl_gm_sl_virtual_phone_binding
				WHERE partition_day=regexp_replace(date_sub(current_date,1),'-','')
			)c
			ON b.id = c.platform_binding_id
			LEFT JOIN
			(
				SELECT phone_binding_id,lead_task_id
				FROM tl.tl_gm_sl_lead_task_phone_binding
				WHERE partition_day=regexp_replace(date_sub(current_date,1),'-','')
			)d
			ON c.id = d.phone_binding_id
			JOIN
			(
				SELECT id,user_id,merchant_id,REGEXP_REPLACE(SUBSTR(last_issue_time,1,10), '-', '') as created_date
				FROM tl.tl_gm_sl_lead_task  --线索任务表（用户点击授权后记入该表）
				WHERE partition_day=regexp_replace(date_sub(current_date,1),'-','')
				AND source='2' --用户行为电话授权
				and (user_id is NOT NULL or USER_ID <> '')
			)e
			ON d.lead_task_id = e.id
			where a.partition_date<>e.created_date
			GROUP BY user_id,merchant_id,regexp_replace(SUBSTR(a.partition_date,1,6),'-','')
		)t1
		join
		(
			SELECT distinct merchant_id
			FROM
			(
				SELECT merchant_id,merchant_level
						,row_number() over(partition by merchant_id order by data_month desc) as rn
				FROM online.al_business_merchant_grade_day_repo
				where partition_date=regexp_replace(date_sub(current_date,1),'-','')
			)a
			where rn=1 and merchant_level>=3
		)b
		on t1.merchant_id=b.merchant_id
		GROUP BY user_id,partition_date
	)t12_v_d
		ON t3_d.partition_date = t12_v_d.partition_date and t3_d.user_id=t12_v_d.user_id
group by t3_d.partition_date,a.device_os_type,a.grey_type,a.active_type,a.channel
)T2
on T1.partition_date=T2.partition_date
AND T1.device_os_type=T2.device_os_type
AND T1.active_type=T2.active_type
AND T1.grey_type=T2.grey_type
AND T1.channel=T2.channel


