--***************************************************************
--*脚本名称:
--*功能: 搜索日报
--*业务名称: pm
--*输入数据:
--*作者: yindanlei@igengmei.com
--*更新时间:2020-08-07
--***************************************************************

--设置全局变量&UDF
SET mapreduce.job.queuename=data;

--使用bl数据库
USE pm;

--创建BL层内部表
CREATE TABLE IF NOT EXISTS pm.tl_pm_search_d
(
 day_id string comment '{"chs_name":"日期","description":"","etl":"","value":"","remark":""}',
 device_os_type string comment '{"chs_name":"平台","description":"","etl":"","value":"","remark":""}',
 active_type string comment '{"chs_name":"活跃类型","description":"","etl":"","value":"","remark":""}',
 channel string comment '{"chs_name":"渠道类型","description":"","etl":"","value":"","remark":""}',
 dau int comment '{"chs_name":"DAU","description":"","etl":"","value":"","remark":""}',
 all_search_uv int comment '{"chs_name":"完成搜索uv","description":"","etl":"","value":"","remark":""}',
 all_search_pv int comment '{"chs_name":"完成搜索pv","description":"","etl":"","value":"","remark":""}',
 all_search_uv/dau double comment '{"chs_name":"完成搜索的用户比例","description":"","etl":"","value":"","remark":""}',
 all_search_pv/all_search_uv double comment '{"chs_name":"搜索用户人均使用次数","description":"","etl":"","value":"","remark":""}',
 all_search_pv/search_home_pv double comment '{"chs_name":"搜索成功率","description":"","etl":"","value":"","remark":""}',
 sug_search_pv_726/sug_out_pv_726 double comment '{"chs_name":"sug使用率","description":"","etl":"","value":"","remark":""}',
 referrer_search_hexin_pv/all_search_uv double comment '{"chs_name":"来源于搜索的核心页pv/搜索uv","description":"","etl":"","value":"","remark":""}',
 referrer_search_neirong_pv/all_search_uv double comment '{"chs_name":"来源于搜索的内容页pv/搜索uv","description":"","etl":"","value":"","remark":""}',
 search_hexin_two_pv/referrer_search_hexin_pv double comment '{"chs_name":"来源于搜索的核心页二跳率","description":"","etl":"","value":"","remark":""}',
 search_neirong_two_pv/referrer_search_neirong_pv double comment '{"chs_name":"来源于搜索的内容页二跳率","description":"","etl":"","value":"","remark":""}',
 referrer_search_neirong_pagestay double comment '{"chs_name":"来源于搜索的内容平均浏览时长(m)","description":"","etl":"","value":"","remark":""}'
)comment '搜索日报'
PARTITIONED BY (PARTITION_DAY STRING comment '分区日期')
ROW FORMAT DELIMITED
FIELDS TERMINATED BY '\t'
COLLECTION ITEMS TERMINATED BY '\002'
MAP KEYS TERMINATED BY '\003'
LINES TERMINATED BY '\n'
STORED AS TEXTFILE;