SELECT day_id `日期`
		,device_os_type `系统`
		,active_type `新老`
		,channel `渠道`
		,dau as `dau（去除积分墙）`
		,nvl(login_dev_num,0) as `新增注册设备数`
		,nvl(login_user_num,0) as `新增注册账号`
		,nvl(login_phone_user_num,0) as `新增注册手机号用户数`
		,nvl(retention_1,0) as `次日留存率`
		,nvl(retention_7,0) as `第7日留存率`
		,nvl(retention_30,0) as `第30日留存率`
		,nvl(per_open_times,0) as `单设备打开频次`
		,nvl(home_feeds_ctr,0) as `信息流内容ctr`
		,nvl(per_use_time,0) as `单设备app停留时长(M)`
		,nvl(neirong_page_stay,0) as `单设备内容时长(M)`
		,nvl(neirong_in_app_use_time,0) as `单设备内容时长/app停留时长`
		,nvl(service_privacy_uv,0) as `到达隐私授权界面设备数`
		,nvl(service_click_uv,0) as `同意隐私授权设备设备数`
		,nvl(service_privacy_uv_in_dau,0) as `到达隐私授权界面设备数/DAU`
		,nvl(service_click_uv_in_dau,0) as `同意隐私授权设备数/到达隐私授权界面设备数`
		,nvl(open_push_uv,0) as `开启推送授权设备数`
		,nvl(open_push_uv_in_dau,0) as `开启推送授权设备数/DAU`
		,nvl(push_receive_uv_in_open_push_uv,0) as `次日接收推送设备数/当天开启推送授权设备数`
		,nvl(click_uv,0) as `点击推送的设备数`
		,nvl(non_click_uv,0) as `未点击推送的设备数`
		,nvl(click_uv_in_dau,0) as `点击推送设备数/DAU`

		,nvl(non_click_uv_in_dau,0) `未点击推送设备数/DAU`
		,nvl(op_push_open_uv,0) `点击运营推送设备数`
		,nvl(auto_push_open_uv,0) as `点击系统推送设备数`
		,nvl(personal_push_open_uv,0) `点击个性化推送设备数`
		,nvl(sign_push_open_uv,0) as `点击签到推送设备数`
		,nvl(op_push_open_uv_in_receive,0) as `点击运营推送设备/接收到运营推送设备`
		,nvl(auto_push_open_uv_in_receive,0) as `点击系统推送设备/接收到系统推送设备`
		,nvl(personal_push_open_uv_in_receive,0) as `点击个性化推送设备/接收到个性化推送设备`
		,nvl(sign_push_open_uv_in_receive,0) as `点击签到推送设备/接收到签到推送设备`
		,nvl(question_num,0) as `主动提问数`
		,nvl(answer_num,0) as `主动回答数`
		,nvl(topic_num,0) as `主动发帖数`
		,nvl(reply_num,0) as `真实评论数`
		,nvl(question_num_in_dau,0) as `主动提问设备数/DAU`
		,nvl(answer_num_in_dau,0) as `主动回答设备数/DAU`
		,nvl(topic_num_in_dau,0) as `主动发帖设备数/DAU`
		,nvl(reply_num_in_dau,0) as `主动评论设备数/DAU`

		,nvl(neirongUV,0) as `内容UV`
		,nvl(neirongPV,0) `内容PV`
		,nvl(neirongUV_in_dau,0) `内容UV/DAU`
		,nvl(neirongPV_in_UV,0) `内容PV/内容UV`
		,nvl(result_more_UV,0) as `搜索结果综合页UV`
		,nvl(result_meigou_UV,0) as `搜索结果美购页UV`
		,nvl(result_con_UV,0) as `搜索结果商业页UV`
		,nvl(result_more_UV_in_dau,0) as `搜索结果综合页UV/DAU`
		,nvl(result_meigou_UV_in_dau,0) as `搜索结果美购页UV/DAU`
		,nvl(result_con_UV_in_dau,0) as `搜索结果商业页UV/DAU`
		,nvl(result_more_PV,0) as `搜索结果综合页PV`
		,nvl(result_meigou_PV,0) as `搜索结果美购页PV`
		,nvl(result_con_PV,0) as `搜索结果商业页PV`
		,nvl(result_more_PV_in_UV,0) as `搜索结果综合页PV/搜索结果综合页UV`
		,nvl(result_meigou_PV_in_UV,0) as `搜索结果美购页PV/搜索结果美购页UV`
		,nvl(result_con_PV_in_UV,0) `搜索结果商业页PV/搜索结果商业页UV`
		,nvl(result_more_PV_in_dau,0) `搜索结果综合页PV/DAU`
		,nvl(result_meigou_PV_in_dau,0) `搜索结果美购页PV/DAU`
		,nvl(result_con_PV_in_dau,0) as `搜索结果商业页PV/DAU`
		,nvl(neirong_meigou_PV,0) as `来自内容页的美购页PV`
		,nvl(neirong_con_PV,0) as `来自内容页的商业页PV`
		,nvl(neirong_meigou_PV_in_dau,0) as `来自内容页的美购页PV/DAU`
		,nvl(neirong_con_PV_in_dau,0) as `来自内容页的商业页PV/DAU`
		,nvl(neirong_click_pv,0) as `内容页的推荐内容点击pv`
		,nvl(wel_second_pv_in_neirongPV,0) as `来自内容页的商业二跳/内容pv`
		,nvl(neirong_second_pv_in_neirongPV,0) as `来自内容页的内容二跳/内容pv`
		,nvl(pv,0) as `全站日记帖子问答详情页浏览>20 pv`
		,nvl(concat(round(pv_20/pv*100,2),'%'),0) as `全站日记帖子问答详情页浏览>20 pv/同口径下不限制浏览时长总pv`
FROM pm.tl_pm_operation_d_v2
where ((partition_day ='20200922' and day_id<='2020-08-25')
       or (partition_day<regexp_replace(date_sub(current_date,1),'-','') and partition_day>'20200922' and day_id=date_sub(FROM_UNIXTIME(UNIX_TIMESTAMP(partition_day,'yyyymmdd'),'yyyy-mm-dd'),29))
       or (partition_day=regexp_replace(date_sub(current_date,1),'-','') and day_id>=date_sub(current_date,30)))
order by `日期` desc,`系统`,`新老`,`渠道`
