SELECT partition_day as `日期`
    ,count(post_id) as `帖子数量`
    ,nvl(sum(exp_pv_1),0) as `前1日曝光`
    ,nvl(concat(round(sum(click_pv_1)/sum(exp_pv_1)*100,2),'%'),0) as `前1日ctr`
    ,nvl(concat(round(sum(page_pv_20s_1)/sum(exp_pv_1)*100,2),'%'),0) as `日优秀浏览点击ctr`
    ,nvl(round(avg(avg_page_stay_1),2),0) as `前1日平均阅读时长(s)`
    ,nvl(sum(exp_pv),0) as `历史曝光`
    ,nvl(concat(round(sum(click_pv)/sum(exp_pv)*100,2),'%'),0) as `历史ctr`
    ,nvl(concat(round(sum(page_pv_20s)/sum(exp_pv)*100,2),'%'),0) as `历史优秀浏览点击ctr`
    ,nvl(round(avg(avg_page_stay),2),0) as `历史平均阅读时长(s)`
FROM pm.tl_pm_userpost_d_v2
where partition_day>='20200915'
group by partition_day
order by `日期`