SET mapreduce.job.queuename=data;
SET mapreduce.map.memory.mb=8192;
SET mapreduce.map.java.opts=-Xmx8000m;
SET mapreduce.reduce.memory.mb=8192;
SET mapreduce.reduce.java.opts=-Xmx8000m;
set hive.auto.convert.join=true;
SET mapred.reduce.tasks=20;
SET role admin;



INSERT OVERWRITE TABLE pm.tl_pm_channel_d PARTITION (PARTITION_DAY = ${partition_day})

SELECT a.partition_date as day_id
    ,a.device_id as device_id
    ,device_os_type,active_type,first_channel_source_type,first_city
FROM
(
    SELECT
    partition_date,device_os_type
    ,device_id,first_channel_source_type,first_city
    ,case WHEN active_type = '4'  THEN '老活'
          WHEN active_type  in ('1','2')  then '新增' END as active_type
    FROM online.ml_device_day_active_status
    where partition_date >= '20200101'
    AND partition_date < regexp_replace(current_date ,'-','')
    AND active_type in ('1','2','4')
    and first_channel_source_type not in ('yqxiu1','yqxiu2','yqxiu3','yqxiu4','yqxiu5','mxyc1','mxyc2','mxyc3'
    ,'wanpu','jinshan','jx','maimai','zhuoyi','huatian','suopingjingling','mocha','mizhe','meika','lamabang'
    ,'js-az1','js-az2','js-az3','js-az4','js-az5','jfq-az1','jfq-az2','jfq-az3','jfq-az4','jfq-az5','toufang1'
    ,'toufang2','toufang3','toufang4','toufang5','toufang6','TF-toufang1','TF-toufang2','TF-toufang3','TF-toufang4'
    ,'TF-toufang5','tf-toufang1','tf-toufang2','tf-toufang3','tf-toufang4','tf-toufang5','benzhan','promotion_aso100'
    ,'promotion_qianka','promotion_xiaoyu','promotion_dianru','promotion_malioaso','promotion_malioaso-shequ'
    ,'promotion_shike','promotion_julang_jl03','promotion_zuimei','','unknown')
    AND first_channel_source_type not like 'promotion\_jf\_%'
)a
LEFT JOIN
(
    SELECT partition_date,cl_id
    from online.bl_hdfs_maidian_updates
    where partition_date >= '20200101'
    AND partition_date < regexp_replace(current_date ,'-','')
    AND action = 'popup_view'
    AND params['popup_name']='service_privacy'
    GROUP BY partition_date,cl_id
)b
    ON a.device_id = b.cl_id
    AND a.partition_date = b.partition_date

LEFT JOIN
(
    SELECT partition_date,cl_id
    from online.bl_hdfs_maidian_updates
    where partition_date >= '20200101'
    AND partition_date < regexp_replace(current_date ,'-','')
    AND action = 'page_view'
    GROUP BY partition_date,cl_id
)c
    ON a.device_id = c.cl_id
    AND a.partition_date = c.partition_date
LEFT JOIN
(
    SELECT partition_day,device_id
    FROM ml.ml_c_et_ck_click_dimen_d
    where partition_day >= '20200101'
    AND partition_day < regexp_replace(current_date ,'-','')
    GROUP BY partition_day,device_id
)d
    on a.device_id = d.device_id
    AND a.partition_date = d.partition_day
    WHERE b.cl_id is NOT NULL
    AND c.cl_id is NULL
    AND d.device_id is NULL

GROUP BY a.partition_date,a.device_id,device_os_type,active_type,first_channel_source_type,first_city


