SET mapreduce.job.queuename=data;
SET mapreduce.map.memory.mb=8192;
SET mapreduce.map.java.opts=-Xmx8000m;
SET mapreduce.reduce.memory.mb=8192;
SET mapreduce.reduce.java.opts=-Xmx8000m;
set hive.auto.convert.join=true;
SET mapred.reduce.tasks=20;
SET role admin;


INSERT OVERWRITE TABLE pm.tl_pm_yeji_d PARTITION (PARTITION_DAY = ${partition_day})

SELECT nvl(nvl(nvl(nvl(t1.partition_date,t2.DATA_DAY),t3.DATA_MONTH),t4.PAY_MONTH),t5.day_month) as data
  ,nvl(nvl(nvl(nvl(t1.merchant_name,t2.merchant_name),t3.merchant_name),t4.merchant_name),t5.merchant_name) as merchant_name
  ,nvl(nvl(nvl(nvl(t1.business_group_name,t2.business_group_name),t3.business_group_name),t4.business_group_name),t5.business_group_name)  as business_group_name
  ,nvl(nvl(nvl(nvl(t1.business_partener_name,t2.business_partener_name),t3.business_partener_name),t4.business_partener_name),t5.business_partener_name) as business_partener_name
  ,nvl(nvl(nvl(nvl(t1.city_name,t2.city_name),t3.city_name),t4.city_name),t5.city_name) as city_name
  ,nvl(hexin_pv,0) as hexin_pv
  ,nvl(service_pv,0) as service_pv
  ,nvl(clue_num,0) as clue_num
  ,nvl(discount,0) as discount
  ,nvl(recharge_amount,0) as recharge_amount
  ,nvl(chongzhi_amount,0) as chongzhi_amount
  ,nvl(all_amount,0) as all_amount
  ,nvl(cpc_amount,0) as cpc_amount
  ,nvl(cpc_chongzhi_amount,0) as cpc_chongzhi_amount
  ,nvl(budget,0) as budget
  ,nvl(cpc_click_num,0) as cpc_click_num
  ,nvl(liulan_amount,0) as liulan_amount
  ,nvl(sixin_amount,0) as sixin_amount
  ,nvl(service_price,0) as service_price

FROM
---核心、美购页pv
(
  SELECT
  a.partition_date
  ,merchant_name
  ,b.business_group_name
  ,b.business_partener_name
  ,city_name
  ,SUM(hexin_pv) as hexin_pv
  ,SUM(service_pv) as service_pv
  FROM
  (
    SELECT  --之前是根据merchant_id算的，有重复，如果按doctor_id值不会重复
      partition_date,doctor_id,SUM(pv_num) as hexin_pv,SUM(case when business_type = 'service' then pv_num end) as service_pv
    FROM  online.ml_doctor_event_indic_day
    WHERE partition_date=REGEXP_REPLACE(date_sub(current_date(),1),'-','')
    AND merchant_id IS NOT NULL
    AND merchant_id <> ''
    AND business_type IN ('service','org', 'doctor')
    AND data_type = 'pv'
    AND cl_id <> ''
    AND cl_id <> '0'
    GROUP BY  partition_date,doctor_id
  )a
  LEFT JOIN
  ( --商务归属1009更新
    --！！ 注意：这里的日期变量设置为当前日期的前一天，定时任务为每月第一天，故查询的为上月最后一天的归属
    SELECT
         doctor_id,merchant_name,business_group_name,business_partener_name,city_name
    FROM
    online.ml_doctor_relation_dimen_day
    WHERE partition_date =REGEXP_REPLACE(date_sub(current_date(),1),'-','')
    GROUP BY doctor_id,merchant_name,business_group_name,business_partener_name,city_name
  )b
  ON a.doctor_id=b.doctor_id
  GROUP BY  a.partition_date
  ,merchant_name
  ,b.business_group_name
  ,b.business_partener_name
  ,city_name
)t1
FULL JOIN
(
  SELECT DATA_DAY
  ,merchant_name
  ,b.business_group_name
  ,b.business_partener_name
  ,city_name
  ,SUM(clue_num) as clue_num
  FROM
  (--有效线索分日数据
      SELECT
          DATA_DAY,merchant_id,count(1) AS clue_num
      FROM
      (
          SELECT NVL(T1.USER_ID,T2.USER_ID) AS USER_ID,
                  NVL(T1.merchant_id,T2.merchant_id) AS merchant_id,
                  NVL(T1.DATA_MONTH,T2.CALL_MONTH) AS DATA_MONTH,
                  least(NVL(DATA_DAY,'99999999'),NVL(FIRST_CALL_DATE,'99999999')) AS DATA_DAY,
                  NVL(T1.CONSULT_NUM,0) AS CONSULT_NUM,
                  NVL(T1.PAY_NUM,0) AS PAY_NUM,
                  NVL(T2.call_num,0) AS CALL_NUM
          FROM
          (
              SELECT
                  NVL(T3.USER_ID,T4.USER_ID) AS USER_ID,
                  NVL(T3.merchant_id,T4.merchant_id) AS merchant_id,
                  NVL(T3.CONSULT_MONTH,T4.PAY_MONTH) AS DATA_MONTH,
                  least(NVL(first_consult_date,'99999999'),NVL(FIRST_PAY_DATE,'99999999')) AS DATA_DAY,
                  NVL(T3.CONSULT_NUM,0) AS CONSULT_NUM,
                  NVL(T4.PAY_NUM,0) AS PAY_NUM
              FROM
              (
                  SELECT
                      user_id
                      ,merchant_id
                      ,substr(partition_day,1,6) AS consult_month
                      ,min(partition_day) AS first_consult_date
                      ,1 AS consult_num
                  FROM  ml.ML_C_ET_MSG_CONVERSATION_DIMEN_INC_D
                  WHERE
                      partition_day  =REGEXP_REPLACE(date_sub(current_date(),1),'-','')
                      AND is_valid='true'
                      AND merchant_id IS NOT NULL
                  GROUP BY user_id,merchant_id,substr(partition_day,1,6)
              )T3
              FULL JOIN
              (
                  SELECT
                      T.USER_ID,
                      T.merchant_id,
                      regexp_replace(SUBSTR(T.PAY_DATE,1,7),'-','') AS PAY_MONTH,
                      MIN(regexp_replace(SUBSTR(T.PAY_DATE,1,10),'-','')) AS FIRST_PAY_DATE,
                      1 AS PAY_NUM
                  FROM  ONLINE.ML_TRADE_ORDER_DETAIL_DAY T
                  WHERE
                      T.PARTITION_DATE = REGEXP_REPLACE(date_sub(current_date(),1),'-','')
                      AND regexp_replace(substr(T.PAY_DATE,1,10),'-','') =REGEXP_REPLACE(date_sub(current_date(),1),'-','')
                      AND T.is_pure_user='true'
                  GROUP BY T.USER_ID,T.merchant_id,regexp_replace(SUBSTR(T.PAY_DATE,1,7),'-','')
              ) T4
              ON T3.USER_ID = T4.USER_ID AND T3.merchant_id = T4.merchant_id AND T3.CONSULT_MONTH = T4.PAY_MONTH
              GROUP BY NVL(T3.USER_ID,T4.USER_ID),NVL(T3.merchant_id,T4.merchant_id),NVL(T3.CONSULT_MONTH,T4.PAY_MONTH),
                  least(NVL(first_consult_date,'99999999'),NVL(FIRST_PAY_DATE,'99999999')),NVL(T3.CONSULT_NUM,0),NVL(T4.PAY_NUM,0)
          )T1

          FULL JOIN
          (
              SELECT user_id,merchant_id,regexp_replace(SUBSTR(a.partition_date,1,6),'-','') AS CALL_MONTH,
              MIN(partition_date) as FIRST_CALL_DATE,1 AS call_num
              FROM
              (
                  SELECT sub_id,REGEXP_REPLACE(SUBSTR(call_time,0,10), '-', '') as partition_date
                  FROM  tl.tl_gm_sl_ali_virtual_phone_call_detail --通话记录表，call_type呼叫类型
                  WHERE partition_day=regexp_replace(date_sub(current_date(),1),'-','')
                  AND REGEXP_REPLACE(SUBSTR(call_time,0,10), '-', '')=REGEXP_REPLACE(date_sub(current_date(),1),'-','')
                  --AND start_time+ interval 30 second <= release_time --通话时长大于30秒
                  AND release_time>start_time
              )a
              LEFT JOIN
              (
                  SELECT id,sub_id
                  FROM tl.tl_gm_sl_ali_virtual_phone_binding --阿里记录表
                  WHERE partition_day=REGEXP_REPLACE(date_sub(current_date(),1),'-','')
              )b
                  ON a.sub_id = b.sub_id
              LEFT JOIN
              (
                  SELECT id,platform_binding_id
                  FROM tl.tl_gm_sl_virtual_phone_binding
                  WHERE partition_day=REGEXP_REPLACE(date_sub(current_date(),1),'-','')
              )c
                  ON b.id = c.platform_binding_id
              LEFT JOIN
              (
                  SELECT phone_binding_id,lead_task_id
                  FROM tl.tl_gm_sl_lead_task_phone_binding
                  WHERE partition_day=REGEXP_REPLACE(date_sub(current_date(),1),'-','')
              )d
                  ON c.id = d.phone_binding_id
              JOIN
              (
                  SELECT id,user_id,merchant_id
                  FROM tl.tl_gm_sl_lead_task  --线索任务表（用户点击授权后记入该表）
                  WHERE partition_day=REGEXP_REPLACE(date_sub(current_date(),1),'-','')
                  AND source='2' --用户行为电话授权
                  AND (USER_ID is NOT NULL or USER_ID <>'')
              )e
                  ON d.lead_task_id = e.id
              GROUP BY user_id,merchant_id,regexp_replace(SUBSTR(a.partition_date,1,6),'-','')
          )T2
          ON T1.USER_ID = T2.USER_ID AND T1.merchant_id = T2.merchant_id AND T1.DATA_MONTH = T2.CALL_MONTH
      )T1
      GROUP BY DATA_DAY,merchant_id
  )t3

  LEFT JOIN
  ( --商务归属1009更新
    --！！ 注意：这里的日期变量设置为当前日期的前一天，定时任务为每月第一天，故查询的为上月最后一天的归属
    SELECT
         merchant_id,merchant_name,business_group_name,business_partener_name,city_name
    FROM
    online.ml_doctor_relation_dimen_day
    WHERE partition_date =REGEXP_REPLACE(date_sub(current_date(),1),'-','')
    GROUP BY merchant_id,merchant_name,business_group_name,business_partener_name,city_name
  )b
  ON t3.merchant_id=b.merchant_id
  GROUP BY  DATA_DAY
  ,merchant_name
  ,b.business_group_name
  ,b.business_partener_name
  ,city_name
)t2
  ON t1.partition_date=t2.DATA_DAY AND t1.merchant_name=t2.merchant_name
  AND t1.business_group_name=t2.business_group_name AND t1.business_partener_name=t2.business_partener_name
  AND t1.city_name=t2.city_name

FULL JOIN
(
    SELECT nvl(nvl(t1.month,t2.month),t3.month) as DATA_MONTH
    ,nvl(nvl(t1.merchant_name,t2.merchant_name),t3.merchant_name) as merchant_name
    ,nvl(nvl(t1.business_group_name,t2.business_group_name),t3.business_group_name) as business_group_name
    ,nvl(nvl(t1.business_partener_name,t2.business_partener_name),t3.business_partener_name) as business_partener_name
    ,nvl(nvl(t1.city_name,t2.city_name),t3.city_name) as city_name
    ,nvl(discount,0) as discount
    ,nvl(recharge_amount,0) as recharge_amount
    ,nvl(all_amount,0) as all_amount
    ,nvl(chongzhi_amount,0) as chongzhi_amount
    ,nvl(cpc_amount,0) as cpc_amount
    ,nvl(cpc_chongzhi_amount,0) as cpc_chongzhi_amount
    ,nvl(cpc_click_num,0) as cpc_click_num
    ,nvl(liulan_amount,0) as liulan_amount
    ,nvl(sixin_amount,0) as sixin_amount
    FROM
    (
      --佣金（订单验证抽成+一般补单（常规补单+罚款）+买单+剔除转诊关联的订单
      SELECT month,merchant_name,business_group_name,business_partener_name,city_name,SUM(money1) as discount
      FROM
      (
          SELECT SUBSTR(REGEXP_REPLACE(SUBSTR(validate_time, 1, 10), '-', ''),1,8) as month,doctor_id,sum(discount) as money1
          FROM online.ml_trade_order_detail_day   --美购交易表
          WHERE partition_date = REGEXP_REPLACE(date_sub(current_date(),1),'-','')
          AND REGEXP_REPLACE(SUBSTR(validate_time, 1, 10), '-', '') = REGEXP_REPLACE(date_sub(current_date(),1),'-','')
          AND status <> '3'   --去除已退款
          AND is_referral_order ='false'  --去除转诊关联的订单
          GROUP BY REGEXP_REPLACE(SUBSTR(validate_time, 1, 10), '-', ''),doctor_id

          UNION ALL
          SELECT SUBSTR(REGEXP_REPLACE(SUBSTR(created_time, 1, 10), '-', ''),1,8) as month,doctor_id,sum(amount) as money1
          FROM online.tl_hdfs_budanluru_view   --补单录入表
          WHERE partition_date = REGEXP_REPLACE(date_sub(current_date(),1),'-','')
          AND REGEXP_REPLACE(SUBSTR(created_time, 1, 10), '-', '') = REGEXP_REPLACE(date_sub(current_date(),1),'-','')
          AND status = 0  --已录入
          AND type in ('0','2')  --常规补单和罚款
          GROUP BY REGEXP_REPLACE(SUBSTR(created_time, 1, 10), '-', ''),doctor_id

          UNION ALL
          SELECT SUBSTR(REGEXP_REPLACE(SUBSTR(created_time, 1, 10), '-', ''),1,8) as month,doctor_id,sum(discount_cent)/100 as money1
          FROM online.tl_maidan_order_view   --买单表
          WHERE partition_date = REGEXP_REPLACE(date_sub(current_date(),1),'-','')
          AND REGEXP_REPLACE(SUBSTR(created_time, 1, 10), '-', '') = REGEXP_REPLACE(date_sub(current_date(),1),'-','')
          AND status ='1'
          GROUP BY REGEXP_REPLACE(SUBSTR(created_time, 1, 10), '-', ''),doctor_id
      )ord
      LEFT JOIN
      (
        SELECT doctor_id,city_name,business_group_name,business_partener_name,merchant_name
        FROM online.ml_doctor_relation_dimen_day
        WHERE partition_date=REGEXP_REPLACE(date_sub(current_date(),1),'-','')
        GROUP BY doctor_id,city_name,business_group_name,business_partener_name,merchant_name
      )doc
        on ord.doctor_id = doc.doctor_id
      GROUP BY month,merchant_name,business_group_name,business_partener_name,city_name
    )t1

    FULL JOIN
    ( --广告充值
      SELECT month,merchant_name,business_group_name,business_partener_name,city_name,SUM(recharge_amount) as recharge_amount
      FROM
      (
          SELECT SUBSTR(partition_day,1,8) as month,merchant_id,sum(proportion_recharge_amount) as recharge_amount  --当天充值金额
          FROM ml.ml_c_ct_mc_merchant_indic_d
          WHERE partition_day = REGEXP_REPLACE(date_sub(current_date(),1),'-','')
          GROUP BY SUBSTR(partition_day,1,8),merchant_id
      )gg
      LEFT JOIN
      (
        SELECT merchant_id,city_name,business_group_name,business_partener_name,merchant_name
        FROM online.ml_doctor_relation_dimen_day
        WHERE partition_date=REGEXP_REPLACE(date_sub(current_date(),1),'-','')
        AND doctor_is_merchant = 'true'
        GROUP BY merchant_id,city_name,business_group_name,business_partener_name,merchant_name
      )doc
        on gg.merchant_id = doc.merchant_id
        GROUP BY month,merchant_name,business_group_name,business_partener_name,city_name
    )t2
    on t1.month=t2.month AND t1.merchant_name=t2.merchant_name AND t1.business_group_name=t2.business_group_name AND t1.business_partener_name=t2.business_partener_name AND t1.city_name=t2.city_name

    FULL JOIN
    (--广告充值消耗（报表口径）
      SELECT month,merchant_name,business_group_name,business_partener_name,city_name,SUM(all_amount) as all_amount,SUM(chongzhi_amount) as chongzhi_amount
          ,SUM(cpc_amount) as cpc_amount,SUM(cpc_chongzhi_amount) as cpc_chongzhi_amount,SUM(cpc_click_num) as cpc_click_num,SUM(liulan_amount) as liulan_amount,SUM(sixin_amount) as sixin_amount
      FROM
      (
          SELECT SUBSTR(partition_day,1,8) as month,merchant_id
          ,SUM(CASE WHEN advertise_type = 'cpc' AND advertise_calculate_type = 'cpc_flownext' THEN
                 proportion_expend_recharge_amount
                WHEN advertise_type = 'cpt' AND advertise_calculate_type = 'cpt_schedule' THEN
                 proportion_expend_recharge_amount
                WHEN advertise_type IN ('browse', 'message', 'valueadded','rechargededuction') THEN
                 proportion_expend_recharge_amount
                WHEN advertise_type = 'adjustment' AND advertise_calculate_type ='adjustment_flow' THEN
                 proportion_expend_recharge_amount
                ELSE
                 0
              END) chongzhi_amount  --广告充值总消耗（等比例）
          ,SUM(CASE WHEN advertise_type = 'cpc' AND advertise_calculate_type = 'cpc_flownext' THEN
                 proportion_expend_amount
                WHEN advertise_type = 'cpt' AND advertise_calculate_type = 'cpt_schedule' THEN
                 proportion_expend_amount
                WHEN advertise_type IN ('browse', 'message', 'valueadded','rechargededuction') THEN
                 proportion_expend_amount
                WHEN advertise_type = 'adjustment' AND advertise_calculate_type ='adjustment_flow' THEN
                 proportion_expend_amount
                ELSE
                 0
              END) all_amount  --广告总消耗（含返点等比例）
          ,SUM(CASE WHEN advertise_type = 'cpc' AND advertise_calculate_type = 'cpc_flownext' THEN proportion_expend_amount END) as cpc_amount  --cpc总消耗
          ,SUM(CASE WHEN advertise_type = 'cpc' AND advertise_calculate_type = 'cpc_flownext' THEN proportion_expend_recharge_amount END) as cpc_chongzhi_amount  --cpc充值消耗
          ,SUM(case when advertise_type = 'cpc' AND advertise_business_type in('service') and advertise_calculate_type='cpc_log' then cpc_click_num end)   cpc_click_num  ---当天cpc商品点击量
          ,SUM(CASE WHEN advertise_type='browse' THEN proportion_expend_recharge_amount END) as liulan_amount  --浏览收入(不含返点)
          ,SUM(CASE WHEN advertise_type='message' THEN proportion_expend_recharge_amount END) as sixin_amount  --私信收入(不含返点)
          from ml.ml_c_ct_mc_merchantadclassify_indic_d
          where partition_day=REGEXP_REPLACE(date_sub(current_date(),1),'-','')
          group by SUBSTR(partition_day,1,8),merchant_id
      )gg
      LEFT JOIN
      (
        SELECT merchant_id,city_name,business_group_name,business_partener_name,merchant_name
        FROM online.ml_doctor_relation_dimen_day
        WHERE partition_date=REGEXP_REPLACE(date_sub(current_date(),1),'-','')
        AND doctor_is_merchant = 'true'
        GROUP BY merchant_id,city_name,business_group_name,business_partener_name,merchant_name
      )doc
        on gg.merchant_id = doc.merchant_id
        GROUP BY month,merchant_name,business_group_name,business_partener_name,city_name
    )t3
    on nvl(t1.month,t2.month)=t3.month
    and nvl(t1.merchant_name,t2.merchant_name)=t3.merchant_name
    AND nvl(t1.business_group_name,t2.business_group_name)=t3.business_group_name
    AND nvl(t1.business_partener_name,t2.business_partener_name)=t3.business_partener_name
    AND nvl(t1.city_name,t2.city_name)=t3.city_name
)t3
  on nvl(t1.partition_date,t2.DATA_DAY)=t3.DATA_MONTH
  and nvl(t1.merchant_name,t2.merchant_name)=t3.merchant_name
  AND nvl(t1.business_group_name,t2.business_group_name)=t3.business_group_name
  AND nvl(t1.business_partener_name,t2.business_partener_name)=t3.business_partener_name
  AND nvl(t1.city_name,t2.city_name)=t3.city_name

FULL JOIN
(
    SELECT SUBSTR(pay_date, 1, 8) as PAY_MONTH,merchant_name,business_group_name,business_partener_name,city_name,SUM(service_price) as service_price
    FROM
    (
      SELECT REGEXP_REPLACE(SUBSTR(pay_time, 1, 10), '-', '') as pay_date,doctor_id,sum(service_price) as service_price
      FROM online.ml_trade_order_detail_day   --美购交易表（梦雨新做）
      WHERE partition_date = REGEXP_REPLACE(date_sub(current_date(),1),'-','')
        AND REGEXP_REPLACE(SUBSTR(pay_time, 1, 10), '-', '') = REGEXP_REPLACE(date_sub(current_date(),1),'-','')
        AND is_pure_user = 'true'   --取纯用户
        GROUP BY REGEXP_REPLACE(SUBSTR(pay_time, 1, 10), '-', ''),doctor_id
    )ord
    LEFT JOIN
    (
      SELECT doctor_id,city_name,business_group_name,business_partener_name,merchant_name
      FROM online.ml_doctor_relation_dimen_day
      WHERE partition_date=REGEXP_REPLACE(date_sub(current_date(),1),'-','')
      GROUP BY doctor_id,city_name,business_group_name,business_partener_name,merchant_name
    )doc
      on ord.doctor_id = doc.doctor_id
    GROUP BY SUBSTR(pay_date, 1, 8),merchant_name,business_group_name,business_partener_name,city_name
)t4
  on nvl(nvl(t1.partition_date,t2.DATA_DAY),t3.DATA_MONTH)=t4.PAY_MONTH
  and nvl(nvl(t1.merchant_name,t2.merchant_name),t3.merchant_name) =t4.merchant_name
  AND nvl(nvl(t1.business_group_name,t2.business_group_name),t3.business_group_name)=t4.business_group_name
  AND nvl(nvl(t1.business_partener_name,t2.business_partener_name),t3.business_partener_name)=t4.business_partener_name
  AND nvl(nvl(t1.city_name,t2.city_name),t3.city_name)=t4.city_name

FULL JOIN
(
    SELECT SUBSTR(day_id, 1, 8) as day_month,merchant_name,business_group_name,business_partener_name,city_name,SUM(budget) as budget
    FROM
    (
      SELECT T1.day_id,T1.merchant_doctor_id,case when merchant_budget>=tot_service_budget then tot_service_budget else merchant_budget end as budget
      FROM
      (
          SELECT
            clicklog.create_time AS day_id
            ,clicklog.merchant_doctor_id
            ,max(merchant_budget) as merchant_budget --商户预算
          FROM
          (
              SELECT id,promote_id,price,service_budget,merchant_budget,merchant_doctor_id,regexp_replace(substr(create_time,1,10),'-','') as create_time,recharge
              FROM online.tl_hdfs_cpc_clicklog_view
              WHERE partition_date=REGEXP_REPLACE(date_sub(current_date(),1),'-','')
              AND regexp_replace(substr(create_time,1,10),'-','')= REGEXP_REPLACE(date_sub(current_date(),1),'-','')
          )clicklog
          group by clicklog.create_time,clicklog.merchant_doctor_id
      )T1
      LEFT JOIN
      (
          SELECT
               day_id
               ,merchant_doctor_id
              ,sum(service_budget) as tot_service_budget
          FROM
          (
              SELECT
                clicklog.create_time AS day_id
                ,clicklog.merchant_doctor_id,clicklog.service_id
                ,max(service_budget) as service_budget

              FROM
              (
                  SELECT id,promote_id,price,service_budget,merchant_budget,merchant_doctor_id,service_id,regexp_replace(substr(create_time,1,10),'-','') as create_time
                  FROM  online.tl_hdfs_cpc_clicklog_view
                  WHERE partition_date=REGEXP_REPLACE(date_sub(current_date(),1),'-','')
                  AND regexp_replace(substr(create_time,1,10),'-','')= REGEXP_REPLACE(date_sub(current_date(),1),'-','')
              )clicklog
              GROUP BY clicklog.create_time,clicklog.merchant_doctor_id,clicklog.service_id
          )service_budget
          GROUP BY day_id,merchant_doctor_id
      )T2
      ON T1.day_id=T2.day_id
      AND T1.merchant_doctor_id=T2.merchant_doctor_id
    )ord
    LEFT JOIN
    (
      SELECT  merchant_doctor_id,merchant_name,business_group_name,business_partener_name,city_name
      FROM online.ml_doctor_relation_dimen_day
      WHERE partition_date=REGEXP_REPLACE(date_sub(current_date(),1),'-','')
      AND doctor_is_merchant='true'
      group by  merchant_doctor_id,merchant_name,business_group_name,business_partener_name,city_name
    )doc
      on ord.merchant_doctor_id = doc.merchant_doctor_id
    GROUP BY SUBSTR(day_id, 1, 8),merchant_name,business_group_name,business_partener_name,city_name
)t5
  on nvl(nvl(nvl(t1.partition_date,t2.DATA_DAY),t3.DATA_MONTH),t4.PAY_MONTH)=t5.day_month
  and nvl(nvl(nvl(t1.merchant_name,t2.merchant_name),t3.merchant_name),t4.merchant_name)=t5.merchant_name
  AND nvl(nvl(nvl(t1.business_group_name,t2.business_group_name),t3.business_group_name),t4.business_group_name)=t5.business_group_name
  AND nvl(nvl(nvl(t1.business_partener_name,t2.business_partener_name),t3.business_partener_name),t4.business_partener_name)=t5.business_partener_name
  AND nvl(nvl(nvl(t1.city_name,t2.city_name),t3.city_name),t4.city_name)=t5.city_name
order by data desc









