package com.gmei.data.gateway.server.service.impl;

import com.gmei.data.gateway.server.common.Constants;
import com.gmei.data.gateway.server.dto.ExcelGenDto;
import com.gmei.data.gateway.server.service.ExcelService;
import com.gmei.data.gateway.server.utils.DateUtils;
import com.gmei.data.gateway.server.utils.ProperUtils;
import org.apache.poi.hssf.usermodel.*;
import org.apache.poi.ss.usermodel.BorderStyle;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.VerticalAlignment;
import org.apache.poi.ss.util.CellRangeAddress;
import org.apache.poi.xssf.usermodel.*;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;

/**
 * ClassName: ExcelServiceImpl
 * Function: Excel业务处理类.
 * Date: 2020-04-28 20:57
 *
 * @since JDK 1.8
 */
@Service
public class ExcelServiceImpl implements ExcelService {

    @Value("${excel.output.path}")
    private String filePath;
    private static final Logger logger = LoggerFactory.getLogger(ExcelServiceImpl.class);

    /**
     * Excel流输出
     * @return
     */
    @Override
    public int genExcel(ExcelGenDto excelGenDto, String name) {
        int rs = Constants.SUCCESS;
        try {
            List<String> sheetNameList = excelGenDto.getSheetNameList();
            List<List<String>> headersList = excelGenDto.getHeadersList();
            List<List<List>> rowsList = excelGenDto.getRowsList();
            XSSFWorkbook wb = new XSSFWorkbook();
            if(null != sheetNameList && sheetNameList.size() > 0){
                List<XSSFSheet> sheets = new ArrayList<XSSFSheet>();
                for(int i=0;i<sheetNameList.size();i++){
                    XSSFSheet sheet = wb.createSheet(sheetNameList.get(i));
                    sheets.add(sheet);
                }
                this.output(wb,sheets,headersList,rowsList);
            }else{
                rs = Constants.FAIL;
                logger.error("Error!");
            }
            //String subject = "";
            //String value = ProperUtils.getValue(properFilePath, name);
            //if(null != value){
            //    subject = value;
            //}else{
            //    subject = name;
            //}
            FileOutputStream out = new FileOutputStream(filePath + name + "-" + DateUtils.getYesterdayDateSimpleStr() + ".xlsx");
            wb.write(out);
            out.close();
        } catch (IOException e) {
            rs = Constants.FAIL;
            e.printStackTrace();
        }
        return rs;
    }

    /**
     * 输出包含多个sheet的excel文件
     * @param sheetList
     */
    public void output(XSSFWorkbook wb,List<XSSFSheet> sheetList,List<List<String>> headersList, List<List<List>> rowsList){
        XSSFCellStyle cellStyle=wb.createCellStyle();
        cellStyle.setVerticalAlignment(VerticalAlignment.CENTER);
        cellStyle.setAlignment(HorizontalAlignment.CENTER);
        //cellStyle.setAlignment(HorizontalAlignment.LEFT);
        cellStyle.setBorderBottom(BorderStyle.THIN);
        cellStyle.setBorderLeft(BorderStyle.THIN);
        cellStyle.setBorderRight(BorderStyle.THIN);
        cellStyle.setBorderTop(BorderStyle.THIN);
        //cellStyle.setWrapText(true);//自动换行
        for(int i =0;i<sheetList.size();i++){
            XSSFSheet sheet = sheetList.get(i);
            List<String> headers = headersList.get(i);
            List<List> rows = rowsList.get(i);

            XSSFRow header = sheet.createRow(0);
            //设置sheet头部列宽
            for(int ii=0;ii<headers.size();ii++){
                sheet.setColumnWidth(ii,20*256);
            }
            //给sheet头部赋值以及设置样式
            Integer columIndex = 0;
            for(String str: headers){
                XSSFCell cell = header.createCell(columIndex);
                cell.setCellValue(str);
                cell.setCellStyle(cellStyle);
                columIndex++;
            }
            Integer rowIndex = 1;
            for(List row: rows){
                XSSFRow hssfRow = sheet.createRow(rowIndex);
                //设置单元格长度
                for(int ii=0;ii<row.size();ii++){
                    sheet.setColumnWidth(ii,20*256);
                }
                //依次给单元格赋值
                Integer j = 0;
                for(Object value: row){
                    XSSFCell cell = hssfRow.createCell(j);
                    cell.setCellStyle(cellStyle);
                    this.setCellValue(cell, value);
                    j++;
                }
                rowIndex ++;
            }
        }
    }

    /**
     * Excel单元格赋值
     * @param cell
     * @param value
     */
    private void setCellValue(XSSFCell cell, Object value) {
        if(null != value){
            if (value instanceof String) {
                cell.setCellValue((String) value);
            } else if (value instanceof Integer) {
                cell.setCellValue((Integer) value);
            } else if (value instanceof Float) {
                cell.setCellValue((Float) value);
            } else if (value instanceof Double){
                cell.setCellValue((Double)value);
            } else if (value instanceof Date) {
                cell.setCellValue((Date) value);
            } else if (value instanceof Boolean) {
                cell.setCellValue((Boolean) value);
            } else {
                cell.setCellValue("unknown value type");
                logger.error("value's type is {}!",value.getClass().toString());
            }
        }else{
            cell.setCellValue("");
            logger.error("the value is null!");
        }
    }

    /**
     * 画excel格局的demo代码
     * @param args
     */
    public static void main(String[] args) {
      HSSFWorkbook workbook = new HSSFWorkbook();

      HSSFCellStyle style = workbook.createCellStyle();
      style.setAlignment(HSSFCellStyle.ALIGN_CENTER);
      style.setVerticalAlignment(HSSFCellStyle.VERTICAL_CENTER);
      HSSFSheet sheet = workbook.createSheet("sheet");
      HSSFRow row0 = sheet.createRow(0);
      HSSFCell cell_00 = row0.createCell(0);
      cell_00.setCellStyle(style);
      cell_00.setCellValue("分类");
      HSSFCell cell_01 = row0.createCell(1);
      cell_01.setCellStyle(style);
      cell_01.setCellValue("指标");
      HSSFCell cell_02 = row0.createCell(2);
      cell_02.setCellStyle(style);
      cell_02.setCellValue("昨日值");
      HSSFCell cell_03 = row0.createCell(3);
      cell_03.setCellStyle(style);
      cell_03.setCellValue("前日值");
      HSSFCell cell_04 = row0.createCell(4);
      cell_04.setCellStyle(style);
      cell_04.setCellValue("前日环比");
      HSSFCell cell_05 = row0.createCell(5);
      cell_05.setCellStyle(style);
      cell_05.setCellValue("上周同比");
      HSSFCell cell_06 = row0.createCell(6);
      cell_06.setCellStyle(style);
      cell_06.setCellValue("上月日均值环比");
      HSSFCell cell_07 = row0.createCell(7);
      cell_07.setCellStyle(style);
      cell_07.setCellValue("历史同期上月日均值同比");
      HSSFCell cell_08 = row0.createCell(8);
      cell_08.setCellStyle(style);
      cell_08.setCellValue("预警");

      HSSFRow row1 = sheet.createRow(1);
      HSSFCell cell_10 = row1.createCell(0);
      cell_10.setCellStyle(style);
      cell_10.setCellValue("活跃情况");

      HSSFCell cell_11 = row1.createCell(1);
      cell_11.setCellStyle(style);
      cell_11.setCellValue("DAU");

      HSSFRow row2 = sheet.createRow(2);
      HSSFCell cell_21 = row2.createCell(1);
      cell_21.setCellStyle(style);
      cell_21.setCellValue("新增");

      HSSFRow row3 = sheet.createRow(3);
      HSSFCell cell_31 = row3.createCell(1);
      cell_31.setCellStyle(style);
      cell_31.setCellValue("老活");

      HSSFRow row4 = sheet.createRow(4);
      HSSFCell cell_41 = row4.createCell(1);
      cell_41.setCellStyle(style);
      cell_41.setCellValue("新增次日app留存率（前日）");

      HSSFRow row5 = sheet.createRow(5);
      HSSFCell cell_51 = row5.createCell(1);
      cell_51.setCellStyle(style);
      cell_51.setCellValue("老活次日app留存率（前日）");

      HSSFRow row6 = sheet.createRow(6);
      HSSFCell cell_61 = row6.createCell(1);
      cell_61.setCellStyle(style);
      cell_61.setCellValue("新增单设备app时长");

      HSSFRow row7 = sheet.createRow(7);
      HSSFCell cell_71 = row7.createCell(1);
      cell_71.setCellStyle(style);
      cell_71.setCellValue("新增单设备app打开");

      // 合并日期占两行(4个参数，分别为起始行，结束行，起始列，结束列)
      // 行和列都是从0开始计数，且起始结束都会合并
      // 这里是合并excel中日期的两行为一行
      CellRangeAddress region = new CellRangeAddress(1, 7, 0, 0);
      sheet.addMergedRegion(region);

      try{
          File file = new File("/Users/apple/Downloads/北极星指标_dev.xls");
          FileOutputStream fout = new FileOutputStream(file);
          workbook.write(fout);
          fout.close();
      }catch (Exception e){
          e.printStackTrace();
      }
    }
}

