package com.gmei.data.gateway.server.utils;

import java.io.*;
import java.util.Properties;

/**
 * @ClassName ProperUtils
 * @Author apple
 * @Date 2020/5/1
 * @Version V1.0
 **/
public class ProperUtils {

    /**
     * 根据属性文件路径、key获取value的值
     * @param path
     * @param key
     * @return
     */
    public static String getValue(String path,String key){
        Properties properties = getProperties(path);
        return properties.getProperty(key);
    }

    /**
     * 获取属性文件对象
     *
     * @param path
     * @return
     */
    private static Properties getProperties(String path) {
        Properties properties = new Properties();
        try {
            //InputStream inputStream = ProperUtils.class.getClassLoader().getResourceAsStream(path);
            InputStreamReader reader = new InputStreamReader(new FileInputStream(path), "UTF-8");
            properties.load(reader);
            reader.close();
        } catch (FileNotFoundException e) {
            e.printStackTrace();
        } catch (IOException e) {
            e.printStackTrace();
        }
        return properties;
    }
}
