---电话线索明细数据
SELECT
    t1.created_time as `日期`
    ,t1.id as `线索ID`
    ,doc.hospital_id as `机构ID`
    ,doc.hospital_name as `机构名称`
    ,mer.merchant_level as `商户等级`
    ,doc.business_group_region_name `所属大区`
    ,doc.city_name `所属城市`
    ,doc.business_partener_name`对应商务名`
    ,coalesce(t3.virtual_phone,'-') `留电虚拟号`
    ,t1.created_time `留电时间`
    ,case when t5.release_time>t5.start_time then '已接通'
    when t5.release_time=t5.start_time then '未接通'
    when (t2.lead_task_id is null )then '未绑定'
    when t5.sub_id is null then '未联系'end as `沟通状态`
    ,coalesce(t5.call_type,'-') as `拨打状态`

    FROM
    (
        select id,created_time,phone_binding_id,merchant_id
        from tl.tl_gm_sl_lead_task
        WHERE partition_day=REGEXP_REPLACE(date_sub(current_date(),1),'-','')
        and source='2'
        AND REGEXP_REPLACE(SUBSTR(created_time,0,10), '-', '')>=REGEXP_REPLACE(date_sub(current_date(),7),'-','')
        AND REGEXP_REPLACE(SUBSTR(created_time,0,10), '-', '')<=REGEXP_REPLACE(date_sub(current_date(),1),'-','')
        ---AND id ='7268457'
     )t1
     LEFT JOIN
    (
        SELECT id,merchant_level
        FROM online.tl_hdfs_hippo_merchant_view
        where partition_date=regexp_replace(date_sub(current_date,1),'-','')
        ----AND merchant_id='6329571003697540960'
    )mer
    on mer.id=t1.merchant_id
    left JOIN
    (
        SELECT hospital_id,merchant_id,hospital_name,business_group_region_name,city_name,business_partener_name
        FROM online.ml_doctor_relation_dimen_day
        WHERE partition_date=REGEXP_REPLACE(date_sub(current_date(),1),'-','')
        and doctor_is_merchant='true'
    )doc
    on doc.merchant_id=t1.merchant_id
    left JOIN
    (
    SELECT phone_binding_id,lead_task_id
    FROM tl.tl_gm_sl_lead_task_phone_binding
    WHERE partition_day=regexp_replace(date_sub(current_date(),1),'-','')
    )t2
    on t1.id=t2.lead_task_id
    LEFT JOIN
    (
        SELECT id,platform_binding_id,virtual_phone
        FROM tl.tl_gm_sl_virtual_phone_binding
        WHERE partition_day=regexp_replace(date_sub(current_date(),1),'-','')
    )t3
    on t3.id=t2.phone_binding_id
    LEFT JOIN
    (
        SELECT id,sub_id
        FROM tl.tl_gm_sl_ali_virtual_phone_binding --阿里记录表
        WHERE partition_day=regexp_replace(date_sub(current_date(),1),'-','')
        --AND id in ('2664','2943')
    )t4
    on t4.id=t3.platform_binding_id
   left JOIN
    (
        SELECT id,REGEXP_REPLACE(SUBSTR(call_time,0,10), '-', '') as call_date,sub_id,start_time,release_time,call_time
        ,case when call_type='1'then '机构拨打'when call_type='0'then '用户回拨' end as call_type
        from  tl.tl_gm_sl_ali_virtual_phone_call_detail
        WHERE partition_day=REGEXP_REPLACE(date_sub(current_date(),1),'-','')
        and start_time is not null
    )t5
    on t5.sub_id=t4.sub_id
    group by
    t1.created_time
    ,t1.id
    ,mer.merchant_level
    ,doc.hospital_id
    ,doc.hospital_name
    ,doc.business_group_region_name
    ,doc.city_name
    ,doc.business_partener_name
    ,coalesce(t3.virtual_phone,'-')
    ,t1.created_time
    ,case when t5.release_time>t5.start_time then '已接通'
    when t5.release_time=t5.start_time then '未接通'
    when (t2.lead_task_id is null )then '未绑定'
    when t5.sub_id is null then '未联系'end
    ,coalesce(t5.call_type,'-')
    order by 1