package com.gmei.data.gateway.server.service.impl;

import com.gmei.data.gateway.server.common.Constants;
import com.gmei.data.gateway.server.dto.ExcelGenDto;
import com.gmei.data.gateway.server.service.*;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

/**
 * @ClassName BiReportServiceImpl
 * @Author apple
 * @Date 2020/4/30
 * @Version V1.0
 **/
@Service
public class BiReportServiceImpl implements BiReportService {

    @Autowired
    public EmailService emailService;
    @Autowired
    public ExcelService excelService;
    @Autowired
    public HivesqlService hivesqlService;
    @Autowired
    public SparksqlService sparksqlService;

    @Override
    public int execSql(String name){
        return hivesqlService.executeSql(name);
    }

    @Override
    public int genExcel(String name){
        ExcelGenDto resultDto = sparksqlService.getResultDto(name);
        if(null == resultDto){
            return Constants.FAIL;
        }else{
            return excelService.genExcel(resultDto, name);
        }
    }

    @Override
    public int sendEmail(String to,String cc,String name){
        int rs = Constants.SUCCESS;
        ExcelGenDto resultDto = sparksqlService.getResultDto(name);
        if(null == resultDto){
            rs = Constants.FAIL;
        }else{
            int genExcelRs = excelService.genExcel(resultDto,name);
            if(Constants.SUCCESS == genExcelRs){
                rs = emailService.sendAttachmentsMail(to,cc,name);
            }
        }
        return rs;
    }
}
