package com.gmei.data.gateway.server.service.impl;

import com.gmei.data.gateway.server.service.HivesqlService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.Statement;

/**
 * @ClassName HivesqlServiceImpl
 * @Author apple
 * @Date 2020/5/01
 * @Version V1.0
 **/
@Service
public class HivesqlServiceImpl implements HivesqlService {

    @Value("${sql.input.path}")
    private String sqlPath;
    @Value("${datasource.hiveSql.jdbcUrl}")
    private String hiveSqlJdbcUrl;
    private static final Logger logger = LoggerFactory.getLogger(HivesqlServiceImpl.class);

    @Override
    public int executeSql(String name){
        File sqlDir = new File(sqlPath + name);
        File[] files = sqlDir.listFiles();
        for(File file : files){
            BufferedReader reader = null;
            StringBuffer sbf = new StringBuffer();
            try {
                reader = new BufferedReader(new FileReader(file));
                String tempStr;
                while ((tempStr = reader.readLine()) != null) {
                    sbf.append("\t").append(tempStr);
                }
                reader.close();
            } catch (IOException e) {
                e.printStackTrace();
                logger.error(e.getMessage());
                continue;
            } finally {
                if (reader != null) {
                    try {
                        reader.close();
                    } catch (IOException e1) {
                        e1.printStackTrace();
                        logger.error(e1.getMessage());
                        continue;
                    }
                }
            }
            String hql = sbf.toString();

            Connection conn = null;
            try{
                conn = DriverManager.getConnection(hiveSqlJdbcUrl,"bi","");
                Statement statement = conn.createStatement();
                statement.executeUpdate("set role admin");
                statement.executeUpdate("set mapreduce.job.queuename=data");
                int updateCount = statement.executeUpdate(hql);
                if(updateCount > 0){
                    logger.info("*** Execute success, hql: {}",hql);
                }else{
                    logger.warn("*** Execute finish, hql: {}",hql);
                }
            }catch (Exception e){
                e.printStackTrace();
                logger.error("*** Execute failed, error message: {}, hql: {}",e.getMessage(),hql);
                return 1;
            }
        }
        return 0;
    }
}
