package com.gmei.data.gateway.server.utils;

import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;

/**
 * @author apple
 */
public class DateUtils {

	private static final String DATE_FORMATE_YMDHMS = "yyyy-MM-dd HH:mm:ss";
	private static final String DATE_FORMATE_YMD_SIMPLE = "yyyyMMdd";
	private static final String DATE_FORMATE_YMD = "yyyy-MM-dd";

	/**
	 * 获取当前时间字符串
	 * @return
	 */
	public static String getCurrentTimeStr() {
		return new SimpleDateFormat(DATE_FORMATE_YMDHMS).format(new Date());
	}

	/**
	 * 获取当前时间字符串
	 * @return
	 */
	public static String getCurrentDateStr() {
		return new SimpleDateFormat(DATE_FORMATE_YMD).format(new Date());
	}

	/**
	 * 获取当前时间字符串
	 * @return
	 */
//	public static String getCurrentDateSimpleStr() {
//		return new SimpleDateFormat(DATE_FORMATE_YMD_SIMPLE).format(new Date());
//	}

	/**
	 * 获取昨天的日期字符串
	 * @return
	 */
	public static String getYesterdayDateSimpleStr() {
		Calendar instance = Calendar.getInstance();
		instance.setTime(new Date());
		instance.add(Calendar.DAY_OF_MONTH,-1);
		return new SimpleDateFormat(DATE_FORMATE_YMD_SIMPLE).format(instance.getTime());
	}
}
