--***************************************************************
--*脚本名称:
--*功能: 运营日报
--*业务名称: pm
--*输入数据:
--*作者: weiyimin@igengmei.com
--*更新时间:
--***************************************************************

--设置全局变量&UDF
SET mapreduce.job.queuename=data;

--使用bl数据库
USE pm;

--创建BL层内部表
CREATE TABLE IF NOT EXISTS pm.tl_pm_operation_d
(
 day_id string comment '{"chs_name":"当天日期","description":"","etl":"","value":"","remark":""}',
 device_os_type string comment '{"chs_name":"设备类型","description":"","etl":"","value":"","remark":""}',
 active_type string comment '{"chs_name":"活跃类型","description":"","etl":"","value":"","remark":""}',
 channel string comment '{"chs_name":"渠道","description":"","etl":"","value":"","remark":""}',
 dau bigint comment '{"chs_name":"dau(去除积分墙)","description":"","etl":"","value":"","remark":""}',
 login_dev_num bigint comment '{"chs_name":"新增注册设备数","description":"","etl":"","value":"","remark":""}',
 login_user_num bigint comment '{"chs_name":"新增注册账号","description":"","etl":"","value":"","remark":""}',
 login_phone_user_num bigint comment '{"chs_name":"新增注册手机号用户数","description":"","etl":"","value":"","remark":""}',
 retention_1 string comment '{"chs_name":"次日留存率","description":"","etl":"","value":"","remark":""}',
 retention_7 string comment '{"chs_name":"第7日留存率","description":"","etl":"","value":"","remark":""}',
 retention_30 string comment '{"chs_name":"第30日留存率","description":"","etl":"","value":"","remark":""}',
 per_open_times bigint comment '{"chs_name":"单设备打开频次","description":"","etl":"","value":"","remark":""}',
 home_feeds_ctr string comment '{"chs_name":"信息流内容ctr","description":"","etl":"","value":"","remark":""}',
 per_use_time double comment '{"chs_name":"单设备app停留时长(M)","description":"","etl":"","value":"","remark":""}',
 neirong_page_stay double comment '{"chs_name":"单设备内容时长(M)","description":"","etl":"","value":"","remark":""}',
 neirong_in_app_use_time string comment '{"chs_name":"单设备内容时长/app停留时长","description":"","etl":"","value":"","remark":""}',
 service_privacy_uv bigint comment '{"chs_name":"到达隐私授权界面设备数","description":"","etl":"","value":"","remark":""}',
 service_click_uv bigint comment '{"chs_name":"同意隐私授权设备设备数","description":"","etl":"","value":"","remark":""}',
 service_privacy_uv_in_dau string comment '{"chs_name":"到达隐私授权界面设备数/DAU","description":"","etl":"","value":"","remark":""}',
 service_click_uv_in_dau string comment '{"chs_name":"同意隐私授权设备数/到达隐私授权界面设备数","description":"","etl":"","value":"","remark":""}',

 open_push_uv bigint comment '{"chs_name":"开启推送授权设备数","description":"","etl":"","value":"","remark":""}',
 open_push_uv_in_dau string comment '{"chs_name":"开启推送授权设备数/DAU","description":"","etl":"","value":"","remark":""}',
 push_receive_uv_in_open_push_uv string comment '{"chs_name":"次日接收推送设备数/当天开启推送授权设备数","description":"","etl":"","value":"","remark":""}',
 click_uv bigint comment '{"chs_name":"点击推送的设备数","description":"","etl":"","value":"","remark":""}',
 non_click_uv bigint comment '{"chs_name":"未点击推送的设备数","description":"","etl":"","value":"","remark":""}',
 click_uv_in_dau string comment '{"chs_name":"点击推送设备数/DAU","description":"","etl":"","value":"","remark":""}',
 non_click_uv_in_dau string comment '{"chs_name":"未点击推送设备数/DAU","description":"","etl":"","value":"","remark":""}',
 op_push_open_uv bigint comment '{"chs_name":"点击运营推送设备数","description":"","etl":"","value":"","remark":""}',
 auto_push_open_uv bigint comment '{"chs_name":"点击系统推送设备数","description":"","etl":"","value":"","remark":""}',
 personal_push_open_uv bigint comment '{"chs_name":"点击个性化推送设备数","description":"","etl":"","value":"","remark":""}',
 sign_push_open_uv bigint comment '{"chs_name":"点击签到推送设备数","description":"","etl":"","value":"","remark":""}',
 op_push_open_uv_in_receive string comment '{"chs_name":"点击运营推送设备/接收到运营推送设备","description":"","etl":"","value":"","remark":""}',
 auto_push_open_uv_in_receive string comment '{"chs_name":"点击系统推送设备/接收到系统推送设备","description":"","etl":"","value":"","remark":""}',
 personal_push_open_uv_in_receive string comment '{"chs_name":"点击个性化推送设备/接收到个性化推送设备","description":"","etl":"","value":"","remark":""}',
 sign_push_open_uv_in_receive string comment '{"chs_name":"点击签到推送设备/接收到签到推送设备","description":"","etl":"","value":"","remark":""}',

 question_num bigint comment '{"chs_name":"主动提问数","description":"","etl":"","value":"","remark":""}',
 answer_num bigint comment '{"chs_name":"主动回答数","description":"","etl":"","value":"","remark":""}',
 topic_num bigint comment '{"chs_name":"主动发帖数","description":"","etl":"","value":"","remark":""}',
 reply_num bigint comment '{"chs_name":"真实评论数","description":"","etl":"","value":"","remark":""}',
 question_num_in_dau string comment '{"chs_name":"主动提问设备数/DAU`","description":"","etl":"","value":"","remark":""}',
 answer_num_in_dau string comment '{"chs_name":"主动回答设备数/DAU","description":"","etl":"","value":"","remark":""}',
 topic_num_in_dau string comment '{"chs_name":"主动发帖设备数/DAU","description":"","etl":"","value":"","remark":""}',
 reply_num_in_dau string comment '{"chs_name":"主动评论设备数/DAU","description":"","etl":"","value":"","remark":""}',

 neirongUV bigint comment '{"chs_name":"内容UV","description":"","etl":"","value":"","remark":""}',
 neirongPV bigint comment '{"chs_name":"内容PV","description":"","etl":"","value":"","remark":""}',
 neirongUV_in_dau string comment '{"chs_name":"内容UV/DAU","description":"","etl":"","value":"","remark":""}',
 neirongPV_in_UV double comment '{"chs_name":"内容PV/内容UV","description":"","etl":"","value":"","remark":""}',
 result_more_UV bigint comment '{"chs_name":"搜索结果综合页UV","description":"","etl":"","value":"","remark":""}',
 result_meigou_UV bigint comment '{"chs_name":"搜索结果美购页UV","description":"","etl":"","value":"","remark":""}',
 result_con_UV bigint comment '{"chs_name":"搜索结果商业页UV","description":"","etl":"","value":"","remark":""}',
 result_more_UV_in_dau string comment '{"chs_name":"搜索结果综合页UV/DAU","description":"","etl":"","value":"","remark":""}',
 result_meigou_UV_in_dau string comment '{"chs_name":"搜索结果美购页UV/DAU","description":"","etl":"","value":"","remark":""}',
 result_con_UV_in_dau string comment '{"chs_name":"搜索结果商业页UV/DAU","description":"","etl":"","value":"","remark":""}',
 result_more_PV bigint comment '{"chs_name":"搜索结果综合页PV","description":"","etl":"","value":"","remark":""}',
 result_meigou_PV bigint comment '{"chs_name":"搜索结果美购页PV","description":"","etl":"","value":"","remark":""}',
 result_con_PV bigint comment '{"chs_name":"搜索结果商业页PV","description":"","etl":"","value":"","remark":""}',
 result_more_PV_in_UV double comment '{"chs_name":"搜索结果综合页PV/搜索结果综合页UV","description":"","etl":"","value":"","remark":""}',
 result_meigou_PV_in_UV double comment '{"chs_name":"搜索结果美购页PV/搜索结果美购页UV","description":"","etl":"","value":"","remark":""}',
 result_con_PV_in_UV double comment '{"chs_name":"搜索结果商业页PV/搜索结果商业页UV","description":"","etl":"","value":"","remark":""}',
 result_more_PV_in_dau string comment '{"chs_name":"搜索结果综合页PV/DAU","description":"","etl":"","value":"","remark":""}',
 result_meigou_PV_in_dau string comment '{"chs_name":"搜索结果美购页PV/DAU","description":"","etl":"","value":"","remark":""}',
 result_con_PV_in_dau string comment '{"chs_name":"搜索结果商业页PV/DAU","description":"","etl":"","value":"","remark":""}',
 neirong_meigou_PV bigint comment '{"chs_name":"来自内容页的美购页PV","description":"","etl":"","value":"","remark":""}',
 neirong_con_PV bigint comment '{"chs_name":"来自内容页的商业页PV","description":"","etl":"","value":"","remark":""}',
 neirong_meigou_PV_in_dau string comment '{"chs_name":"来自内容页的美购页PV/DAU","description":"","etl":"","value":"","remark":""}',
 neirong_con_PV_in_dau string comment '{"chs_name":"来自内容页的商业页PV/DAU","description":"","etl":"","value":"","remark":""}',
 neirong_click_pv bigint comment '{"chs_name":"内容页的推荐内容点击pv","description":"","etl":"","value":"","remark":""}',
 wel_second_pv_in_neirongPV string comment '{"chs_name":"来自内容页的商业二跳/内容pv","description":"","etl":"","value":"","remark":""}',
 neirong_second_pv_in_neirongPV string comment '{"chs_name":"来自内容页的内容二跳/内容pv","description":"","etl":"","value":"","remark":""}'
 )comment '运营日报'
PARTITIONED BY (PARTITION_DAY STRING comment '分区日期')
ROW FORMAT DELIMITED
FIELDS TERMINATED BY '\t'
COLLECTION ITEMS TERMINATED BY '\002'
MAP KEYS TERMINATED BY '\003'
LINES TERMINATED BY '\n'
STORED AS TEXTFILE;