package com.gmei.data.gateway.server.service.impl;

import com.gmei.data.gateway.server.common.Constants;
import com.gmei.data.gateway.server.service.EmailService;
import com.gmei.data.gateway.server.utils.DateUtils;
import com.gmei.data.gateway.server.utils.ProperUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.io.FileSystemResource;
import org.springframework.mail.MailSendException;
import org.springframework.mail.javamail.JavaMailSender;
import org.springframework.mail.javamail.MimeMessageHelper;
import org.springframework.stereotype.Component;

import javax.mail.Address;
import javax.mail.SendFailedException;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMessage;
import java.io.File;
import java.util.ArrayList;
import java.util.List;


@Component
public class EmailServiceImpl implements EmailService {
    @Value("${mail.fromMail.addr}")
    private String from;
    @Value("${mail.fromMail.content}")
    private String content;
    @Value("${mail.toMail.bcc}")
    private String bcc;
    @Value("${excel.output.path}")
    private String filePath;
    @Value("${proper.file.path}")
    private String properFilePath;
    @Value("${proper.base.path}")
    private String properBasePath;
    @Autowired
    private JavaMailSender mailSender;
    private static final Logger logger = LoggerFactory.getLogger(EmailServiceImpl.class);

    private List<String> getInvalidAddresses(Throwable throwable) {
        List<String> rsList = new ArrayList<String>();
        if (throwable == null) {
            return rsList;
        }
        if (throwable instanceof MailSendException) {
            Exception[] exceptions = ((MailSendException) throwable).getMessageExceptions();
            for (Exception exception : exceptions) {
                if (exception instanceof SendFailedException) {
                    rsList = getStringAddress(((SendFailedException) exception).getInvalidAddresses());
                }
            }
        }
        if (throwable instanceof SendFailedException) {
            rsList = getStringAddress(((SendFailedException) throwable).getInvalidAddresses());
        }
        return rsList;
    }

    private List<String> getStringAddress(Address[] addresses) {
        List<String> invalid = new ArrayList<String>();
        for (Address a : addresses) {
            String address = ((InternetAddress) a).getAddress();
            if (address != null && StringUtils.isNotEmpty(address)) {
                invalid.add(address);
            }
        }
        return invalid;
    }

    @Override
    public int sendAttachmentsMail(String to,String cc,String name){
        String[] toUsers = to.split(",");
        String[] ccUsers = cc.split(",");
        try {
            String subject = "";
            String properPath = properBasePath + "pm/" + name + "/en-cn.properties";
            logger.info("邮件主题属性文件目录为：{}",properPath);
            String value = ProperUtils.getValue(properPath , name);
            if(null != value){
                subject = value;
            }else{
                subject = name;
            }
            MimeMessage message = mailSender.createMimeMessage();
            MimeMessageHelper helper = new MimeMessageHelper(message, true,"UTF-8");
            helper.setFrom(from);
            helper.setTo(toUsers);
            helper.setSubject(subject);
            helper.setText(content, true);
            helper.setCc(ccUsers);
            if (bcc != null && !"".equals(bcc.trim())) {
                String[] bccUsers = bcc.split(",");
                helper.setBcc(bccUsers);
            }
            String fileName = subject + "-" + DateUtils.getYesterdayDateSimpleStr() + ".xlsx";
            String fileNameSrc = name + "-" + DateUtils.getYesterdayDateSimpleStr() + ".xlsx";
            FileSystemResource file = new FileSystemResource(new File(filePath + fileNameSrc));
            helper.addAttachment(fileName, file);
            mailSender.send(message);
        }catch(Throwable e){
            String validToUsers = "";
            List<String> invalid = getInvalidAddresses(e);
            for(String toUser : toUsers){
                if(invalid.contains(toUser)){
                    logger.error("剔除无效接收人邮箱地址：{}",toUser);
                    continue;
                }
                validToUsers = validToUsers + toUser + ",";
            }
            String validCcUsers = "";
            for(String ccUser : ccUsers){
                if(invalid.contains(ccUser)){
                    logger.error("剔除无效抄送人邮箱地址：{}",ccUser);
                    continue;
                }
                validCcUsers = validCcUsers + ccUser + ",";
            }
            if (invalid.size() > 0) {
                validToUsers = validToUsers.substring(0, validToUsers.length() - 1);
                validCcUsers = validCcUsers.substring(0, validCcUsers.length() - 1);
                sendAttachmentsMail(validToUsers,validCcUsers,name);
                return Constants.FAIL;
            }
        }
        return Constants.SUCCESS;
    }

    @Override
    public int sendFormatedMail(String to,String cc,String name, String htmlContent){
        int rs = Constants.SUCCESS;
        // 主题内容转义
        String subject = "";
        String value = ProperUtils.getValue(properFilePath, name);
        if(null != value){
            subject = value;
        }else{
            subject = name;
        }
        // 邮件发送逻辑
        MimeMessage message = mailSender.createMimeMessage();
        try {
            MimeMessageHelper helper = new MimeMessageHelper(message, true,"UTF-8");
            helper.setFrom(from);
            String[] toUsers = to.split(",");
            helper.setTo(toUsers);
            helper.setSubject(subject);
            helper.setText(htmlContent, true);
            if (cc != null && !"".equals(cc.trim())) {
                String[] ccUsers = cc.split(",");
                helper.setCc(ccUsers);
            }
            if (bcc != null && !"".equals(bcc.trim())) {
                String[] bccUsers = bcc.split(",");
                helper.setBcc(bccUsers);
            }
            mailSender.send(message);
            logger.info("格式化的邮件已经发送。");
        } catch (Exception e) {
            logger.error("格式化后的邮件发送异常！", e);
            rs = Constants.FAIL;
        }
        return rs;
    }
}
