--***************************************************************
--*脚本名称:
--*功能: push质量数据
--*业务名称: pm
--*输入数据:
--*作者: weiyimin@igengmei.com
--*更新时间:
--***************************************************************

--设置全局变量&UDF
SET mapreduce.job.queuename=data;

--使用bl数据库
USE pm;

--创建BL层内部表
CREATE TABLE IF NOT EXISTS pm.tl_pm_push_quality_d
(
 day_id string comment '{"chs_name":"当天日期","description":"","etl":"","value":"","remark":""}',
 device_os_type string comment '{"chs_name":"设备类型","description":"","etl":"","value":"","remark":""}',
 op_only_wel double comment '{"chs_name":"只通过运营push来-漏到核心页","description":"","etl":"","value":"","remark":""}',
 op_push_first_wel double comment '{"chs_name":"先通过运营push来-漏到核心页","description":"","etl":"","value":"","remark":""}',
 op_open_first_wel double comment '{"chs_name":"先主动打开再运营push-漏到核心页","description":"","etl":"","value":"","remark":""}',
 op_only_clue double comment '{"chs_name":"只通过运营push来-漏到线索","description":"","etl":"","value":"","remark":""}',
 op_push_first_clue double comment '{"chs_name":"先通过运营push来-漏到线索","description":"","etl":"","value":"","remark":""}',
 op_open_first_clue double comment '{"chs_name":"先主动打开再运营push-漏到线索","description":"","etl":"","value":"","remark":""}',

 auto_only_wel double comment '{"chs_name":"只通过自动化push来-漏到核心页","description":"","etl":"","value":"","remark":""}',
 auto_push_first_wel double comment '{"chs_name":"先通过自动化push来-漏到核心页","description":"","etl":"","value":"","remark":""}',
 auto_open_first_wel double comment '{"chs_name":"先主动打开再自动化push-漏到核心页","description":"","etl":"","value":"","remark":""}',
 auto_only_clue double comment '{"chs_name":"只通过自动化push来-漏到线索","description":"","etl":"","value":"","remark":""}',
 auto_push_first_clue double comment '{"chs_name":"先通过自动化push来-漏到线索","description":"","etl":"","value":"","remark":""}',
 auto_open_first_clue double comment '{"chs_name":"先主动打开再自动化push-漏到线索","description":"","etl":"","value":"","remark":""}',
)comment 'push质量数据'
PARTITIONED BY (PARTITION_DAY STRING comment '分区日期')
ROW FORMAT DELIMITED
FIELDS TERMINATED BY '\t'
COLLECTION ITEMS TERMINATED BY '\002'
MAP KEYS TERMINATED BY '\003'
LINES TERMINATED BY '\n'
STORED AS TEXTFILE;