select day_id as `日期`
        ,device_os_type as `设备类型`
        ,active_type as `活跃类型`
        ,NVL(CONCAT(ROUND(sum(case when push_type = '101' then click_dev_num end)/sum(case when push_type = '101' then received_dev_num end)*100,2),'%'),0) as `ctr帖子点击率`
        ,NVL(CONCAT(ROUND(sum(case when push_type = '102' then click_dev_num end)/sum(case when push_type = '102' then received_dev_num end)*100,2),'%'),0) as `ctr日记点击率`
        ,NVL(CONCAT(ROUND(sum(case when push_type = '103' then click_dev_num end)/sum(case when push_type = '103' then received_dev_num end)*100,2),'%'),0) as `ctr回答点击率`
        ,NVL(CONCAT(ROUND(sum(case when push_type = '111' then click_dev_num end)/sum(case when push_type = '111' then received_dev_num end)*100,2),'%'),0) as `非ctr帖子点击率`
        ,NVL(CONCAT(ROUND(sum(case when push_type = '112' then click_dev_num end)/sum(case when push_type = '112' then received_dev_num end)*100,2),'%'),0) as `非ctr日记点击率`
        ,NVL(CONCAT(ROUND(sum(case when push_type = '113' then click_dev_num end)/sum(case when push_type = '113' then received_dev_num end)*100,2),'%'),0) as `非ctr回答点击率`
        ,NVL(ROUND(sum(case when push_type = '101' then received_dev_num end)/sum(case when push_type = '111' then received_dev_num end),2),0) as `ctr帖子接收设备数/非ctr帖子接收设备数`
        ,NVL(ROUND(sum(case when push_type = '102' then received_dev_num end)/sum(case when push_type = '112' then received_dev_num end),2),0) as `ctr日记接收设备数/非ctr日记接收设备数`
        ,NVL(ROUND(sum(case when push_type = '103' then received_dev_num end)/sum(case when push_type = '113' then received_dev_num end),2),0) as `ctr回答接收设备数/非ctr回答接收设备数`
        ,NVL(sum(case when push_type = '101' then received_dev_num end),0) as `ctr帖子接收设备数`
        ,NVL(sum(case when push_type = '102' then received_dev_num end),0) as `ctr日记接收设备数`
        ,NVL(sum(case when push_type = '103' then received_dev_num end),0) as `ctr回答接收设备数`
        ,NVL(sum(case when push_type = '111' then received_dev_num end),0) as `非ctr帖子接收设备数`
        ,NVL(sum(case when push_type = '112' then received_dev_num end),0) as `非ctr日记接收设备数`
        ,NVL(sum(case when push_type = '113' then received_dev_num end),0) as `非ctr回答接收设备数`
from pm.tl_pm_push_receive_d
where partition_day>='20200708' and partition_day<=regexp_replace(DATE_SUB(current_date,1) ,'-','')
and day_id>='20200626'
group by day_id
        ,device_os_type
        ,active_type
order by `日期`,`设备类型`,`活跃类型`