

select a.*
FROM
(
    --有评论过日记帖的设备,排除疑似广告
    SELECT diary_id as content_id,'日记贴' as type,user_id,create_time,content
    FROM
    (
        SELECT id,problem_id,user_id,reply_date as create_time,content
        FROM online.tl_hdfs_topicreply_view
        WHERE partition_date = regexp_replace(DATE_SUB(current_date,1) ,'-','')
        AND is_spam = 'false'  --排除疑似广告
        and regexp_replace(substr(reply_date,1,10),'-','') >= regexp_replace(DATE_SUB(current_date,1) ,'-','')
        group by id,problem_id,user_id,reply_date,content
    )t1
    JOIN
    (
        SELECT id,diary_id
        FROM online.tl_hdfs_problem_view
        WHERE partition_date = regexp_replace(DATE_SUB(current_date,1) ,'-','')
        group by id,diary_id
    )t2
    on t2.id=t1.problem_id
    group by diary_id,user_id,create_time,content

    UNION ALL

    --有评论过回答的设备,排除疑似广告

    SELECT answer_id as content_id,'回答' as type,user_id,create_time,content
    FROM online.tl_hdfs_answer_reply_view
    WHERE partition_date =regexp_replace(DATE_SUB(current_date,1) ,'-','')
    and (is_fake is NULL or is_fake = 'false')
    AND answer_id is not NULL
    and regexp_replace(substr(create_time,1,10),'-','') >= regexp_replace(DATE_SUB(current_date,1) ,'-','')
    group by answer_id,user_id,create_time,content

    UNION ALL

    --有评论过用户帖的设备
    SELECT tractate_id as content_id,'帖子' as type,user_id,create_time,content
    FROM  online.tl_hdfs_api_tractate_reply_view
    WHERE partition_date =regexp_replace(DATE_SUB(current_date,1) ,'-','')
    and regexp_replace(substr(create_time,1,10),'-','') >= regexp_replace(DATE_SUB(current_date,1) ,'-','')
    group by tractate_id,user_id,create_time,content

)a
JOIN --限制用户是在app进行的回复
(
    SELECT a.partition_date,user_id
    FROM
    (
        SELECT concat_ws('-',substr(partition_date,1,4),substr(partition_date,5,2),substr(partition_date,7,2)) as partition_date,user_id,device_id,action
        FROM online.bl_hdfs_operation_updates
        WHERE partition_date>=regexp_replace(DATE_SUB(current_date,1) ,'-','')
        AND partition_date<=regexp_replace(DATE_SUB(current_date,1) ,'-','')
    )a
    JOIN
    (
        SELECT code
        FROM  dim.dim_community_action_type
        WHERE communityuserbehavior_type_name = '回帖'
    )type
    ON a.action = code
    GROUP BY a.partition_date,user_id
)b
   ON a.user_id = b.user_id
   AND substr(a.create_time,1,10)= b.partition_date
left join
(
    select distinct user_id
    from ml.ML_D_CT_UI_USERCLEAN_DIMEN_D
    where PARTITION_DAY =regexp_replace(DATE_SUB(current_date,1) ,'-','')
    and (is_doctor = 'true'
        or is_puppet = 'true'
        or is_classify_user = 'true'
        or is_reply_fake = 'true'
        or is_staff = 'true'
        or is_associated_issuedevice = 'true')
)c
on a.user_id=c.user_id
where c.user_id is null
