SET mapreduce.job.queuename=data;
set role admin;
ADD JAR hdfs:///user/hive/share/lib/udf/hive-udf-1.0-SNAPSHOT.jar;
    CREATE TEMPORARY FUNCTION convup AS 'com.gmei.hive.common.udf.UDFConvUpgrade';--进制转换函数，支持各种进制转换
    CREATE TEMPORARY FUNCTION setencryption AS 'com.gmei.hive.common.udf.UDFStringSetEncryption';

select t2.title
		,sum(pv) as `选择pv`
		,count(distinct cl_id) as `选择uv`
from

(--自测页浏览
	SELECT json_map(t2.result,'string,string')['answer_id'] answer_id
		,json_map(t2.result,'string,string')['question_id'] question_id
		,cl_id
		,count(1) as pv
	from
	(
	    SELECT cl_id
	    		,json_split(params['result_list']) as result_list
		FROM online.bl_hdfs_maidian_updates
		where partition_date>='20200729' AND partition_date<= regexp_replace(DATE_SUB(current_date,1) ,'-','')
		and page_name = 'ai_conversation_detail'
		and action='on_click_button'
		and params['button_name']='ai_answer'
	)t1
	LATERAL VIEW EXPLODE(t1.result_list) t2 as result
	group by json_map(t2.result,'string,string')['answer_id']
		,json_map(t2.result,'string,string')['question_id']
		,cl_id
)t1
JOIN
(
	SELECT id,title
	FROM tl.tl_zx_api_ai_qa_answer
	where partition_day= regexp_replace(DATE_SUB(current_date,1) ,'-','')
	and is_online='true'
)t2
on t1.answer_id=t2.id
join
(
	SELECT distinct device_id
	FROM online.ml_device_day_active_status
	where partition_date>='20200729' AND partition_date<= regexp_replace(DATE_SUB(current_date,1) ,'-','')
	AND active_type in ('1','2','4')
	and first_channel_source_type not in ('yqxiu1','yqxiu2','yqxiu3','yqxiu4','yqxiu5','mxyc1','mxyc2','mxyc3'
    ,'wanpu','jinshan','jx','maimai','zhuoyi','huatian','suopingjingling','mocha','mizhe','meika','lamabang'
    ,'js-az1','js-az2','js-az3','js-az4','js-az5','jfq-az1','jfq-az2','jfq-az3','jfq-az4','jfq-az5','toufang1'
    ,'toufang2','toufang3','toufang4','toufang5','toufang6','TF-toufang1','TF-toufang2','TF-toufang3','TF-toufang4'
    ,'TF-toufang5','tf-toufang1','tf-toufang2','tf-toufang3','tf-toufang4','tf-toufang5','benzhan','promotion_aso100'
    ,'promotion_qianka','promotion_xiaoyu','promotion_dianru','promotion_malioaso','promotion_malioaso-shequ'
    ,'promotion_shike','promotion_julang_jl03','promotion_zuimei','','unknown')
    AND first_channel_source_type not like 'promotion\_jf\_%'
	AND substr(convup(setencryption(device_id,'sha-1'),16,10),-2,2)%20 = 0--取灰度
)mas
on mas.device_id=t1.cl_id
left join
( -- 去掉疑似机构刷量的PV和UV
    select distinct device_id
	from ml.ml_d_ct_dv_devicespam_d
	where partition_day=regexp_replace(DATE_SUB(current_date,1) ,'-','')
)spam_pv
on mas.device_id=spam_pv.device_id
left join
(
	SELECT distinct device_id
	FROM
	(--找出user_id当天活跃的第一个设备id
		SELECT user_id,partition_date,
            if(size(device_list) > 0, device_list [ 0 ], '') AS device_id
	    FROM online.ml_user_updates
	    WHERE partition_date>='20200729' AND partition_date<=regexp_replace(DATE_SUB(current_date,1) ,'-','')
	)a
	join
	(	--医生账号
		SELECT distinct user_id
		FROM online.tl_hdfs_doctor_view
		WHERE partition_date = regexp_replace(DATE_SUB(current_date,1) ,'-','')

		--马甲账号/模特用户
		UNION ALL
		SELECT user_id
		FROM ml.ml_c_ct_ui_user_dimen_d
		WHERE partition_day = regexp_replace(DATE_SUB(current_date,1) ,'-','')
		AND (is_puppet = 'true' or is_classifyuser = 'true')

		UNION ALL
		--公司内网覆盖用户
		select distinct user_id
		from dim.dim_device_user_staff

		UNION ALL
		--登陆过医生设备
		SELECT distinct t1.user_id
	    FROM
	    (
	        SELECT user_id, v.device_id as device_id
	        FROM online.ml_user_history_detail
	            LATERAL VIEW EXPLODE(device_history_list) v AS device_id
	        WHERE partition_date = regexp_replace(DATE_SUB(current_date,1) ,'-','')
	    ) t1
	    JOIN
	    (
	        SELECT device_id
	        FROM online.ml_device_history_detail
	        WHERE partition_date = regexp_replace(DATE_SUB(current_date,1) ,'-','')
	        AND is_login_doctor = '1'
	    ) t2
	        ON t1.device_id = t2.device_id
	)b
	on a.user_id=b.user_id
)dev
on t1.cl_id=dev.device_id
WHERE spam_pv.device_id IS NULL
and dev.device_id is NULL
group by t2.title;