SET mapreduce.job.queuename=data;
SET mapreduce.map.memory.mb=8192;
SET mapreduce.map.java.opts=-Xmx8000m;
SET mapreduce.reduce.memory.mb=8192;
SET mapreduce.reduce.java.opts=-Xmx8000m;
set hive.auto.convert.join=true;
SET mapred.reduce.tasks=20;
SET role admin;


ADD JAR hdfs:///user/hive/share/lib/udf/hive-udf-1.0-SNAPSHOT.jar;
CREATE TEMPORARY FUNCTION convup AS 'com.gmei.hive.common.udf.UDFConvUpgrade';

INSERT OVERWRITE TABLE pm.tl_pm_search_d PARTITION (PARTITION_DAY = ${partition_day})



--搜索日报-英赫
SELECT
    partition_date as day_id
    ,device_os_type
    ,active_type
    ,channel
    ,dau
    ,all_search_uv
    ,all_search_pv
    ,if(dau <> 0 ,concat(cast((all_search_uv/dau)*100 as decimal(18,2)),'%') , '-')  as all_search_uv/dau
    ,if(all_search_uv <> 0 ,concat(cast((all_search_pv/all_search_uv) as decimal(18,2)),'') , '-') as all_search_pv/all_search_uv
    ,if(search_home_pv <> 0 ,concat(cast((all_search_pv/search_home_pv)*100 as decimal(18,2)),'%') , '-') as all_search_pv/search_home_pv
    ,if(sug_out_pv_726 <> 0 ,concat(cast((sug_search_pv_726/sug_out_pv_726)*100 as decimal(18,2)),'%') , '-') as sug_search_pv_726/sug_out_pv_726
    ,NVL(referrer_search_hexin_pv,0) as referrer_search_hexin_pv
    ,if(all_search_uv <> 0 ,concat(cast((referrer_search_hexin_pv/all_search_uv) as decimal(18,2)),'') , '-') as referrer_search_hexin_pv/all_search_uv
    ,if(all_search_uv <> 0 ,concat(cast((referrer_search_neirong_pv/all_search_uv) as decimal(18,2)),'') , '-') as referrer_search_neirong_pv/all_search_uv
    ,if(referrer_search_hexin_pv <> 0 ,concat(cast((search_hexin_two_pv/referrer_search_hexin_pv)*100 as decimal(18,2)),'%') , '-') as search_hexin_two_pv/referrer_search_hexin_pv
    ,if(referrer_search_neirong_pv <> 0 ,concat(cast((search_neirong_two_pv/referrer_search_neirong_pv)*100 as decimal(18,2)),'%') , '-') as search_neirong_two_pv/referrer_search_neirong_pv
    ,if(referrer_search_neirong_uv_1000 <> 0 ,concat(cast((referrer_search_neirong_pagestay/referrer_search_neirong_uv_1000/60) as decimal(18,2)),'') , '-') as referrer_search_neirong_pagestay
FROM
(
    SELECT
        coalesce(t1.partition_date,t2.partition_date,t3.partition_date,t4.partition_date,t5.partition_date,t6.partition_date) as partition_date
        ,coalesce(t1.active_type,t2.active_type,t3.active_type,t4.active_type,t5.active_type,t6.active_type) as active_type
        ,coalesce(t1.device_os_type,t2.device_os_type,t3.device_os_type,t4.device_os_type,t5.device_os_type,t6.device_os_type) as device_os_type
        ,coalesce(t1.channel,t2.channel,t3.channel,t4.channel,t5.channel,t6.channel) as channel
        ,coalesce(t1.dau,0) as dau
        ,coalesce(t3.all_search_uv,0) as all_search_uv                                           --全部搜索uv
        ,coalesce(t3.all_search_pv,0) as all_search_pv                                           --全部搜索pv
        ,coalesce(t4.search_home_uv,0) as search_home_uv                                         --搜索首页uv
        ,coalesce(t4.search_home_pv,0) as search_home_pv                                         --搜索首页pv
        ,coalesce(t3.sug_search_uv_726,0) as sug_search_uv_726                                   --726以上sug搜索uv
        ,coalesce(t3.sug_search_pv_726,0) as sug_search_pv_726                                   --726以上sug搜索pv
        ,coalesce(t2.home_search_click_uv_724,0) as home_search_click_uv_724                 --724及以上搜索首页搜索框点击uv
        ,coalesce(t2.home_search_click_pv_724,0) as home_search_click_pv_724                 --724及以上搜索首页搜索框点击pv
        ,coalesce(t4.referrer_search_hexin_pv,0) as referrer_search_hexin_pv                 --来源于搜索的核心页pv
        ,coalesce(t4.referrer_search_neirong_pv,0) as referrer_search_neirong_pv             --来源于搜索的内容页pv
        ,coalesce(t5.search_hexin_two_pv,0) as search_hexin_two_pv                           --来源于搜索的核心页二跳pv
        ,coalesce(t5.search_neirong_two_pv,0) as search_neirong_two_pv                       --来源于搜索的内容页二跳pv
        ,coalesce(t4.referrer_search_neirong_uv_1000,0) as referrer_search_neirong_uv_1000   --来源于搜索的内容页uv，限制停留时长
        ,coalesce(t4.referrer_search_neirong_pagestay,0) as referrer_search_neirong_pagestay --来源于搜索的内容页的总停留时长(s)
        ,coalesce(t6.sug_out_uv_726,0) as sug_out_uv_726
        ,coalesce(t6.sug_out_pv_726,0) as sug_out_pv_726
    FROM
    (  --dau
        SELECT mas.partition_date,t2.active_type,t2.device_os_type,t2.channel,count(DISTINCT mas.device_id) as dau
        FROM
        (
            SELECT
            partition_date,m.device_id
            ,array(device_os_type ,'合计') as device_os_type
            ,array(case WHEN active_type = '4'  THEN '老活'
                  WHEN active_type  in ('1','2')  then '新增' END ,'合计') as active_type
            ,array(CASE WHEN (partition_date>='20190601' and tmp.col2 = 'AI')
                            or (partition_date < '20200301' AND partition_date>='20190601' and first_channel_source_type like 'promotion_toutiao_jy%')
                            or (partition_date>='20200601' and ((first_channel_source_type like 'promotion_toutiao_jy%') or (first_channel_source_type like 'dyand%') or (first_channel_source_type like 'douyin%')))
                            THEN 'AI'  ELSE '其他' END , '合计') as channel
            FROM online.ml_device_day_active_status m
                LEFT JOIN
                (SELECT col1,col2  --col1:子渠道，col2：是否属于AI，col3:标识
                   FROM pm.tl_pm_ydl
                   WHERE col3='0204_danlei_channel')tmp
                on first_channel_source_type=tmp.col1
            where partition_date = REGEXP_REPLACE(date_sub(current_date(),1),'-','')
            AND active_type in ('1','2','4')
        ) mas
        LATERAL VIEW explode(mas.channel) t2 AS channel
        LATERAL VIEW explode(mas.device_os_type) t2 AS device_os_type
        LATERAL VIEW explode(mas.active_type) t2 AS active_type
        GROUP BY mas.partition_date,t2.active_type,t2.device_os_type,t2.channel
    )t1
    full JOIN
    (
        --搜索框点击,724版本埋点修复
        SELECT
            click.partition_date as partition_date
            ,active_type
            ,device_os_type
            ,channel
            ,count(click.cl_id) as home_search_click_pv_724
            ,count(distinct click.cl_id) as home_search_click_uv_724
        FROM
        (
            SELECT cl_id,partition_date,action,params['page_name'] as page_name,app_version
            FROM online.bl_hdfs_maidian_updates
            WHERE partition_date = REGEXP_REPLACE(date_sub(current_date(),1),'-','')
              AND action = 'on_click_navbar_search'
              AND (int(split(app_version,'\\.')[0]) = 7 AND int(split(app_version,'\\.')[1]) >= 24)
              AND page_name in ('search_home','search_home_more','search_home_welfare','search_home_diary','search_home_wiki','search_home_post','search_home_hospital','search_home_doctor')
        )click
        JOIN
        (
            SELECT partition_date,device_id,t2.active_type,t2.channel,t2.device_os_type
            FROM
            (
                SELECT
                partition_date,m.device_id
                ,array(device_os_type ,'合计') as device_os_type
                ,array(case WHEN active_type = '4'  THEN '老活'
                      WHEN active_type  in ('1','2')  then '新增' END ,'合计') as active_type
                ,array(CASE WHEN (partition_date>='20190601' and tmp.col2 = 'AI')
                                or (partition_date < '20200301' AND partition_date>='20190601' and first_channel_source_type like 'promotion_toutiao_jy%')
                                or (partition_date>='20200601' and ((first_channel_source_type like 'promotion_toutiao_jy%') or (first_channel_source_type like 'dyand%') or (first_channel_source_type like 'douyin%')))
                                THEN 'AI'  ELSE '其他' END , '合计') as channel
                FROM online.ml_device_day_active_status m
                    LEFT JOIN
                    (SELECT col1,col2  --col1:子渠道，col2：是否属于AI，col3:标识
                       FROM pm.tl_pm_ydl
                       WHERE col3='0204_danlei_channel')tmp
                    on first_channel_source_type=tmp.col1
                where partition_date = REGEXP_REPLACE(date_sub(current_date(),1),'-','')
                AND active_type in ('1','2','4')
            ) mas
            LATERAL VIEW explode(mas.channel) t2 AS channel
            LATERAL VIEW explode(mas.device_os_type) t2 AS device_os_type
            LATERAL VIEW explode(mas.active_type) t2 AS active_type
        )dev_channel
          on dev_channel.device_id = click.cl_id
            AND dev_channel.partition_date = click.partition_date
        GROUP BY click.partition_date,active_type,device_os_type,channel
    )t2
      on t2.partition_date = t1.partition_date
        AND t2.active_type = t1.active_type
        AND t2.device_os_type = t1.device_os_type
        AND t2.channel = t1.channel
    full JOIN
    (
        --搜索pvuv
        SELECT
            click.partition_date as partition_date
            ,active_type
            ,device_os_type
            ,channel
            ,count(click.cl_id) as all_search_pv
            ,count(distinct click.cl_id) as all_search_uv
            ,count(case when int(split(app_version,'\\.')[0]) = 7 AND int(split(app_version,'\\.')[1]) >= 26 AND input_type in ('联想','聚合模块') then click.cl_id else null end) as sug_search_pv_726
            ,count(distinct case when int(split(app_version,'\\.')[0]) = 7 AND int(split(app_version,'\\.')[1]) >= 26 AND input_type in ('联想','聚合模块') then click.cl_id else null end) as sug_search_uv_726
        FROM
        (
            SELECT cl_id,partition_date,action,params['page_name'] as page_name,params['input_type'] as input_type,app_version
            FROM online.bl_hdfs_maidian_updates
            WHERE partition_date = REGEXP_REPLACE(date_sub(current_date(),1),'-','')
              AND action in ('do_search','search_result_click_search')

            union all
            SELECT cl_id,partition_date,action,'home' as page_name,'首页-猜你喜欢' as input_type,app_version
            FROM online.bl_hdfs_maidian_updates
            WHERE partition_date = REGEXP_REPLACE(date_sub(current_date(),1),'-','')
              AND action = 'on_click_card'
              AND params['in_page_pos']='猜你喜欢'
              AND params['tab_name']='精选'
              AND params['card_type']='search_word'
              --AND page_name='home' android的page_name为空

            union all
            SELECT cl_id,partition_date,action,params['page_name'] as page_name,'美购首页-大家都在搜' as input_type,app_version
            FROM online.bl_hdfs_maidian_updates
            WHERE partition_date = REGEXP_REPLACE(date_sub(current_date(),1),'-','')
              AND action = 'on_click_card'
              AND params['page_name']='welfare_home'
              AND params['card_type'] ='search_word'
              AND params['in_page_pos']='大家都在搜'

            union all
            SELECT cl_id,partition_date,action,params['page_name'] as page_name,'高亮词' as input_type,app_version
            FROM online.bl_hdfs_maidian_updates
            WHERE partition_date = REGEXP_REPLACE(date_sub(current_date(),1),'-','')
              AND action = 'on_click_card'
              AND params['card_type'] ='highlight_word'
        )click
        JOIN
        (
            SELECT partition_date,device_id,t2.active_type,t2.channel,t2.device_os_type
            FROM
            (
                SELECT
                partition_date,m.device_id
                ,array(device_os_type ,'合计') as device_os_type
                ,array(case WHEN active_type = '4'  THEN '老活'
                      WHEN active_type  in ('1','2')  then '新增' END ,'合计') as active_type
                ,array(CASE WHEN (partition_date>='20190601' and tmp.col2 = 'AI')
                                or (partition_date < '20200301' AND partition_date>='20190601' and first_channel_source_type like 'promotion_toutiao_jy%')
                                or (partition_date>='20200601' and ((first_channel_source_type like 'promotion_toutiao_jy%') or (first_channel_source_type like 'dyand%') or (first_channel_source_type like 'douyin%')))
                                THEN 'AI'  ELSE '其他' END , '合计') as channel
                FROM online.ml_device_day_active_status m
                    LEFT JOIN
                    (SELECT col1,col2  --col1:子渠道，col2：是否属于AI，col3:标识
                       FROM pm.tl_pm_ydl
                       WHERE col3='0204_danlei_channel')tmp
                    on first_channel_source_type=tmp.col1
                where partition_date = REGEXP_REPLACE(date_sub(current_date(),1),'-','')
                AND active_type in ('1','2','4')
            ) mas
            LATERAL VIEW explode(mas.channel) t2 AS channel
            LATERAL VIEW explode(mas.device_os_type) t2 AS device_os_type
            LATERAL VIEW explode(mas.active_type) t2 AS active_type
        )dev_channel
          on dev_channel.device_id = click.cl_id
            AND dev_channel.partition_date = click.partition_date
        GROUP BY click.partition_date,active_type,device_os_type,channel
    )t3
      on t3.partition_date = t1.partition_date
        AND t3.active_type = t1.active_type
        AND t3.device_os_type = t1.device_os_type
        AND t3.channel = t1.channel
    full JOIN
    (
        --页面浏览pvuv
        SELECT
            page.partition_date as partition_date
            ,active_type
            ,device_os_type
            ,channel
            ,count(case when page_name in ('search_home','search_home_more','search_home_welfare','search_home_diary','search_home_wiki','search_home_post','search_home_hospital','search_home_doctor') then page.cl_id else NULL end) as search_home_pv
            ,count(distinct case when page_name in ('search_home','search_home_more','search_home_welfare','search_home_diary','search_home_wiki','search_home_post','search_home_hospital','search_home_doctor') then page.cl_id else NULL end) as search_home_uv
            ,count(CASE when referrer in  ('search_result_diary','search_result_doctor','search_result_hospital','search_result_more'
                        ,'search_result_more_infomation','search_result_more_user','search_result_post','search_result_welfare'
                        ,'search_result_wiki') and page_name in ('welfare_detail','organization_detail','expert_detail') THEN page.cl_id else NULL END) as referrer_search_hexin_pv
            ,count(CASE when referrer in  ('search_result_diary','search_result_doctor','search_result_hospital','search_result_more'
                        ,'search_result_more_infomation','search_result_more_user','search_result_post','search_result_welfare'
                        ,'search_result_wiki') and page_name in ('diary_detail','topic_detail','post_detail','user_post_detail','doctor_post_detail','question_detail','answer_detail'
                        ,'question_answer_detail','article_detail') THEN page.cl_id else NULL END) as referrer_search_neirong_pv
            ,count(DISTINCT CASE WHEN referrer in  ('search_result_diary','search_result_doctor','search_result_hospital','search_result_more'
                        ,'search_result_more_infomation','search_result_more_user','search_result_post','search_result_welfare'
                        ,'search_result_wiki') and page_name in ('diary_detail','topic_detail','post_detail','user_post_detail','doctor_post_detail','question_detail','answer_detail'
                        ,'question_answer_detail','article_detail') and page_stay >= '0' and page_stay < '1000' THEN page.cl_id else NULL END) as referrer_search_neirong_uv_1000
            ,sum(CASE WHEN referrer in  ('search_result_diary','search_result_doctor','search_result_hospital','search_result_more'
                        ,'search_result_more_infomation','search_result_more_user','search_result_post','search_result_welfare'
                        ,'search_result_wiki') and page_name in ('diary_detail','topic_detail','post_detail','user_post_detail','doctor_post_detail','question_detail','answer_detail'
                        ,'question_answer_detail','article_detail') and page_stay >= '0' and page_stay < '1000' THEN page.page_stay else NULL END) as  referrer_search_neirong_pagestay
        FROM
        (
            SELECT cl_id,partition_date,page_name,params['referrer'] as referrer,page_stay
            FROM online.bl_hdfs_maidian_updates
            WHERE partition_date = REGEXP_REPLACE(date_sub(current_date(),1),'-','')
              AND action='page_view'
              AND page_name in ('search_home','search_home_more','search_home_welfare','search_home_diary','search_home_wiki','search_home_post','search_home_hospital','search_home_doctor'
                        ,'diary_detail','topic_detail','post_detail','user_post_detail','doctor_post_detail','question_detail','answer_detail'
                        ,'question_answer_detail','article_detail','welfare_detail','organization_detail','expert_detail')
        )page
        JOIN
        (
            SELECT partition_date,device_id,t2.active_type,t2.channel,t2.device_os_type
            FROM
            (
                SELECT
                partition_date,m.device_id
                ,array(device_os_type ,'合计') as device_os_type
                ,array(case WHEN active_type = '4'  THEN '老活'
                      WHEN active_type  in ('1','2')  then '新增' END ,'合计') as active_type
                ,array(CASE WHEN (partition_date>='20190601' and tmp.col2 = 'AI')
                                or (partition_date < '20200301' AND partition_date>='20190601' and first_channel_source_type like 'promotion_toutiao_jy%')
                                or (partition_date>='20200601' and ((first_channel_source_type like 'promotion_toutiao_jy%') or (first_channel_source_type like 'dyand%') or (first_channel_source_type like 'douyin%')))
                                THEN 'AI'  ELSE '其他' END , '合计') as channel
                FROM online.ml_device_day_active_status m
                    LEFT JOIN
                    (SELECT col1,col2  --col1:子渠道，col2：是否属于AI，col3:标识
                       FROM pm.tl_pm_ydl
                       WHERE col3='0204_danlei_channel')tmp
                    on first_channel_source_type=tmp.col1
                where partition_date = REGEXP_REPLACE(date_sub(current_date(),1),'-','')
                AND active_type in ('1','2','4')
            ) mas
            LATERAL VIEW explode(mas.channel) t2 AS channel
            LATERAL VIEW explode(mas.device_os_type) t2 AS device_os_type
            LATERAL VIEW explode(mas.active_type) t2 AS active_type
        )dev_channel
          on dev_channel.device_id = page.cl_id
            AND dev_channel.partition_date = page.partition_date
        GROUP BY page.partition_date,active_type,device_os_type,channel
    )t4
      on t4.partition_date = t1.partition_date
        AND t4.active_type = t1.active_type
        AND t4.device_os_type = t1.device_os_type
        AND t4.channel = t1.channel
    full JOIN
    (   --搜索结果页的二跳率
        SELECT
            card_click.partition_date as partition_date
            ,active_type
            ,device_os_type
            ,channel
            ,count(case when type = 'hexin' then card_click.cl_id else null end) as search_hexin_two_pv
            ,count(case when type = 'neirong' then card_click.cl_id else null end) as search_neirong_two_pv
        FROM
        (   --核心页二跳率
            SELECT cl_id,partition_date,'hexin' as type
            FROM online.bl_hdfs_maidian_updates
            WHERE partition_date = REGEXP_REPLACE(date_sub(current_date(),1),'-','')
              AND (referrer in ('search_result_diary','search_result_doctor','search_result_hospital','search_result_more'
                        ,'search_result_more_infomation','search_result_more_user','search_result_post','search_result_welfare'
                        ,'search_result_wiki')
                    or (params['referrer_link'] like '%[%' and json_split(params['referrer_link'])[size(json_split(params['referrer_link']))-1] in ('search_result_diary','search_result_doctor','search_result_hospital','search_result_more'
                        ,'search_result_more_infomation','search_result_more_user','search_result_post','search_result_welfare','search_result_wiki')))
              AND ((action in ('welfare_multiattribute_click_add','welfare_multiattribute_click_buy') AND page_name = 'welfare_detail')
                    or action = 'welfare_detail_click_message'
                    or (action = 'on_click_button' AND page_name = 'welfare_detail' AND params['button_name'] in ('question_tag','appointment'))
                    or (action = 'welfare_detail_click_curearea_contact' AND params['connect_type'] in ('phone','onlineconsult')))

            UNION ALL
            SELECT cl_id,partition_date,'hexin' as type
            FROM online.bl_hdfs_maidian_updates
            WHERE partition_date = REGEXP_REPLACE(date_sub(current_date(),1),'-','')    --医院主页、医生主页点击咨询和浮层提问
            AND action = 'on_click_button'
            AND page_name in ('organization_detail','expert_detail')
            AND (params['button_name'] in ('online_consult','phone_consult','put_question','discount_pay') OR params['button_name'] like "%？%")
            AND params['referrer_link'] like '%[%'
            and (referrer in ('search_result_diary','search_result_doctor','search_result_hospital','search_result_more'
                        ,'search_result_more_infomation','search_result_more_user','search_result_post','search_result_welfare'
                        ,'search_result_wiki')
                    or (params['referrer_link'] like '%[%' and json_split(params['referrer_link'])[size(json_split(params['referrer_link']))-1] in ('search_result_diary','search_result_doctor','search_result_hospital','search_result_more'
                        ,'search_result_more_infomation','search_result_more_user','search_result_post','search_result_welfare','search_result_wiki')))

            UNION ALL
            --内容二跳率-点击搜索框、搜索按钮、高亮词、美购卡片、推荐内容卡片
            SELECT cl_id,partition_date,'neirong' as type
            FROM online.bl_hdfs_maidian_updates
            WHERE partition_date=REGEXP_REPLACE(date_sub(current_date(),1),'-','')
            AND page_name IN ('diary_detail','topic_detail','post_detail','user_post_detail','doctor_post_detail','question_detail','answer_detail','question_answer_detail','article_detail')
            AND (referrer in ('search_result_diary','search_result_doctor','search_result_hospital','search_result_more'
                        ,'search_result_more_infomation','search_result_more_user','search_result_post','search_result_welfare'
                        ,'search_result_wiki')
                    or (params['referrer_link'] like '%[%' and json_split(params['referrer_link'])[size(json_split(params['referrer_link']))-1] in ('search_result_diary','search_result_doctor','search_result_hospital','search_result_more'
                        ,'search_result_more_infomation','search_result_more_user','search_result_post','search_result_welfare','search_result_wiki')))
            AND (action in ('on_click_navbar_search','do_search')
                  or (action='on_click_card' and params['card_type']='highlight_word')
                  or (action='on_click_card' and params['card_content_type'] in ('service','qa','diary','user_post','answer'))
                  or (action='on_click_button' and params['button_name']='unfold'))
        )card_click
        JOIN
        (
            SELECT partition_date,device_id,t2.active_type,t2.channel,t2.device_os_type
            FROM
            (
                SELECT
                partition_date,m.device_id
                ,array(device_os_type ,'合计') as device_os_type
                ,array(case WHEN active_type = '4'  THEN '老活'
                      WHEN active_type  in ('1','2')  then '新增' END ,'合计') as active_type
                ,array(CASE WHEN (partition_date>='20190601' and tmp.col2 = 'AI')
                                or (partition_date < '20200301' AND partition_date>='20190601' and first_channel_source_type like 'promotion_toutiao_jy%')
                                or (partition_date>='20200601' and ((first_channel_source_type like 'promotion_toutiao_jy%') or (first_channel_source_type like 'dyand%') or (first_channel_source_type like 'douyin%')))
                                THEN 'AI'  ELSE '其他' END , '合计') as channel
                FROM online.ml_device_day_active_status m
                    LEFT JOIN
                    (SELECT col1,col2  --col1:子渠道，col2：是否属于AI，col3:标识
                       FROM pm.tl_pm_ydl
                       WHERE col3='0204_danlei_channel')tmp
                    on first_channel_source_type=tmp.col1
                where partition_date = REGEXP_REPLACE(date_sub(current_date(),1),'-','')
                AND active_type in ('1','2','4')
            ) mas
            LATERAL VIEW explode(mas.channel) t2 AS channel
            LATERAL VIEW explode(mas.device_os_type) t2 AS device_os_type
            LATERAL VIEW explode(mas.active_type) t2 AS active_type
        )dev_channel
          on dev_channel.device_id = card_click.cl_id
            AND dev_channel.partition_date = card_click.partition_date
        GROUP BY card_click.partition_date,active_type,device_os_type,channel
    )t5
      on t5.partition_date = t1.partition_date
        AND t5.active_type = t1.active_type
        AND t5.device_os_type = t1.device_os_type
        AND t5.channel = t1.channel

    full JOIN
    (   --sug弹窗弹出--预计排期726修复
        SELECT
            click.partition_date as partition_date
            ,active_type
            ,device_os_type
            ,channel
            ,count(click.cl_id) as sug_out_pv_726
            ,count(distinct click.cl_id) as sug_out_uv_726
        FROM
        (
            SELECT cl_id,partition_date,action,params['page_name'] as page_name
            FROM online.bl_hdfs_maidian_updates
            where partition_date = REGEXP_REPLACE(date_sub(current_date(),1),'-','')
              AND action = 'searchsug_view'
              AND (int(split(app_version,'\\.')[0]) = 7 AND int(split(app_version,'\\.')[1]) >= 26)
        )click
        JOIN
        (
            SELECT partition_date,device_id,t2.active_type,t2.channel,t2.device_os_type
            FROM
            (
                SELECT
                partition_date,m.device_id
                ,array(device_os_type ,'合计') as device_os_type
                ,array(case WHEN active_type = '4'  THEN '老活'
                      WHEN active_type  in ('1','2')  then '新增' END ,'合计') as active_type
                ,array(CASE WHEN (partition_date>='20190601' and tmp.col2 = 'AI')
                                or (partition_date < '20200301' AND partition_date>='20190601' and first_channel_source_type like 'promotion_toutiao_jy%')
                                or (partition_date>='20200601' and ((first_channel_source_type like 'promotion_toutiao_jy%') or (first_channel_source_type like 'dyand%') or (first_channel_source_type like 'douyin%')))
                                THEN 'AI'  ELSE '其他' END , '合计') as channel
                FROM online.ml_device_day_active_status m
                    LEFT JOIN
                    (SELECT col1,col2  --col1:子渠道，col2：是否属于AI，col3:标识
                       FROM pm.tl_pm_ydl
                       WHERE col3='0204_danlei_channel')tmp
                    on first_channel_source_type=tmp.col1
                where partition_date = REGEXP_REPLACE(date_sub(current_date(),1),'-','')
                AND active_type in ('1','2','4')
            ) mas
            LATERAL VIEW explode(mas.channel) t2 AS channel
            LATERAL VIEW explode(mas.device_os_type) t2 AS device_os_type
            LATERAL VIEW explode(mas.active_type) t2 AS active_type
        )dev_channel
          on dev_channel.device_id = click.cl_id
            AND dev_channel.partition_date = click.partition_date
        GROUP BY click.partition_date,active_type,device_os_type,channel
    )t6
      on t6.partition_date = t1.partition_date
        AND t6.active_type = t1.active_type
        AND t6.device_os_type = t1.device_os_type
        AND t6.channel = t1.channel
)t
ORDER BY `日期`,`平台`,`活跃类型`,`渠道类型`



