SELECT
      first_active_date as `日期`
      ,channel as `渠道`
      ,device_os_type as `平台`
      ,COUNT(DISTINCT device.device_id) AS `当天新活量`
      ,nvl(SUM(IF(pv.action_date=device.first_active_date, pv.wel_pv, NULL)),0) AS `当日核心页pv`
      ,nvl(SUM(IF(pv.action_date>=device.first_active_date AND pv.action_date<=date_add(device.first_active_date,2), pv.wel_pv, NULL)),0) AS `3日内核心页pv`
      ,nvl(SUM(IF(pv.action_date>=device.first_active_date AND pv.action_date<=date_add(device.first_active_date,6), pv.wel_pv, NULL)),0) AS `7日内核心页pv`
  FROM
  (
      SELECT
        first_active_date,device_id,device_os_type
        ,IF(ios_device.channel IS NOT NULL, ios_device.channel, first_channel_source_type) AS channel
      FROM
      (
          SELECT
              device_id,device_os_type
              ,first_channel_source_type
              ,concat_ws('-',substr(partition_date,1,4),substr(partition_date,5,2),substr(partition_date,7,2)) AS first_active_date
          FROM online.ml_device_day_active_status
          WHERE partition_date >= REGEXP_REPLACE(trunc(date_sub(current_date(),8),'MM'),'-','')
            AND partition_date <=regexp_replace(date_sub(current_date(),1),'-','')
            AND active_type in ('1','2')
            AND first_channel_source_type not in ('yqxiu1','yqxiu2','yqxiu3','yqxiu4','yqxiu5','mxyc1','mxyc2','mxyc3'
          ,'wanpu','jinshan','jx','maimai','zhuoyi','huatian','suopingjingling','mocha','mizhe','meika','lamabang'
          ,'js-az1','js-az2','js-az3','js-az4','js-az5','jfq-az1','jfq-az2','jfq-az3','jfq-az4','jfq-az5','toufang1'
          ,'toufang2','toufang3','toufang4','toufang5','toufang6','TF-toufang1','TF-toufang2','TF-toufang3','TF-toufang4'
          ,'TF-toufang5','tf-toufang1','tf-toufang2','tf-toufang3','tf-toufang4','tf-toufang5','benzhan','promotion_aso100'
          ,'promotion_qianka','promotion_xiaoyu','promotion_dianru','promotion_malioaso','promotion_malioaso-shequ'
          ,'promotion_shike','promotion_julang_jl03','promotion_zuimei','','unknown')
  	        AND first_channel_source_type not like 'promotion\_jf\_%'
      )device

      LEFT JOIN
      ( SELECT channel,idfa
        FROM
        (
          SELECT channel,idfa,row_number () over (PARTITION BY idfa ORDER BY active_time asc) rn--,substr(active_time,1,7) as new_month
          FROM online.tl_hdfs_ios_idfa_tmp--设备表，区分App Store 明细渠道名字
        )a
        WHERE rn = 1
      )ios_device
      ON ios_device.idfa = device.device_id
      GROUP BY first_active_date,device_id,device_os_type,IF(ios_device.channel IS NOT NULL, ios_device.channel, first_channel_source_type)
 	)device

  LEFT JOIN
	(
      SELECT action_date,cl_id,count(1) as wel_pv
      FROM
      (
        SELECT concat_ws('-',substr(partition_date,0,4),substr(partition_date,5,2),substr(partition_date,7,2)) AS action_date,cl_id
    		FROM online.bl_hdfs_maidian_updates
    		WHERE partition_date >= REGEXP_REPLACE(trunc(date_sub(current_date(),8),'MM'),'-','')
            AND partition_date <=regexp_replace(date_sub(current_date(),1),'-','')
    			AND page_name in ('welfare_detail','organization_detail','expert_detail')
    			AND action = 'page_view'
      )a
      LEFT JOIN
      ( -- 2.去掉疑似机构刷量的PV和UV
          SELECT device_id
          FROM ml.ml_d_ct_dv_devicespam_d
          WHERE partition_day=regexp_replace(date_sub(current_date(),1),'-','')
      )spam_pv
      on a.cl_id=spam_pv.device_id
      WHERE spam_pv.device_id IS NULL
      GROUP BY action_date,cl_id
	)pv
    ON device.device_id = pv.cl_id
GROUP BY
    first_active_date,channel,device_os_type