package com.gmei.data.gateway.server.endpoint;

import com.gmei.data.gateway.server.service.BiReportService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

@RestController
@RequestMapping(value = "/api/report")
public class BiReportEndpoint {

    @Autowired
    public BiReportService biReportService;

    @ResponseBody
    @RequestMapping(value = "/genExcel")
    public int genExcel(@RequestParam String name){
        return biReportService.genExcel(name);
    }

    @ResponseBody
    @RequestMapping(value = "/sendEmail/{to}/{cc}/{name}",method = RequestMethod.GET)
    public int sendEmail(@PathVariable("to") String to,@PathVariable("cc") String cc,@PathVariable("name") String name){
        return biReportService.sendEmail(to,cc,name);
    }
}
