#coding: utf-8
#author:
#date:
#desc:send email with attach

import smtplib
import sys
import getopt
import os
import getpass
import time
from email.mime.multipart import MIMEMultipart
from email.mime.text import MIMEText
from email.header import Header

#email info
to_address = ""
subject = ""
content = ""
attach = ""
memail = ""
htable = ""

#userinfo
authfile = "/home/bi/bi-report/conf/auth.cf"

def readallow(filepath):
    usernames = []
    f = open(filepath,"r")
    lines = f.readlines()
    for line in lines:
        usernames.append(line.strip())
    return usernames

def checkauth():
    global authfile
    usernames = readallow(authfile)
    username = getpass.getuser()
    return username in usernames

def isfile(filestr):
    if os.path.isfile(filestr):
        file = open(filestr,'r')
        lines = file.readlines()
        if len(lines) >= 2:
            return True
    write2file("%s file is less than 2 lines or does not exist...." % getfilename(filestr))
    print "--->%s file is less than 2 lines or does not exist...." % getfilename(filestr)
    return False

def getfilename(filestr):
    return os.path.basename(filestr)

def makeaddress():
    global to_address
    address_str = ""
    for address in to_address.split(","):
        if address.find("@") > 0:
            address_str += address + ";"
        else:
            address_str += "%s@igengmei.com;" % address
    return address_str[:-1]

def addattch(msgRoot):
    global attach
    if attach.strip() == "":
        return 0
    for item in attach.split(","):
        if isfile(item):
            att = MIMEText(open('%s' % item, 'rb').read(), 'base64', 'utf-8')
            att["Content-Type"] = 'application/octet-stream'
            att["Content-Disposition"] = 'attachment; filename="%s"'% getfilename(item)
            msgRoot.attach(att)
        else:
            print "--->send mail failed, %s file is not exist or file row num less than 2" % getfilename(item)
            return -1

def makecc():
    global memail
    address_str = ""
    for address in memail.split(","):
        if address.find("@") > 0:
            address_str += address + ";"
        else:
            address_str += "%s@igengmei.com;" % address
    print address_str
    return address_str[:-1]

def addsubject(msgRoot):
    global subject
    global content
    global htable

    msgRoot['Subject'] = Header(subject, 'utf-8')
    msgRoot['To'] = makeaddress()
    msgRoot['Cc'] = makecc()

    if htable != "":
        for ff in htable.split(","):
            if not isfile(ff):
                return -1
            hcontent = trans2table(ff)
            content += hcontent

    content += "<br><br><br><br><font color=red size='3'>这是一封自动发出的邮件，邮件发送自大数据BI组。<br>请使用wps打开，appstore地址:https://appsto.re/cn/MAqWJ.i</font>"
    msg = MIMEText(content,'html','utf-8')
    msgRoot.attach(msg)
    return True

def trans2table(path):
    for ff in path.split(","):
        index = 0
        result = "<br><br><table border='1' style='border-collapse:collapse' bordercolor='#9D9D9D'>\n"
        for eachline in open(ff,'r'):
            if len(eachline.strip()) == 0:
                continue
            result += "    <tr>"
            for item in eachline.strip().split(","):
                if index == 0:
                    result += "<td align='left' bgcolor='#8EA9DB' style='font-family:Microsoft YaHei;padding:2px 5px'>%s</td>" % item
                else:
                    result += "<td align='left' style='font-family:Microsoft YaHei;padding:2px 5px'>%s</td>" % item
            index += 1
            result += "</tr>\n"
        result += "</table>"
    return result

def sendmail():
    global to_address
    #account info
    sender = 'youjiantongji@wanmeizhensuo.com'
    username = 'youjiantongji@wanmeizhensuo.com'
    password = 'mq37tgk8nGi6eg1Hgq388oro3itvdmPl'
    smtpserver = 'smtp.exmail.qq.com'
    server_port = 25

    if not checkparam():
        return 0

    msgRoot = MIMEMultipart()
    if addsubject(msgRoot) == -1:
        return 0
    if addattch(msgRoot) == -1:
        return 0

    smtp = smtplib.SMTP(smtpserver, server_port)
    smtp.ehlo()
    smtp.starttls()
    smtp.login(username, password)
    to_receiver = makeaddress()
    to_cc = makecc()
    smtp.sendmail(sender, to_receiver.split(";") + to_cc.split(";"), msgRoot.as_string())
    smtp.quit()
    print "send mail success...."
    write2file("send mail success")
    write2file("--------------------------------------------------------------------------------------")

def processcmd(cmd):
    global to_address
    global subject
    global content
    global attach
    global memail
    global htable

    try:
        options, args = getopt.getopt(cmd, "c:a:t:s:m:f:")
        for name,value in options:
            if name in ("-t"):
                to_address = value
            elif name in ("-s"):
                subject = value
            elif name in ("-c"):
                content = value
            elif name in ("-a"):
                attach = value
            elif name in ("-m"):
                memail = value
            elif name in ("-f"):
                htable = value
    except Exception, e:
        print "--->%s, remove this param" % str(e)
        usage()
        return -1

def checkparam():
    global to_address
    global subject

    if to_address.strip() == "" or subject.strip() == "":
        print "--->must input -t to_address -s subject, and the value can not be empty"
        usage()
        return False
    else:
        return True

def loginlog(command):
    day = time.strftime("%Y-%m-%d %H:%M:%S", time.localtime())
    user = getpass.getuser()
    logstr = "%s\tuser:%s\tcmd:%s" % (day, user, command)
    write2file(logstr)

def processlog():
    global to_address
    global subject
    global content
    global attach

    day = time.strftime("%Y-%m-%d %H:%M:%S", time.localtime())
    user = getpass.getuser()

    logstr = "%s\tuser:%s\ttoaddredd:%s\tsubject:%s\tcontent:%s\tattach:%s" % (day, user, to_address, subject, content, attach)
    write2file(logstr)
    write2file("--------------------------------------------------------------------------------------")

def write2file(sss):
    logfile = "/data/bi-report/logs/sendmail.log"
    output=open(logfile,'a')
    output.write(str(sss) + "\n")
    output.close()

def usage():
    print 'sendmail usage:'
    print '  -t: mail to (Required)'
    print '  -s: subject (Required)'
    print '  -m: cc address (Required)'
    print '  -c: mail content (Optional)'
    print '  -a: attach (Optional)'
    print '  -f: trans file content to html table(Optional)'

if __name__ == '__main__':
    loginlog(sys.argv)
    if not checkauth():
        print "--->You do not have permission to send email, please contact fangguoqing@igengmei.com"
        sys.exit(0)
    if len(sys.argv) >= 3:
        if processcmd(sys.argv[1:]) != -1:
            sendmail()
    else:
        usage()