--***************************************************************
--*脚本名称:
--*功能: 业绩基础数据
--*业务名称: pm
--*输入数据:
--*作者: yindanlei@igengmei.com
--*更新时间:2020-09-22
--***************************************************************

--设置全局变量&UDF
SET mapreduce.job.queuename=data;

--使用bl数据库
USE pm;

--创建BL层内部表
CREATE TABLE IF NOT EXISTS pm.tl_pm_yeji_d
(
 data string comment '{"chs_name":"日期","description":"","etl":"","value":"","remark":""}',
 merchant_name string comment '{"chs_name":"商户名称","description":"","etl":"","value":"","remark":""}',
 business_group_name string comment '{"chs_name":"商务组","description":"","etl":"","value":"","remark":""}',
 business_partener_name string comment '{"chs_name":"商务名称","description":"","etl":"","value":"","remark":""}',
 city_name string comment '{"chs_name":"城市","description":"","etl":"","value":"","remark":""}',
 hexin_pv BIGINT comment '{"chs_name":"核心页pv","description":"","etl":"","value":"","remark":""}',
 service_pv BIGINT comment '{"chs_name":"美购页pv","description":"","etl":"","value":"","remark":""}',
 clue_num BIGINT comment '{"chs_name":"有效线索人次","description":"","etl":"","value":"","remark":""}',
 discount BIGINT comment '{"chs_name":"总验证抽成","description":"","etl":"","value":"","remark":""}',
 recharge_amount BIGINT comment '{"chs_name":"广告收款","description":"","etl":"","value":"","remark":""}',
 chongzhi_amount BIGINT comment '{"chs_name":"广告消耗","description":"","etl":"","value":"","remark":""}',
 all_amount BIGINT comment '{"chs_name":"广告总消耗(含返点)","description":"","etl":"","value":"","remark":""}',
 cpc_amount BIGINT comment '{"chs_name":"cpc总消耗","description":"","etl":"","value":"","remark":""}',
 cpc_chongzhi_amount BIGINT comment '{"chs_name":"cpc充值消耗","description":"","etl":"","value":"","remark":""}',
 budget BIGINT comment '{"chs_name":"cpc商品有效预算","description":"","etl":"","value":"","remark":""}',
 cpc_click_num BIGINT comment '{"chs_name":"cpc点击数","description":"","etl":"","value":"","remark":""}',
 liulan_amount BIGINT comment '{"chs_name":"浏览收入","description":"","etl":"","value":"","remark":""}',
 sixin_amount BIGINT comment '{"chs_name":"私信收入","description":"","etl":"","value":"","remark":""}',
 service_price BIGINT comment '{"chs_name":"纯用户支付金额","description":"","etl":"","value":"","remark":""}'
 )comment '业绩基础数据'
PARTITIONED BY (PARTITION_DAY STRING comment '分区日期')
ROW FORMAT DELIMITED
FIELDS TERMINATED BY '\t'
COLLECTION ITEMS TERMINATED BY '\002'
MAP KEYS TERMINATED BY '\003'
LINES TERMINATED BY '\n'
STORED AS TEXTFILE;