SET mapreduce.job.queuename=data;
SET mapreduce.map.memory.mb=8192;
SET mapreduce.map.java.opts=-Xmx8000m;
SET mapreduce.reduce.memory.mb=8192;
SET mapreduce.reduce.java.opts=-Xmx8000m;
set hive.auto.convert.join=true;
SET mapred.reduce.tasks=20;
SET role admin;

--push点击数据
INSERT OVERWRITE TABLE pm.tl_pm_push_detail_d PARTITION (PARTITION_DAY = ${partition_day})

SELECT NVL(click.partition_date,received.partition_date) as day_id
        ,NVL(click.device_os_type,received.device_os_type) as device_os_type
        ,NVL(click.active_type,received.active_type) as active_type
        ,dau
        ,is_open_uv
        ,push_receive_uv
        ,push_receive_pv
        ,push_open_uv
        ,push_open_pv
        ,push_open_2_uv
        ,push_open_2_pv
        ,op_receive_uv
        ,op_receive_pv
        ,op_push_open_uv
        ,op_push_open_pv
        ,op_push_open_2_uv
        ,op_push_open_2_pv
        ,xitong_receive_uv
        ,xitong_receive_pv
        ,xitong_push_open_uv
        ,xitong_push_open_pv
        ,xitong_push_open_2_uv
        ,xitong_push_open_2_pv
        ,will_receive_uv
        ,will_receive_pv
        ,will_push_open_uv
        ,will_push_open_pv
        ,will_push_open_2_uv
        ,will_push_open_2_pv
        ,sign_receive_uv
        ,sign_receive_pv
        ,sign_push_open_uv
        ,sign_push_open_pv
        ,sign_push_open_2_uv
        ,sign_push_open_2_pv
        ,personal_receive_uv
        ,personal_receive_pv
        ,personal_push_open_uv
        ,personal_push_open_pv
        ,personal_push_open_2_uv
        ,personal_push_open_2_pv
        ,ctr_receive_uv
        ,ctr_receive_pv
        ,ctr_push_open_uv
        ,ctr_push_open_pv
        ,ctr_push_open_2_uv
        ,ctr_push_open_2_pv
        ,non_ctr_receive_uv
        ,non_ctr_receive_pv
        ,non_ctr_push_open_uv
        ,non_ctr_push_open_pv
        ,non_ctr_push_open_2_uv
        ,non_ctr_push_open_2_pv
        ,AI_receive_uv
        ,AI_receive_pv
        ,AI_push_open_pv
        ,AI_push_open_uv
        ,AI_push_open_2_uv
        ,AI_push_open_2_pv
        ,auto_receive_uv
        ,auto_receive_pv
        ,auto_push_open_uv
        ,auto_push_open_pv
        ,auto_push_open_2_uv
        ,auto_push_open_2_pv
        ,location_receive_uv
        ,location_receive_pv
        ,location_push_open_uv
        ,location_push_open_pv
        ,location_push_open_2_uv
        ,location_push_open_2_pv
        ,qa_receive_uv
        ,qa_receive_pv
        ,qa_push_open_uv
        ,qa_push_open_pv
        ,qa_push_open_2_uv
        ,qa_push_open_2_pv
FROM
(
    SELECT  t1.partition_date
           ,device_os_type
           ,active_type
           ,count(distinct t1.device_id) as dau
           ,count(distinct is_open.cl_id) as is_open_uv                                                                                   --push开启设备数
           ,count(distinct t2.cl_id) as push_open_uv                                                                                      --push拉起设备数
           ,sum(NVL(t2.push_open_pv,0)) as push_open_pv                                                                                   --push拉起人次
           ,count(distinct t5.cl_id) as push_open_2_uv                                                                                    --push拉起有2跳设备数
           ,sum(case WHEN t5.cl_id is not null then push_open_2_pv END) as push_open_2_pv                                                 --push拉起有2跳人次
           ,count(distinct case when op_push_open_pv is not null and op_push_open_pv>0 then t2.cl_id end) as op_push_open_uv              --运营push拉起设备数
           ,sum(NVL(t2.op_push_open_pv,0)) as op_push_open_pv                                                                             --运营push拉起人次
           ,count(distinct case when op_push_open_2_pv is not null and op_push_open_2_pv>0 then t5.cl_id end) as op_push_open_2_uv        --运营push拉起有2跳设备数
           ,sum(NVL(t5.op_push_open_2_pv,0)) as op_push_open_2_pv                                                                         --运营push拉起有2跳人次
           ,count(distinct case when xitong_push_open_pv is not null and xitong_push_open_pv>0 then t2.cl_id end) as xitong_push_open_uv        --自动push拉起设备数
           ,sum(NVL(t2.xitong_push_open_pv,0)) as xitong_push_open_pv                                                                         --自动push拉起人次
           ,count(distinct case when xitong_push_open_2_pv is not null and xitong_push_open_2_pv>0 then t5.cl_id end) as xitong_push_open_2_uv  --自动push拉起有2跳设备数
           ,sum(NVL(t5.xitong_push_open_2_pv,0)) as xitong_push_open_2_pv                                                                     --自动push拉起有2跳人次
           ,count(distinct case when will_push_open_pv is not null and will_push_open_pv>0 then t2.cl_id end) as will_push_open_uv        --意愿探索push拉起设备数
           ,sum(NVL(t2.will_push_open_pv,0)) as will_push_open_pv                                                                             --意愿探索push拉起人次
           ,count(distinct case when will_push_open_2_pv is not null and will_push_open_2_pv>0 then t5.cl_id end) as will_push_open_2_uv  --意愿探索push拉起有2跳设备数
           ,sum(NVL(t5.will_push_open_2_pv,0)) as will_push_open_2_pv
           ,count(distinct case when sign_push_open_pv is not null and sign_push_open_pv>0 then t2.cl_id end) as sign_push_open_uv        --签到push拉起设备数
           ,sum(NVL(t2.sign_push_open_pv,0)) as sign_push_open_pv                                                                             --签到push拉起人次
           ,count(distinct case when sign_push_open_2_pv is not null and sign_push_open_2_pv>0 then t5.cl_id end) as sign_push_open_2_uv  --签到push拉起有2跳设备数
           ,sum(NVL(t5.sign_push_open_2_pv,0)) as sign_push_open_2_pv
           ,count(distinct case when t2.ctr_push_open_pv+t2.non_ctr_push_open_pv>0 then t2.cl_id end) as personal_push_open_uv        --个性化push拉起设备数
           ,sum(NVL(t2.ctr_push_open_pv+t2.non_ctr_push_open_pv,0)) as personal_push_open_pv                                                                             --个性化push拉起人次
           ,count(distinct case when t5.ctr_push_open_2_pv+t5.non_ctr_push_open_2_pv>0 then t5.cl_id end) as personal_push_open_2_uv        --个性化push拉起设备数
           ,sum(NVL(t5.ctr_push_open_2_pv+t5.non_ctr_push_open_2_pv,0)) as personal_push_open_2_pv                                                                       --个性化push拉起有2跳人次
           ,count(distinct case when ctr_push_open_pv is not null and ctr_push_open_pv>0 then t2.cl_id end) as ctr_push_open_uv        --签到push拉起设备数
           ,sum(NVL(t2.ctr_push_open_pv,0)) as ctr_push_open_pv                                                                             --签到push拉起人次
           ,count(distinct case when ctr_push_open_2_pv is not null and ctr_push_open_2_pv>0 then t5.cl_id end) as ctr_push_open_2_uv  --签到push拉起有2跳设备数
           ,sum(NVL(t5.ctr_push_open_2_pv,0)) as ctr_push_open_2_pv
           ,count(distinct case when non_ctr_push_open_pv is not null and non_ctr_push_open_pv>0 then t2.cl_id end) as non_ctr_push_open_uv        --签到push拉起设备数
           ,sum(NVL(t2.non_ctr_push_open_pv,0)) as non_ctr_push_open_pv                                                                             --签到push拉起人次
           ,count(distinct case when non_ctr_push_open_2_pv is not null and non_ctr_push_open_2_pv>0 then t5.cl_id end) as non_ctr_push_open_2_uv  --签到push拉起有2跳设备数
           ,sum(NVL(t5.non_ctr_push_open_2_pv,0)) as non_ctr_push_open_2_pv
           ,count(distinct case when AI_push_open_pv is not null and AI_push_open_pv>0 then t2.cl_id end) as AI_push_open_uv        --签到push拉起设备数
           ,sum(NVL(t2.AI_push_open_pv,0)) as AI_push_open_pv                                                                             --签到push拉起人次
           ,count(distinct case when AI_push_open_2_pv is not null and AI_push_open_2_pv>0 then t5.cl_id end) as AI_push_open_2_uv  --签到push拉起有2跳设备数
           ,sum(NVL(t5.AI_push_open_2_pv,0)) as AI_push_open_2_pv
           ,count(distinct case when auto_push_open_pv is not null and auto_push_open_pv>0 then t2.cl_id end) as auto_push_open_uv        --签到push拉起设备数
           ,sum(NVL(t2.auto_push_open_pv,0)) as auto_push_open_pv                                                                             --签到push拉起人次
           ,count(distinct case when auto_push_open_2_pv is not null and auto_push_open_2_pv>0 then t5.cl_id end) as auto_push_open_2_uv  --签到push拉起有2跳设备数
           ,sum(NVL(t5.auto_push_open_2_pv,0)) as auto_push_open_2_pv
           ,count(distinct case when location_push_open_pv is not null and location_push_open_pv>0 then t2.cl_id end) as location_push_open_uv        --地狱push拉起设备数
           ,sum(NVL(t2.location_push_open_pv,0)) as location_push_open_pv                                                                             --地狱push拉起人次
           ,count(distinct case when location_push_open_2_pv is not null and location_push_open_2_pv>0 then t5.cl_id end) as location_push_open_2_uv  --地狱push拉起有2跳设备数
           ,sum(NVL(t5.location_push_open_2_pv,0)) as location_push_open_2_pv
           ,count(distinct case when qa_push_open_pv is not null and qa_push_open_pv>0 then t2.cl_id end) as qa_push_open_uv        --邀请回答push拉起设备数
           ,sum(NVL(t2.qa_push_open_pv,0)) as qa_push_open_pv                                                                             --邀请回答push拉起人次
           ,count(distinct case when qa_push_open_2_pv is not null and qa_push_open_2_pv>0 then t5.cl_id end) as qa_push_open_2_uv  --邀请回答push拉起有2跳设备数
           ,sum(NVL(t5.qa_push_open_2_pv,0)) as qa_push_open_2_pv
    FROM
    (
        select
            partition_date
            ,device_id
            ,device_os_type
            ,case WHEN active_type = '4'  THEN '老活' WHEN active_type  in ('1','2')  then '新增' END as active_type
        from online.ml_device_day_active_status
        where partition_date = regexp_replace(DATE_SUB(current_date,1) ,'-','')
        AND active_type in ('4','1','2')
        AND first_channel_source_type not IN ('yqxiu1','yqxiu2','yqxiu3','yqxiu4','yqxiu5','mxyc1','mxyc2','mxyc3'
                ,'wanpu','jinshan','jx','maimai','zhuoyi','huatian','suopingjingling','mocha','mizhe','meika','lamabang'
                ,'js-az1','js-az2','js-az3','js-az4','js-az5','jfq-az1','jfq-az2','jfq-az3','jfq-az4','jfq-az5','toufang1'
                ,'toufang2','toufang3','toufang4','toufang5','toufang6','TF-toufang1','TF-toufang2','TF-toufang3','TF-toufang4'
                ,'TF-toufang5','tf-toufang1','tf-toufang2','tf-toufang3','tf-toufang4','tf-toufang5','benzhan','promotion_aso100'
                ,'promotion_qianka','promotion_xiaoyu','promotion_dianru','promotion_malioaso','promotion_malioaso-shequ'
                ,'promotion_shike','promotion_julang_jl03','promotion_zuimei','','unknown')
        AND first_channel_source_type not LIKE 'promotion\_jf\_%'
    )t1
    LEFT JOIN
    (
        select a.partition_date,a.cl_id   --开启push设备
        from
        (
           SELECT partition_date,cl_id,max(time_str) as max_time_str
           FROM online.bl_hdfs_maidian_updates
           where partition_date = regexp_replace(DATE_SUB(current_date,1) ,'-','')
           and action='is_open_push'
           group by partition_date,cl_id
        )a
        left join
        (
           SELECT partition_date,
                  cl_id,time_str,COALESCE(params['type'],params['tyep']) as type
           FROM online.bl_hdfs_maidian_updates
           where partition_date = regexp_replace(DATE_SUB(current_date,1) ,'-','')
           and action='is_open_push'
        )b
        on b.partition_date=a.partition_date and b.cl_id=a.cl_id and b.time_str=a.max_time_str
        where type=1
        group by a.partition_date,a.cl_id
    )is_open
    on is_open.partition_date=t1.partition_date and is_open.cl_id=t1.device_id
    LEFT JOIN
    (
        SELECT a.partition_date,a.cl_id,
               count(distinct a.message_id) as push_open_pv,
               count(distinct case when push_type in ('70','71') then a.message_id end) as op_push_open_pv,                                  --运营push  push_type in ('70','71')
               count(distinct case when push_type in ('101','102','103') then a.message_id end) as ctr_push_open_pv,        --个性化push
               count(distinct case when push_type in ('111','112','113') then a.message_id end) as non_ctr_push_open_pv,        --个性化push
               count(distinct case when push_type in ('104') then a.message_id end) as qa_push_open_pv,        --邀请回答push
               count(distinct case when push_type in ('105') then a.message_id end) as location_push_open_pv,        --地狱push
               count(distinct case when push_type in ('106','107','108') then a.message_id end) as will_push_open_pv,          --意愿push
               count(distinct case when push_type in ('25') then a.message_id end) as sign_push_open_pv,          --签到push
               count(distinct case when push_type is not null
                              and push_type not in  ('70','71','101','102','103','104','105','111','112','113','106','107','108','25','93','94') then a.message_id end) as xitong_push_open_pv,   --系统push
               count(distinct case when push_type in ('93','94') then a.message_id end) as AI_push_open_pv,
               count(distinct case when push_type is not null and push_type not in ('70','71') then a.message_id end) as auto_push_open_pv   --自动push
        FROM
        (
          SELECT a.partition_date,b.cl_id,a.app_session_id,b.message_id
          FROM
          (
              --设备开启
              SELECT partition_date,cl_id,unix_timestamp(substr(time_str,1,19)) as time_stamp,app_session_id
              FROM online.bl_hdfs_maidian_updates
              where partition_date = regexp_replace(DATE_SUB(current_date,1) ,'-','')
              and action='device_opened'
              group by partition_date,cl_id,unix_timestamp(substr(time_str,1,19)),app_session_id
          )a
          JOIN
          (
              --推送点击
              SELECT partition_date,cl_id,unix_timestamp(substr(time_str,1,19)) as time_stamp,params['message_id'] as message_id
              FROM online.bl_hdfs_maidian_updates
              where partition_date = regexp_replace(DATE_SUB(current_date,1) ,'-','')
              and action='notification_open'
              group by partition_date,cl_id,unix_timestamp(substr(time_str,1,19)),params['message_id']
          )b
          on a.partition_date = b.partition_date
          AND a.cl_id = b.cl_id
          where abs(a.time_stamp-b.time_stamp)<=2
        )a
        LEFT JOIN
        (
            SELECT a.msg_id,case when b.msg_id is not null then 'ex' else push_type end as push_type
            FROM
            (
                select msg_id,push_type,time_stamp
                from online.tl_hdfs_push2_new_view --增量表
                where partition_date>='20190801' AND partition_date<=regexp_replace(DATE_SUB(current_date,1) ,'-','')
                group by msg_id,push_type,time_stamp
            )a
            left join
            (
                SELECT if(substr(jiguang_id,1,1)=',',substr(jiguang_id,2),jiguang_id) as msg_id
                FROM online.tl_hdfs_api_pushtask2_view       --mars后台消息推送表
                WHERE partition_date=regexp_replace(DATE_SUB(current_date,1) ,'-','')
                AND regexp_replace(substr(pushtime,1,10),'-','') >= '20200629'
                AND regexp_replace(substr(pushtime,1,10),'-','') <= '20200714'
                AND approver_status = 'true'  --审核状态，true表示审核通过
                AND status = '2'   --推送状态，2表示发送成功，1表示准备发送
                AND creator_id in ('32018153','32719681','32264790','31779749','31436904')
            )b
            on a.msg_id=b.msg_id
        )e
        on e.msg_id=a.message_id
        group by a.partition_date,a.cl_id
    )t2
    on t2.cl_id=t1.device_id and t2.partition_date=t1.partition_date

    LEFT JOIN
    (
        --push拉起后有2跳的设备
        SELECT partition_date,
               a.cl_id,
               count(distinct a.app_session_id) as push_open_2_pv,
               count(distinct case when push_type in ('70','71') then a.app_session_id end) as op_push_open_2_pv,                                  --运营push  push_type in ('70','71')
               count(distinct case when push_type in ('101','102','103') then a.app_session_id end) as ctr_push_open_2_pv,          --个性化push
               count(distinct case when push_type in ('111','112','113') then a.app_session_id end) as non_ctr_push_open_2_pv,          --个性化push
               count(distinct case when push_type in ('104') then a.app_session_id end) as qa_push_open_2_pv,          --个性化push
               count(distinct case when push_type in ('105') then a.app_session_id end) as location_push_open_2_pv,          --个性化push
               count(distinct case when push_type in ('106','107','108') then a.app_session_id end) as will_push_open_2_pv,          --意愿push
               count(distinct case when push_type in ('25') then a.app_session_id end) as sign_push_open_2_pv,          --签到push
               count(distinct case when push_type is not null
                              and push_type not in  ('70','71','101','102','103','104','105','111','112','113','106','107','108','25','93','94') then a.app_session_id end) as xitong_push_open_2_pv,   --系统push
               count(distinct case when push_type in ('93','94') then a.app_session_id end) as AI_push_open_2_pv,          --签到push
               count(distinct case when push_type is not null and push_type not in  ('70','71') then a.app_session_id end) as auto_push_open_2_pv   --自动push
        FROM
        (
          SELECT a.partition_date,b.cl_id,a.app_session_id,b.message_id
          FROM
          (
              --设备开启
              SELECT partition_date,cl_id,unix_timestamp(substr(time_str,1,19)) as time_stamp,app_session_id
              FROM online.bl_hdfs_maidian_updates
              where partition_date = regexp_replace(DATE_SUB(current_date,1) ,'-','')
              and action='device_opened'
              group by partition_date,cl_id,unix_timestamp(substr(time_str,1,19)),app_session_id
          )a
          JOIN
          (
              --推送点击
              SELECT partition_date,cl_id,unix_timestamp(substr(time_str,1,19)) as time_stamp,params['message_id'] as message_id
              FROM online.bl_hdfs_maidian_updates
              where partition_date = regexp_replace(DATE_SUB(current_date,1) ,'-','')
              and action='notification_open'
              group by partition_date,cl_id,unix_timestamp(substr(time_str,1,19)),params['message_id']
          )b
          on a.partition_date = b.partition_date
          AND a.cl_id = b.cl_id
          where abs(a.time_stamp-b.time_stamp)<=2
        )a
        LEFT JOIN
        (
            SELECT a.msg_id,case when b.msg_id is not null then 'ex' else push_type end as push_type
            FROM
            (
                select msg_id,push_type,time_stamp
                from online.tl_hdfs_push2_new_view --增量表
                where partition_date>='20190801' AND partition_date<= regexp_replace(DATE_SUB(current_date,1) ,'-','')
                group by msg_id,push_type,time_stamp
            )a
            left join
            (
                SELECT if(substr(jiguang_id,1,1)=',',substr(jiguang_id,2),jiguang_id) as msg_id
                FROM online.tl_hdfs_api_pushtask2_view       --mars后台消息推送表
                WHERE partition_date=regexp_replace(DATE_SUB(current_date,1) ,'-','')
                AND regexp_replace(substr(pushtime,1,10),'-','') >= '20200629'
                AND regexp_replace(substr(pushtime,1,10),'-','') <= '20200714'
                AND approver_status = 'true'  --审核状态，true表示审核通过
                AND status = '2'   --推送状态，2表示发送成功，1表示准备发送
                AND creator_id in ('32018153','32719681','32264790','31779749','31436904')
            )b
            on a.msg_id=b.msg_id
        )e
        on e.msg_id=a.message_id
        JOIN
        (
            --通过push拉起的一次会话中，有2跳，包括回退
            SELECT a.partition_date,a.cl_id,a.app_session_id,a.cl_type
            from
            (
                SELECT partition_date,cl_id,app_session_id,cl_type,if(page_name='home','home','non_home') as is_home
                FROM online.bl_hdfs_maidian_updates
                where partition_date = regexp_replace(DATE_SUB(current_date,1) ,'-','')
                and action='page_view'
                GROUP BY partition_date,cl_id,app_session_id,cl_type,if(page_name='home','home','non_home')
            )a
            join
            (
                SELECT partition_date,cl_id,app_session_id,cl_type
                    ,count(distinct page_name) as page_num
                    ,count(distinct array(time_str,page_name)) as page_array
                FROM online.bl_hdfs_maidian_updates
                where partition_date = regexp_replace(DATE_SUB(current_date,1) ,'-','')
                and action='page_view'
                GROUP BY partition_date,cl_id,app_session_id,cl_type
            )b
            on b.partition_date=a.partition_date and b.cl_id=a.cl_id and b.app_session_id=a.app_session_id
            left join
            (
                select device_id
                from ml.ml_d_ct_dv_devicespam_d  --去除机构刷单设备，即作弊设备（浏览和曝光事件去除）
                WHERE partition_day=regexp_replace(DATE_SUB(current_date,1) ,'-','')
            )spam
            on spam.device_id=a.cl_id
            where spam.device_id IS NULL and
            (a.cl_type='ios' and is_home='home' and page_num>=2 and page_array>=3 or
             a.cl_type='ios' and is_home='non_home' and page_array>=2 or
             a.cl_type='android' and page_array>=2)
            GROUP BY a.partition_date,a.cl_id,a.app_session_id,a.cl_type
        )c
        on a.partition_date = c.partition_date
        AND a.cl_id = c.cl_id
        AND a.app_session_id = c.app_session_id
        GROUP BY a.cl_id,a.partition_date
    )t5
    on t1.partition_date=t5.partition_date and t1.device_id=t5.cl_id
    GROUP BY t1.partition_date,device_os_type,active_type
)click
full join
(
    SELECT a.partition_date
            ,device_os_type
            ,'老活' as active_type
            ,count(distinct a.device_id) as push_receive_uv
            ,count(distinct case when push_type in ('70','71') then a.device_id end) as op_receive_uv                                 --运营push  push_type in ('70','71')
            ,count(distinct case when push_type in ('101','102','103','111','112','113') then a.device_id end) as personal_receive_uv        --个性化push
            ,count(distinct case when push_type in ('101','102','103') then a.device_id end) as ctr_receive_uv        --个性化push
            ,count(distinct case when push_type in ('111','112','113') then a.device_id end) as non_ctr_receive_uv        --个性化push
            ,count(distinct case when push_type in ('104') then a.device_id end) as qa_receive_uv        --邀请回答push
            ,count(distinct case when push_type in ('105') then a.device_id end) as location_receive_uv        --地狱push
            ,count(distinct case when push_type in ('106','107','108') then a.device_id end) as will_receive_uv          --意愿push
            ,count(distinct case when push_type in ('25') then a.device_id end) as sign_receive_uv          --签到push
            ,count(distinct case when push_type is not null
                          and push_type not in  ('70','71','101','102','103','104','105','111','112','113','106','107','108','25','93','94') then a.device_id end) as xitong_receive_uv   --系统push
            ,count(distinct case when push_type in ('93','94') then a.device_id end) as AI_receive_uv
            ,count(distinct case when push_type is not null and push_type not in ('70','71') then a.device_id end) as auto_receive_uv   --自动push
            ,count(a.device_id) as push_receive_pv
            ,count(case when push_type in ('70','71') then a.device_id end) as op_receive_pv                                 --运营push  push_type in ('70','71')
            ,count(case when push_type in ('101','102','103','111','112','113') then a.device_id end) as personal_receive_pv       --个性化push
            ,count(case when push_type in ('101','102','103') then a.device_id end) as ctr_receive_pv        --个性化push
            ,count(case when push_type in ('111','112','113') then a.device_id end) as non_ctr_receive_pv        --个性化push
            ,count(case when push_type in ('104') then a.device_id end) as qa_receive_pv        --邀请回答push
            ,count(case when push_type in ('105') then a.device_id end) as location_receive_pv        --地狱push
            ,count(case when push_type in ('106','107','108') then a.device_id end) as will_receive_pv          --意愿push
            ,count(case when push_type in ('25') then a.device_id end) as sign_receive_pv          --签到push
            ,count(case when push_type is not null
                          and push_type not in  ('70','71','101','102','103','104','105','111','112','113','106','107','108','25','93','94') then a.device_id end) as xitong_receive_pv   --系统push
            ,count(case when push_type in ('93','94') then a.device_id end) as AI_receive_pv
            ,count(case when push_type is not null and push_type not in ('70','71') then a.device_id end) as auto_receive_pv   --自动push

    FROM
    (
        select partition_day as partition_date
                ,device_id,msg_id,'ios' as device_os_type
        from bl.bl_et_bg_trackingpushlog_inc_d
        where partition_day= regexp_replace(DATE_SUB(current_date,1) ,'-','')
        group by partition_day,device_id,msg_id

        union all

        SELECT partition_date,device_id,mesid as msg_id,'android' as device_os_type
        FROM
        (
          SELECT partition_date,registration_id,platform,mesid
          FROM online.tl_hdfs_auroracallback_view--推送push的回调表
          where partition_date= regexp_replace(DATE_SUB(current_date,1) ,'-','')
          --and notification_state='true'--用户开启通知
          and callback_type = '0'--送达回执
          and platform='android'
          group by partition_date,registration_id,platform,mesid
        )msg
        JOIN
        (
          SELECT device_id,registration_id
          from online.tl_hdfs_api_jpushuserdevicebinding_view--极光id和设备id绑定关系全量表
          where partition_date=regexp_replace(date_sub(current_date(),1),'-','')
          and  (registration_id is not null  or registration_id <>'')
          group by device_id,registration_id
        )reg
        on reg.registration_id=msg.registration_id
    )a
    JOIN
    (
        select device_id
        from online.ml_device_history_detail
        where partition_date=regexp_replace(DATE_SUB(current_date,1) ,'-','')
        and first_channel_source_type not in ('yqxiu1','yqxiu2','yqxiu3','yqxiu4','yqxiu5','mxyc1','mxyc2','mxyc3'
               ,'wanpu','jinshan','jx','maimai','zhuoyi','huatian','suopingjingling','mocha','mizhe','meika','lamabang'
               ,'js-az1','js-az2','js-az3','js-az4','js-az5','jfq-az1','jfq-az2','jfq-az3','jfq-az4','jfq-az5','toufang1'
               ,'toufang2','toufang3','toufang4','toufang5','toufang6','TF-toufang1','TF-toufang2','TF-toufang3','TF-toufang4'
               ,'TF-toufang5','tf-toufang1','tf-toufang2','tf-toufang3','tf-toufang4','tf-toufang5','benzhan','promotion_aso100'
               ,'promotion_qianka','promotion_xiaoyu','promotion_dianru','promotion_malioaso','promotion_malioaso-shequ'
               ,'promotion_shike','promotion_julang_jl03','promotion_zuimei')
        AND first_channel_source_type not like 'promotion\_jf\_%'
    )b
    on a.device_id=b.device_id
    JOIN
    (
        select msg_id,push_type,time_stamp
        from online.tl_hdfs_push2_new_view --增量表
        where partition_date>='20190801' AND partition_date<= regexp_replace(DATE_SUB(current_date,1) ,'-','')
        group by msg_id,push_type,time_stamp
    )c
    on a.msg_id=c.msg_id
    left join
    (
        select
            partition_date
            ,device_id
        from online.ml_device_day_active_status
        where partition_date = regexp_replace(DATE_SUB(current_date,1) ,'-','')
        AND active_type in ('1','2','3')
    )d
    on a.partition_date=d.partition_date and a.device_id=d.device_id
    where d.device_id is null
    group by a.partition_date
            ,device_os_type
)received
on click.partition_date = received.partition_date
and click.device_os_type=received.device_os_type
and click.active_type=received.active_type
order by day_id,device_os_type,active_type;


--push接收数据


INSERT OVERWRITE TABLE pm.tl_pm_push_receive_d PARTITION (PARTITION_DAY = ${partition_day})

SELECT t1.partition_day as day_id
        ,t1.device_os_type as device_os_type
        ,'老活' as active_type
        ,t1.push_type as push_type
        ,count(distinct t1.device_id) as received_dev_num
        ,count(t1.msg_id) as received_msg_num
        ,count(distinct t2.cl_id) as click_dev_num
        ,count(t2.msg_id) as click_msg_num
FROM
(--接收设备数
    SELECT partition_day
            ,device_os_type
            ,push_type
            ,a.device_id
            ,a.msg_id
    FROM
    (
        select partition_day
                ,device_id,msg_id
        from bl.bl_et_bg_trackingpushlog_inc_d
        where partition_day=regexp_replace(DATE_SUB(current_date,1) ,'-','')
        group by partition_day,device_id,msg_id
    )a
    JOIN
    (
        select device_id,device_os_type
        from online.ml_device_history_detail
        where partition_date=regexp_replace(DATE_SUB(current_date,1) ,'-','')
        and first_channel_source_type not in ('yqxiu1','yqxiu2','yqxiu3','yqxiu4','yqxiu5','mxyc1','mxyc2','mxyc3'
               ,'wanpu','jinshan','jx','maimai','zhuoyi','huatian','suopingjingling','mocha','mizhe','meika','lamabang'
               ,'js-az1','js-az2','js-az3','js-az4','js-az5','jfq-az1','jfq-az2','jfq-az3','jfq-az4','jfq-az5','toufang1'
               ,'toufang2','toufang3','toufang4','toufang5','toufang6','TF-toufang1','TF-toufang2','TF-toufang3','TF-toufang4'
               ,'TF-toufang5','tf-toufang1','tf-toufang2','tf-toufang3','tf-toufang4','tf-toufang5','benzhan','promotion_aso100'
               ,'promotion_qianka','promotion_xiaoyu','promotion_dianru','promotion_malioaso','promotion_malioaso-shequ'
               ,'promotion_shike','promotion_julang_jl03','promotion_zuimei')
        AND first_channel_source_type not like 'promotion\_jf\_%'
    )b
    on a.device_id=b.device_id
    JOIN
    (
        select msg_id,push_type,time_stamp
        from online.tl_hdfs_push2_new_view --增量表
        where partition_date=regexp_replace(DATE_SUB(current_date,1) ,'-','')
        group by msg_id,push_type,time_stamp

        union all

        SELECT msg_id,regexp_replace(labels['event'], '\\s+', '') AS push_type,time_stamp
        FROM online.tl_hdfs_push2_task_view
        WHERE partition_date=regexp_replace(DATE_SUB(current_date,1) ,'-','')
        AND labels['event_type'] = 'push'
        group by  msg_id,regexp_replace(labels['event'], '\\s+', ''),time_stamp
    )c
    on a.msg_id=c.msg_id
    left join
    (
        select
            partition_date
            ,device_id
        from online.ml_device_day_active_status
        where partition_date=regexp_replace(DATE_SUB(current_date,1) ,'-','')
        AND active_type in ('1','2','3')
        and device_os_type='ios'
    )d
    on a.partition_day=d.partition_date and a.device_id=d.device_id
    where d.device_id is null
    group by partition_day
            ,device_os_type
            ,push_type
            ,a.device_id
            ,a.msg_id
)t1
left join
(--点击设备数
    select partition_date
            ,cl_id,params['message_id'] as msg_id,time_stamp
    from online.bl_hdfs_maidian_updates
    where partition_date=regexp_replace(DATE_SUB(current_date,1) ,'-','')
    and action='notification_open'
    group by partition_date,cl_id,params['message_id'],time_stamp
)t2
on t2.partition_date=t1.partition_day
and t2.msg_id=t1.msg_id
and t2.cl_id=t1.device_id
group by t1.partition_day
        ,t1.device_os_type
        ,t1.push_type;




--push质量数据

INSERT OVERWRITE TABLE pm.tl_pm_push_quality_d PARTITION (PARTITION_DAY = ${partition_day})
SELECT partition_date as day_id
      ,device_os_type
      ,round(nvl((op_only_wel_pv/op_only_wel_uv)/(wel_pv/wel_uv),0),2) as op_only_wel
      ,round(nvl((op_push_first_wel_pv/op_push_first_wel_uv)/(wel_pv/wel_uv),0),2) as op_push_first_wel
      ,round(nvl((op_open_first_wel_pv/op_open_first_wel_uv)/(wel_pv/wel_uv),0),2) as op_open_first_wel
      ,round(nvl((op_only_clue_pv/op_only_clue_uv)/(clue_pv/clue_uv),0),2) as op_only_clue
      ,round(nvl((op_push_first_clue_pv/op_push_first_clue_uv)/(clue_pv/clue_uv),0),2) as op_push_first_clue
      ,round(nvl((op_open_first_clue_pv/op_open_first_clue_uv)/(clue_pv/clue_uv),0),2) as op_open_first_clue

      ,round(nvl((auto_only_wel_pv/auto_only_wel_uv)/(wel_pv/wel_uv),0),2) as auto_only_wel
      ,round(nvl((auto_push_first_wel_pv/auto_push_first_wel_uv)/(wel_pv/wel_uv),0),2) as auto_push_first_wel
      ,round(nvl((auto_open_first_wel_pv/auto_open_first_wel_uv)/(wel_pv/wel_uv),0),2) as auto_open_first_wel
      ,round(nvl((auto_only_clue_pv/auto_only_clue_uv)/(clue_pv/clue_uv),0),2) as auto_only_clue
      ,round(nvl((auto_push_first_clue_pv/auto_push_first_clue_uv)/(clue_pv/clue_uv),0),2) as auto_push_first_clue
      ,round(nvl((auto_open_first_clue_pv/auto_open_first_clue_uv)/(clue_pv/clue_uv),0),2) as auto_open_first_clue
FROM
(
    SELECT mas.partition_date
            ,device_os_type
            ,count(distinct a.cl_id) as wel_uv
            ,sum(a.wel_pv) as wel_pv
            ,count(distinct b.device_id) as clue_uv
            ,sum(b.valid_pv) as clue_pv
            ,count(distinct case when c.push_type='运营push' and d.type='仅点击push' then a.cl_id end) as op_only_wel_uv
            ,sum(case when c.push_type='运营push' and d.type='仅点击push' then a.wel_pv end) as op_only_wel_pv
            ,count(distinct case when c.push_type='运营push' and d.type='仅点击push' then b.device_id end) as op_only_clue_uv
            ,sum(case when c.push_type='运营push' and d.type='仅点击push' then b.valid_pv end) as op_only_clue_pv
            ,count(distinct case when c.push_type='自动化push' and d.type='仅点击push' then a.cl_id end) as auto_only_wel_uv
            ,sum(case when c.push_type='自动化push' and d.type='仅点击push' then a.wel_pv end) as auto_only_wel_pv
            ,count(distinct case when c.push_type='自动化push' and d.type='仅点击push' then b.device_id end) as auto_only_clue_uv
            ,sum(case when c.push_type='自动化push' and d.type='仅点击push' then b.valid_pv end) as auto_only_clue_pv

            ,count(distinct case when c.push_type='运营push' and d.type='先通过push来后主动打开' then a.cl_id end) as op_push_first_wel_uv
            ,sum(case when c.push_type='运营push' and d.type='先通过push来后主动打开' then a.wel_pv end) as op_push_first_wel_pv
            ,count(distinct case when c.push_type='运营push' and d.type='先通过push来后主动打开' then b.device_id end) as op_push_first_clue_uv
            ,sum(case when c.push_type='运营push' and d.type='先通过push来后主动打开' then b.valid_pv end) as op_push_first_clue_pv
            ,count(distinct case when c.push_type='自动化push' and d.type='先通过push来后主动打开' then a.cl_id end) as auto_push_first_wel_uv
            ,sum(case when c.push_type='自动化push' and d.type='先通过push来后主动打开' then a.wel_pv end) as auto_push_first_wel_pv
            ,count(distinct case when c.push_type='自动化push' and d.type='先通过push来后主动打开' then b.device_id end) as auto_push_first_clue_uv
            ,sum(case when c.push_type='自动化push' and d.type='先通过push来后主动打开' then b.valid_pv end) as auto_push_first_clue_pv

            ,count(distinct case when c.push_type='运营push' and d.type='先主动打开后通过push来' then a.cl_id end) as op_open_first_wel_uv
            ,sum(case when c.push_type='运营push' and d.type='先主动打开后通过push来' then a.wel_pv end) as op_open_first_wel_pv
            ,count(distinct case when c.push_type='运营push' and d.type='先主动打开后通过push来' then b.device_id end) as op_open_first_clue_uv
            ,sum(case when c.push_type='运营push' and d.type='先主动打开后通过push来' then b.valid_pv end) as op_open_first_clue_pv
            ,count(distinct case when c.push_type='自动化push' and d.type='先主动打开后通过push来' then a.cl_id end) as auto_open_first_wel_uv
            ,sum(case when c.push_type='自动化push' and d.type='先主动打开后通过push来' then a.wel_pv end) as auto_open_first_wel_pv
            ,count(distinct case when c.push_type='自动化push' and d.type='先主动打开后通过push来' then b.device_id end) as auto_open_first_clue_uv
            ,sum(case when c.push_type='自动化push' and d.type='先主动打开后通过push来' then b.valid_pv end) as auto_open_first_clue_pv

    FROM
    (
        SELECT  partition_date
                ,device_os_type
                ,device_id
        FROM online.ml_device_day_active_status
        WHERE partition_date>=REGEXP_REPLACE(trunc(date_sub(current_date(),1),'MM'),'-','')
		AND partition_date<=regexp_replace(date_sub(current_date,1),'-','')
        AND active_type IN ('4')
        AND first_channel_source_type not IN ('yqxiu1','yqxiu2','yqxiu3','yqxiu4','yqxiu5','mxyc1','mxyc2','mxyc3'
                ,'wanpu','jinshan','jx','maimai','zhuoyi','huatian','suopingjingling','mocha','mizhe','meika','lamabang'
                ,'js-az1','js-az2','js-az3','js-az4','js-az5','jfq-az1','jfq-az2','jfq-az3','jfq-az4','jfq-az5','toufang1'
                ,'toufang2','toufang3','toufang4','toufang5','toufang6','TF-toufang1','TF-toufang2','TF-toufang3','TF-toufang4'
                ,'TF-toufang5','tf-toufang1','tf-toufang2','tf-toufang3','tf-toufang4','tf-toufang5','benzhan','promotion_aso100'
                ,'promotion_qianka','promotion_xiaoyu','promotion_dianru','promotion_malioaso','promotion_malioaso-shequ'
                ,'promotion_shike','promotion_julang_jl03','promotion_zuimei')
        AND first_channel_source_type not LIKE 'promotion\_jf\_%'
    )mas
    LEFT JOIN
    (
        SELECT partition_date,cl_id,wel_pv
        FROM
        (
            SELECT partition_date,cl_id,count(1) as wel_pv
            FROM online.bl_hdfs_maidian_updates
            WHERE partition_date>=REGEXP_REPLACE(trunc(date_sub(current_date(),1),'MM'),'-','')
		    AND partition_date<=regexp_replace(date_sub(current_date,1),'-','')
            AND action = 'page_view'
            AND page_name in ('welfare_detail','organization_detail','expert_detail')
            GROUP BY partition_date,cl_id
        )a
        LEFT JOIN
        ( -- 去掉疑似机构刷量的PV和UV
            select distinct device_id
            from ml.ml_d_ct_dv_devicespam_d
            where partition_day=regexp_replace(date_sub(current_date,1),'-','')
        )spam_pv
        on a.cl_id=spam_pv.device_id
        WHERE spam_pv.device_id IS NULL
    )a
    on a.partition_date=mas.partition_date and a.cl_id=mas.device_id
    LEFT JOIN
    (   --有效线索分日数据(按用户维度)
        SELECT
            t2.device_id,DATE_DAY,count(1) AS valid_pv
        FROM
        (
            SELECT NVL(T1.USER_ID,T2.USER_ID) AS USER_ID,
                NVL(T1.merchant_id,T2.merchant_id) AS merchant_id,
                NVL(T1.DATE_MONTH,T2.CALL_MONTH) AS DATE_MONTH,
                least(NVL(DATE_DAY,'99999999'),NVL(FIRST_CALL_DATE,'99999999')) AS DATE_DAY,
                NVL(T1.CONSULT_NUM,0) AS CONSULT_NUM,
                NVL(T1.PAY_NUM,0) AS PAY_NUM,
                NVL(T2.call_num,0) AS CALL_NUM
        FROM
        (
            SELECT
                NVL(T3.USER_ID,T4.USER_ID) AS USER_ID,
                NVL(T3.merchant_id,T4.merchant_id) AS merchant_id,
                NVL(T3.CONSULT_MONTH,T4.PAY_MONTH) AS DATE_MONTH,
                least(NVL(first_consult_date,'99999999'),NVL(FIRST_PAY_DATE,'99999999')) AS DATE_DAY,
                NVL(T3.CONSULT_NUM,0) AS CONSULT_NUM,
                NVL(T4.PAY_NUM,0) AS PAY_NUM
            FROM
            (
                SELECT user_id,merchant_id,SUBSTR(partition_day,1,6) AS consult_month,min(partition_day) as first_consult_date,1 as CONSULT_NUM
                FROM ml.ml_c_et_msg_conversation_dimen_inc_d --新仓库私信表
                WHERE partition_day >= REGEXP_REPLACE(trunc(date_sub(current_date(),1),'MM'),'-','')
                AND partition_day <= regexp_replace(date_sub(current_date,1),'-','')
                and is_valid='true'
                GROUP BY user_id,merchant_id,SUBSTR(partition_day,1,6)
            )T3
            FULL JOIN
            (
                SELECT
                    T.USER_ID,
                    T.merchant_id,
                    regexp_replace(SUBSTR(T.PAY_DATE,1,7),'-','') AS PAY_MONTH,
                    MIN(regexp_replace(SUBSTR(T.PAY_DATE,1,10),'-','')) AS FIRST_PAY_DATE,
                    1 AS PAY_NUM
                FROM  ONLINE.ML_TRADE_ORDER_DETAIL_DAY T
                WHERE
                    T.PARTITION_DATE = regexp_replace(date_sub(current_date(),1),'-','')
                    AND regexp_replace(SUBSTR(T.pay_date,1,10),'-','') >= REGEXP_REPLACE(trunc(date_sub(current_date(),1),'MM'),'-','')
                    AND regexp_replace(SUBSTR(T.pay_date,1,10),'-','')<=regexp_replace(date_sub(current_date,1),'-','')
                    AND T.is_pure_user='true'
                GROUP BY T.USER_ID,T.merchant_id,regexp_replace(SUBSTR(T.PAY_DATE,1,7),'-','')
            ) T4
            ON T3.USER_ID = T4.USER_ID AND T3.merchant_id = T4.merchant_id AND T3.CONSULT_MONTH = T4.PAY_MONTH
            GROUP BY NVL(T3.USER_ID,T4.USER_ID),NVL(T3.merchant_id,T4.merchant_id),NVL(T3.CONSULT_MONTH,T4.PAY_MONTH),
                least(NVL(first_consult_date,'99999999'),NVL(FIRST_PAY_DATE,'99999999')),NVL(T3.CONSULT_NUM,0),NVL(T4.PAY_NUM,0)
        )T1

        FULL JOIN
        (
            SELECT user_id,merchant_id,regexp_replace(SUBSTR(a.partition_date,1,6),'-','') AS CALL_MONTH,
            MIN(partition_date) as FIRST_CALL_DATE,1 AS call_num
            FROM
            (
                SELECT sub_id,REGEXP_REPLACE(SUBSTR(call_time,0,10), '-', '') as partition_date
                FROM  tl.tl_gm_sl_ali_virtual_phone_call_detail --通话记录表，call_type呼叫类型
                WHERE partition_day=regexp_replace(date_sub(current_date(),1),'-','')
                AND REGEXP_REPLACE(SUBSTR(call_time,0,10), '-', '')>=REGEXP_REPLACE(trunc(date_sub(current_date(),1),'MM'),'-','')
                AND REGEXP_REPLACE(SUBSTR(call_time,0,10), '-', '')<=regexp_replace(date_sub(current_date,1),'-','')
                AND start_time<release_time --通话时长大于30秒
            )a
            LEFT JOIN
            (
                SELECT id,sub_id
                FROM tl.tl_gm_sl_ali_virtual_phone_binding --阿里记录表
                WHERE partition_day=regexp_replace(date_sub(current_date(),1),'-','')
            )b
                ON a.sub_id = b.sub_id
            LEFT JOIN
            (
                SELECT id,platform_binding_id
                FROM tl.tl_gm_sl_virtual_phone_binding
                WHERE partition_day=regexp_replace(date_sub(current_date(),1),'-','')
            )c
                ON b.id = c.platform_binding_id
            LEFT JOIN
            (
                SELECT phone_binding_id,lead_task_id
                FROM tl.tl_gm_sl_lead_task_phone_binding
                WHERE partition_day=regexp_replace(date_sub(current_date(),1),'-','')
            )d
                ON c.id = d.phone_binding_id
            JOIN
            (
                SELECT id,user_id,merchant_id
                FROM tl.tl_gm_sl_lead_task  --线索任务表（用户点击授权后记入该表）
                WHERE partition_day=regexp_replace(date_sub(current_date(),1),'-','')
                AND source='2' --用户行为电话授权
            )e
                ON d.lead_task_id = e.id
            GROUP BY user_id,merchant_id,regexp_replace(SUBSTR(a.partition_date,1,6),'-','')
        )T2
        ON T1.USER_ID = T2.USER_ID AND T1.merchant_id = T2.merchant_id AND T1.DATE_MONTH = T2.CALL_MONTH
        )t1
        JOIN
        (
            SELECT t.user_id,partition_date,if(size(t.device_list) > 0, device_list [ 0 ], '') device_id
            FROM online.ml_user_updates t
            WHERE t.partition_date >= REGEXP_REPLACE(trunc(date_sub(current_date(),1),'MM'),'-','')
            and t.partition_date <= regexp_replace(date_sub(current_date(),1),'-','')
        )t2
            on t1.user_id=t2.user_id and t1.DATE_DAY=t2.partition_date
        GROUP BY t2.device_id,date_day
    )b
    ON b.date_day=mas.partition_date and b.device_id=mas.device_id
    LEFT JOIN
    (
        SELECT a.partition_date,a.cl_id,
                case when push_type in ('70','71') then '运营push'
                     when push_type not in ('70','71') and push_type is not null then '自动化push' end as push_type
        FROM
        (
            SELECT a.partition_date,b.cl_id,b.message_id
            FROM
            (
              --设备开启
              SELECT partition_date,cl_id,unix_timestamp(substr(time_str,1,19)) as time_stamp,app_session_id
              FROM online.bl_hdfs_maidian_updates
              WHERE partition_date >= REGEXP_REPLACE(trunc(date_sub(current_date(),1),'MM'),'-','')
              and partition_date <= regexp_replace(date_sub(current_date(),1),'-','')
              and action='device_opened'
              group by partition_date,cl_id,unix_timestamp(substr(time_str,1,19)),app_session_id
            )a
            JOIN
            (
              --推送点击
              SELECT partition_date,cl_id,unix_timestamp(substr(time_str,1,19)) as time_stamp,params['message_id'] as message_id
              FROM online.bl_hdfs_maidian_updates
              WHERE partition_date >= REGEXP_REPLACE(trunc(date_sub(current_date(),1),'MM'),'-','')
              and partition_date <= regexp_replace(date_sub(current_date(),1),'-','')
              and action='notification_open'
              group by partition_date,cl_id,unix_timestamp(substr(time_str,1,19)),params['message_id']
            )b
            on a.partition_date = b.partition_date
            AND a.cl_id = b.cl_id
            where abs(a.time_stamp-b.time_stamp)<=2
        )a
        LEFT join
        (
            select msg_id,push_type,time_stamp
            from online.tl_hdfs_push2_new_view --增量表
            where partition_date>=REGEXP_REPLACE(trunc(date_sub(current_date(),1),'MM'),'-','')
            AND partition_date<=regexp_replace(DATE_SUB(current_date,1) ,'-','')
            group by msg_id,push_type,time_stamp
        )b
        on a.message_id=b.msg_id
        group by a.partition_date,a.cl_id,
                case when push_type in ('70','71') then '运营push'
                     when push_type not in ('70','71') and push_type is not null then '自动化push' end
    )c
    on c.cl_id=mas.device_id and c.partition_date=mas.partition_date
    LEFT JOIN
    (
        SELECT t1.partition_date,t1.cl_id
                ,case when array_contains(t1.type,"点击push")=TRUE and size(t1.type)=1 then '仅点击push'
                      when array_contains(t1.type,"打开设备")=TRUE and size(t1.type)=1 then '仅打开设备'
                      when t2.type='首次push拉起' then '先通过push来后主动打开'
                      when t2.type ='首次非push拉起' then '先主动打开后通过push来' else null end as type
        FROM
        (
            SELECT partition_date,cl_id,collect_set(type) as type
            FROM
            (
                SELECT a.partition_date,a.cl_id
                        ,case when abs(a.time_stamp-b.time_stamp)<=2 then '点击push'
                              else '打开设备' end as type
                FROM
                (
                  --设备开启
                  SELECT partition_date,cl_id,unix_timestamp(substr(time_str,1,19)) as time_stamp
                  FROM online.bl_hdfs_maidian_updates
                  WHERE partition_date >= REGEXP_REPLACE(trunc(date_sub(current_date(),1),'MM'),'-','')
                  and partition_date <= regexp_replace(date_sub(current_date(),1),'-','')
                  and action='device_opened'
                  and REGEXP_REPLACE(SUBSTR(time_str, 1, 10), '-', '')=partition_date
                  group by partition_date,cl_id,unix_timestamp(substr(time_str,1,19))
                )a
                left JOIN
                (
                  --推送点击
                  SELECT partition_date,cl_id,unix_timestamp(substr(time_str,1,19)) as time_stamp,params['message_id'] as message_id
                  FROM online.bl_hdfs_maidian_updates
                  WHERE partition_date >= REGEXP_REPLACE(trunc(date_sub(current_date(),1),'MM'),'-','')
                  and partition_date <= regexp_replace(date_sub(current_date(),1),'-','')
                  and action='notification_open'
                  and REGEXP_REPLACE(SUBSTR(time_str, 1, 10), '-', '')=partition_date
                  group by partition_date,cl_id,unix_timestamp(substr(time_str,1,19)),params['message_id']
                )b
                on a.partition_date = b.partition_date
                AND a.cl_id = b.cl_id
                group by a.partition_date,a.cl_id,case when abs(a.time_stamp-b.time_stamp)<=2 then '点击push'else '打开设备' end
            )a
            group by partition_date,cl_id
        )t1
        left join
        (
            SELECT a.partition_date,a.cl_id,
                    case when abs(a.time_stamp-b.time_stamp)<=2 then '首次push拉起' else '首次非push拉起' end as type
            FROM
            (
                  --设备开启
              SELECT partition_date,cl_id,min(unix_timestamp(substr(time_str,1,19))) as time_stamp
              FROM online.bl_hdfs_maidian_updates
              WHERE partition_date >= REGEXP_REPLACE(trunc(date_sub(current_date(),1),'MM'),'-','')
              and partition_date <= regexp_replace(date_sub(current_date(),1),'-','')
              and action='device_opened'
              and REGEXP_REPLACE(SUBSTR(time_str, 1, 10), '-', '')=partition_date
              group by partition_date,cl_id
            )a
            left JOIN
            (
              --推送点击
              SELECT partition_date,cl_id,min(unix_timestamp(substr(time_str,1,19))) as time_stamp
              FROM online.bl_hdfs_maidian_updates
              WHERE partition_date >= REGEXP_REPLACE(trunc(date_sub(current_date(),1),'MM'),'-','')
              and partition_date <= regexp_replace(date_sub(current_date(),1),'-','')
              and action='notification_open'
              and REGEXP_REPLACE(SUBSTR(time_str, 1, 10), '-', '')=partition_date
              group by partition_date,cl_id
            )b
            on a.partition_date=b.partition_date and a.cl_id=b.cl_id
        )t2
        on t1.partition_date=t2.partition_date and t1.cl_id=t2.cl_id
    )d
    on c.cl_id=d.cl_id and c.partition_date=d.partition_date
    group by mas.partition_date
            ,device_os_type
)t;




