select *
from
(
    SELECT partition_day as `日期`
            ,count(post_id) as `帖子数量`
            ,nvl(concat(round(sum(click_pv_1)/sum(exp_pv_1)*100,2),'%'),0) as `前1日ctr`
            ,nvl(sum(exp_pv_1),0) as `前1日曝光`
            ,nvl(round(avg(avg_page_stay_1),2),0) as `前1日平均阅读时长(s)`
            ,nvl(concat(round(sum(click_pv_3)/sum(exp_pv_3)*100,2),'%'),0) as `前3日ctr`
            ,nvl(sum(exp_pv_3),0) as `前3日曝光`
            ,nvl(round(avg(avg_page_stay_3),2),0) as `前3日平均阅读时长(s)`
            ,nvl(concat(round(sum(click_pv_10)/sum(exp_pv_10)*100,2),'%'),0) as `前10日ctr`
            ,nvl(sum(exp_pv_10),0) as `前10日曝光`
            ,nvl(round(avg(avg_page_stay_10),2),0) as `前10日平均阅读时长(s)`
    FROM pm.tl_pm_userpost_d
    where partition_day>='20200911' and partition_day<='20200922'
    group by partition_day

    union all

    SELECT partition_day as `日期`
            ,count(post_id) as `帖子数量`
            ,nvl(concat(round(sum(click_pv_1)/sum(exp_pv_1)*100,2),'%'),0) as `前1日ctr`
            ,nvl(sum(exp_pv_1),0) as `前1日曝光`
            ,nvl(round(avg(avg_page_stay_1),2),0) as `前1日平均阅读时长(s)`
            ,nvl(concat(round(sum(click_pv_3)/sum(exp_pv_3)*100,2),'%'),0) as `前3日ctr`
            ,nvl(sum(exp_pv_3),0) as `前3日曝光`
            ,nvl(round(avg(avg_page_stay_3),2),0) as `前3日平均阅读时长(s)`
            ,nvl(concat(round(sum(click_pv_10)/sum(exp_pv_10)*100,2),'%'),0) as `前10日ctr`
            ,nvl(sum(exp_pv_10),0) as `前10日曝光`
            ,nvl(round(avg(avg_page_stay_10),2),0) as `前10日平均阅读时长(s)`
    FROM pm.tl_pm_userpost_d_v2
    where partition_day>='20200923'
    group by partition_day
)a
order by `日期`