
SELECT post_id as `帖子id`
		,title as `帖子标题`
		,audit_date as `审核日期`
		,tag_list as `所有关联标签`
		,nvl(concat(round(click_pv_1/exp_pv_1*100,2),'%'),0) as `前1日ctr`
		,nvl(concat(round(page_pv_20s_1/page_pv_1*100,2),'%'),0) as `前1日浏览20s以上pv/前1日总浏览pv`
		,nvl(exp_pv_1,0) as `前1日曝光`
		,nvl(avg_page_stay_1,0) as `前1日平均阅读时长(s)`
		,nvl(concat(round(click_pv_3/exp_pv_3*100,2),'%'),0) as `前3日ctr`
		,nvl(concat(round(page_pv_20s_3/page_pv_3*100,2),'%'),0) as `前3日浏览20s以上pv/前3日总浏览pv`
		,nvl(exp_pv_3,0) as `前3日曝光`
		,nvl(avg_page_stay_3,0) as `前3日平均阅读时长(s)`
		,nvl(concat(round(click_pv_10/exp_pv_10*100,2),'%'),0) as `前10日ctr`
		,nvl(concat(round(page_pv_20s_10/page_pv_10*100,2),'%'),0) as `前10日浏览20s以上pv/前10日总浏览pv`
		,nvl(exp_pv_10,0) as `前10日曝光`
		,nvl(avg_page_stay_10,0) as `前10日平均阅读时长(s)`
FROM pm.tl_pm_userpost_d_v2
where partition_day=regexp_replace(DATE_SUB(current_date,1) ,'-','')
order by `前10日曝光` desc



