SET mapreduce.job.queuename=data;
SET mapreduce.map.memory.mb=8192;
SET mapreduce.map.java.opts=-Xmx8000m;
SET mapreduce.reduce.memory.mb=8192;
SET mapreduce.reduce.java.opts=-Xmx8000m;
set hive.auto.convert.join=true;
SET mapred.reduce.tasks=20;
SET role admin;

--push点击数据
INSERT OVERWRITE TABLE pm.tl_pm_push_detail_d PARTITION (PARTITION_DAY = ${partition_day})

SELECT NVL(click.partition_date,received.partition_date) as day_id
        ,NVL(click.device_os_type,received.device_os_type) as device_os_type
        ,NVL(click.active_type,received.active_type) as active_type
        ,dau
        ,is_open_uv
        ,push_receive_uv
        ,push_receive_pv
        ,push_open_uv
        ,push_open_pv
        ,push_open_2_uv
        ,push_open_2_pv
        ,op_receive_uv
        ,op_receive_pv
        ,op_push_open_uv
        ,op_push_open_pv
        ,op_push_open_2_uv
        ,op_push_open_2_pv
        ,xitong_receive_uv
        ,xitong_receive_pv
        ,xitong_push_open_uv
        ,xitong_push_open_pv
        ,xitong_push_open_2_uv
        ,xitong_push_open_2_pv
        ,will_receive_uv
        ,will_receive_pv
        ,will_push_open_uv
        ,will_push_open_pv
        ,will_push_open_2_uv
        ,will_push_open_2_pv
        ,sign_receive_uv
        ,sign_receive_pv
        ,sign_push_open_uv
        ,sign_push_open_pv
        ,sign_push_open_2_uv
        ,sign_push_open_2_pv
        ,personal_receive_uv
        ,personal_receive_pv
        ,personal_push_open_uv
        ,personal_push_open_pv
        ,personal_push_open_2_uv
        ,personal_push_open_2_pv
        ,ctr_receive_uv
        ,ctr_receive_pv
        ,ctr_push_open_uv
        ,ctr_push_open_pv
        ,ctr_push_open_2_uv
        ,ctr_push_open_2_pv
        ,non_ctr_receive_uv
        ,non_ctr_receive_pv
        ,non_ctr_push_open_uv
        ,non_ctr_push_open_pv
        ,non_ctr_push_open_2_uv
        ,non_ctr_push_open_2_pv
        ,AI_receive_uv
        ,AI_receive_pv
        ,AI_push_open_pv
        ,AI_push_open_uv
        ,AI_push_open_2_uv
        ,AI_push_open_2_pv
        ,auto_receive_uv
        ,auto_receive_pv
        ,auto_push_open_uv
        ,auto_push_open_pv
        ,auto_push_open_2_uv
        ,auto_push_open_2_pv
        ,location_receive_uv
        ,location_receive_pv
        ,location_push_open_uv
        ,location_push_open_pv
        ,location_push_open_2_uv
        ,location_push_open_2_pv
        ,qa_receive_uv
        ,qa_receive_pv
        ,qa_push_open_uv
        ,qa_push_open_pv
        ,qa_push_open_2_uv
        ,qa_push_open_2_pv
FROM
(
    SELECT  t1.partition_date
           ,device_os_type
           ,active_type
           ,count(distinct t1.device_id) as dau
           ,count(distinct is_open.cl_id) as is_open_uv                                                                                   --push开启设备数
           ,count(distinct t2.cl_id) as push_open_uv                                                                                      --push拉起设备数
           ,sum(NVL(t2.push_open_pv,0)) as push_open_pv                                                                                   --push拉起人次
           ,count(distinct t5.cl_id) as push_open_2_uv                                                                                    --push拉起有2跳设备数
           ,sum(case WHEN t5.cl_id is not null then push_open_2_pv END) as push_open_2_pv                                                 --push拉起有2跳人次
           ,count(distinct case when op_push_open_pv is not null and op_push_open_pv>0 then t2.cl_id end) as op_push_open_uv              --运营push拉起设备数
           ,sum(NVL(t2.op_push_open_pv,0)) as op_push_open_pv                                                                             --运营push拉起人次
           ,count(distinct case when op_push_open_2_pv is not null and op_push_open_2_pv>0 then t5.cl_id end) as op_push_open_2_uv        --运营push拉起有2跳设备数
           ,sum(NVL(t5.op_push_open_2_pv,0)) as op_push_open_2_pv                                                                         --运营push拉起有2跳人次
           ,count(distinct case when xitong_push_open_pv is not null and xitong_push_open_pv>0 then t2.cl_id end) as xitong_push_open_uv        --自动push拉起设备数
           ,sum(NVL(t2.xitong_push_open_pv,0)) as xitong_push_open_pv                                                                         --自动push拉起人次
           ,count(distinct case when xitong_push_open_2_pv is not null and xitong_push_open_2_pv>0 then t5.cl_id end) as xitong_push_open_2_uv  --自动push拉起有2跳设备数
           ,sum(NVL(t5.xitong_push_open_2_pv,0)) as xitong_push_open_2_pv                                                                     --自动push拉起有2跳人次
           ,count(distinct case when will_push_open_pv is not null and will_push_open_pv>0 then t2.cl_id end) as will_push_open_uv        --意愿探索push拉起设备数
           ,sum(NVL(t2.will_push_open_pv,0)) as will_push_open_pv                                                                             --意愿探索push拉起人次
           ,count(distinct case when will_push_open_2_pv is not null and will_push_open_2_pv>0 then t5.cl_id end) as will_push_open_2_uv  --意愿探索push拉起有2跳设备数
           ,sum(NVL(t5.will_push_open_2_pv,0)) as will_push_open_2_pv
           ,count(distinct case when sign_push_open_pv is not null and sign_push_open_pv>0 then t2.cl_id end) as sign_push_open_uv        --签到push拉起设备数
           ,sum(NVL(t2.sign_push_open_pv,0)) as sign_push_open_pv                                                                             --签到push拉起人次
           ,count(distinct case when sign_push_open_2_pv is not null and sign_push_open_2_pv>0 then t5.cl_id end) as sign_push_open_2_uv  --签到push拉起有2跳设备数
           ,sum(NVL(t5.sign_push_open_2_pv,0)) as sign_push_open_2_pv
           ,count(distinct case when t2.ctr_push_open_pv+t2.non_ctr_push_open_pv>0 then t2.cl_id end) as personal_push_open_uv        --个性化push拉起设备数
           ,sum(NVL(t2.ctr_push_open_pv+t2.non_ctr_push_open_pv,0)) as personal_push_open_pv                                                                             --个性化push拉起人次
           ,count(distinct case when t5.ctr_push_open_2_pv+t5.non_ctr_push_open_2_pv>0 then t5.cl_id end) as personal_push_open_2_uv        --个性化push拉起设备数
           ,sum(NVL(t5.ctr_push_open_2_pv+t5.non_ctr_push_open_2_pv,0)) as personal_push_open_2_pv                                                                       --个性化push拉起有2跳人次
           ,count(distinct case when ctr_push_open_pv is not null and ctr_push_open_pv>0 then t2.cl_id end) as ctr_push_open_uv        --签到push拉起设备数
           ,sum(NVL(t2.ctr_push_open_pv,0)) as ctr_push_open_pv                                                                             --签到push拉起人次
           ,count(distinct case when ctr_push_open_2_pv is not null and ctr_push_open_2_pv>0 then t5.cl_id end) as ctr_push_open_2_uv  --签到push拉起有2跳设备数
           ,sum(NVL(t5.ctr_push_open_2_pv,0)) as ctr_push_open_2_pv
           ,count(distinct case when non_ctr_push_open_pv is not null and non_ctr_push_open_pv>0 then t2.cl_id end) as non_ctr_push_open_uv        --签到push拉起设备数
           ,sum(NVL(t2.non_ctr_push_open_pv,0)) as non_ctr_push_open_pv                                                                             --签到push拉起人次
           ,count(distinct case when non_ctr_push_open_2_pv is not null and non_ctr_push_open_2_pv>0 then t5.cl_id end) as non_ctr_push_open_2_uv  --签到push拉起有2跳设备数
           ,sum(NVL(t5.non_ctr_push_open_2_pv,0)) as non_ctr_push_open_2_pv
           ,count(distinct case when AI_push_open_pv is not null and AI_push_open_pv>0 then t2.cl_id end) as AI_push_open_uv        --签到push拉起设备数
           ,sum(NVL(t2.AI_push_open_pv,0)) as AI_push_open_pv                                                                             --签到push拉起人次
           ,count(distinct case when AI_push_open_2_pv is not null and AI_push_open_2_pv>0 then t5.cl_id end) as AI_push_open_2_uv  --签到push拉起有2跳设备数
           ,sum(NVL(t5.AI_push_open_2_pv,0)) as AI_push_open_2_pv
           ,count(distinct case when auto_push_open_pv is not null and auto_push_open_pv>0 then t2.cl_id end) as auto_push_open_uv        --签到push拉起设备数
           ,sum(NVL(t2.auto_push_open_pv,0)) as auto_push_open_pv                                                                             --签到push拉起人次
           ,count(distinct case when auto_push_open_2_pv is not null and auto_push_open_2_pv>0 then t5.cl_id end) as auto_push_open_2_uv  --签到push拉起有2跳设备数
           ,sum(NVL(t5.auto_push_open_2_pv,0)) as auto_push_open_2_pv
           ,count(distinct case when location_push_open_pv is not null and location_push_open_pv>0 then t2.cl_id end) as location_push_open_uv        --地狱push拉起设备数
           ,sum(NVL(t2.location_push_open_pv,0)) as location_push_open_pv                                                                             --地狱push拉起人次
           ,count(distinct case when location_push_open_2_pv is not null and location_push_open_2_pv>0 then t5.cl_id end) as location_push_open_2_uv  --地狱push拉起有2跳设备数
           ,sum(NVL(t5.location_push_open_2_pv,0)) as location_push_open_2_pv
           ,count(distinct case when qa_push_open_pv is not null and qa_push_open_pv>0 then t2.cl_id end) as qa_push_open_uv        --邀请回答push拉起设备数
           ,sum(NVL(t2.qa_push_open_pv,0)) as qa_push_open_pv                                                                             --邀请回答push拉起人次
           ,count(distinct case when qa_push_open_2_pv is not null and qa_push_open_2_pv>0 then t5.cl_id end) as qa_push_open_2_uv  --邀请回答push拉起有2跳设备数
           ,sum(NVL(t5.qa_push_open_2_pv,0)) as qa_push_open_2_pv
    FROM
    (
        select
            partition_date
            ,device_id
            ,device_os_type
            ,case WHEN active_type = '4'  THEN '老活' WHEN active_type  in ('1','2')  then '新增' END as active_type
        from online.ml_device_day_active_status
        where partition_date = regexp_replace(DATE_SUB(current_date,1) ,'-','')
        AND active_type in ('4','1','2')
        AND first_channel_source_type not IN ('yqxiu1','yqxiu2','yqxiu3','yqxiu4','yqxiu5','mxyc1','mxyc2','mxyc3'
                ,'wanpu','jinshan','jx','maimai','zhuoyi','huatian','suopingjingling','mocha','mizhe','meika','lamabang'
                ,'js-az1','js-az2','js-az3','js-az4','js-az5','jfq-az1','jfq-az2','jfq-az3','jfq-az4','jfq-az5','toufang1'
                ,'toufang2','toufang3','toufang4','toufang5','toufang6','TF-toufang1','TF-toufang2','TF-toufang3','TF-toufang4'
                ,'TF-toufang5','tf-toufang1','tf-toufang2','tf-toufang3','tf-toufang4','tf-toufang5','benzhan','promotion_aso100'
                ,'promotion_qianka','promotion_xiaoyu','promotion_dianru','promotion_malioaso','promotion_malioaso-shequ'
                ,'promotion_shike','promotion_julang_jl03','promotion_zuimei','','unknown')
        AND first_channel_source_type not LIKE 'promotion\_jf\_%'
    )t1
    LEFT JOIN
    (
        select a.partition_date,a.cl_id   --开启push设备
        from
        (
           SELECT partition_date,cl_id,max(time_str) as max_time_str
           FROM online.bl_hdfs_maidian_updates
           where partition_date = regexp_replace(DATE_SUB(current_date,1) ,'-','')
           and action='is_open_push'
           group by partition_date,cl_id
        )a
        left join
        (
           SELECT partition_date,
                  cl_id,time_str,COALESCE(params['type'],params['tyep']) as type
           FROM online.bl_hdfs_maidian_updates
           where partition_date = regexp_replace(DATE_SUB(current_date,1) ,'-','')
           and action='is_open_push'
        )b
        on b.partition_date=a.partition_date and b.cl_id=a.cl_id and b.time_str=a.max_time_str
        where type=1
        group by a.partition_date,a.cl_id
    )is_open
    on is_open.partition_date=t1.partition_date and is_open.cl_id=t1.device_id
    LEFT JOIN
    (
        SELECT a.partition_date,a.cl_id,
               count(distinct a.message_id) as push_open_pv,
               count(distinct case when push_type in ('70','71') then a.message_id end) as op_push_open_pv,                                  --运营push  push_type in ('70','71')
               count(distinct case when push_type in ('101','102','103') then a.message_id end) as ctr_push_open_pv,        --个性化push
               count(distinct case when push_type in ('111','112','113') then a.message_id end) as non_ctr_push_open_pv,        --个性化push
               count(distinct case when push_type in ('104') then a.message_id end) as qa_push_open_pv,        --邀请回答push
               count(distinct case when push_type in ('105') then a.message_id end) as location_push_open_pv,        --地狱push
               count(distinct case when push_type in ('106','107','108') then a.message_id end) as will_push_open_pv,          --意愿push
               count(distinct case when push_type in ('25') then a.message_id end) as sign_push_open_pv,          --签到push
               count(distinct case when push_type is not null
                              and push_type not in  ('70','71','101','102','103','104','105','111','112','113','106','107','108','25','93','94') then a.message_id end) as xitong_push_open_pv,   --系统push
               count(distinct case when push_type in ('93','94') then a.message_id end) as AI_push_open_pv,
               count(distinct case when push_type is not null and push_type not in ('70','71') then a.message_id end) as auto_push_open_pv   --自动push
        FROM
        (
          SELECT a.partition_date,b.cl_id,a.app_session_id,b.message_id
          FROM
          (
              --设备开启
              SELECT partition_date,cl_id,unix_timestamp(substr(time_str,1,19)) as time_stamp,app_session_id
              FROM online.bl_hdfs_maidian_updates
              where partition_date = regexp_replace(DATE_SUB(current_date,1) ,'-','')
              and action='device_opened'
              group by partition_date,cl_id,unix_timestamp(substr(time_str,1,19)),app_session_id
          )a
          JOIN
          (
              --推送点击
              SELECT partition_date,cl_id,unix_timestamp(substr(time_str,1,19)) as time_stamp,params['message_id'] as message_id
              FROM online.bl_hdfs_maidian_updates
              where partition_date = regexp_replace(DATE_SUB(current_date,1) ,'-','')
              and action='notification_open'
              group by partition_date,cl_id,unix_timestamp(substr(time_str,1,19)),params['message_id']
          )b
          on a.partition_date = b.partition_date
          AND a.cl_id = b.cl_id
          where abs(a.time_stamp-b.time_stamp)<=2
        )a
        LEFT JOIN
        (
            SELECT a.msg_id,case when b.msg_id is not null then 'ex' else push_type end as push_type
            FROM
            (
                select msg_id,push_type,time_stamp
                from online.tl_hdfs_push2_new_view --增量表
                where partition_date>='20190801' AND partition_date<=regexp_replace(DATE_SUB(current_date,1) ,'-','')
                group by msg_id,push_type,time_stamp
            )a
            left join
            (
                SELECT if(substr(jiguang_id,1,1)=',',substr(jiguang_id,2),jiguang_id) as msg_id
                FROM online.tl_hdfs_api_pushtask2_view       --mars后台消息推送表
                WHERE partition_date=regexp_replace(DATE_SUB(current_date,1) ,'-','')
                AND regexp_replace(substr(pushtime,1,10),'-','') >= '20200629'
                AND regexp_replace(substr(pushtime,1,10),'-','') <= '20200714'
                AND approver_status = 'true'  --审核状态，true表示审核通过
                AND status = '2'   --推送状态，2表示发送成功，1表示准备发送
                AND creator_id in ('32018153','32719681','32264790','31779749','31436904')
            )b
            on a.msg_id=b.msg_id
        )e
        on e.msg_id=a.message_id
        group by a.partition_date,a.cl_id
    )t2
    on t2.cl_id=t1.device_id and t2.partition_date=t1.partition_date

    LEFT JOIN
    (
        --push拉起后有2跳的设备
        SELECT partition_date,
               a.cl_id,
               count(distinct a.app_session_id) as push_open_2_pv,
               count(distinct case when push_type in ('70','71') then a.app_session_id end) as op_push_open_2_pv,                                  --运营push  push_type in ('70','71')
               count(distinct case when push_type in ('101','102','103') then a.app_session_id end) as ctr_push_open_2_pv,          --个性化push
               count(distinct case when push_type in ('111','112','113') then a.app_session_id end) as non_ctr_push_open_2_pv,          --个性化push
               count(distinct case when push_type in ('104') then a.app_session_id end) as qa_push_open_2_pv,          --个性化push
               count(distinct case when push_type in ('105') then a.app_session_id end) as location_push_open_2_pv,          --个性化push
               count(distinct case when push_type in ('106','107','108') then a.app_session_id end) as will_push_open_2_pv,          --意愿push
               count(distinct case when push_type in ('25') then a.app_session_id end) as sign_push_open_2_pv,          --签到push
               count(distinct case when push_type is not null
                              and push_type not in  ('70','71','101','102','103','104','105','111','112','113','106','107','108','25','93','94') then a.app_session_id end) as xitong_push_open_2_pv,   --系统push
               count(distinct case when push_type in ('93','94') then a.app_session_id end) as AI_push_open_2_pv,          --签到push
               count(distinct case when push_type is not null and push_type not in  ('70','71') then a.app_session_id end) as auto_push_open_2_pv   --自动push
        FROM
        (
          SELECT a.partition_date,b.cl_id,a.app_session_id,b.message_id
          FROM
          (
              --设备开启
              SELECT partition_date,cl_id,unix_timestamp(substr(time_str,1,19)) as time_stamp,app_session_id
              FROM online.bl_hdfs_maidian_updates
              where partition_date = regexp_replace(DATE_SUB(current_date,1) ,'-','')
              and action='device_opened'
              group by partition_date,cl_id,unix_timestamp(substr(time_str,1,19)),app_session_id
          )a
          JOIN
          (
              --推送点击
              SELECT partition_date,cl_id,unix_timestamp(substr(time_str,1,19)) as time_stamp,params['message_id'] as message_id
              FROM online.bl_hdfs_maidian_updates
              where partition_date = regexp_replace(DATE_SUB(current_date,1) ,'-','')
              and action='notification_open'
              group by partition_date,cl_id,unix_timestamp(substr(time_str,1,19)),params['message_id']
          )b
          on a.partition_date = b.partition_date
          AND a.cl_id = b.cl_id
          where abs(a.time_stamp-b.time_stamp)<=2
        )a
        LEFT JOIN
        (
            SELECT a.msg_id,case when b.msg_id is not null then 'ex' else push_type end as push_type
            FROM
            (
                select msg_id,push_type,time_stamp
                from online.tl_hdfs_push2_new_view --增量表
                where partition_date>='20190801' AND partition_date<= regexp_replace(DATE_SUB(current_date,1) ,'-','')
                group by msg_id,push_type,time_stamp
            )a
            left join
            (
                SELECT if(substr(jiguang_id,1,1)=',',substr(jiguang_id,2),jiguang_id) as msg_id
                FROM online.tl_hdfs_api_pushtask2_view       --mars后台消息推送表
                WHERE partition_date=regexp_replace(DATE_SUB(current_date,1) ,'-','')
                AND regexp_replace(substr(pushtime,1,10),'-','') >= '20200629'
                AND regexp_replace(substr(pushtime,1,10),'-','') <= '20200714'
                AND approver_status = 'true'  --审核状态，true表示审核通过
                AND status = '2'   --推送状态，2表示发送成功，1表示准备发送
                AND creator_id in ('32018153','32719681','32264790','31779749','31436904')
            )b
            on a.msg_id=b.msg_id
        )e
        on e.msg_id=a.message_id
        JOIN
        (
            --通过push拉起的一次会话中，有2跳，包括回退
            SELECT a.partition_date,a.cl_id,a.app_session_id,a.cl_type
            from
            (
                SELECT partition_date,cl_id,app_session_id,cl_type,if(page_name='home','home','non_home') as is_home
                FROM online.bl_hdfs_maidian_updates
                where partition_date = regexp_replace(DATE_SUB(current_date,1) ,'-','')
                and action='page_view'
                GROUP BY partition_date,cl_id,app_session_id,cl_type,if(page_name='home','home','non_home')
            )a
            join
            (
                SELECT partition_date,cl_id,app_session_id,cl_type
                    ,count(distinct page_name) as page_num
                    ,count(distinct array(time_str,page_name)) as page_array
                FROM online.bl_hdfs_maidian_updates
                where partition_date = regexp_replace(DATE_SUB(current_date,1) ,'-','')
                and action='page_view'
                GROUP BY partition_date,cl_id,app_session_id,cl_type
            )b
            on b.partition_date=a.partition_date and b.cl_id=a.cl_id and b.app_session_id=a.app_session_id
            left join
            (
                select device_id
                from ml.ml_d_ct_dv_devicespam_d  --去除机构刷单设备，即作弊设备（浏览和曝光事件去除）
                WHERE partition_day=regexp_replace(DATE_SUB(current_date,1) ,'-','')
            )spam
            on spam.device_id=a.cl_id
            where spam.device_id IS NULL and
            (a.cl_type='ios' and is_home='home' and page_num>=2 and page_array>=3 or
             a.cl_type='ios' and is_home='non_home' and page_array>=2 or
             a.cl_type='android' and page_array>=2)
            GROUP BY a.partition_date,a.cl_id,a.app_session_id,a.cl_type
        )c
        on a.partition_date = c.partition_date
        AND a.cl_id = c.cl_id
        AND a.app_session_id = c.app_session_id
        GROUP BY a.cl_id,a.partition_date
    )t5
    on t1.partition_date=t5.partition_date and t1.device_id=t5.cl_id
    GROUP BY t1.partition_date,device_os_type,active_type
)click
full join
(
    SELECT a.partition_date
            ,device_os_type
            ,'老活' as active_type
            ,count(distinct a.device_id) as push_receive_uv
            ,count(distinct case when push_type in ('70','71') then a.device_id end) as op_receive_uv                                 --运营push  push_type in ('70','71')
            ,count(distinct case when push_type in ('101','102','103','111','112','113') then a.device_id end) as personal_receive_uv        --个性化push
            ,count(distinct case when push_type in ('101','102','103') then a.device_id end) as ctr_receive_uv        --个性化push
            ,count(distinct case when push_type in ('111','112','113') then a.device_id end) as non_ctr_receive_uv        --个性化push
            ,count(distinct case when push_type in ('104') then a.device_id end) as qa_receive_uv        --邀请回答push
            ,count(distinct case when push_type in ('105') then a.device_id end) as location_receive_uv        --地狱push
            ,count(distinct case when push_type in ('106','107','108') then a.device_id end) as will_receive_uv          --意愿push
            ,count(distinct case when push_type in ('25') then a.device_id end) as sign_receive_uv          --签到push
            ,count(distinct case when push_type is not null
                          and push_type not in  ('70','71','101','102','103','104','105','111','112','113','106','107','108','25','93','94') then a.device_id end) as xitong_receive_uv   --系统push
            ,count(distinct case when push_type in ('93','94') then a.device_id end) as AI_receive_uv
            ,count(distinct case when push_type is not null and push_type not in ('70','71') then a.device_id end) as auto_receive_uv   --自动push
            ,count(a.device_id) as push_receive_pv
            ,count(case when push_type in ('70','71') then a.device_id end) as op_receive_pv                                 --运营push  push_type in ('70','71')
            ,count(case when push_type in ('101','102','103','111','112','113') then a.device_id end) as personal_receive_pv       --个性化push
            ,count(case when push_type in ('101','102','103') then a.device_id end) as ctr_receive_pv        --个性化push
            ,count(case when push_type in ('111','112','113') then a.device_id end) as non_ctr_receive_pv        --个性化push
            ,count(case when push_type in ('104') then a.device_id end) as qa_receive_pv        --邀请回答push
            ,count(case when push_type in ('105') then a.device_id end) as location_receive_pv        --地狱push
            ,count(case when push_type in ('106','107','108') then a.device_id end) as will_receive_pv          --意愿push
            ,count(case when push_type in ('25') then a.device_id end) as sign_receive_pv          --签到push
            ,count(case when push_type is not null
                          and push_type not in  ('70','71','101','102','103','104','105','111','112','113','106','107','108','25','93','94') then a.device_id end) as xitong_receive_pv   --系统push
            ,count(case when push_type in ('93','94') then a.device_id end) as AI_receive_pv
            ,count(case when push_type is not null and push_type not in ('70','71') then a.device_id end) as auto_receive_pv   --自动push

    FROM
    (
        select partition_day as partition_date
                ,device_id,msg_id,'ios' as device_os_type
        from bl.bl_et_bg_trackingpushlog_inc_d
        where partition_day= regexp_replace(DATE_SUB(current_date,1) ,'-','')
        group by partition_day,device_id,msg_id

        union all

        SELECT partition_date,device_id,mesid as msg_id,'android' as device_os_type
        FROM
        (
          SELECT partition_date,registration_id,platform,mesid
          FROM online.tl_hdfs_auroracallback_view--推送push的回调表
          where partition_date= regexp_replace(DATE_SUB(current_date,1) ,'-','')
          --and notification_state='true'--用户开启通知
          and callback_type = '0'--送达回执
          and platform='android'
          group by partition_date,registration_id,platform,mesid
        )msg
        JOIN
        (
          SELECT device_id,registration_id
          from online.tl_hdfs_api_jpushuserdevicebinding_view--极光id和设备id绑定关系全量表
          where partition_date=regexp_replace(date_sub(current_date(),1),'-','')
          and  (registration_id is not null  or registration_id <>'')
          group by device_id,registration_id
        )reg
        on reg.registration_id=msg.registration_id
    )a
    JOIN
    (
        select device_id
        from online.ml_device_history_detail
        where partition_date=regexp_replace(DATE_SUB(current_date,1) ,'-','')
        and first_channel_source_type not in ('yqxiu1','yqxiu2','yqxiu3','yqxiu4','yqxiu5','mxyc1','mxyc2','mxyc3'
               ,'wanpu','jinshan','jx','maimai','zhuoyi','huatian','suopingjingling','mocha','mizhe','meika','lamabang'
               ,'js-az1','js-az2','js-az3','js-az4','js-az5','jfq-az1','jfq-az2','jfq-az3','jfq-az4','jfq-az5','toufang1'
               ,'toufang2','toufang3','toufang4','toufang5','toufang6','TF-toufang1','TF-toufang2','TF-toufang3','TF-toufang4'
               ,'TF-toufang5','tf-toufang1','tf-toufang2','tf-toufang3','tf-toufang4','tf-toufang5','benzhan','promotion_aso100'
               ,'promotion_qianka','promotion_xiaoyu','promotion_dianru','promotion_malioaso','promotion_malioaso-shequ'
               ,'promotion_shike','promotion_julang_jl03','promotion_zuimei')
        AND first_channel_source_type not like 'promotion\_jf\_%'
    )b
    on a.device_id=b.device_id
    JOIN
    (
        select msg_id,push_type,time_stamp
        from online.tl_hdfs_push2_new_view --增量表
        where partition_date>='20190801' AND partition_date<= regexp_replace(DATE_SUB(current_date,1) ,'-','')
        group by msg_id,push_type,time_stamp
    )c
    on a.msg_id=c.msg_id
    left join
    (
        select
            partition_date
            ,device_id
        from online.ml_device_day_active_status
        where partition_date = regexp_replace(DATE_SUB(current_date,1) ,'-','')
        AND active_type in ('1','2','3')
    )d
    on a.partition_date=d.partition_date and a.device_id=d.device_id
    where d.device_id is null
    group by a.partition_date
            ,device_os_type
)received
on click.partition_date = received.partition_date
and click.device_os_type=received.device_os_type
and click.active_type=received.active_type
order by day_id,device_os_type,active_type;


--push接收数据


INSERT OVERWRITE TABLE pm.tl_pm_push_receive_d PARTITION (PARTITION_DAY = ${partition_day})

SELECT t1.partition_day as day_id
        ,t1.device_os_type as device_os_type
        ,'老活' as active_type
        ,t1.push_type as push_type
        ,count(distinct t1.device_id) as received_dev_num
        ,count(t1.msg_id) as received_msg_num
        ,count(distinct t2.cl_id) as click_dev_num
        ,count(t2.msg_id) as click_msg_num
FROM
(--接收设备数
    SELECT partition_day
            ,device_os_type
            ,push_type
            ,a.device_id
            ,a.msg_id
    FROM
    (
        select partition_day
                ,device_id,msg_id
        from bl.bl_et_bg_trackingpushlog_inc_d
        where partition_day=regexp_replace(DATE_SUB(current_date,1) ,'-','')
        group by partition_day,device_id,msg_id
    )a
    JOIN
    (
        select device_id,device_os_type
        from online.ml_device_history_detail
        where partition_date=regexp_replace(DATE_SUB(current_date,1) ,'-','')
        and first_channel_source_type not in ('yqxiu1','yqxiu2','yqxiu3','yqxiu4','yqxiu5','mxyc1','mxyc2','mxyc3'
               ,'wanpu','jinshan','jx','maimai','zhuoyi','huatian','suopingjingling','mocha','mizhe','meika','lamabang'
               ,'js-az1','js-az2','js-az3','js-az4','js-az5','jfq-az1','jfq-az2','jfq-az3','jfq-az4','jfq-az5','toufang1'
               ,'toufang2','toufang3','toufang4','toufang5','toufang6','TF-toufang1','TF-toufang2','TF-toufang3','TF-toufang4'
               ,'TF-toufang5','tf-toufang1','tf-toufang2','tf-toufang3','tf-toufang4','tf-toufang5','benzhan','promotion_aso100'
               ,'promotion_qianka','promotion_xiaoyu','promotion_dianru','promotion_malioaso','promotion_malioaso-shequ'
               ,'promotion_shike','promotion_julang_jl03','promotion_zuimei')
        AND first_channel_source_type not like 'promotion\_jf\_%'
    )b
    on a.device_id=b.device_id
    JOIN
    (
        select msg_id,push_type,time_stamp
        from online.tl_hdfs_push2_new_view --增量表
        where partition_date=regexp_replace(DATE_SUB(current_date,1) ,'-','')
        group by msg_id,push_type,time_stamp

        union all

        SELECT msg_id,regexp_replace(labels['event'], '\\s+', '') AS push_type,time_stamp
        FROM online.tl_hdfs_push2_task_view
        WHERE partition_date=regexp_replace(DATE_SUB(current_date,1) ,'-','')
        AND labels['event_type'] = 'push'
        group by  msg_id,regexp_replace(labels['event'], '\\s+', ''),time_stamp
    )c
    on a.msg_id=c.msg_id
    left join
    (
        select
            partition_date
            ,device_id
        from online.ml_device_day_active_status
        where partition_date=regexp_replace(DATE_SUB(current_date,1) ,'-','')
        AND active_type in ('1','2','3')
        and device_os_type='ios'
    )d
    on a.partition_day=d.partition_date and a.device_id=d.device_id
    where d.device_id is null
    group by partition_day
            ,device_os_type
            ,push_type
            ,a.device_id
            ,a.msg_id
)t1
left join
(--点击设备数
    select partition_date
            ,cl_id,params['message_id'] as msg_id,time_stamp
    from online.bl_hdfs_maidian_updates
    where partition_date=regexp_replace(DATE_SUB(current_date,1) ,'-','')
    and action='notification_open'
    group by partition_date,cl_id,params['message_id'],time_stamp
)t2
on t2.partition_date=t1.partition_day
and t2.msg_id=t1.msg_id
and t2.cl_id=t1.device_id
group by t1.partition_day
        ,t1.device_os_type
        ,t1.push_type;