--美购详情页的来源

SELECT T1.partition_date as `日期`
		,T1.device_type as `设备类型`
		,T1.active_type as `活跃类型`
		,T1.channel as `渠道`
		,T1.wel_uv as `美购详情页uv`
		,T1.search_result_welfare_uv as `搜索结果美购页uv`
		,T2.search_result_welfare_uv as `搜索结果美购页-转化uv`
		,T3.result_wel_add_uv as `搜索结果美购页-转化点击加车uv`
		,T3.result_wel_buy_uv as `搜索结果美购页-转化点击立即支付uv`
		,T3.result_wel_msg_uv as `搜索结果美购页-转化点击私信咨询uv`
		,concat(round(T2.search_result_welfare_uv/T1.search_result_welfare_uv*100,2),'%') as `搜索结果美购页-转化uv率`
		,concat(round(T2.search_result_welfare_uv/T1.wel_uv*100,2),'%') as `搜索结果美购页-转化美购uv占比`
		,concat(round(T3.result_wel_add_uv/T2.search_result_welfare_uv*100,2),'%') as `搜索结果美购页-点击加车率`
		,concat(round(T3.result_wel_buy_uv/T2.search_result_welfare_uv*100,2),'%') as `搜索结果美购页-点击立即支付率`
		,concat(round(T3.result_wel_msg_uv/T2.search_result_welfare_uv*100,2),'%') as `搜索结果美购页-点击私信咨询率`
		,T1.organization_detail_uv as `医院主页uv`
		,T2.organization_detail_uv as `医院主页-转化uv`
		,T3.org_add_uv as `医院主页-转化点击加车uv`
		,T3.org_buy_uv as `医院主页-转化点击立即支付uv`
		,T3.org_msg_uv as `医院主页-转化点击私信咨询uv`
		,concat(round(T2.organization_detail_uv/T1.organization_detail_uv*100,2),'%') as `医院主页-转化uv率`
		,concat(round(T2.organization_detail_uv/T1.wel_uv*100,2),'%') as `医院主页-转化美购uv占比`
		,concat(round(T3.org_add_uv/T2.organization_detail_uv*100,2),'%') as `医院主页-点击加车率`
		,concat(round(T3.org_buy_uv/T2.organization_detail_uv*100,2),'%') as `医院主页-点击立即支付率`
		,concat(round(T3.org_msg_uv/T2.organization_detail_uv*100,2),'%') as `医院主页-点击私信咨询率`
		,T1.category_uv as `品类聚合页uv`
		,T2.category_uv as `品类聚合页-转化uv`
		,T3.category_add_uv as `品类聚合页-转化点击加车uv`
		,T3.category_buy_uv as `品类聚合页-转化点击立即支付uv`
		,T3.category_msg_uv as `品类聚合页-转化点击私信咨询uv`
		,concat(round(T2.category_uv/T1.category_uv*100,2),'%') as `品类聚合页-转化uv率`
		,concat(round(T2.category_uv/T1.wel_uv*100,2),'%') as `品类聚合页-转化美购uv占比`
		,concat(round(T3.category_add_uv/T2.category_uv*100,2),'%') as `品类聚合页-点击加车率`
		,concat(round(T3.category_buy_uv/T2.category_uv*100,2),'%') as `品类聚合页-点击立即支付率`
		,concat(round(T3.category_msg_uv/T2.category_uv*100,2),'%') as `品类聚合页-点击私信咨询率`
		,T1.conversation_detail_uv as  `私信详情页uv`
		,T2.conversation_detail_uv as  `私信详情页-转化uv`
		,T3.conv_add_uv as `私信详情页-转化点击加车uv`
		,T3.conv_buy_uv as `私信详情页-转化点击立即支付uv`
		,T3.conv_msg_uv as `私信详情页-转化点击私信咨询uv`
		,concat(round(T2.conversation_detail_uv/T1.conversation_detail_uv*100,2),'%') as `私信详情页-转化uv率`
		,concat(round(T2.conversation_detail_uv/T1.wel_uv*100,2),'%') as `私信详情页-转化美购uv占比`
		,concat(round(T3.conv_add_uv/T2.conversation_detail_uv*100,2),'%') as `私信详情页-点击加车率`
		,concat(round(T3.conv_buy_uv/T2.conversation_detail_uv*100,2),'%') as `私信详情页-点击立即支付率`
		,concat(round(T3.conv_msg_uv/T2.conversation_detail_uv*100,2),'%') as `私信详情页-点击私信咨询率`
		,T1.welfare_list_uv as `美购列表页uv`
		,T2.welfare_list_uv as `美购列表页-转化uv`
		,T3.wel_list_add_uv as `美购列表页-转化点击加车uv`
		,T3.wel_list_buy_uv as `美购列表页-转化点击立即支付uv`
		,T3.wel_list_msg_uv as `美购列表页-转化点击私信咨询uv`
		,concat(round(T2.welfare_list_uv/T1.welfare_list_uv*100,2),'%') as `美购列表页-转化uv率`
		,concat(round(T2.welfare_list_uv/T1.wel_uv*100,2),'%') as `美购列表页-转化美购uv占比`
		,concat(round(T3.wel_list_add_uv/T2.welfare_list_uv*100,2),'%') as `美购列表页-点击加车率`
		,concat(round(T3.wel_list_buy_uv/T2.welfare_list_uv*100,2),'%') as `美购列表页-点击立即支付率`
		,concat(round(T3.wel_list_msg_uv/T2.welfare_list_uv*100,2),'%') as `美购列表页-点击私信咨询率`
		,T1.my_cart_uv as`购物车uv`
		,T2.my_cart_uv as`购物车-转化uv`
		,T3.cart_add_uv as `购物车-转化点击加车uv`
		,T3.cart_buy_uv as `购物车-转化点击立即支付uv`
		,T3.cart_msg_uv as `购物车-转化点击私信咨询uv`
		,concat(round(T2.my_cart_uv/T1.my_cart_uv*100,2),'%') as `购物车-转化uv率`
		,concat(round(T2.my_cart_uv/T1.wel_uv*100,2),'%') as `购物车-转化美购uv占比`
		,concat(round(T3.cart_add_uv/T2.my_cart_uv*100,2),'%') as `购物车-点击加车率`
		,concat(round(T3.cart_buy_uv/T2.my_cart_uv*100,2),'%') as `购物车-点击立即支付率`
		,concat(round(T3.cart_msg_uv/T2.my_cart_uv*100,2),'%') as `购物车-点击私信咨询率`
		,T1.search_result_more_uv as  `搜索结果综合页uv`
		,T2.search_result_more_uv as  `搜索结果综合页-转化uv`
		,T3.result_more_add_uv as `搜索结果综合页-转化点击加车uv`
		,T3.result_more_buy_uv as `搜索结果综合页-转化点击立即支付uv`
		,T3.result_more_msg_uv as `搜索结果综合页-转化点击私信咨询uv`
		,concat(round(T2.search_result_more_uv/T1.search_result_more_uv*100,2),'%') as `搜索结果综合页-转化uv率`
		,concat(round(T2.search_result_more_uv/T1.wel_uv*100,2),'%') as `搜索结果综合页-转化美购uv占比`
		,concat(round(T3.result_more_add_uv/T2.search_result_more_uv*100,2),'%') as `搜索结果综合页-点击加车率`
		,concat(round(T3.result_more_buy_uv/T2.search_result_more_uv*100,2),'%') as `搜索结果综合页-点击立即支付率`
		,concat(round(T3.result_more_msg_uv/T2.search_result_more_uv*100,2),'%') as `搜索结果综合页-点击私信咨询率`
		,T1.order_detail_uv as `订单详情页uv`
		,T2.order_detail_uv as `订单详情页-转化uv`
		,T3.order_add_uv as `订单详情页-转化点击加车uv`
		,T3.order_buy_uv as `订单详情页-转化点击立即支付uv`
		,T3.order_msg_uv as `订单详情页-转化点击私信咨询uv`
		,concat(round(T2.order_detail_uv/T1.order_detail_uv*100,2),'%') as `订单详情页-转化uv率`
		,concat(round(T2.order_detail_uv/T1.wel_uv*100,2),'%') as `订单详情页-转化美购uv占比`
		,concat(round(T3.order_add_uv/T2.order_detail_uv*100,2),'%') as `订单详情页-点击加车率`
		,concat(round(T3.order_buy_uv/T2.order_detail_uv*100,2),'%') as `订单详情页-点击立即支付率`
		,concat(round(T3.order_msg_uv/T2.order_detail_uv*100,2),'%') as `订单详情页-点击私信咨询率`
		,T1.special_uv as `专题和大促页uv`
		,T2.special_uv as `专题和大促页-转化uv`
		,T3.special_add_uv as `专题和大促页-转化点击加车uv`
		,T3.special_buy_uv as `专题和大促页-转化点击立即支付uv`
		,T3.special_msg_uv as `专题和大促页-转化点击私信咨询uv`
		,concat(round(T2.special_uv/T1.special_uv*100,2),'%') as `专题和大促页-转化uv率`
		,concat(round(T2.special_uv/T1.wel_uv*100,2),'%') as `专题和大促页-转化美购uv占比`
		,concat(round(T3.special_add_uv/T2.special_uv*100,2),'%') as `专题和大促页-点击加车率`
		,concat(round(T3.special_buy_uv/T2.special_uv*100,2),'%') as `专题和大促页-点击立即支付率`
		,concat(round(T3.special_msg_uv/T2.special_uv*100,2),'%') as `专题和大促页-点击私信咨询率`
		,T1.expert_detail_uv as `医生主页uv`
		,T2.expert_detail_uv as `医生主页-转化uv`
		,T3.exp_add_uv as `医生主页-转化点击加车uv`
		,T3.exp_buy_uv as `医生主页-转化点击立即支付uv`
		,T3.exp_msg_uv as `医生主页-转化点击私信咨询uv`
		,concat(round(T2.expert_detail_uv/T1.expert_detail_uv*100,2),'%') as `医生主页-转化uv率`
		,concat(round(T2.expert_detail_uv/T1.wel_uv*100,2),'%') as `医生主页-转化美购uv占比`
		,concat(round(T3.exp_add_uv/T2.expert_detail_uv*100,2),'%') as `医生主页-点击加车率`
		,concat(round(T3.exp_buy_uv/T2.expert_detail_uv*100,2),'%') as `医生主页-点击立即支付率`
		,concat(round(T3.exp_msg_uv/T2.expert_detail_uv*100,2),'%') as `医生主页-点击私信咨询率`
		,T1.wel_uv as `美购详情页uv`
		,T2.wel_uv as `其他美购详情页-转化uv`
		,T3.wel_add_uv as `其他美购详情页-转化点击加车uv`
		,T3.wel_buy_uv as `其他美购详情页-转化点击立即支付uv`
		,T3.wel_msg_uv as `其他美购详情页-转化点击私信咨询uv`
		,concat(round(T2.wel_uv/T1.wel_uv*100,2),'%') as `其他美购详情页-转化uv率`
		,concat(round(T2.wel_uv/T1.wel_uv*100,2),'%') as `其他美购详情页-转化美购uv占比`
		,concat(round(T3.wel_add_uv/T2.wel_uv*100,2),'%') as `其他美购详情页-点击加车率`
		,concat(round(T3.wel_buy_uv/T2.wel_uv*100,2),'%') as `其他美购详情页-点击立即支付率`
		,concat(round(T3.wel_msg_uv/T2.wel_uv*100,2),'%') as `其他美购详情页-点击私信咨询率`
		,T1.welfare_home_uv as `美购首页uv`
		,T2.welfare_home_uv as `美购首页-转化uv`
		,T3.wel_home_add_uv as `美购首页-转化点击加车uv`
		,T3.wel_home_buy_uv as `美购首页-转化点击立即支付uv`
		,T3.wel_home_msg_uv as `美购首页-转化点击私信咨询uv`
		,concat(round(T2.welfare_home_uv/T1.welfare_home_uv*100,2),'%') as `美购首页-转化uv率`
		,concat(round(T2.welfare_home_uv/T1.wel_uv*100,2),'%') as `美购首页-转化美购uv占比`
		,concat(round(T3.wel_home_add_uv/T2.welfare_home_uv*100,2),'%') as `美购首页-点击加车率`
		,concat(round(T3.wel_home_buy_uv/T2.welfare_home_uv*100,2),'%') as `美购首页-点击立即支付率`
		,concat(round(T3.wel_home_msg_uv/T2.welfare_home_uv*100,2),'%') as `美购首页-点击私信咨询率`
		,T1.diary_detail_uv as `日记本详情页uv`
		,T2.diary_detail_uv as `日记本详情页-转化uv`
		,T3.diary_add_uv as `日记本详情页-转化点击加车uv`
		,T3.diary_buy_uv as `日记本详情页-转化点击立即支付uv`
		,T3.diary_msg_uv as `日记本详情页-转化点击私信咨询uv`
		,concat(round(T2.diary_detail_uv/T1.diary_detail_uv*100,2),'%') as `日记本详情页-转化uv率`
		,concat(round(T2.diary_detail_uv/T1.wel_uv*100,2),'%') as `日记本详情页-转化美购uv占比`
		,concat(round(T3.diary_add_uv/T2.diary_detail_uv*100,2),'%') as `日记本详情页-点击加车率`
		,concat(round(T3.diary_buy_uv/T2.diary_detail_uv*100,2),'%') as `日记本详情页-点击立即支付率`
		,concat(round(T3.diary_msg_uv/T2.diary_detail_uv*100,2),'%') as `日记本详情页-点击私信咨询率`
		,T1.sign_uv as `签到页uv`
		,T2.sign_uv as `签到页-转化uv`
		,T3.sign_add_uv as `签到页-转化点击加车uv`
		,T3.sign_buy_uv as `签到页-转化点击立即支付uv`
		,T3.sign_msg_uv as `签到页-转化点击私信咨询uv`
		,concat(round(T2.sign_uv/T1.sign_uv*100,2),'%') as `签到页-转化uv率`
		,concat(round(T2.sign_uv/T1.wel_uv*100,2),'%') as `签到页-转化美购uv占比`
		,concat(round(T3.sign_add_uv/T2.sign_uv*100,2),'%') as `签到页-点击加车率`
		,concat(round(T3.sign_buy_uv/T2.sign_uv*100,2),'%') as `签到页-点击立即支付率`
		,concat(round(T3.sign_msg_uv/T2.sign_uv*100,2),'%') as `签到页-点击私信咨询率`
		,T1.ai_report_uv as `AI结果页uv`
		,T2.ai_report_uv as `AI结果页-转化uv`
		,T3.ai_add_uv as `AI结果页-转化点击加车uv`
		,T3.ai_buy_uv as `AI结果页-转化点击立即支付uv`
		,T3.ai_msg_uv as `AI结果页-转化点击私信咨询uv`
		,concat(round(T2.ai_report_uv/T1.ai_report_uv*100,2),'%') as `AI结果页-转化uv率`
		,concat(round(T2.ai_report_uv/T1.wel_uv*100,2),'%') as `AI结果页-转化美购uv占比`
		,concat(round(T3.ai_add_uv/T2.ai_report_uv*100,2),'%') as `AI结果页-点击加车率`
		,concat(round(T3.ai_buy_uv/T2.ai_report_uv*100,2),'%') as `AI结果页-点击立即支付率`
		,concat(round(T3.ai_msg_uv/T2.ai_report_uv*100,2),'%') as `AI结果页-点击私信咨询率`
		,T1.zone_uv as `内容聚合页uv`
		,T2.zone_uv as `内容聚合页-转化uv`
		,T3.zone_add_uv as `内容聚合页-转化点击加车uv`
		,T3.zone_buy_uv as `内容聚合页-转化点击立即支付uv`
		,T3.zone_msg_uv as `内容聚合页-转化点击私信咨询uv`
		,concat(round(T2.zone_uv/T1.zone_uv*100,2),'%') as `内容聚合页-转化uv率`
		,concat(round(T2.zone_uv/T1.wel_uv*100,2),'%') as `内容聚合页-转化美购uv占比`
		,concat(round(T3.zone_add_uv/T2.zone_uv*100,2),'%') as `内容聚合页-点击加车率`
		,concat(round(T3.zone_buy_uv/T2.zone_uv*100,2),'%') as `内容聚合页-点击立即支付率`
		,concat(round(T3.zone_msg_uv/T2.zone_uv*100,2),'%') as `内容聚合页-点击私信咨询率`

FROM
(--能够走向美购详情页的各页面uv/uv
	SELECT t1.partition_date
			,t1.device_type
			,t1.active_type
			,t2.channel
			,count(distinct case when page_name = 'welfare_detail' then t1.cl_id end) as wel_uv
			,count(distinct case when page_name = 'search_result_more' then t1.cl_id end) as search_result_more_uv
			,count(distinct case when page_name = 'search_result_welfare' then t1.cl_id end) as search_result_welfare_uv
			,count(distinct case when page_name = 'organization_detail' then t1.cl_id end) as organization_detail_uv
			,count(distinct case when page_name = 'expert_detail' then t1.cl_id end) as expert_detail_uv
			,count(distinct case when page_name = 'category' then t1.cl_id end) as category_uv
			,count(distinct case when page_name = 'welfare_list' then t1.cl_id end) as welfare_list_uv
			,count(distinct case when page_name = 'welfare_home' then t1.cl_id end) as welfare_home_uv
			,count(distinct case when page_name = 'conversation_detail' then t1.cl_id end) as conversation_detail_uv
			,count(distinct case when page_name = 'my_cart' then t1.cl_id end) as my_cart_uv
			,count(distinct case when page_name = 'diary_detail' then t1.cl_id end) as diary_detail_uv
			,count(distinct case when page_name = 'order_detail' then t1.cl_id end) as order_detail_uv
			,count(distinct case when page_name ='new_sign' then t1.cl_id end) as sign_uv
			,count(distinct case when page_name in ('special_polymer','newt_welfare_special','welfare_special','activity_promotion_seckill','activity_promotion','custom_special') then t1.cl_id end) as special_uv --专题和大促
			,count(distinct case when page_name = 'zone_v3' then t1.cl_id end) as zone_uv
			,count(distinct case when page_name in ('report_result','face_detect_result') then t1.cl_id end) as ai_report_uv --待之后增加模拟整形页面
	FROM
	(
		SELECT t1.partition_date,t1.page_name,t1.cl_id,mas.device_type,mas.active_type,mas.channel
		FROM
		(
			SELECT partition_date,page_name,cl_id
			FROM online.bl_hdfs_maidian_updates
			WHERE partition_date >=regexp_replace(DATE_SUB(current_date,90) ,'-','')
			AND partition_date < regexp_replace((current_date),'-','')
		    --AND page_name = 'welfare_detail'
			AND action='page_view'
		)t1
		JOIN
		(
			SELECT  partition_date,device_os_type as device_type,m.device_id
            ,case WHEN active_type = '4'  THEN '老活跃设备'
                  WHEN active_type  in ('1','2')  then '新增设备' END as active_type
            ,array(CASE WHEN first_channel_source_type like '%xinyouxingkong%' or a.device_id is not NULL
                                or first_channel_source_type in ('promotion_aisi','promotion_koomobi_km00','promotion_koomobi_km01')
                                or first_channel_source_type like '%longyuzhixing%' or first_channel_source_type like '%jingmeng%'
                                or first_channel_source_type like '%mailuo%' THEN '可疑'
                        WHEN (partition_date>='20190601' and tmp.col2 = 'AI')
                                or (partition_date < '20200301' AND partition_date>='20190601' and first_channel_source_type like 'promotion_toutiao_jy%')
                                or (partition_date>='20200601' and ((first_channel_source_type like 'promotion_toutiao_jy%') or (first_channel_source_type like 'dyand%') or (first_channel_source_type like 'douyin%')))
                                THEN 'AI'  ELSE '其他' END , '合计') as channel
            FROM online.ml_device_day_active_status m
                LEFT JOIN
                (SELECT col1,col2  --col1:子渠道，col2：是否属于AI，col3:标识
                   FROM pm.tl_pm_ydl
                   WHERE col3='0204_danlei_channel')tmp
                on first_channel_source_type=tmp.col1
                LEFT JOIN
                (SELECT DISTINCT device_id
                   FROM al.al_pm_ct_dv_deviceappversionrollbackfrom20190101_d
                   WHERE partition_day = regexp_replace(DATE_SUB(current_date,2) ,'-',''))a
                ON m.device_id = a.device_id
            where partition_date >= regexp_replace(DATE_SUB(current_date,90) ,'-','')
			AND partition_date < regexp_replace((current_date),'-','')
            AND active_type in ('1','2','4')
            and first_channel_source_type not in ('yqxiu1','yqxiu2','yqxiu3','yqxiu4','yqxiu5','mxyc1','mxyc2','mxyc3'
            ,'wanpu','jinshan','jx','maimai','zhuoyi','huatian','suopingjingling','mocha','mizhe','meika','lamabang'
            ,'js-az1','js-az2','js-az3','js-az4','js-az5','jfq-az1','jfq-az2','jfq-az3','jfq-az4','jfq-az5','toufang1'
            ,'toufang2','toufang3','toufang4','toufang5','toufang6','TF-toufang1','TF-toufang2','TF-toufang3','TF-toufang4'
            ,'TF-toufang5','tf-toufang1','tf-toufang2','tf-toufang3','tf-toufang4','tf-toufang5','benzhan','promotion_aso100'
            ,'promotion_qianka','promotion_xiaoyu','promotion_dianru','promotion_malioaso','promotion_malioaso-shequ'
            ,'promotion_shike','promotion_julang_jl03','promotion_zuimei','','unknown')
            AND first_channel_source_type not like 'promotion\_jf\_%'
		)mas
		ON t1.cl_id=mas.device_id
		  AND t1.partition_date=mas.partition_date
		LEFT JOIN
		( -- 去掉疑似机构刷量的pV和UV
	        SELECT distinct device_id
            FROM ml.ml_d_ct_dv_devicespam_d
            WHERE partition_day=regexp_replace(DATE_SUB(current_date,1) ,'-','')
	    )spam_pv
	    on t1.cl_id=spam_pv.device_id
	    WHERE spam_pv.device_id IS NULL
	)t1
    LATERAL VIEW explode(t1.channel) t2 AS channel
    GROUP BY t1.partition_date,t1.device_type,t1.active_type,t2.channel
)T1
LEFT JOIN
(--不同referrer下的美购详情页uv/uv
	SELECT t1.partition_date
			,t1.device_type
			,t1.active_type
			,t2.channel
			,count(distinct case when referrer = 'welfare_detail' then t1.cl_id end) as wel_uv
			,count(distinct case when referrer = 'search_result_more' then t1.cl_id end) as search_result_more_uv
			,count(distinct case when referrer = 'search_result_welfare' then t1.cl_id end) as search_result_welfare_uv
			,count(distinct case when referrer = 'organization_detail' then t1.cl_id end) as organization_detail_uv
			,count(distinct case when referrer = 'expert_detail' then t1.cl_id end) as expert_detail_uv
			,count(distinct case when referrer = 'category' then t1.cl_id end) as category_uv
			,count(distinct case when referrer = 'welfare_list' then t1.cl_id end) as welfare_list_uv
			,count(distinct case when referrer = 'welfare_home' then t1.cl_id end) as welfare_home_uv
			,count(distinct case when referrer = 'conversation_detail' then t1.cl_id end) as conversation_detail_uv
			,count(distinct case when referrer = 'my_cart' then t1.cl_id end) as my_cart_uv
			,count(distinct case when referrer = 'diary_detail' then t1.cl_id end) as diary_detail_uv
			,count(distinct case when referrer = 'order_detail' then t1.cl_id end) as order_detail_uv
			,count(distinct case when referrer ='new_sign' then t1.cl_id end) as sign_uv
			,count(distinct case when referrer in ('special_polymer','newt_welfare_special','welfare_special','activity_promotion_seckill','activity_promotion','custom_special') then t1.cl_id end) as special_uv --专题和大促
			,count(distinct case when referrer = 'zone_v3' then t1.cl_id end) as zone_uv
			,count(distinct case when referrer in ('report_result','face_detect_result') then t1.cl_id end) as ai_report_uv --待之后增加模拟整形页面
	FROM
	(
		SELECT t1.partition_date,t1.referrer,t1.cl_id,mas.device_type,mas.active_type,mas.channel
		FROM
		(
			SELECT partition_date,referrer,cl_id
			FROM online.bl_hdfs_maidian_updates
			WHERE partition_date >= regexp_replace(DATE_SUB(current_date,90) ,'-','')
			AND partition_date < regexp_replace((current_date),'-','')
		    AND page_name = 'welfare_detail'
			AND action='page_view'
		)t1
		JOIN
		(
			SELECT  partition_date,device_os_type as device_type,m.device_id
            ,case WHEN active_type = '4'  THEN '老活跃设备'
                  WHEN active_type  in ('1','2')  then '新增设备' END as active_type
            ,array(CASE WHEN first_channel_source_type like '%xinyouxingkong%' or a.device_id is not NULL
                                or first_channel_source_type in ('promotion_aisi','promotion_koomobi_km00','promotion_koomobi_km01')
                                or first_channel_source_type like '%longyuzhixing%' or first_channel_source_type like '%jingmeng%'
                                or first_channel_source_type like '%mailuo%' THEN '可疑'
                        WHEN (partition_date>='20190601' and tmp.col2 = 'AI')
                                or (partition_date < '20200301' AND partition_date>='20190601' and first_channel_source_type like 'promotion_toutiao_jy%')
                                or (partition_date>='20200601' and ((first_channel_source_type like 'promotion_toutiao_jy%') or (first_channel_source_type like 'dyand%') or (first_channel_source_type like 'douyin%')))
                                THEN 'AI'  ELSE '其他' END , '合计') as channel
            FROM online.ml_device_day_active_status m
                LEFT JOIN
                (SELECT col1,col2  --col1:子渠道，col2：是否属于AI，col3:标识
                   FROM pm.tl_pm_ydl
                   WHERE col3='0204_danlei_channel')tmp
                on first_channel_source_type=tmp.col1
                LEFT JOIN
                (SELECT DISTINCT device_id
                   FROM al.al_pm_ct_dv_deviceappversionrollbackfrom20190101_d
                   WHERE partition_day = regexp_replace(DATE_SUB(current_date,2) ,'-',''))a
                ON m.device_id = a.device_id
            where partition_date >= regexp_replace(DATE_SUB(current_date,90) ,'-','')
			AND partition_date < regexp_replace((current_date),'-','')
            AND active_type in ('1','2','4')
            and first_channel_source_type not in ('yqxiu1','yqxiu2','yqxiu3','yqxiu4','yqxiu5','mxyc1','mxyc2','mxyc3'
            ,'wanpu','jinshan','jx','maimai','zhuoyi','huatian','suopingjingling','mocha','mizhe','meika','lamabang'
            ,'js-az1','js-az2','js-az3','js-az4','js-az5','jfq-az1','jfq-az2','jfq-az3','jfq-az4','jfq-az5','toufang1'
            ,'toufang2','toufang3','toufang4','toufang5','toufang6','TF-toufang1','TF-toufang2','TF-toufang3','TF-toufang4'
            ,'TF-toufang5','tf-toufang1','tf-toufang2','tf-toufang3','tf-toufang4','tf-toufang5','benzhan','promotion_aso100'
            ,'promotion_qianka','promotion_xiaoyu','promotion_dianru','promotion_malioaso','promotion_malioaso-shequ'
            ,'promotion_shike','promotion_julang_jl03','promotion_zuimei','','unknown')
            AND first_channel_source_type not like 'promotion\_jf\_%'
		)mas
		ON t1.cl_id=mas.device_id
		  AND t1.partition_date=mas.partition_date
		LEFT JOIN
		( -- 去掉疑似机构刷量的pV和UV
	        SELECT distinct device_id
            FROM ml.ml_d_ct_dv_devicespam_d
            WHERE partition_day=regexp_replace(DATE_SUB(current_date,1) ,'-','')
	    )spam_pv
	    on t1.cl_id=spam_pv.device_id
	    WHERE spam_pv.device_id IS NULL
	)t1
    LATERAL VIEW explode(t1.channel) t2 AS channel
    GROUP BY t1.partition_date,t1.device_type,t1.active_type,t2.channel
)T2
ON T1.partition_date=T2.partition_date
  and T1.device_type=T2.device_type
  AND T1.active_type=T2.active_type
  AND T1.channel=T2.channel
LEFT JOIN
(--点击加车/支付/私信的不同来源
	SELECT t1.partition_date
			,t1.device_type
			,t1.active_type
			,t2.channel
			,count(distinct case when referrer = 'welfare_detail' and action = 'welfare_multiattribute_click_add' then t1.cl_id end) as wel_add_uv
			,count(distinct case when referrer = 'welfare_detail' and action = 'welfare_multiattribute_click_buy' then t1.cl_id end) as wel_buy_uv
			,count(distinct case when referrer = 'welfare_detail' and action in ('welfare_detail_click_message','on_click_button') then t1.cl_id end) as wel_msg_uv
			,count(distinct case when referrer = 'search_result_more' and action = 'welfare_multiattribute_click_add' then t1.cl_id end) as result_more_add_uv
			,count(distinct case when referrer = 'search_result_more' and action = 'welfare_multiattribute_click_buy' then t1.cl_id end) as result_more_buy_uv
			,count(distinct case when referrer = 'search_result_more' and action in ('welfare_detail_click_message','on_click_button') then t1.cl_id end) as result_more_msg_uv
			,count(distinct case when referrer = 'search_result_welfare' and action = 'welfare_multiattribute_click_add' then t1.cl_id end) as result_wel_add_uv
			,count(distinct case when referrer = 'search_result_welfare' and action = 'welfare_multiattribute_click_buy' then t1.cl_id end) as result_wel_buy_uv
			,count(distinct case when referrer = 'search_result_welfare' and action in ('welfare_detail_click_message','on_click_button') then t1.cl_id end) as result_wel_msg_uv
			,count(distinct case when referrer = 'organization_detail' and action = 'welfare_multiattribute_click_add' then t1.cl_id end) as org_add_uv
			,count(distinct case when referrer = 'organization_detail' and action = 'welfare_multiattribute_click_buy' then t1.cl_id end) as org_buy_uv
			,count(distinct case when referrer = 'organization_detail' and action in ('welfare_detail_click_message','on_click_button') then t1.cl_id end) as org_msg_uv
			,count(distinct case when referrer = 'expert_detail' and action = 'welfare_multiattribute_click_add' then t1.cl_id end) as exp_add_uv
			,count(distinct case when referrer = 'expert_detail' and action = 'welfare_multiattribute_click_buy' then t1.cl_id end) as exp_buy_uv
			,count(distinct case when referrer = 'expert_detail' and action in ('welfare_detail_click_message','on_click_button') then t1.cl_id end) as exp_msg_uv
			,count(distinct case when referrer = 'category' and action = 'welfare_multiattribute_click_add' then t1.cl_id end) as category_add_uv
			,count(distinct case when referrer = 'category' and action = 'welfare_multiattribute_click_buy' then t1.cl_id end) as category_buy_uv
			,count(distinct case when referrer = 'category' and action in ('welfare_detail_click_message','on_click_button') then t1.cl_id end) as category_msg_uv
			,count(distinct case when referrer = 'welfare_list' and action = 'welfare_multiattribute_click_add' then t1.cl_id end) as wel_list_add_uv
			,count(distinct case when referrer = 'welfare_list' and action = 'welfare_multiattribute_click_buy' then t1.cl_id end) as wel_list_buy_uv
			,count(distinct case when referrer = 'welfare_list' and action in ('welfare_detail_click_message','on_click_button') then t1.cl_id end) as wel_list_msg_uv
			,count(distinct case when referrer = 'welfare_home' and action = 'welfare_multiattribute_click_add' then t1.cl_id end) as wel_home_add_uv
			,count(distinct case when referrer = 'welfare_home' and action = 'welfare_multiattribute_click_buy' then t1.cl_id end) as wel_home_buy_uv
			,count(distinct case when referrer = 'welfare_home' and action in ('welfare_detail_click_message','on_click_button') then t1.cl_id end) as wel_home_msg_uv
			,count(distinct case when referrer = 'conversation_detail' and action = 'welfare_multiattribute_click_add' then t1.cl_id end) as conv_add_uv
			,count(distinct case when referrer = 'conversation_detail' and action = 'welfare_multiattribute_click_buy' then t1.cl_id end) as conv_buy_uv
			,count(distinct case when referrer = 'conversation_detail' and action in ('welfare_detail_click_message','on_click_button') then t1.cl_id end) as conv_msg_uv
			,count(distinct case when referrer = 'my_cart' and action = 'welfare_multiattribute_click_add' then t1.cl_id end) as cart_add_uv
			,count(distinct case when referrer = 'my_cart' and action = 'welfare_multiattribute_click_buy' then t1.cl_id end) as cart_buy_uv
			,count(distinct case when referrer = 'my_cart' and action in ('welfare_detail_click_message','on_click_button') then t1.cl_id end) as cart_msg_uv
			,count(distinct case when referrer = 'diary_detail' and action = 'welfare_multiattribute_click_add' then t1.cl_id end) as diary_add_uv
			,count(distinct case when referrer = 'diary_detail' and action = 'welfare_multiattribute_click_buy' then t1.cl_id end) as diary_buy_uv
			,count(distinct case when referrer = 'diary_detail' and action in ('welfare_detail_click_message','on_click_button') then t1.cl_id end) as diary_msg_uv
			,count(distinct case when referrer = 'order_detail' and action = 'welfare_multiattribute_click_add' then t1.cl_id end) as order_add_uv
			,count(distinct case when referrer = 'order_detail' and action = 'welfare_multiattribute_click_buy' then t1.cl_id end) as order_buy_uv
			,count(distinct case when referrer = 'order_detail' and action in ('welfare_detail_click_message','on_click_button') then t1.cl_id end) as order_msg_uv
			,count(distinct case when referrer = 'new_sign' and action = 'welfare_multiattribute_click_add' then t1.cl_id end) as sign_add_uv
			,count(distinct case when referrer = 'new_sign' and action = 'welfare_multiattribute_click_buy' then t1.cl_id end) as sign_buy_uv
			,count(distinct case when referrer = 'new_sign' and action in ('welfare_detail_click_message','on_click_button') then t1.cl_id end) as sign_msg_uv
			,count(distinct case when referrer in ('special_polymer','newt_welfare_special','welfare_special','activity_promotion_seckill','activity_promotion','custom_special') and action = 'welfare_multiattribute_click_add' then t1.cl_id end) as special_add_uv
			,count(distinct case when referrer in ('special_polymer','newt_welfare_special','welfare_special','activity_promotion_seckill','activity_promotion','custom_special') and action = 'welfare_multiattribute_click_buy' then t1.cl_id end) as special_buy_uv
			,count(distinct case when referrer in ('special_polymer','newt_welfare_special','welfare_special','activity_promotion_seckill','activity_promotion','custom_special') and action in ('welfare_detail_click_message','on_click_button') then t1.cl_id end) as special_msg_uv
			,count(distinct case when referrer = 'zone_v3' and action = 'welfare_multiattribute_click_add' then t1.cl_id end) as zone_add_uv
			,count(distinct case when referrer = 'zone_v3' and action = 'welfare_multiattribute_click_buy' then t1.cl_id end) as zone_buy_uv
			,count(distinct case when referrer = 'zone_v3' and action in ('welfare_detail_click_message','on_click_button') then t1.cl_id end) as zone_msg_uv
			,count(distinct case when referrer in ('report_result','face_detect_result') and action = 'welfare_multiattribute_click_add' then t1.cl_id end) as ai_add_uv
			,count(distinct case when referrer in ('report_result','face_detect_result') and action = 'welfare_multiattribute_click_buy' then t1.cl_id end) as ai_buy_uv
			,count(distinct case when referrer in ('report_result','face_detect_result') and action in ('welfare_detail_click_message','on_click_button') then t1.cl_id end) as ai_msg_uv

	FROM
	(
		SELECT t1.partition_date,t1.referrer,t1.action,t1.cl_id,mas.device_type,mas.active_type,mas.channel
		FROM
		(   --点击加车/支付
			SELECT partition_date,referrer,action,cl_id
			FROM online.bl_hdfs_maidian_updates
			WHERE partition_date >=regexp_replace(DATE_SUB(current_date,90) ,'-','')
			AND partition_date < regexp_replace((current_date),'-','')
		    AND page_name = 'welfare_detail'
			AND action in ('welfare_multiattribute_click_add','welfare_multiattribute_click_buy')

			UNION ALL
			--点击私信按钮
			SELECT partition_date,referrer,action,cl_id
			FROM online.bl_hdfs_maidian_updates
			WHERE partition_date >=regexp_replace(DATE_SUB(current_date,90) ,'-','')
			AND partition_date < regexp_replace((current_date),'-','')
		    --AND page_name = 'welfare_detail'
			AND action='welfare_detail_click_message'

			UNION ALL
			--点击私信区域(目前referrer缺失,故通过拆解referrer_link的方式获得)
			SELECT partition_date,referrer,action,cl_id
			FROM
			(
			    SELECT partition_date,cl_id,action,t2.referrer as referrer
			            ,row_number () over (PARTITION BY t1.referrer_link,t1.cl_id ORDER BY t2.link_id desc) as rank
			    from
			    (   SELECT partition_date,params['referrer_link'] as referrer_link,cl_id,action
			            ,json_split(params['referrer_link'],'string') as a
					FROM online.bl_hdfs_maidian_updates
					WHERE partition_date >= regexp_replace(DATE_SUB(current_date,90) ,'-','')
					AND partition_date < regexp_replace((current_date),'-','')
				    AND page_name = 'welfare_detail'
					AND action='on_click_button'
					AND params['button_name'] in ('question_tag','appointment')
				)t1
				lateral view posexplode(a) t2 as link_id,referrer
			)t3
			where rank=1

		)t1
		JOIN
		(
			SELECT  partition_date,device_os_type as device_type,m.device_id
            ,case WHEN active_type = '4'  THEN '老活跃设备'
                  WHEN active_type  in ('1','2')  then '新增设备' END as active_type
            ,array(CASE WHEN first_channel_source_type like '%xinyouxingkong%' or a.device_id is not NULL
                                or first_channel_source_type in ('promotion_aisi','promotion_koomobi_km00','promotion_koomobi_km01')
                                or first_channel_source_type like '%longyuzhixing%' or first_channel_source_type like '%jingmeng%'
                                or first_channel_source_type like '%mailuo%' THEN '可疑'
                        WHEN (partition_date>='20190601' and tmp.col2 = 'AI')
                                or (partition_date < '20200301' AND partition_date>='20190601' and first_channel_source_type like 'promotion_toutiao_jy%')
                                or (partition_date>='20200601' and ((first_channel_source_type like 'promotion_toutiao_jy%') or (first_channel_source_type like 'dyand%') or (first_channel_source_type like 'douyin%')))
                                THEN 'AI'  ELSE '其他' END , '合计') as channel
            FROM online.ml_device_day_active_status m
                LEFT JOIN
                (SELECT col1,col2  --col1:子渠道，col2：是否属于AI，col3:标识
                   FROM pm.tl_pm_ydl
                   WHERE col3='0204_danlei_channel')tmp
                on first_channel_source_type=tmp.col1
                LEFT JOIN
                (SELECT DISTINCT device_id
                   FROM al.al_pm_ct_dv_deviceappversionrollbackfrom20190101_d
                   WHERE partition_day = regexp_replace(DATE_SUB(current_date,2) ,'-',''))a
                ON m.device_id = a.device_id
            where partition_date >= regexp_replace(DATE_SUB(current_date,90) ,'-','')
			AND partition_date < regexp_replace((current_date),'-','')
            AND active_type in ('1','2','4')
            and first_channel_source_type not in ('yqxiu1','yqxiu2','yqxiu3','yqxiu4','yqxiu5','mxyc1','mxyc2','mxyc3'
            ,'wanpu','jinshan','jx','maimai','zhuoyi','huatian','suopingjingling','mocha','mizhe','meika','lamabang'
            ,'js-az1','js-az2','js-az3','js-az4','js-az5','jfq-az1','jfq-az2','jfq-az3','jfq-az4','jfq-az5','toufang1'
            ,'toufang2','toufang3','toufang4','toufang5','toufang6','TF-toufang1','TF-toufang2','TF-toufang3','TF-toufang4'
            ,'TF-toufang5','tf-toufang1','tf-toufang2','tf-toufang3','tf-toufang4','tf-toufang5','benzhan','promotion_aso100'
            ,'promotion_qianka','promotion_xiaoyu','promotion_dianru','promotion_malioaso','promotion_malioaso-shequ'
            ,'promotion_shike','promotion_julang_jl03','promotion_zuimei','','unknown')
            AND first_channel_source_type not like 'promotion\_jf\_%'
		)mas
		ON t1.cl_id=mas.device_id
		  AND t1.partition_date=mas.partition_date
		LEFT JOIN
		( -- 去掉疑似机构刷量的PV和UV
	        SELECT distinct device_id
            FROM ml.ml_d_ct_dv_devicespam_d
            WHERE partition_day=regexp_replace(DATE_SUB(current_date,1) ,'-','')
	    )spam_pv
	    on t1.cl_id=spam_pv.device_id
	    WHERE spam_pv.device_id IS NULL
	)t1
    LATERAL VIEW explode(t1.channel) t2 AS channel
    GROUP BY t1.partition_date,t1.device_type,t1.active_type,t2.channel
)T3
ON T1.partition_date=T3.partition_date
  and T1.device_type=T3.device_type
  AND T1.active_type=T3.active_type
  AND T1.channel=T3.channel
ORDER BY `日期` desc,`设备类型`,`活跃类型`,`渠道`

