SET mapreduce.job.queuename=data;
SET mapreduce.map.memory.mb=8192;
SET mapreduce.map.java.opts=-Xmx8000m;
SET mapreduce.reduce.memory.mb=8192;
SET mapreduce.reduce.java.opts=-Xmx8000m;
set hive.auto.convert.join=true;
SET mapred.reduce.tasks=20;
SET role admin;


ADD JAR hdfs:///user/hive/share/lib/udf/hive-udf-1.0-SNAPSHOT.jar;
CREATE TEMPORARY FUNCTION convup AS 'com.gmei.hive.common.udf.UDFConvUpgrade';

INSERT OVERWRITE TABLE pm.tl_pm_search_d PARTITION (PARTITION_DAY = ${partition_day})


SELECT
    concat(substr(partition_date,0,4),'-',substr(partition_date,5,2),'-',substr(partition_date,7,2)) as day_id
    ,device_os_type as device_os_type
    ,active_type as active_type
    ,channel as channel
    ,dau as dau
    ,all_search_uv as all_search_uv
    ,if(dau <> 0 ,concat(cast((all_search_uv/dau)*100 as decimal(18,2)),'%') , '-') as all_search_uv/dau
    ,if(all_search_uv <> 0 ,concat(cast((all_search_pv/all_search_uv) as decimal(18,2)),'') , '-') as all_search_pv/all_search_uv
    ,if(search_result_more_pv <> 0 ,concat(cast(((search_result_more_some_click_pv + ai_more_card_click_pv)/search_result_more_pv)*100 as decimal(18,2)),'%') , '-') as search_result_more_all_click_pv/search_result_more_pv
    ,if(search_result_more_pv <> 0 ,concat(cast((ai_more_card_click_pv/search_result_more_pv)*100 as decimal(18,2)),'%') , '-') as search_result_more_card_click_pv/search_result_more_pv
    ,if(search_result_welfare_pv <> 0 ,concat(cast((welfare_card_click_pv/search_result_welfare_pv)*100 as decimal(18,2)),'%') , '-') as search_result_welfare_card_click_pv/search_result_welfare_pv
    ,if(search_result_hospital_pv <> 0 ,concat(cast((hospital_card_click_pv/search_result_hospital_pv)*100 as decimal(18,2)),'%') , '-') as search_result_hospital_card_click_pv/search_result_hospital_pv
    ,if(search_result_doctor_pv <> 0 ,concat(cast((doctor_card_click_pv/search_result_doctor_pv)*100 as decimal(18,2)),'%') , '-') as search_result_doctor_card_click_pv/search_result_doctor_pv
    ,if(search_result_diary_pv <> 0 ,concat(cast((diary_card_click_pv/search_result_diary_pv)*100 as decimal(18,2)),'%') , '-') as search_result_diary_card_click_pv/search_result_diary_pv
    ,if(search_result_post_pv <> 0 ,concat(cast((post_card_click_pv/search_result_post_pv)*100 as decimal(18,2)),'%') , '-') as search_result_post_card_click_pv/search_result_post_pv
    ,if(search_result_wiki_pv <> 0 ,concat(cast((wiki_card_click_pv/search_result_wiki_pv)*100 as decimal(18,2)),'%') , '-') as search_result_wiki_card_click_pv/search_result_wiki_pv
    ,all_search_click_pv_724 as all_search_click_pv
    ,if(all_search_click_pv_724 <> 0 ,concat(cast((navbar_search_pv_724/all_search_click_pv_724)*100 as decimal(18,2)),'%') , '-') as navbar_search_pv/all_search_click_pv
    ,if(sug_out_pv_726 <> 0 ,concat(cast((sug_search_pv_726/sug_out_pv_726)*100 as decimal(18,2)),'%') , '-') as sug_search_pv/sug_out_pv
    ,if(home_you_like_grey_type_pv_723 <> 0 ,concat(cast((home_youlike_search_pv/home_you_like_grey_type_pv_723)*100 as decimal(18,2)),'%') , '-') as home_youlike_search_pv/home_you_like_grey_type_pv
    ,if(search_home_pv <> 0 ,concat(cast((faxain_search_pv/search_home_pv)*100 as decimal(18,2)),'%') , '-') as faxain_search_pv/search_home_pv
    ,if(search_home_pv <> 0 ,concat(cast((lishi_search_pv/search_home_pv)*100 as decimal(18,2)),'%') , '-') as lishi_search_pv/search_home_pv
    ,if(search_home_pv <> 0 ,concat(cast((allsee_search_pv/search_home_pv)*100 as decimal(18,2)),'%') , '-') as allsee_search_pv/search_home_pv
    ,if(home_search_click_pv_727 <> 0 ,concat(cast((home_morenci_search_pv_727/home_search_click_pv_727)*100 as decimal(18,2)),'%') , '-') as home_morenci_search_pv/home_search_click_pv
    ,if(welfare_home_search_click_pv_727 <> 0 ,concat(cast((welfare_home_morenci_search_pv_727/welfare_home_search_click_pv_727)*100 as decimal(18,2)),'%') , '-') as welfare_home_morenci_search_pv/welfare_home_search_click_pv
    ,if(content_detail_search_grey_pv_725 <> 0 ,concat(cast((content_detail_search_pv/content_detail_search_grey_pv_725)*100 as decimal(18,2)),'%') , '-') as content_detail_search_pv/content_detail_search_grey_pv
    ,if(all_search_result_pv <> 0 ,concat(cast((search_result_welfare_pv/all_search_result_pv)*100 as decimal(18,2)),'%') , '-') as search_result_welfare_pv/all_search_result_pv
    ,if(all_search_result_pv <> 0 ,concat(cast((search_result_hospital_pv/all_search_result_pv)*100 as decimal(18,2)),'%') , '-') as search_result_hospital_pv/all_search_result_pv
    ,if(all_search_result_pv <> 0 ,concat(cast((search_result_doctor_pv/all_search_result_pv)*100 as decimal(18,2)),'%') , '-') as search_result_doctor_pv/all_search_result_pv
    ,if(all_search_result_pv <> 0 ,concat(cast((search_result_diary_pv/all_search_result_pv)*100 as decimal(18,2)),'%') , '-') as search_result_diary_pv/all_search_result_pv
    ,if(all_search_result_pv <> 0 ,concat(cast((search_result_post_pv/all_search_result_pv)*100 as decimal(18,2)),'%') , '-') as search_result_post_pv/all_search_result_pv
    ,if(all_search_result_pv <> 0 ,concat(cast((search_result_wiki_pv/all_search_result_pv)*100 as decimal(18,2)),'%') , '-') as search_result_wiki_pv/all_search_result_pv
FROM
(
    SELECT
        coalesce(t1.partition_date,t2.partition_date,t3.partition_date,t4.partition_date,t5.partition_date,t6.partition_date,t7.partition_date) as partition_date
        ,coalesce(t1.active_type,t2.active_type,t3.active_type,t4.active_type,t5.active_type,t6.active_type,t7.active_type) as active_type
        ,coalesce(t1.device_os_type,t2.device_os_type,t3.device_os_type,t4.device_os_type,t5.device_os_type,t6.device_os_type,t7.device_os_type) as device_os_type
        ,coalesce(t1.channel,t2.channel,t3.channel,t4.channel,t5.channel,t6.channel,t7.channel) as channel
        ,coalesce(t1.dau,0) as dau
        ,coalesce(t2.all_search_click_uv_724,0) as all_search_click_uv_724                   --724及以上全部搜索框点击uv
        ,coalesce(t2.all_search_click_pv_724,0) as all_search_click_pv_724                   --724及以上全部搜索框点击pv
        ,coalesce(t2.home_search_click_uv_727,0) as home_search_click_uv_727                 --725及以上首页搜索框点击uv
        ,coalesce(t2.home_search_click_pv_727,0) as home_search_click_pv_727                --725及以上首页搜索框点击pv
        ,coalesce(t2.welfare_home_search_click_uv_727,0) as welfare_home_search_click_uv_727 --725及以上美购首页搜索框点击uv
        ,coalesce(t2.welfare_home_search_click_pv_727,0) as welfare_home_search_click_pv_727 --725及以上美购首页搜索框点击pv
        ,coalesce(t2.content_search_click_uv_724,0) as content_search_click_uv_724           --内容详情页搜索框点击uv(725上10%灰度)
        ,coalesce(t2.content_search_click_pv_724,0) as content_search_click_pv_724           --内容详情页搜索框点击pv(725上10%灰度)

        ,coalesce(t3.all_search_uv,0) as all_search_uv                                           --全部搜索uv
        ,coalesce(t3.all_search_pv,0) as all_search_pv                                           --全部搜索pv
        ,coalesce(t3.navbar_search_uv_724,0) as navbar_search_uv_724                             --724及以上通过搜索框搜索uv
        ,coalesce(t3.navbar_search_pv_724,0) as navbar_search_pv_724                             --724及以上通过搜索框搜索pv
        ,coalesce(t3.sug_search_uv,0) as sug_search_uv                                           --sug搜索uv
        ,coalesce(t3.sug_search_pv,0) as sug_search_pv                                           --sug搜索pv
        ,coalesce(t3.home_youlike_search_uv,0) as home_youlike_search_uv                         --首页猜你喜欢搜索uv(725上5%灰度)
        ,coalesce(t3.home_youlike_search_pv,0) as home_youlike_search_pv                         --首页猜你喜欢搜索pv(725上5%灰度)
        ,coalesce(t3.faxain_search_uv,0) as faxain_search_uv                                     --发现搜索uv
        ,coalesce(t3.faxain_search_pv,0) as faxain_search_pv                                     --发现搜索pv
        ,coalesce(t3.lishi_search_uv,0) as lishi_search_uv                                       --历史搜索uv
        ,coalesce(t3.lishi_search_pv,0) as lishi_search_pv                                       --历史搜索pv
        ,coalesce(t3.allsee_search_uv,0) as allsee_search_uv                                     --大家都在看搜索uv
        ,coalesce(t3.allsee_search_pv,0) as allsee_search_pv                                     --大家都在看搜索pv
        ,coalesce(t3.home_morenci_search_uv_727,0) as home_morenci_search_uv_727                 --725及以上首页默认词搜索uv，725do_search加的page_name参数
        ,coalesce(t3.home_morenci_search_pv_727,0) as home_morenci_search_pv_727                 --725及以上首页默认词搜索uv，725do_search加的page_name参数
        ,coalesce(t3.welfare_home_morenci_search_uv_727,0) as welfare_home_morenci_search_uv_727 --725及以上美购首页默认词搜索uv，725do_search加的page_name参数
        ,coalesce(t3.welfare_home_morenci_search_pv_727,0) as welfare_home_morenci_search_pv_727 --725及以上美购首页默认词搜索uv，725do_search加的page_name参数
        ,coalesce(t3.content_detail_search_uv,0) as content_detail_search_uv                     --内容详情页默认词搜索uv
        ,coalesce(t3.content_detail_search_pv,0) as content_detail_search_pv                     --内容详情页默认词搜索pv
        ,coalesce(t3.sug_search_uv_726,0) as sug_search_uv_726                                   --726及以上版本的sug搜索uv
        ,coalesce(t3.sug_search_pv_726,0) as sug_search_pv_726                                   --726及以上版本的sug搜索pv

        ,coalesce(t4.home_you_like_grey_type_uv_723,0) as home_you_like_grey_type_uv_723 --723及以上首页-猜你喜欢灰度设备的首页uv
        ,coalesce(t4.home_you_like_grey_type_pv_723,0) as home_you_like_grey_type_pv_723 --723及以上首页-猜你喜欢灰度设备的首页pv
        ,coalesce(t4.content_detail_search_grey_uv_725,0) as content_detail_search_grey_uv_725  --725及以上内容详情页-搜索框灰度设备的内容详情页uv
        ,coalesce(t4.content_detail_search_grey_pv_725,0) as content_detail_search_grey_pv_725  --725及以上内容详情页-搜索框灰度设备的内容详情页pv
        ,coalesce(t4.search_home_uv,0) as search_home_uv
        ,coalesce(t4.search_home_pv,0) as search_home_pv
        ,coalesce(t4.all_search_result_uv,0) as all_search_result_uv
        ,coalesce(t4.all_search_result_pv,0) as all_search_result_pv
        ,coalesce(t4.search_result_more_uv,0) as search_result_more_uv
        ,coalesce(t4.search_result_more_pv,0) as search_result_more_pv
        ,coalesce(t4.search_result_welfare_uv,0) as search_result_welfare_uv
        ,coalesce(t4.search_result_welfare_pv,0) as search_result_welfare_pv
        ,coalesce(t4.search_result_diary_uv,0) as search_result_diary_uv
        ,coalesce(t4.search_result_diary_pv,0) as search_result_diary_pv
        ,coalesce(t4.search_result_post_uv,0) as search_result_post_uv
        ,coalesce(t4.search_result_post_pv,0) as search_result_post_pv
        ,coalesce(t4.search_result_wiki_uv,0) as search_result_wiki_uv
        ,coalesce(t4.search_result_wiki_pv,0) as search_result_wiki_pv
        ,coalesce(t4.search_result_doctor_uv,0) as search_result_doctor_uv
        ,coalesce(t4.search_result_doctor_pv,0) as search_result_doctor_pv
        ,coalesce(t4.search_result_hospital_uv,0) as search_result_hospital_uv
        ,coalesce(t4.search_result_hospital_pv,0) as search_result_hospital_pv

        ,coalesce(t5.more_card_click_uv,0) as more_card_click_uv  --搜索结果综合页卡片点击uv(不含AI)
        ,coalesce(t5.more_card_click_pv,0) as more_card_click_pv  --搜索结果综合页卡片点击pv(不含AI)
        ,coalesce(t5.ai_more_card_click_uv,0) as ai_more_card_click_uv  --搜索结果综合页卡片点击uv(含AI)
        ,coalesce(t5.ai_more_card_click_pv,0) as ai_more_card_click_pv  --搜索结果综合页卡片点击pv(含AI)
        ,coalesce(t5.welfare_card_click_uv,0) as welfare_card_click_uv
        ,coalesce(t5.welfare_card_click_pv,0) as welfare_card_click_pv
        ,coalesce(t5.diary_card_click_uv,0) as diary_card_click_uv
        ,coalesce(t5.diary_card_click_pv,0) as diary_card_click_pv
        ,coalesce(t5.post_card_click_uv,0) as post_card_click_uv
        ,coalesce(t5.post_card_click_pv,0) as post_card_click_pv
        ,coalesce(t5.wiki_card_click_uv,0) as wiki_card_click_uv
        ,coalesce(t5.wiki_card_click_pv,0) as wiki_card_click_pv
        ,coalesce(t5.doctor_card_click_uv,0) as doctor_card_click_uv
        ,coalesce(t5.doctor_card_click_pv,0) as doctor_card_click_pv
        ,coalesce(t5.hospital_card_click_uv,0) as hospital_card_click_uv
        ,coalesce(t5.hospital_card_click_pv,0) as hospital_card_click_pv

        ,coalesce(t6.sug_out_uv_726,0) as sug_out_uv_726
        ,coalesce(t6.sug_out_pv_726,0) as sug_out_pv_726

        ,coalesce(t7.search_result_more_some_click_pv,0) as search_result_more_some_click_pv
    FROM
    (   --dau
        SELECT
            partition_date
            ,(case when active_type in (1,2) then '新增' when active_type = 4 then '老活' else NULL end) as active_type
            ,device_os_type
            ,(CASE WHEN first_channel_source_type like '%xinyouxingkong%' or a.device_id is not NULL
                            or first_channel_source_type in ('promotion_aisi','promotion_koomobi_km00','promotion_koomobi_km01')
                            or first_channel_source_type like '%jingmeng%' or first_channel_source_type like '%longyuzhixing%'
                            or first_channel_source_type like '%mailuo%' THEN '可疑'
                        WHEN (partition_date>='20190601' and channel_ai.col2 = 'AI')
                                or (partition_date < '20200301' AND partition_date>='20190601' and first_channel_source_type like 'promotion_toutiao_jy%')
                                or (partition_date>='20200601' and ((first_channel_source_type like 'promotion_toutiao_jy%') or (first_channel_source_type like 'dyand%') or (first_channel_source_type like 'douyin%')))
                                THEN 'AI渠道'  ELSE '非AI渠道' END) as channel
            ,count(distinct m.device_id)  as dau
        FROM online.ml_device_day_active_status m
         LEFT JOIN (SELECT col1,col2 FROM pm.tl_pm_ydl WHERE col3='0204_danlei_channel') channel_ai
            on first_channel_source_type = channel_ai.col1
        LEFT JOIN (SELECT DISTINCT device_id FROM al.al_pm_ct_dv_deviceappversionrollbackfrom20190101_d WHERE partition_day = REGEXP_REPLACE(date_sub(current_date(),2),'-',''))a
            ON m.device_id = a.device_id
        WHERE partition_date >= REGEXP_REPLACE(date_sub(current_date(),2),'-','')
          AND partition_date < regexp_replace(current_date ,'-','')
          AND active_type in (1,2,4)
          AND first_channel_source_type not in ('yqxiu1','yqxiu2','yqxiu3','yqxiu4','yqxiu5','mxyc1','mxyc2','mxyc3'
                   ,'wanpu','jinshan','jx','maimai','zhuoyi','huatian','suopingjingling','mocha','mizhe','meika','lamabang'
                   ,'js-az1','js-az2','js-az3','js-az4','js-az5','jfq-az1','jfq-az2','jfq-az3','jfq-az4','jfq-az5','toufang1'
                   ,'toufang2','toufang3','toufang4','toufang5','toufang6','TF-toufang1','TF-toufang2','TF-toufang3','TF-toufang4'
                   ,'TF-toufang5','tf-toufang1','tf-toufang2','tf-toufang3','tf-toufang4','tf-toufang5','benzhan','promotion_aso100'
                   ,'promotion_qianka','promotion_xiaoyu','promotion_dianru','promotion_malioaso','promotion_malioaso-shequ'
                   ,'promotion_shike','promotion_julang_jl03','promotion_zuimei','','unknown')
          AND first_channel_source_type not like 'promotion\_jf\_%'
        GROUP BY partition_date,(case when active_type in (1,2) then '新增' when active_type = 4 then '老活' else NULL end),device_os_type
            ,(CASE WHEN first_channel_source_type like '%xinyouxingkong%' or a.device_id is not NULL
                            or first_channel_source_type in ('promotion_aisi','promotion_koomobi_km00','promotion_koomobi_km01')
                            or first_channel_source_type like '%jingmeng%' or first_channel_source_type like '%longyuzhixing%'
                            or first_channel_source_type like '%mailuo%' THEN '可疑'
                        WHEN (partition_date>='20190601' and channel_ai.col2 = 'AI')
                                or (partition_date < '20200301' AND partition_date>='20190601' and first_channel_source_type like 'promotion_toutiao_jy%')
                                or (partition_date>='20200601' and ((first_channel_source_type like 'promotion_toutiao_jy%') or (first_channel_source_type like 'dyand%') or (first_channel_source_type like 'douyin%')))
                                THEN 'AI渠道'  ELSE '非AI渠道' END)
    )t1
    full JOIN
    (
        --搜索框点击,724版本埋点修复
        SELECT
            click.partition_date as partition_date
            ,active_type
            ,device_os_type
            ,channel
            ,count(click.cl_id) as all_search_click_pv_724
            ,count(distinct click.cl_id) as all_search_click_uv_724
            ,count(case when page_name = 'home' AND (int(split(app_version,'\\.')[0]) = 7 AND int(split(app_version,'\\.')[1]) >= 27) then click.cl_id else null end) as home_search_click_pv_727
            ,count(distinct case when page_name = 'home' AND (int(split(app_version,'\\.')[0]) = 7 AND int(split(app_version,'\\.')[1]) >= 27) then click.cl_id else null end) as home_search_click_uv_727
            ,count(case when page_name = 'welfare_home' AND (int(split(app_version,'\\.')[0]) = 7 AND int(split(app_version,'\\.')[1]) >= 27) then click.cl_id else null end) as welfare_home_search_click_pv_727
            ,count(distinct case when page_name = 'welfare_home' AND (int(split(app_version,'\\.')[0]) = 7 AND int(split(app_version,'\\.')[1]) >= 27) then click.cl_id else null end) as welfare_home_search_click_uv_727

            ,count(case when page_name in ('diary_detail','topic_detail','post_detail','user_post_detail','doctor_post_detail','question_detail','answer_detail','question_answer_detail',
                            'video_steep','article_detail','wiki_detail','product_detail','wiki_brand','wiki_collect') then click.cl_id else NULL END) as content_search_click_pv_724
            ,count(distinct case when page_name in ('diary_detail','topic_detail','post_detail','user_post_detail','doctor_post_detail','question_detail','answer_detail','question_answer_detail',
                            'video_steep','article_detail','wiki_detail','product_detail','wiki_brand','wiki_collect') then click.cl_id else null end) as content_search_click_uv_724
        FROM
        (
            SELECT cl_id,partition_date,action,params['page_name'] as page_name,app_version
            FROM online.bl_hdfs_maidian_updates
            WHERE partition_date >= REGEXP_REPLACE(date_sub(current_date(),2),'-','')
              AND partition_date < regexp_replace(current_date ,'-','')
              AND action = 'on_click_navbar_search'
              AND (int(split(app_version,'\\.')[0]) = 7 AND int(split(app_version,'\\.')[1]) >= 24)
        )click
        JOIN
        (
            SELECT
                partition_date
                ,(case when active_type in (1,2) then '新增' when active_type = 4 then '老活' else NULL end) as active_type
                ,device_os_type
                ,m.device_id
                ,(CASE WHEN first_channel_source_type like '%xinyouxingkong%' or a.device_id is not NULL
                            or first_channel_source_type in ('promotion_aisi','promotion_koomobi_km00','promotion_koomobi_km01')
                            or first_channel_source_type like '%jingmeng%' or first_channel_source_type like '%longyuzhixing%'
                            or first_channel_source_type like '%mailuo%' THEN '可疑'
                        WHEN (partition_date>='20190601' and channel_ai.col2 = 'AI')
                                or (partition_date < '20200301' AND partition_date>='20190601' and first_channel_source_type like 'promotion_toutiao_jy%')
                                or (partition_date>='20200601' and ((first_channel_source_type like 'promotion_toutiao_jy%') or (first_channel_source_type like 'dyand%') or (first_channel_source_type like 'douyin%')))
                                THEN 'AI渠道'  ELSE '非AI渠道' END) as channel
            FROM online.ml_device_day_active_status m
             LEFT JOIN (SELECT col1,col2 FROM pm.tl_pm_ydl WHERE col3='0204_danlei_channel') channel_ai
                on first_channel_source_type = channel_ai.col1
            LEFT JOIN (SELECT DISTINCT device_id FROM al.al_pm_ct_dv_deviceappversionrollbackfrom20190101_d WHERE partition_day = REGEXP_REPLACE(date_sub(current_date(),2),'-',''))a
                ON m.device_id = a.device_id
            WHERE partition_date >= REGEXP_REPLACE(date_sub(current_date(),2),'-','')
              AND partition_date < regexp_replace(current_date ,'-','')
              AND active_type in (1,2,4)
              AND first_channel_source_type not in ('yqxiu1','yqxiu2','yqxiu3','yqxiu4','yqxiu5','mxyc1','mxyc2','mxyc3'
                       ,'wanpu','jinshan','jx','maimai','zhuoyi','huatian','suopingjingling','mocha','mizhe','meika','lamabang'
                       ,'js-az1','js-az2','js-az3','js-az4','js-az5','jfq-az1','jfq-az2','jfq-az3','jfq-az4','jfq-az5','toufang1'
                       ,'toufang2','toufang3','toufang4','toufang5','toufang6','TF-toufang1','TF-toufang2','TF-toufang3','TF-toufang4'
                       ,'TF-toufang5','tf-toufang1','tf-toufang2','tf-toufang3','tf-toufang4','tf-toufang5','benzhan','promotion_aso100'
                       ,'promotion_qianka','promotion_xiaoyu','promotion_dianru','promotion_malioaso','promotion_malioaso-shequ'
                       ,'promotion_shike','promotion_julang_jl03','promotion_zuimei')
              AND first_channel_source_type not like 'promotion\_jf\_%'
        )dev_channel
          on dev_channel.device_id = click.cl_id
            AND dev_channel.partition_date = click.partition_date
        LEFT JOIN
        (
            SELECT  device_id as cl_id
            FROM ml.ml_d_ct_dv_devicespam_d
            WHERE partition_day = REGEXP_REPLACE(date_sub(current_date(),1),'-','')
        )spam_pv
          on click.cl_id=spam_pv.cl_id
        WHERE spam_pv.cl_id IS NULL
        GROUP BY click.partition_date,active_type,device_os_type,channel
    )t2
      on t2.partition_date = t1.partition_date
        AND t2.active_type = t1.active_type
        AND t2.device_os_type = t1.device_os_type
        AND t2.channel = t1.channel
    full JOIN
    (
        --搜索pvuv
        SELECT
            click.partition_date as partition_date
            ,active_type
            ,device_os_type
            ,channel
            ,count(click.cl_id) as all_search_pv
            ,count(distinct click.cl_id) as all_search_uv
            ,count(case when (int(split(app_version,'\\.')[0]) = 7 AND int(split(app_version,'\\.')[1]) >= 24)
                            AND input_type not in ('首页-猜你喜欢','美购首页-大家都在搜','详情页默认词','高亮词','related_search') then click.cl_id  else NULL end) as navbar_search_pv_724
            ,count(distinct case when (int(split(app_version,'\\.')[0]) = 7 AND int(split(app_version,'\\.')[1]) >= 24)
                            AND input_type not in ('首页-猜你喜欢','美购首页-大家都在搜','详情页默认词','高亮词','related_search') then click.cl_id else NULL end) as navbar_search_uv_724
            ,count(case when input_type in ('发现') then click.cl_id else null end) as faxain_search_pv
            ,count(distinct case when input_type in ('发现') then click.cl_id else null end) as faxain_search_uv
            ,count(case when input_type in ('历史') then click.cl_id else null end) as lishi_search_pv
            ,count(distinct case when input_type in ('历史') then click.cl_id else null end) as lishi_search_uv
            ,count(case when input_type in ('大家都在看') then click.cl_id else null end) as allsee_search_pv
            ,count(distinct case when input_type in ('大家都在看') then click.cl_id else null end) as allsee_search_uv
            ,count(case when (int(split(app_version,'\\.')[0]) = 7 AND int(split(app_version,'\\.')[1]) >= 27) AND input_type = '默认词' AND referrer_link_last in ('home') then click.cl_id else null end) as home_morenci_search_pv_727
            ,count(distinct case when (int(split(app_version,'\\.')[0]) = 7 AND int(split(app_version,'\\.')[1]) >= 27) AND input_type = '默认词' AND referrer_link_last in ('home') then click.cl_id else null end) as home_morenci_search_uv_727
            ,count(case when (int(split(app_version,'\\.')[0]) = 7 AND int(split(app_version,'\\.')[1]) >= 27) AND input_type = '默认词' AND referrer_link_last in ('welfare_home') then click.cl_id else null end) as welfare_home_morenci_search_pv_727
            ,count(distinct case when (int(split(app_version,'\\.')[0]) = 7 AND int(split(app_version,'\\.')[1]) >= 27) AND input_type = '默认词' AND referrer_link_last in ('welfare_home') then click.cl_id else null end) as welfare_home_morenci_search_uv_727
            ,count(case when input_type = '详情页默认词' then click.cl_id else null end) as content_detail_search_pv
            ,count(distinct case when input_type = '详情页默认词' then click.cl_id else null end) as content_detail_search_uv
            ,count(case when input_type = '输入' then click.cl_id else null end) as shuru_search_pv
            ,count(distinct case when input_type = '输入' then click.cl_id else null end) as shuru_search_uv
            ,count(case when input_type = '默认词' then click.cl_id else null end) as morenci_search_pv
            ,count(distinct case when input_type = '默认词' then click.cl_id else null end) as morenci_search_uv
            ,count(case when input_type in ('联想','聚合模块') then click.cl_id else null end) as sug_search_pv
            ,count(distinct case when input_type in ('联想','聚合模块') then click.cl_id else null end) as sug_search_uv
            ,count(case when (int(split(app_version,'\\.')[0]) = 7 AND int(split(app_version,'\\.')[1]) >= 26) AND input_type in ('联想','聚合模块') then click.cl_id else null end) as sug_search_pv_726
            ,count(distinct case when (int(split(app_version,'\\.')[0]) = 7 AND int(split(app_version,'\\.')[1]) >= 26) AND input_type in ('联想','聚合模块') then click.cl_id else null end) as sug_search_uv_726
            ,count(case when input_type in ('首页-猜你喜欢') then click.cl_id else null end) as home_youlike_search_pv
            ,count(distinct case when input_type in ('首页-猜你喜欢') then click.cl_id else null end) as home_youlike_search_uv
        FROM
        (
            SELECT cl_id,partition_date,action,params['page_name'] as page_name,params['input_type'] as input_type,app_version
                    ,(json_split(params['referrer_link'])[size(json_split(params['referrer_link']))-1]) as referrer_link_last
            FROM online.bl_hdfs_maidian_updates
            WHERE partition_date >= REGEXP_REPLACE(date_sub(current_date(),2),'-','')
              AND partition_date < regexp_replace(current_date ,'-','')
              AND action in ('do_search','search_result_click_search')

            union all

            SELECT cl_id,partition_date,action,'home' as page_name,'首页-猜你喜欢' as input_type,app_version,'其它' as referrer_link_last
            FROM online.bl_hdfs_maidian_updates
            WHERE partition_date >= REGEXP_REPLACE(date_sub(current_date(),2),'-','')
              AND partition_date < regexp_replace(current_date ,'-','')
              AND action = 'on_click_card'
              AND params['in_page_pos']='猜你喜欢'
              AND params['tab_name']='精选'
              AND params['card_type']='search_word'
              --AND page_name='home' android的page_name为空

            union all

            SELECT cl_id,partition_date,action,params['page_name'] as page_name,'美购首页-大家都在搜' as input_type,app_version,'其它' as referrer_link_last
            FROM online.bl_hdfs_maidian_updates
            WHERE partition_date >= REGEXP_REPLACE(date_sub(current_date(),2),'-','')
              AND partition_date < regexp_replace(current_date() ,'-','')
              AND action = 'on_click_card'
              AND params['page_name']='welfare_home'
              AND params['card_type'] ='search_word'
              AND params['in_page_pos']='大家都在搜'

            union all

            SELECT cl_id,partition_date,action,params['page_name'] as page_name,'高亮词' as input_type,app_version,'其它' as referrer_link_last
            FROM online.bl_hdfs_maidian_updates
            WHERE partition_date >= REGEXP_REPLACE(date_sub(current_date(),2),'-','')
              AND partition_date < regexp_replace(current_date() ,'-','')
              AND action = 'on_click_card'
              AND params['card_type'] ='highlight_word'
        )click
        JOIN
        (
            SELECT
                partition_date
                ,(case when active_type in (1,2) then '新增' when active_type = 4 then '老活' else NULL end) as active_type
                ,device_os_type
                ,m.device_id
                ,(CASE WHEN first_channel_source_type like '%xinyouxingkong%' or a.device_id is not NULL
                            or first_channel_source_type in ('promotion_aisi','promotion_koomobi_km00','promotion_koomobi_km01')
                            or first_channel_source_type like '%jingmeng%' or first_channel_source_type like '%longyuzhixing%'
                            or first_channel_source_type like '%mailuo%' THEN '可疑'
                        WHEN (partition_date>='20190601' and channel_ai.col2 = 'AI')
                                or (partition_date < '20200301' AND partition_date>='20190601' and first_channel_source_type like 'promotion_toutiao_jy%')
                                or (partition_date>='20200601' and ((first_channel_source_type like 'promotion_toutiao_jy%') or (first_channel_source_type like 'dyand%') or (first_channel_source_type like 'douyin%')))
                                THEN 'AI渠道'  ELSE '非AI渠道' END) as channel
            FROM online.ml_device_day_active_status m
             LEFT JOIN (SELECT col1,col2 FROM pm.tl_pm_ydl WHERE col3='0204_danlei_channel') channel_ai
                on first_channel_source_type = channel_ai.col1
            LEFT JOIN (SELECT DISTINCT device_id FROM al.al_pm_ct_dv_deviceappversionrollbackfrom20190101_d WHERE partition_day = REGEXP_REPLACE(date_sub(current_date(),2),'-',''))a
                ON m.device_id = a.device_id
            WHERE partition_date >= REGEXP_REPLACE(date_sub(current_date(),2),'-','')
              AND partition_date < regexp_replace(current_date ,'-','')
              AND active_type in (1,2,4)
              AND first_channel_source_type not in ('yqxiu1','yqxiu2','yqxiu3','yqxiu4','yqxiu5','mxyc1','mxyc2','mxyc3'
                       ,'wanpu','jinshan','jx','maimai','zhuoyi','huatian','suopingjingling','mocha','mizhe','meika','lamabang'
                       ,'js-az1','js-az2','js-az3','js-az4','js-az5','jfq-az1','jfq-az2','jfq-az3','jfq-az4','jfq-az5','toufang1'
                       ,'toufang2','toufang3','toufang4','toufang5','toufang6','TF-toufang1','TF-toufang2','TF-toufang3','TF-toufang4'
                       ,'TF-toufang5','tf-toufang1','tf-toufang2','tf-toufang3','tf-toufang4','tf-toufang5','benzhan','promotion_aso100'
                       ,'promotion_qianka','promotion_xiaoyu','promotion_dianru','promotion_malioaso','promotion_malioaso-shequ'
                       ,'promotion_shike','promotion_julang_jl03','promotion_zuimei')
              AND first_channel_source_type not like 'promotion\_jf\_%'
        )dev_channel
          on dev_channel.device_id = click.cl_id
            AND dev_channel.partition_date = click.partition_date
        LEFT JOIN
        (
            SELECT  device_id as cl_id
            FROM ml.ml_d_ct_dv_devicespam_d
            WHERE partition_day = REGEXP_REPLACE(date_sub(current_date(),1),'-','')
        )spam_pv
          on click.cl_id=spam_pv.cl_id
        WHERE spam_pv.cl_id IS NULL
        GROUP BY click.partition_date,active_type,device_os_type,channel
    )t3
      on t3.partition_date = t1.partition_date
        AND t3.active_type = t1.active_type
        AND t3.device_os_type = t1.device_os_type
        AND t3.channel = t1.channel
    full JOIN
    (
        --页面浏览pvuv
        SELECT
            page.partition_date as partition_date
            ,active_type
            ,device_os_type
            ,channel
            ,count(case when home_you_like_grey_type = '灰度' AND page_name = 'home' AND (int(split(app_version,'\\.')[0]) = 7 AND int(split(app_version,'\\.')[1]) >= 23) then page.cl_id else NULL end) as home_you_like_grey_type_pv_723
            ,count(distinct case when home_you_like_grey_type = '灰度' AND page_name = 'home' AND (int(split(app_version,'\\.')[0]) = 7 AND int(split(app_version,'\\.')[1]) >= 23) then page.cl_id else NULL end) as home_you_like_grey_type_uv_723
            ,count(case when page_name in ('search_home','search_home_more','search_home_welfare','search_home_diary','search_home_wiki','search_home_post','search_home_hospital','search_home_doctor') then page.cl_id else NULL end) as search_home_pv
            ,count(distinct case when page_name in ('search_home','search_home_more','search_home_welfare','search_home_diary','search_home_wiki','search_home_post','search_home_hospital','search_home_doctor') then page.cl_id else NULL end) as search_home_uv
            ,count(case when page_name in ('search_result_diary','search_result_doctor','search_result_hospital','search_result_more'
                        ,'search_result_more_infomation','search_result_more_user','search_result_post','search_result_welfare'
                        ,'search_result_wiki') then page.cl_id else NULL end) as all_search_result_pv
            ,count(distinct case when page_name in ('search_result_diary','search_result_doctor','search_result_hospital','search_result_more'
                        ,'search_result_more_infomation','search_result_more_user','search_result_post','search_result_welfare'
                        ,'search_result_wiki') then page.cl_id else NULL end) as all_search_result_uv
            ,count(case when ((content_search_grey_type = '灰度' AND page_name in ('diary_detail','topic_detail','post_detail','user_post_detail','doctor_post_detail','question_detail'
                                                            ,'video_steep','article_detail','wiki_detail','product_detail','wiki_brand','wiki_collect'))
                                or (answer_grey_type = '灰度' AND page_name in ('answer_detail','question_answer_detail')))
                            AND (int(split(app_version,'\\.')[0]) = 7 AND int(split(app_version,'\\.')[1]) >= 25) then page.cl_id else NULL end) as content_detail_search_grey_pv_725
            ,count(distinct case when content_search_grey_type = '灰度' AND page_name in ('diary_detail','topic_detail','post_detail','user_post_detail','doctor_post_detail','question_detail','answer_detail',
                                                            'question_answer_detail','video_steep','article_detail','wiki_detail','product_detail','wiki_brand','wiki_collect')
                            AND (int(split(app_version,'\\.')[0]) = 7 AND int(split(app_version,'\\.')[1]) >= 25) then page.cl_id else NULL end) as content_detail_search_grey_uv_725
            ,count(case when page_name in ('search_result_more') then page.cl_id else NULL end) as search_result_more_pv
            ,count(distinct case when page_name in ('search_result_more') then page.cl_id else NULL end) as search_result_more_uv
            ,count(case when page_name in ('search_result_welfare') then page.cl_id else NULL end) as search_result_welfare_pv
            ,count(distinct case when page_name in ('search_result_welfare') then page.cl_id else NULL end) as search_result_welfare_uv
            ,count(case when page_name in ('search_result_diary') then page.cl_id else NULL end) as search_result_diary_pv
            ,count(distinct case when page_name in ('search_result_diary') then page.cl_id else NULL end) as search_result_diary_uv
            ,count(case when page_name in ('search_result_post') then page.cl_id else NULL end) as search_result_post_pv
            ,count(distinct case when page_name in ('search_result_post') then page.cl_id else NULL end) as search_result_post_uv
            ,count(case when page_name in ('search_result_wiki') then page.cl_id else NULL end) as search_result_wiki_pv
            ,count(distinct case when page_name in ('search_result_wiki') then page.cl_id else NULL end) as search_result_wiki_uv
            ,count(case when page_name in ('search_result_doctor') then page.cl_id else NULL end) as search_result_doctor_pv
            ,count(distinct case when page_name in ('search_result_doctor') then page.cl_id else NULL end) as search_result_doctor_uv
            ,count(case when page_name in ('search_result_hospital') then page.cl_id else NULL end) as search_result_hospital_pv
            ,count(distinct case when page_name in ('search_result_hospital') then page.cl_id else NULL end) as search_result_hospital_uv
        FROM
        (
            SELECT cl_id,partition_date,referrer,params['page_name'] as page_name
                ,(CASE WHEN substr(convup(sha1(cl_id),16,10),-2,2)%20=0 then '灰度' else '非灰' end) as home_you_like_grey_type,app_version
                ,(case when (partition_date <= '20200511' AND substr(convup(sha1(cl_id),16,10),-1) = '0') or (partition_date >= '20200512' AND partition_date <= '20200706' AND substr(convup(sha1(cl_id),16,10),-1) in ('0','1','2','3','4') or partition_date >= '20200707') then '灰度' else '非灰' end) as content_search_grey_type
                ,(case when (int(split(app_version,'\\.')[0]) = 7 AND int(split(app_version,'\\.')[1]) >= 27) or (substr(convup(sha1(cl_id),16,10),-2,2)%20=0) then '灰度' else '非灰' END) as answer_grey_type
            FROM online.bl_hdfs_maidian_updates
            WHERE partition_date >= REGEXP_REPLACE(date_sub(current_date(),2),'-','')
              AND partition_date < regexp_replace(current_date ,'-','')
              AND action='page_view'
              AND params['page_name'] in ('search_home','search_result_diary','search_result_doctor','search_result_hospital','search_result_more'
                        ,'search_result_more_infomation','search_result_more_user','search_result_post','search_result_welfare','search_result_wiki'
                        ,'search_home_more','search_home_welfare','search_home_diary','search_home_wiki','search_home_post','search_home_hospital','search_home_doctor'
                        ,'home','diary_detail','topic_detail','post_detail','user_post_detail','doctor_post_detail','question_detail','answer_detail',
                                                            'question_answer_detail','video_steep','article_detail','wiki_detail','product_detail','wiki_brand','wiki_collect')
        )page
        JOIN
        (
            SELECT
                partition_date
                ,(case when active_type in (1,2) then '新增' when active_type = 4 then '老活' else NULL end) as active_type
                ,device_os_type
                ,m.device_id
                ,(CASE WHEN first_channel_source_type like '%xinyouxingkong%' or a.device_id is not NULL
                            or first_channel_source_type in ('promotion_aisi','promotion_koomobi_km00','promotion_koomobi_km01')
                            or first_channel_source_type like '%jingmeng%' or first_channel_source_type like '%longyuzhixing%'
                            or first_channel_source_type like '%mailuo%' THEN '可疑'
                        WHEN (partition_date>='20190601' and channel_ai.col2 = 'AI')
                                or (partition_date < '20200301' AND partition_date>='20190601' and first_channel_source_type like 'promotion_toutiao_jy%')
                                or (partition_date>='20200601' and ((first_channel_source_type like 'promotion_toutiao_jy%') or (first_channel_source_type like 'dyand%') or (first_channel_source_type like 'douyin%')))
                                THEN 'AI渠道'  ELSE '非AI渠道' END) as channel
            FROM online.ml_device_day_active_status m
             LEFT JOIN (SELECT col1,col2 FROM pm.tl_pm_ydl WHERE col3='0204_danlei_channel') channel_ai
                on first_channel_source_type = channel_ai.col1
            LEFT JOIN (SELECT DISTINCT device_id FROM al.al_pm_ct_dv_deviceappversionrollbackfrom20190101_d WHERE partition_day = REGEXP_REPLACE(date_sub(current_date(),2),'-',''))a
                ON m.device_id = a.device_id
            WHERE partition_date >= REGEXP_REPLACE(date_sub(current_date(),2),'-','')
              AND partition_date < regexp_replace(current_date ,'-','')
              AND active_type in (1,2,4)
              AND first_channel_source_type not in ('yqxiu1','yqxiu2','yqxiu3','yqxiu4','yqxiu5','mxyc1','mxyc2','mxyc3'
                       ,'wanpu','jinshan','jx','maimai','zhuoyi','huatian','suopingjingling','mocha','mizhe','meika','lamabang'
                       ,'js-az1','js-az2','js-az3','js-az4','js-az5','jfq-az1','jfq-az2','jfq-az3','jfq-az4','jfq-az5','toufang1'
                       ,'toufang2','toufang3','toufang4','toufang5','toufang6','TF-toufang1','TF-toufang2','TF-toufang3','TF-toufang4'
                       ,'TF-toufang5','tf-toufang1','tf-toufang2','tf-toufang3','tf-toufang4','tf-toufang5','benzhan','promotion_aso100'
                       ,'promotion_qianka','promotion_xiaoyu','promotion_dianru','promotion_malioaso','promotion_malioaso-shequ'
                       ,'promotion_shike','promotion_julang_jl03','promotion_zuimei')
              AND first_channel_source_type not like 'promotion\_jf\_%'
        )dev_channel
          on dev_channel.device_id = page.cl_id
            AND dev_channel.partition_date = page.partition_date
        LEFT JOIN
        (
            SELECT  device_id as cl_id
            FROM ml.ml_d_ct_dv_devicespam_d
            WHERE partition_day = REGEXP_REPLACE(date_sub(current_date(),1),'-','')
        )spam_pv
          on page.cl_id=spam_pv.cl_id
        WHERE spam_pv.cl_id IS NULL
        GROUP BY page.partition_date,active_type,device_os_type,channel
    )t4
      on t4.partition_date = t1.partition_date
        AND t4.active_type = t1.active_type
        AND t4.device_os_type = t1.device_os_type
        AND t4.channel = t1.channel
    full JOIN
    (   --搜索结果卡片点击事件
        SELECT
            card_click.partition_date as partition_date
            ,active_type
            ,device_os_type
            ,channel
            ,count(case when page_name = 'search_result_more' then card_click.cl_id else null end) as ai_more_card_click_pv
            ,count(distinct case when page_name = 'search_result_more' then card_click.cl_id else null end) as ai_more_card_click_uv
            ,count(case when page_name = 'search_result_more' AND action <> 'search_result_more_click_face' then card_click.cl_id else null end) as more_card_click_pv
            ,count(distinct case when page_name = 'search_result_more' AND action <> 'search_result_more_click_face' then card_click.cl_id else null end) as more_card_click_uv
            ,count(case when page_name = 'search_result_welfare' then card_click.cl_id else null end) as welfare_card_click_pv
            ,count(distinct case when page_name = 'search_result_welfare' then card_click.cl_id else null end) as welfare_card_click_uv
            ,count(case when page_name = 'search_result_diary' then card_click.cl_id else null end) as diary_card_click_pv
            ,count(distinct case when page_name = 'search_result_diary' then card_click.cl_id else null end) as diary_card_click_uv
            ,count(case when page_name = 'search_result_post' then card_click.cl_id else null end) as post_card_click_pv
            ,count(distinct case when page_name = 'search_result_post' then card_click.cl_id else null end) as post_card_click_uv
            ,count(case when page_name = 'search_result_wiki' then card_click.cl_id else null end) as wiki_card_click_pv
            ,count(distinct case when page_name = 'search_result_wiki' then card_click.cl_id else null end) as wiki_card_click_uv
            ,count(case when page_name = 'search_result_doctor' then card_click.cl_id else null end) as doctor_card_click_pv
            ,count(distinct case when page_name = 'search_result_doctor' then card_click.cl_id else null end) as doctor_card_click_uv
            ,count(case when page_name = 'search_result_hospital' then card_click.cl_id else null end) as hospital_card_click_pv
            ,count(distinct case when page_name = 'search_result_hospital' then card_click.cl_id else null end) as hospital_card_click_uv
        FROM
        (
            SELECT
                T.cl_id AS cl_id,
                T.action AS action,
                T.partition_date as partition_date,
                (CASE
                    WHEN T.action = 'search_result_welfare_click_item' OR (T.action = 'goto_welfare_detail' AND T.params [ 'from' ] = 'search_result_welfare_recommend')
                        THEN 'search_result_welfare' --ok
                    WHEN T.action IN ('search_result_wiki_click_item','search_result_wiki_click_recommend_wiki')
                        THEN 'search_result_wiki'
                    WHEN action IN ('on_click_doctor_card','search_result_click_recommend_item')
                            OR (action = 'on_click_hospital_card' AND params [ 'page_name' ] = 'search_result_more')
                            OR (action = 'search_result_click_search' AND params [ 'tab' ] = '综合' and params [ 'input_type' ] = 'related_search')
                        THEN 'search_result_more'
                    WHEN action = 'on_click_diary_card' AND params [ 'page_name' ] = 'search_result_diary'
                        THEN 'search_result_diary'
                    WHEN action = 'search_result_hospital_click_item'
                        THEN 'search_result_hospital'
                    WHEN action = 'search_result_doctor_click_item'
                        THEN 'search_result_doctor'
                    WHEN action = 'on_click_topic_card' AND params [ 'page_name' ] = 'search_result_post'
                        THEN 'search_result_post'
                ELSE params [ 'page_name' ] END) AS page_name,
                T.app_version AS app_version,
                T.params['position'] AS position,
                CASE
                    WHEN T.action IN ('search_result_click_recommend_item','search_result_welfare_click_item')
                            OR (action = 'goto_welfare_detail' and params [ 'from' ] = 'search_result_welfare_recommend')
                        THEN 'service'
                WHEN (T.action = 'search_result_click_infomation_item' AND coalesce(T.params [ 'business_type' ],T.params['post_type'])  = '0')
                            OR (T.action = 'on_click_diary_card' AND T.params [ 'page_name' ] = 'search_result_more' AND T.cl_type = 'android')
                            OR (T.action IN ('on_click_diary_card','search_result_click_infomation_item') AND T.params [ 'page_name' ] = 'search_result_diary')
                        THEN 'diary'
                WHEN T.action = 'search_result_click_infomation_item' AND coalesce(T.params [ 'business_type' ],T.params['post_type']) = '5'
                    THEN 'answer'
                WHEN T.action = 'search_result_click_infomation_item' AND coalesce(T.params [ 'business_type' ],T.params['post_type']) = '9'
                    THEN 'article'
                WHEN T.action = 'search_result_click_infomation_item' AND coalesce(T.params [ 'business_type' ],T.params['post_type']) = '11'
                    THEN 'user_post'
                WHEN T.action IN ('search_result_wiki_click_item','search_result_wiki_click_recommend_wiki')
                    THEN 'wiki'
                WHEN T.action = 'search_result_hospital_click_item'
                            OR (T.action = 'on_click_hospital_card' AND T.params [ 'page_name' ] = 'search_result_more')
                    THEN 'hospital'
                WHEN (T.action = 'on_click_doctor_card' AND T.params [ 'page_name' ] = 'search_result_more')
                            OR (T.action = 'search_result_doctor_click_item')
                    THEN 'doctor'
                WHEN T.action = 'on_click_topic_card' AND T.params [ 'page_name' ] IN ('search_result_post','search_result_more') AND T.params [ 'card_content_type' ] = 'user_post'
                    THEN 'user_post'
                WHEN T.action = 'on_click_topic_card' AND T.params [ 'page_name' ] IN ('search_result_post','search_result_more') AND T.params [ 'card_content_type' ] = 'doctor_post'
                    THEN 'doctor_post'
                WHEN (T.action = 'search_result_click_search' AND params [ 'tab' ] = '综合' and params [ 'input_type' ] = 'related_search')
                    THEN 'related_search'
                ELSE coalesce(T.params [ 'business_type' ],T.params['post_type']) END AS card_content_type
            FROM online.bl_hdfs_maidian_updates T
            WHERE partition_date >= REGEXP_REPLACE(date_sub(current_date(),2),'-','')
              AND partition_date < regexp_replace(current_date ,'-','')
              AND ((T.action IN ('on_click_doctor_card', 'on_click_hospital_card') AND params [ 'page_name' ] = 'search_result_more')
                    OR (T.action='search_result_click_search' AND params [ 'tab' ] = '综合' and params['input_type']='related_search')
                    OR T.action in ('search_result_welfare_click_item', 'search_result_wiki_click_item','search_result_click_recommend_item','goto_welfare_detail','on_click_diary_card',
                            'search_result_hospital_click_item', 'search_result_doctor_click_item','search_result_click_infomation_item','search_result_wiki_click_recommend_wiki')
                    OR (T.action = 'on_click_topic_card' AND T.params [ 'page_name' ] IN ('search_result_post','search_result_more'))
                    OR T.action = 'search_result_more_click_face')
              AND SIZE(split(T.app_version,'\\.')) >= 3
              AND (T.params [ 'page_name' ] LIKE '%search_result%' OR T.params [ 'page_name' ] IS NULL)
              AND (case when T.action='search_result_click_infomation_item' and T.params['tab']='综合' then T.params['input_type']<>'related_search' else 1=1 end)
        )card_click
        JOIN
        (
            SELECT
                partition_date
                ,(case when active_type in (1,2) then '新增' when active_type = 4 then '老活' else NULL end) as active_type
                ,device_os_type
                ,m.device_id
                ,(CASE WHEN first_channel_source_type like '%xinyouxingkong%' or a.device_id is not NULL
                            or first_channel_source_type in ('promotion_aisi','promotion_koomobi_km00','promotion_koomobi_km01')
                            or first_channel_source_type like '%jingmeng%' or first_channel_source_type like '%longyuzhixing%'
                            or first_channel_source_type like '%mailuo%' THEN '可疑'
                        WHEN (partition_date>='20190601' and channel_ai.col2 = 'AI')
                                or (partition_date < '20200301' AND partition_date>='20190601' and first_channel_source_type like 'promotion_toutiao_jy%')
                                or (partition_date>='20200601' and ((first_channel_source_type like 'promotion_toutiao_jy%') or (first_channel_source_type like 'dyand%') or (first_channel_source_type like 'douyin%')))
                                THEN 'AI渠道'  ELSE '非AI渠道' END) as channel
            FROM online.ml_device_day_active_status m
             LEFT JOIN (SELECT col1,col2 FROM pm.tl_pm_ydl WHERE col3='0204_danlei_channel') channel_ai
                on first_channel_source_type = channel_ai.col1
            LEFT JOIN (SELECT DISTINCT device_id FROM al.al_pm_ct_dv_deviceappversionrollbackfrom20190101_d WHERE partition_day = REGEXP_REPLACE(date_sub(current_date(),2),'-',''))a
                ON m.device_id = a.device_id
            WHERE partition_date >= REGEXP_REPLACE(date_sub(current_date(),2),'-','')
              AND partition_date < regexp_replace(current_date ,'-','')
              AND active_type in (1,2,4)
              AND first_channel_source_type not in ('yqxiu1','yqxiu2','yqxiu3','yqxiu4','yqxiu5','mxyc1','mxyc2','mxyc3'
                       ,'wanpu','jinshan','jx','maimai','zhuoyi','huatian','suopingjingling','mocha','mizhe','meika','lamabang'
                       ,'js-az1','js-az2','js-az3','js-az4','js-az5','jfq-az1','jfq-az2','jfq-az3','jfq-az4','jfq-az5','toufang1'
                       ,'toufang2','toufang3','toufang4','toufang5','toufang6','TF-toufang1','TF-toufang2','TF-toufang3','TF-toufang4'
                       ,'TF-toufang5','tf-toufang1','tf-toufang2','tf-toufang3','tf-toufang4','tf-toufang5','benzhan','promotion_aso100'
                       ,'promotion_qianka','promotion_xiaoyu','promotion_dianru','promotion_malioaso','promotion_malioaso-shequ'
                       ,'promotion_shike','promotion_julang_jl03','promotion_zuimei')
              AND first_channel_source_type not like 'promotion\_jf\_%'
        )dev_channel
          on dev_channel.device_id = card_click.cl_id
            AND dev_channel.partition_date = card_click.partition_date
        LEFT JOIN
        (
            SELECT  device_id as cl_id
            FROM ml.ml_d_ct_dv_devicespam_d
            WHERE partition_day = REGEXP_REPLACE(date_sub(current_date(),1),'-','')
        )spam_pv
          on card_click.cl_id=spam_pv.cl_id
        WHERE spam_pv.cl_id IS NULL
        GROUP BY card_click.partition_date,active_type,device_os_type,channel
    )t5
      on t5.partition_date = t1.partition_date
        AND t5.active_type = t1.active_type
        AND t5.device_os_type = t1.device_os_type
        AND t5.channel = t1.channel
    full JOIN
    (   --sug弹窗弹出--预计排期726修复
        SELECT
            click.partition_date as partition_date
            ,active_type
            ,device_os_type
            ,channel
            ,count(click.cl_id) as sug_out_pv_726
            ,count(distinct click.cl_id) as sug_out_uv_726
        FROM
        (
            SELECT cl_id,partition_date,action,params['page_name'] as page_name
            FROM online.bl_hdfs_maidian_updates
            WHERE partition_date >= REGEXP_REPLACE(date_sub(current_date(),2),'-','')
              AND partition_date < regexp_replace(current_date ,'-','')
              AND action = 'searchsug_view'
              AND (int(split(app_version,'\\.')[0]) = 7 AND int(split(app_version,'\\.')[1]) >= 26)
        )click
        JOIN
        (
            SELECT
                partition_date
                ,(case when active_type in (1,2) then '新增' when active_type = 4 then '老活' else NULL end) as active_type
                ,device_os_type
                ,m.device_id
                ,(CASE WHEN first_channel_source_type like '%xinyouxingkong%' or a.device_id is not NULL
                            or first_channel_source_type in ('promotion_aisi','promotion_koomobi_km00','promotion_koomobi_km01')
                            or first_channel_source_type like '%jingmeng%' or first_channel_source_type like '%longyuzhixing%'
                            or first_channel_source_type like '%mailuo%' THEN '可疑'
                        WHEN (partition_date>='20190601' and channel_ai.col2 = 'AI')
                                or (partition_date < '20200301' AND partition_date>='20190601' and first_channel_source_type like 'promotion_toutiao_jy%')
                                or (partition_date>='20200601' and ((first_channel_source_type like 'promotion_toutiao_jy%') or (first_channel_source_type like 'dyand%') or (first_channel_source_type like 'douyin%')))
                                THEN 'AI渠道'  ELSE '非AI渠道' END) as channel
            FROM online.ml_device_day_active_status m
             LEFT JOIN (SELECT col1,col2 FROM pm.tl_pm_ydl WHERE col3='0204_danlei_channel') channel_ai
                on first_channel_source_type = channel_ai.col1
            LEFT JOIN (SELECT DISTINCT device_id FROM al.al_pm_ct_dv_deviceappversionrollbackfrom20190101_d WHERE partition_day = REGEXP_REPLACE(date_sub(current_date(),2),'-',''))a
                ON m.device_id = a.device_id
            WHERE partition_date >= REGEXP_REPLACE(date_sub(current_date(),2),'-','')
              AND partition_date < regexp_replace(current_date ,'-','')
              AND active_type in (1,2,4)
              AND first_channel_source_type not in ('yqxiu1','yqxiu2','yqxiu3','yqxiu4','yqxiu5','mxyc1','mxyc2','mxyc3'
                       ,'wanpu','jinshan','jx','maimai','zhuoyi','huatian','suopingjingling','mocha','mizhe','meika','lamabang'
                       ,'js-az1','js-az2','js-az3','js-az4','js-az5','jfq-az1','jfq-az2','jfq-az3','jfq-az4','jfq-az5','toufang1'
                       ,'toufang2','toufang3','toufang4','toufang5','toufang6','TF-toufang1','TF-toufang2','TF-toufang3','TF-toufang4'
                       ,'TF-toufang5','tf-toufang1','tf-toufang2','tf-toufang3','tf-toufang4','tf-toufang5','benzhan','promotion_aso100'
                       ,'promotion_qianka','promotion_xiaoyu','promotion_dianru','promotion_malioaso','promotion_malioaso-shequ'
                       ,'promotion_shike','promotion_julang_jl03','promotion_zuimei')
              AND first_channel_source_type not like 'promotion\_jf\_%'
        )dev_channel
          on dev_channel.device_id = click.cl_id
            AND dev_channel.partition_date = click.partition_date
        LEFT JOIN
        (
            SELECT  device_id as cl_id
            FROM ml.ml_d_ct_dv_devicespam_d
            WHERE partition_day = REGEXP_REPLACE(date_sub(current_date(),1),'-','')
        )spam_pv
          on click.cl_id=spam_pv.cl_id
        WHERE spam_pv.cl_id IS NULL
        GROUP BY click.partition_date,active_type,device_os_type,channel
    )t6
      on t6.partition_date = t1.partition_date
        AND t6.active_type = t1.active_type
        AND t6.device_os_type = t1.device_os_type
        AND t6.channel = t1.channel
    full JOIN
    (
        --搜索结果综合页的点击,包括搜索框点击、tab切换、美购-查看更多按钮、百科-查看更多按钮、相关搜索
        SELECT
            page.partition_date as partition_date
            ,active_type
            ,device_os_type
            ,channel
            ,count(page.cl_id) as search_result_more_some_click_pv
            ,count(distinct page.cl_id) as search_result_more_some_click_uv
        FROM
        (
            SELECT cl_id,partition_date,params['page_name'] as page_name,app_version
            FROM online.bl_hdfs_maidian_updates
            WHERE partition_date >= REGEXP_REPLACE(date_sub(current_date(),2),'-','')
              AND partition_date < regexp_replace(current_date ,'-','')
              AND action='on_click_navbar_search'
              AND params['page_name'] = 'search_result_more'

            union all

            SELECT cl_id,partition_date,params['page_name'] as page_name,app_version
            FROM online.bl_hdfs_maidian_updates
            WHERE partition_date >= REGEXP_REPLACE(date_sub(current_date(),2),'-','')
              AND partition_date < regexp_replace(current_date ,'-','')
              AND action = 'search_result_more_click_more'
              AND params['page_name'] = 'search_result_more'
              AND params['business_type'] in ('service','wiki')

            union all

            SELECT cl_id,partition_date,'search_result_more' as page_name,app_version
            FROM online.bl_hdfs_maidian_updates
            WHERE partition_date >= REGEXP_REPLACE(date_sub(current_date(),2),'-','')
              AND partition_date < regexp_replace(current_date ,'-','')
              AND action in ('do_search','search_result_click_search')
              AND params['input_type'] = 'related_search'

            union all

            SELECT cl_id,partition_date,'search_result_more' as page_name,app_version
            FROM online.bl_hdfs_maidian_updates
            WHERE partition_date >= REGEXP_REPLACE(date_sub(current_date(),2),'-','')
              AND partition_date < regexp_replace(current_date ,'-','')
              AND action = 'search_result_click_tab'
              AND params['referrer_tab_name'] = '综合'
        )page
        JOIN
        (
            SELECT
                partition_date
                ,(case when active_type in (1,2) then '新增' when active_type = 4 then '老活' else NULL end) as active_type
                ,device_os_type
                ,m.device_id
                ,(CASE WHEN first_channel_source_type like '%xinyouxingkong%' or a.device_id is not NULL
                            or first_channel_source_type in ('promotion_aisi','promotion_koomobi_km00','promotion_koomobi_km01')
                            or first_channel_source_type like '%jingmeng%' or first_channel_source_type like '%longyuzhixing%'
                            or first_channel_source_type like '%mailuo%' THEN '可疑'
                        WHEN (partition_date>='20190601' and channel_ai.col2 = 'AI')
                                or (partition_date < '20200301' AND partition_date>='20190601' and first_channel_source_type like 'promotion_toutiao_jy%')
                                or (partition_date>='20200601' and ((first_channel_source_type like 'promotion_toutiao_jy%') or (first_channel_source_type like 'dyand%') or (first_channel_source_type like 'douyin%')))
                                THEN 'AI渠道'  ELSE '非AI渠道' END) as channel
            FROM online.ml_device_day_active_status m
             LEFT JOIN (SELECT col1,col2 FROM pm.tl_pm_ydl WHERE col3='0204_danlei_channel') channel_ai
                on first_channel_source_type = channel_ai.col1
            LEFT JOIN (SELECT DISTINCT device_id FROM al.al_pm_ct_dv_deviceappversionrollbackfrom20190101_d WHERE partition_day = REGEXP_REPLACE(date_sub(current_date(),2),'-',''))a
                ON m.device_id = a.device_id
            WHERE partition_date >= REGEXP_REPLACE(date_sub(current_date(),2),'-','')
              AND partition_date < regexp_replace(current_date ,'-','')
              AND active_type in (1,2,4)
              AND first_channel_source_type not in ('yqxiu1','yqxiu2','yqxiu3','yqxiu4','yqxiu5','mxyc1','mxyc2','mxyc3'
                       ,'wanpu','jinshan','jx','maimai','zhuoyi','huatian','suopingjingling','mocha','mizhe','meika','lamabang'
                       ,'js-az1','js-az2','js-az3','js-az4','js-az5','jfq-az1','jfq-az2','jfq-az3','jfq-az4','jfq-az5','toufang1'
                       ,'toufang2','toufang3','toufang4','toufang5','toufang6','TF-toufang1','TF-toufang2','TF-toufang3','TF-toufang4'
                       ,'TF-toufang5','tf-toufang1','tf-toufang2','tf-toufang3','tf-toufang4','tf-toufang5','benzhan','promotion_aso100'
                       ,'promotion_qianka','promotion_xiaoyu','promotion_dianru','promotion_malioaso','promotion_malioaso-shequ'
                       ,'promotion_shike','promotion_julang_jl03','promotion_zuimei')
              AND first_channel_source_type not like 'promotion\_jf\_%'
        )dev_channel
          on dev_channel.device_id = page.cl_id
            AND dev_channel.partition_date = page.partition_date
        LEFT JOIN
        (
            SELECT  device_id as cl_id
            FROM ml.ml_d_ct_dv_devicespam_d
            WHERE partition_day = REGEXP_REPLACE(date_sub(current_date(),1),'-','')
        )spam_pv
          on page.cl_id=spam_pv.cl_id
        WHERE spam_pv.cl_id IS NULL
        GROUP BY page.partition_date,active_type,device_os_type,channel
    )t7
      on t7.partition_date = t1.partition_date
        AND t7.active_type = t1.active_type
        AND t7.device_os_type = t1.device_os_type
        AND t7.channel = t1.channel
)t
ORDER BY `日期`,`平台`,`活跃类型`,`渠道类型`;

