package com.gmei.data.gateway.server.service.impl;

import com.gmei.data.gateway.server.common.Constants;
import com.gmei.data.gateway.server.dto.ExcelGenDto;
import com.gmei.data.gateway.server.service.*;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

/**
 * @ClassName BiReportServiceImpl
 * @Author apple
 * @Date 2020/4/30
 * @Version V1.0
 **/
@Service
public class BiReportServiceImpl implements BiReportService {

    @Autowired
    public EmailService emailService;
    @Autowired
    public ExcelService excelService;
    @Autowired
    public HivesqlService hivesqlService;
    @Autowired
    public SparksqlService sparksqlService;

    @Override
    public int execSql(String name){
        return sparksqlService.executeSql(name);
    }

    @Override
    public int execSqlByHive(String name){
        return hivesqlService.executeSql(name);
    }

    @Override
    public void email(String name, String to, String cc) throws Exception{
        ExcelGenDto resultDto = sparksqlService.getResult(name);
        if(null == resultDto){
            throw new Exception("获取查询结果失败，请核实!");
        }else{
            int genExcelRs = excelService.genExcel(resultDto,name);
            if(Constants.SUCCESS == genExcelRs){
                int rs = emailService.sendAttachmentsMail(to, cc, name);
                if(rs == Constants.FAIL){
                    throw new Exception("收件人或抄送人邮件地址有误，未完全发送成功，请核实!");
                }
            }
        }
    }

    @Override
    public int genExcel(String name){
        ExcelGenDto resultDto = sparksqlService.getResultDto(name);
        if(null == resultDto){
            return Constants.FAIL;
        }else{
            return excelService.genExcel(resultDto, name);
        }
    }

    @Override
    public int sendEmail(String to,String cc,String name){
        int rs = Constants.SUCCESS;
        ExcelGenDto resultDto = sparksqlService.getResultDto(name);
        if(null == resultDto){
            rs = Constants.FAIL;
        }else{
            int genExcelRs = excelService.genExcel(resultDto,name);
            if(Constants.SUCCESS == genExcelRs){
                try{
                    emailService.sendAttachmentsMail(to,cc,name);
                }catch (Exception e){
                    rs = Constants.FAIL;
                }
            }
        }
        return rs;
    }
}
