--***************************************************************
--*脚本名称:
--*功能: 方案灰度数据
--*业务名称: pm
--*输入数据:
--*作者: yindanlei@igengmei.com
--*更新时间:2020-07-24
--***************************************************************

--设置全局变量&UDF
SET mapreduce.job.queuename=data;

--使用bl数据库
USE pm;

--创建BL层内部表
CREATE TABLE IF NOT EXISTS pm.tl_pm_fangan_d
(
 day_id string comment '{"chs_name":"日期","description":"","etl":"","value":"","remark":""}',
 grey_type string comment '{"chs_name":"灰度类型","description":"","etl":"","value":"","remark":""}',
 DAU_730 BIGINT comment '{"chs_name":"7.30及以上版本DAU","description":"","etl":"","value":"","remark":""}',
 new_DAU BIGINT comment '{"chs_name":"新增DAU","description":"","etl":"","value":"","remark":""}',
 old_DAU BIGINT comment '{"chs_name":"老活DAU","description":"","etl":"","value":"","remark":""}',
 quanzhong_DAU BIGINT comment '{"chs_name":"权重日活","description":"","etl":"","value":"","remark":""}',
 liucun DOUBLE comment '{"chs_name":"次日留存率(%)","description":"","etl":"","value":"","remark":""}',
 wel_pv BIGINT comment '{"chs_name":"商详PV","description":"","etl":"","value":"","remark":""}',
 wel_uv BIGINT comment '{"chs_name":"商详UV","description":"","etl":"","value":"","remark":""}',
 pay_num BIGINT comment '{"chs_name":"支付订单数","description":"","etl":"","value":"","remark":""}',
 valid_dev_num BIGINT comment '{"chs_name":"有效线索设备数","description":"","etl":"","value":"","remark":""}',
 valid_pv BIGINT comment '{"chs_name":"有效线索人次","description":"","etl":"","value":"","remark":""}',
 true_valid_dev_num BIGINT comment '{"chs_name":"真实用户有效线索设备数","description":"","etl":"","value":"","remark":""}',
 true_valid_pv BIGINT comment '{"chs_name":"真实用户有效线索人次","description":"","etl":"","value":"","remark":""}'
)comment '方案灰度数据'
PARTITIONED BY (PARTITION_DAY STRING comment '分区日期')
ROW FORMAT DELIMITED
FIELDS TERMINATED BY '\t'
COLLECTION ITEMS TERMINATED BY '\002'
MAP KEYS TERMINATED BY '\003'
LINES TERMINATED BY '\n'
STORED AS TEXTFILE;