package com.gmei.jdbc;

import java.sql.*;
import java.util.List;

/**
 * ClassName: MysqlJdbcDim
 * Function:
 * Reason: 单例模式的码表层jdbc工具
 * Date: 2019/12/7 上午11:01
 *
 * @author liuzhe
 * @since JDK 1.8
 */
public class MysqlJdbcDim {
    private volatile static MysqlJdbcDim mysqlJdbcDim = null;

//    public static String driver = "com.mysql.cj.jdbc.Driver";
//    public static String url = "jdbc:mysql://localhost:3306/zhengxing?useSSL=false&serverTimezone=UTC";
//    //?useUnicode=true&characterEncoding=utf8&serverTimezone=GMT&allowMultiQueries=true&useSSL=false
//    public static String username = "jayden";
//    public static String password = "jayden548493";

//    private String driver = "com.mysql.jdbc.Driver";
//    private String url = "jdbc:mysql://172.22.30.12:3506/test?useUnicode=true&characterEncoding=UTF-8";//设置连接字符串
//    private String username = "work";
//    private String password = "zJnxVEhyyxeC7ciqxdMITVyWqOFc2mew";


    private String driver = "com.mysql.jdbc.Driver";
    private String url;
    private Connection conn;
    private PreparedStatement ps;

    private MysqlJdbcDim(String url) {
        this.url = url;
    }

    public static MysqlJdbcDim getInstance(String url) {
        if (mysqlJdbcDim == null) {
            synchronized (MysqlJdbcDim.class) {
                if(mysqlJdbcDim == null) {
                    mysqlJdbcDim = new MysqlJdbcDim(url);
                }
            }
        }
        return mysqlJdbcDim;
    }

    public Connection getConnection() {
        try {
            Class.forName(driver);
            if(conn == null || conn.isClosed()) {
//                conn = DriverManager.getConnection("jdbc:mysql://localhost:3306/zhengxing?useSSL=false&serverTimezone=UTC", "jayden", "jayden548943");
//                conn = DriverManager.getConnection(url, username, password);
                conn = DriverManager.getConnection(url);
            }
        } catch (ClassNotFoundException e) {
            e.printStackTrace();
        } catch (SQLException e) {
            e.printStackTrace();
        }
        return conn;
    }

    public void insert(String sql, List<Object> param) throws SQLException {
        ps = conn.prepareStatement(sql);
        if (param != null && param.size() > 0) {
            for (int i = 0; i < param.size(); i++) {
                ps.setObject(i + 1, param.get(i));
            }
        }
        ps.executeUpdate();
    }

    public void insert(String sql) throws SQLException {
        Statement st = null;
        st = conn.createStatement();
        st.executeUpdate(sql);
    }

    public ResultSet query(String sql, List<Object> param) {
        Statement st = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            ps = conn.prepareStatement(sql);

            if (param != null && param.size() > 0) {
                for (int i = 0; i < param.size(); i++) {
                    ps.setObject(i + 1, param.get(i));
                }
            }
            if(!ps.isClosed())
                System.out.println("Succeeded connecting to the prepareStatement!");
            rs = ps.executeQuery();
        } catch (SQLException e) {
            e.printStackTrace();
        }
        return rs;
    }

    public ResultSet query(String sql) {
        if(conn == null){
            conn = getConnection();
        }
        ResultSet rs = null;
        Statement st = null;
        try {

            st = conn.createStatement();
            rs = st.executeQuery(sql);
        } catch (SQLException e) {
            e.printStackTrace();
        }
        return rs;
    }

    public static void close(Connection con, Statement st, ResultSet rs) {
        if (rs != null) {
            try {
                rs.close();
            } catch (SQLException e) {
                e.printStackTrace();
            }
            if (st != null) {
                try {
                    st.close();
                } catch (SQLException e) {
                    e.printStackTrace();
                }
            }
            if (con != null) {
                try {
                    con.close();
                } catch (SQLException e) {
                    e.printStackTrace();
                }
            }
        }
    }
}
