package com.gmei.sink;

import com.gmei.bean.ml.MlPreciseExposureBean;
import org.apache.flink.core.io.SimpleVersionedSerializer;
import org.apache.flink.streaming.api.functions.sink.filesystem.BucketAssigner;
import org.apache.flink.streaming.api.functions.sink.filesystem.bucketassigners.SimpleVersionedStringSerializer;

/**
 * ClassName: DayBucketAssigner
 * Function:
 * Reason: 按照日期分区
 * Date: 2019/12/17 下午7:49
 *
 * @author liuzhe
 * @since JDK 1.8
 */
public class DayBucketAssigner implements BucketAssigner<MlPreciseExposureBean, String> {
    @Override
    public String getBucketId(MlPreciseExposureBean mlPreciseExposureBean, Context context) {
        String gm_nginx_time_day = mlPreciseExposureBean.getGm_nginx_time_day();
        return gm_nginx_time_day;
    }
    @Override
    public SimpleVersionedSerializer<String> getSerializer() {
        return SimpleVersionedStringSerializer.INSTANCE;
    }
}
