CREATE TABLE `dim_city` (
  `code` varchar(100) COMMENT '城市编码' PRIMARY KEY,
  `pk` varchar(100) COMMENT '城市TAGID' DEFAULT NULL,
  `name` varchar(100) COMMENT '城市名称' DEFAULT NULL,
  `memo` varchar(100) COMMENT '城市说明' DEFAULT NULL,
  `parent_province_code` varchar(100) COMMENT '省份编码' DEFAULT NULL,
  `parent_province_pk` varchar(100) COMMENT '省份TAGID' DEFAULT NULL,
  `parent_province_name` varchar(100) COMMENT '省份名称' DEFAULT NULL,
  `parent_province_memo` varchar(100) COMMENT '省份说明' DEFAULT NULL,
  `parent_country_code` varchar(100) COMMENT '国家编码' DEFAULT NULL,
  `parent_country_pk` varchar(100) COMMENT '国家TAGID' DEFAULT NULL,
  `parent_country_name` varchar(100) COMMENT '国家名称' DEFAULT NULL,
  `parent_country_memo` varchar(100) COMMENT '国家说明' DEFAULT NULL,
  `parent_region_code` varchar(100) COMMENT '区域编码' DEFAULT NULL,
  `parent_region_pk` varchar(100) COMMENT '区域ID' DEFAULT NULL,
  `parent_region_name` varchar(100) COMMENT '区域名称' DEFAULT NULL,
  `parent_region_memo` varchar(100) COMMENT '区域说明' DEFAULT NULL,
  `oid` int COMMENT '排序' DEFAULT NULL
) COMMENT '城市码表' ENGINE=InnoDB DEFAULT CHARSET=utf8mb4
;

CREATE TABLE `dim_page_type` (
  `code` varchar(100) COMMENT '页面编码' NOT NULL,
  `pk` varchar(100) COMMENT '页面主键' DEFAULT NULL,
  `name` varchar(100) COMMENT '页面名称' DEFAULT NULL,
  `memo` varchar(100) COMMENT '页面说明' DEFAULT NULL,
  `parent_app_code` varchar(100) COMMENT '上级APP编码',
  `parent_app_pk` varchar(100) COMMENT '上级APP主键' DEFAULT NULL,
  `parent_app_name` varchar(100) COMMENT '上级APP名称' DEFAULT NULL,
  `parent_app_memo` varchar(100) COMMENT '上级APP说明' DEFAULT NULL,
  `type_s_code` varchar(100) COMMENT '页面分类小类编码' DEFAULT NULL,
  `type_s_name` varchar(100) COMMENT '页面分类小类名称' DEFAULT NULL,
  `type_m_code` varchar(100) COMMENT '页面分类中类编码' DEFAULT NULL,
  `type_m_name` varchar(100) COMMENT '页面分类中类名称' DEFAULT NULL,
  `type_l_code` varchar(100) COMMENT '页面分类大类编码' DEFAULT NULL,
  `type_l_name` varchar(100) COMMENT '页面分类大类名称' DEFAULT NULL,
  `oid` int COMMENT '排序' DEFAULT NULL,
  PRIMARY KEY (`code`,`parent_app_code`)
) COMMENT '页面分类码表' ENGINE=InnoDB DEFAULT CHARSET=utf8mb4
;

CREATE TABLE `dim_card_content_type` (
  `code` varchar(100) COMMENT '编码' PRIMARY KEY,
  `pk` varchar(100) COMMENT '主键' DEFAULT NULL,
  `name` varchar(100) COMMENT '名称' DEFAULT NULL,
  `memo` varchar(100) COMMENT '说明' DEFAULT NULL,
  `new_code` varchar(100) COMMENT '转换后编码' DEFAULT NULL,
  `oid` int COMMENT '排序' DEFAULT NULL
) COMMENT '卡片内容类型码表' ENGINE=InnoDB DEFAULT CHARSET=utf8mb4
;

CREATE TABLE `dim_card_type` (
  `code` varchar(100) COMMENT '编码' PRIMARY KEY,
  `pk` varchar(100) COMMENT '主键' DEFAULT NULL,
  `name` varchar(100) COMMENT '名称' DEFAULT NULL,
  `memo` varchar(100) COMMENT '说明' DEFAULT NULL,
  `new_code` varchar(100) COMMENT '转换后编码' DEFAULT NULL,
  `oid` int COMMENT '排序' DEFAULT NULL
) COMMENT '卡片类型码表' ENGINE=InnoDB DEFAULT CHARSET=utf8mb4
;

CREATE TABLE `dim_transaction_type` (
  `code` varchar(100) COMMENT '编码' PRIMARY KEY,
  `pk` varchar(100) COMMENT '主键' DEFAULT NULL,
  `name` varchar(100) COMMENT '名称' DEFAULT NULL,
  `memo` varchar(100) COMMENT '说明' DEFAULT NULL,
  `oid` int COMMENT '排序' DEFAULT NULL
) COMMENT '业务类型码表' ENGINE=InnoDB DEFAULT CHARSET=utf8mb4
;

CREATE TABLE `bl_et_mg_preciseexposure_inc_d_rt` (
  `day_id` date DEFAULT NULL COMMENT '账期日',
  `json` longtext COMMENT '原始JSON',
  `gm_nginx_timestamp` varchar(50) DEFAULT NULL COMMENT '接受日志时间戳',
  `create_timestamp` varchar(50) DEFAULT NULL COMMENT '创建日志时间戳',
  `user_id` varchar(20) DEFAULT NULL COMMENT '用户ID',
  `action` varchar(30) DEFAULT NULL COMMENT '事件接口',
  `down_loading_times` int(11) DEFAULT NULL COMMENT '下拉加载次数',
  `down_slide_times` int(11) DEFAULT NULL COMMENT '下拉滑动次数',
  `up_loading_times` int(11) DEFAULT NULL COMMENT '上拉加载次数',
  `up_slide_times` int(11) DEFAULT NULL COMMENT '上拉滑动次数',
  `page_code` varchar(50) DEFAULT NULL COMMENT '页面编码',
  `tab_name` varchar(50) DEFAULT NULL COMMENT 'TAB名称',
  `business_id` varchar(50) DEFAULT NULL COMMENT '业务ID',
  `referrer_code` varchar(50) DEFAULT NULL COMMENT '来源页编码',
  `referrer_id` varchar(50) DEFAULT NULL COMMENT '来源页业务ID',
  `exposure_cards` longtext COMMENT '卡片列表',
  `is_exposure` varchar(20) DEFAULT NULL COMMENT '是否精准曝光',
  `is_popup` varchar(20) DEFAULT NULL COMMENT '是否弹窗',
  `filter` varchar(50) DEFAULT NULL COMMENT '筛选器',
  `query` varchar(200) DEFAULT NULL COMMENT '搜索词',
  `app_grey_type` longtext DEFAULT NULL COMMENT '灰度列表',
  `app_channel` varchar(20) DEFAULT NULL COMMENT 'APP渠道',
  `app_version` varchar(20) DEFAULT NULL COMMENT 'APP版本',
  `app_current_city_id` varchar(20) DEFAULT NULL COMMENT '当前城市ID',
  `app_code` varchar(20) DEFAULT NULL COMMENT 'APP编码',
  `device_os_type` varchar(200) DEFAULT NULL COMMENT '设备系统类型',
  `device_model` varchar(200) DEFAULT NULL COMMENT '设备型号',
  `device_id` varchar(50) DEFAULT NULL COMMENT '设备ID',
  `device_android_id` varchar(50) DEFAULT NULL COMMENT '设备安卓ID',
  `device_idfv` varchar(50) DEFAULT NULL COMMENT '设备IDFV',
  `gm_nginx_time_date` varchar(30) DEFAULT NULL COMMENT '日志接收时间',
  `gm_nginx_time_day` varchar(30) DEFAULT NULL COMMENT '日志接收日期',
  `create_time_date` varchar(30) DEFAULT NULL COMMENT '日志创建时间',
  `create_time_day` varchar(30) DEFAULT NULL COMMENT '日志创建日期',
  KEY `idx_bl_preciseexposure` (`day_id`,`page_code`,`referrer_code`,`app_channel`,`app_version`,`app_current_city_id`,`device_os_type`)
) COMMENT='BL层精准曝光实时表' ENGINE=InnoDB DEFAULT CHARSET=utf8mb4
;

CREATE TABLE `ml_c_et_pe_preciseexposure_dimen_d_rt` (
  `day_id` date DEFAULT NULL COMMENT '账期日',
  `user_id` varchar(20) DEFAULT NULL COMMENT '用户ID',
  `action` varchar(30) DEFAULT NULL COMMENT '事件接口',
  `page_code` varchar(50) DEFAULT NULL COMMENT '页面编码',
  `page_name` varchar(50) DEFAULT NULL COMMENT '页面名称',
  `tab_name` varchar(50) DEFAULT NULL COMMENT 'TAB名称',
  `business_id` varchar(50) DEFAULT NULL COMMENT '业务ID',
  `referrer_code` varchar(50) DEFAULT NULL COMMENT '来源页编码',
  `referrer_name` varchar(50) DEFAULT NULL COMMENT '来源页名称',
  `referrer_id` varchar(50) DEFAULT NULL COMMENT '来源页业务ID',
  `card_id` varchar(100) DEFAULT NULL COMMENT '卡片ID',
  `card_name` varchar(200) DEFAULT NULL COMMENT '卡片名称',
  `card_content_type` varchar(50) DEFAULT NULL COMMENT '卡片内容类型',
  `card_content_type_name` varchar(50) DEFAULT NULL COMMENT '卡片内容类型名称',
  `card_type` varchar(50) DEFAULT NULL COMMENT '卡片类型',
  `card_type_name` varchar(50) DEFAULT NULL COMMENT '卡片类型',
  `is_cpc` varchar(20) DEFAULT NULL COMMENT '是否CPC',
  `cpc_referer` varchar(50) DEFAULT NULL COMMENT 'CPC来源',
  `transaction_type` varchar(50) DEFAULT NULL COMMENT '业务类型',
  `transaction_type_name` varchar(50) DEFAULT NULL COMMENT '业务类型名称',
  `filter` varchar(50) DEFAULT NULL COMMENT '筛选器',
  `query` varchar(200) DEFAULT NULL COMMENT '搜索词',
  `app_version` varchar(20) DEFAULT NULL COMMENT 'APP版本',
  `current_city_id` varchar(20) DEFAULT NULL COMMENT '当前城市ID',
  `current_city_name` varchar(20) DEFAULT NULL COMMENT '当前城市名称',
  `current_province_id` varchar(20) DEFAULT NULL COMMENT '当前省份ID',
  `current_province_name` varchar(20) DEFAULT NULL COMMENT '当前省份名称',
  `current_country_id` varchar(20) DEFAULT NULL COMMENT '当前国家ID',
  `current_country_name` varchar(20) DEFAULT NULL COMMENT '当前国家名称',
  `current_region_id` varchar(20) DEFAULT NULL COMMENT '当前区域ID',
  `current_region_name` varchar(20) DEFAULT NULL COMMENT '当前区域名称',
  `app_code` varchar(20) DEFAULT NULL COMMENT 'APP编码',
  `device_os_type` varchar(20) DEFAULT NULL COMMENT '设备系统类型',
  `device_id` varchar(50) DEFAULT NULL COMMENT '设备ID',
  `create_time_day` varchar(30) DEFAULT NULL COMMENT '日志创建时间',
  `gm_nginx_time_day` varchar(30) DEFAULT NULL COMMENT '日志接收时间',
  `preciseexposure_num` int(11) DEFAULT NULL COMMENT '精准曝光数量',
  KEY `idx_ml_preciseexposure` (`day_id`,`page_code`,`page_name`,`referrer_code`,`referrer_name`,`card_content_type`,`card_content_type_name`,`card_type`,`card_type_name`,`transaction_type`,`transaction_type_name`,`current_city_id`,`device_os_type`)
) COMMENT='ML层精准曝光实时表' ENGINE=InnoDB DEFAULT CHARSET=utf8mb4
;

CREATE TABLE `ml_c_et_pe_preciseexposuredetail_dimen_d_rt` (
  `day_id` date DEFAULT NULL COMMENT '账期日',
  `user_id` varchar(20) DEFAULT NULL COMMENT '用户ID',
  `action` varchar(30) DEFAULT NULL COMMENT '事件接口',
  `page_code` varchar(50) DEFAULT NULL COMMENT '页面编码',
  `page_name` varchar(50) DEFAULT NULL COMMENT '页面名称',
  `tab_name` varchar(50) DEFAULT NULL COMMENT 'TAB名称',
  `business_id` varchar(50) DEFAULT NULL COMMENT '业务ID',
  `referrer_code` varchar(50) DEFAULT NULL COMMENT '来源页编码',
  `referrer_name` varchar(50) DEFAULT NULL COMMENT '来源页名称',
  `referrer_id` varchar(50) DEFAULT NULL COMMENT '来源页业务ID',
  `card_id` varchar(100) DEFAULT NULL COMMENT '卡片ID',
  `card_name` varchar(200) DEFAULT NULL COMMENT '卡片名称',
  `card_content_type` varchar(50) DEFAULT NULL COMMENT '卡片内容类型',
  `card_content_type_name` varchar(50) DEFAULT NULL COMMENT '卡片内容类型名称',
  `card_type` varchar(50) DEFAULT NULL COMMENT '卡片类型',
  `card_type_name` varchar(50) DEFAULT NULL COMMENT '卡片类型',
  `is_cpc` varchar(20) DEFAULT NULL COMMENT '是否CPC',
  `cpc_referer` varchar(50) DEFAULT NULL COMMENT 'CPC来源',
  `transaction_type` varchar(50) DEFAULT NULL COMMENT '业务类型',
  `transaction_type_name` varchar(50) DEFAULT NULL COMMENT '业务类型名称',
  `filter` varchar(50) DEFAULT NULL COMMENT '筛选器',
  `query` varchar(200) DEFAULT NULL COMMENT '搜索词',
  `app_version` varchar(20) DEFAULT NULL COMMENT 'APP版本',
  `current_city_id` varchar(20) DEFAULT NULL COMMENT '当前城市ID',
  `current_city_name` varchar(20) DEFAULT NULL COMMENT '当前城市名称',
  `current_province_id` varchar(20) DEFAULT NULL COMMENT '当前省份ID',
  `current_province_name` varchar(20) DEFAULT NULL COMMENT '当前省份名称',
  `current_country_id` varchar(20) DEFAULT NULL COMMENT '当前国家ID',
  `current_country_name` varchar(20) DEFAULT NULL COMMENT '当前国家名称',
  `current_region_id` varchar(20) DEFAULT NULL COMMENT '当前区域ID',
  `current_region_name` varchar(20) DEFAULT NULL COMMENT '当前区域名称',
  `app_code` varchar(20) DEFAULT NULL COMMENT 'APP编码',
  `device_os_type` varchar(20) DEFAULT NULL COMMENT '设备系统类型',
  `device_id` varchar(50) DEFAULT NULL COMMENT '设备ID',
  `create_time_date` varchar(30) DEFAULT NULL COMMENT '日志创建时间',
  `create_time_day` varchar(30) DEFAULT NULL COMMENT '日志创建日期',
  `gm_nginx_time_date` varchar(30) DEFAULT NULL COMMENT '日志接收时间',
  `gm_nginx_time_day` varchar(30) DEFAULT NULL COMMENT '日志接收日期',
  `preciseexposure_num` int(11) DEFAULT NULL COMMENT '精准曝光数量',
  KEY `idx_ml_preciseexposure` (`day_id`,`page_code`,`page_name`,`referrer_code`,`referrer_name`,`card_content_type`,`card_content_type_name`,`card_type`,`card_type_name`,`transaction_type`,`transaction_type_name`,`current_city_id`,`device_os_type`)
) COMMENT='ML层精准曝光明细实时表' ENGINE=InnoDB DEFAULT CHARSET=utf8mb4
;

SELECT t1.CODE,
       t1.pk,
       t1.NAME,
       t1.memo,
       t1.parent_app_code,
       t1.parent_app_pk,
       t2.NAME parent_app_name,
       t2.memo parent_app_memo,
       t1.type_l_code,
       t1.type_l_name,
       t1.type_m_code,
       t1.type_m_name,
       t1.type_s_code,
       t1.type_s_name,
       t1.oid
  FROM dim.dim_page_type t1
	LEFT JOIN dim.dim_app_name t2
	  ON t1.parent_app_code = t2.CODE;

SELECT t1.CODE,
       t1.pk,
       t1.NAME,
       t1.memo,
       t1.parent_code parent_province_code,
       t1.parent_pk parent_province_pk,
       t2.NAME parent_province_name,
       t2.memo parent_province_memo,
       t2.parent_country_code,
       t2.parent_country_pk,
       t3.NAME parent_country_name,
       t3.memo parent_country_memo,
       t2.parent_region_code,
       t2.parent_region_pk,
       t4.NAME parent_region_name,
       t4.memo parent_region_memo,
       t1.oid
  FROM dim.dim_city t1
	LEFT JOIN dim.dim_province t2
    ON t1.parent_code = t2.CODE
	LEFT JOIN dim.dim_country t3
	  ON t2.parent_country_code = t3.CODE
	LEFT JOIN dim.dim_region t4
	  ON t2.parent_region_code = t4.CODE;