package com.gmei.utils;

import java.text.SimpleDateFormat;
import java.util.Date;

/**
 * ClassName: DateUtil
 * Function:
 * Reason: 日期格式工具类
 * Date: 2019/12/17 下午4:51
 *
 * @author liuzhe
 * @since JDK 1.8
 */
public class DateUtil {

    static SimpleDateFormat secDate = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    static SimpleDateFormat dayDate = new SimpleDateFormat("yyyyMMdd");
    static SimpleDateFormat day_idDate = new SimpleDateFormat("yyyy-MM-dd");

    public enum DateType {
        DAY,
        SECOND,
        DAY_ID;
    }

    /**
    * Function: timestampFormat.
     * DAY:yyyyMMdd
     * SECOND:yyyy-MM-dd HH:mm:ss
    * Reason: timestamp时间戳格式化.
    * Date: 2019/12/25 下午4:43
    *
    * @author liuzhe
    * @since JDK 1.8
    */
    public static String timestampFormat(String timestamp, DateType type) {
        Double timestampDouble = Double.parseDouble(timestamp);
        Long timestampLong = new Double(timestampDouble * 1000).longValue();
        Date date= new Date(timestampLong);
        switch (type) {
            case DAY:
                return dayDate.format(date);
            case SECOND:
                return secDate.format(date);
            case DAY_ID:
                return day_idDate.format(date);
            default:
                return null;
        }
    }

    public static Date stringToDate(String timestamp) {
        Double timestampDouble = Double.parseDouble(timestamp);
        Long timestampLong = new Double(timestampDouble * 1000).longValue();
        Date date= new Date(timestampLong);
        return date;
    }
}
