package com.gmei.etl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.gmei.bean.bl.BlPreciseExposureBean;
import com.gmei.bean.bl.BlPreciseExposureParamsExposureCardsBean;
import com.gmei.utils.BeanReflectUtil;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.DeserializationFeature;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.ObjectMapper;
import org.junit.Test;

import java.io.IOException;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;

/**
 * ClassName: BlPreciseExposureEtl
 * Function: TODO ADD FUNCTION.
 * Reason: TODO ADD REASON.
 * Date: 2019/12/4 下午4:58
 *
 * @author liuzhe
 * @since JDK 1.8
 */
public class BlPreciseExposureEtl implements Serializable {

    /**
    * Function: 废弃.
    * Reason: TODO ADD REASON.
    * Date: 2019/12/7 下午7:54
    *
    * @author liuzhe
    * @since JDK 1.8
    */
    public BlPreciseExposureBean getBlPreciseExposureBeanJackJson(String string) throws IOException {
        ObjectMapper mapper = new ObjectMapper();
//        System.out.println(string);

//        JsonNode jsonNode = mapper.readTree(string);
//        JsonNode jsonNode = mapper.readTree(string);
//        String data = jsonNode.findValue("@raw").asText();
        mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);

        BlPreciseExposureBean blPreciseExposureBean = mapper.readValue(string, BlPreciseExposureBean.class);
//        mapper.readValue()
//        System.out.println(blPreciseExposureBean.toString());

        return blPreciseExposureBean;
    }

    /**
    * Function: mapBlPreciseExposureBean
    * Reason: map一对一
    * Date: 2019/12/7 下午7:56
    *
    * @author liuzhe
    * @since JDK 1.8
    */
    public BlPreciseExposureBean mapBlPreciseExposureBean(String string) throws Exception {
        BlPreciseExposureBean blPreciseExposureBean = new BlPreciseExposureBean();
        JSONObject jsonObject = JSON.parseObject(string);

        //一级别JSON
        JSONObject app = jsonObject.getJSONObject("app");
        String gm_nginx_timestamp = String.valueOf(jsonObject.get("gm_nginx_timestamp"));
        String create_timestamp = String.valueOf(jsonObject.get("create_at"));
        String user_id = jsonObject.getString("user_id");
        String action = jsonObject.getString("type");

        //二级别JSON
        //APP
        String app_grey_type = app.getString("grey_type");
        String app_channel = app.getString("channel");
        String app_version = app.getString("version");
        String app_current_city_id= app.getString("current_city_id");
        String app_code = app.getString("name");

        //1.2 absolute_position参数类型不完整
        //问题描述：在'7.7.35', '7.7.36', '7.7.40'params的absolute_position缺少左边引号
        String paramsString = String.valueOf(jsonObject.get("params"));
        if("7.7.35".equals(app_version) || "7.7.36".equals(app_version) || "7.7.40".equals(app_version)) {
            paramsString = paramsString.replace("absolute_position","\\\"absolute_position");
        }

        //PARAMS
        JSONObject params =  JSON.parseObject(paramsString);
        Integer down_loading_times = params.getInteger("down_loading_times");
        Integer down_slide_times = params.getInteger("down_slide_times");
        Integer up_loading_times = params.getInteger("up_loading_times");
        Integer up_slide_times = params.getInteger("up_slide_times");
        String page_code = params.getString("page_name");
        String tab_name = params.getString("tab_name");
        String business_id = params.getString("business_id");
        String referrer_code = params.getString("referrer");
        String referrer_id = params.getString("referrer_id");

        //1.4 初版精准曝光格式错误
        //问题描述：在'7.7.60'版本中美购页卡片的card_id和transaction_type这两个参数是数组的形式
//        ArrayList<BlPreciseExposureParamsExposureCardsBean> exposure_cards =(ArrayList<BlPreciseExposureParamsExposureCardsBean>)JSONArray.parseArray(params.getJSONArray("exposure_cards").toString(), BlPreciseExposureParamsExposureCardsBean.class);
        ArrayList<BlPreciseExposureParamsExposureCardsBean> exposure_cards = new ArrayList<>();
        JSONArray jsonArray = JSONArray.parseArray(params.getJSONArray("exposure_cards").toString());
        for (int i = 0; i < jsonArray.size(); i++) {
            JSONObject jsonCard = jsonArray.getJSONObject(i);
            String card_id = jsonCard.getString("card_id");
            String transaction_type = jsonCard.getString("transaction_type");
            String card_content_type = jsonCard.getString("card_content_type");
            if("service".equals(card_content_type) && "7.7.60".equals(app_version)) {
                JSONArray card_id_list = JSONArray.parseArray(card_id);
                JSONArray transaction_type_list = JSONArray.parseArray(transaction_type);
                for (int j = 0; j < card_id_list.size(); j++) {
                    BlPreciseExposureParamsExposureCardsBean cardsBean = new BlPreciseExposureParamsExposureCardsBean();
                    cardsBean.setCard_id(card_id_list.getString(j));
                    cardsBean.setTransaction_type(transaction_type_list.getString(j));
                    cardsBean.setCard_content_type(card_content_type);
                    cardsBean.setCard_type(jsonCard.getString("card_type"));
                    cardsBean.setIs_cpc(jsonCard.getString("is_cpc"));
                    cardsBean.setCpc_referer(jsonCard.getString("cpc_referer"));
                    cardsBean.setAbsolute_position(jsonCard.getString("absolute_position"));
                    cardsBean.setRelative_position(jsonCard.getString("relative_position"));
                    exposure_cards.add(cardsBean);
                }
            } else {
                BlPreciseExposureParamsExposureCardsBean cardsBean = JSON.toJavaObject(jsonCard, BlPreciseExposureParamsExposureCardsBean.class);
                exposure_cards.add(cardsBean);
            }
        }

        String is_exposure = params.getString("is_exposure");
        String filter = params.getString("filter");
        String query = params.getString("query");

        //DEVICE
        JSONObject device = jsonObject.getJSONObject("device");
        String device_os_type = device.getString("device_type");
        String device_model = device.getString("model");
        String device_id = device.getString("device_id");
        String device_idfv = device.getString("idfv");
        String device_android_id = device.getString("android_device_id");


        //1.1 ios系统精准曝光埋点channel字段
        //问题描述：ios系统精准曝光埋点channel字段AppStore应该修改为App Store
        if("AppStore".equals(app_channel)) {
            app_channel = "App Store";
        }

        //日志时间处理
        SimpleDateFormat secDate = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        SimpleDateFormat dayDate = new SimpleDateFormat("yyyyMMdd");
        Double gm_nginx_timestampDouble = Double.parseDouble(gm_nginx_timestamp);
        Long gm_nginx_timestampLong = new Double(gm_nginx_timestampDouble * 1000).longValue();
        Date gmDate= new Date(gm_nginx_timestampLong);
        Date createDate= new Date(Long.parseLong(create_timestamp) * 1000);
        String gm_nginx_time_date = secDate.format(gmDate);
        String gm_nginx_time_day = dayDate.format(gmDate);
        String create_time_date = secDate.format(createDate);
        String create_time_day = dayDate.format(createDate);

        //1.7 result_status参数位置问题(未处理)
        //问题描述：搜索结果百科（search_result_wiki)和搜索结果美购（search_result_welfare）的result_status埋点埋在exposure_data里面了为了都获得该参数值，因此需要从两处拿取，默认先取exposure_data里的result_satus字段值（数据中发现不只是这两个页面）search_result_diary、search_result_doctor、search_result_hospital也存在

        //1.9 搜索结果页tab_name参数不该存在
        //问题描述:在搜索结果页出现tab_name参数，参数值和page_name一样，在点击的时候页面有跳转，因此，不应该有tab_name参数
        if (page_code.contains("search_result")) {
            tab_name = null;
        }

        blPreciseExposureBean.setGm_nginx_timestamp(gm_nginx_timestamp);
        blPreciseExposureBean.setCreate_timestamp(create_timestamp);
        blPreciseExposureBean.setUser_id(user_id);
        blPreciseExposureBean.setAction(action);
        blPreciseExposureBean.setApp_grey_type(app_grey_type);
        blPreciseExposureBean.setApp_channel(app_channel);
        blPreciseExposureBean.setApp_version(app_version);
        blPreciseExposureBean.setApp_current_city_id(app_current_city_id);
        blPreciseExposureBean.setApp_code(app_code);
        blPreciseExposureBean.setDown_loading_times(down_loading_times);
        blPreciseExposureBean.setDown_slide_times(down_slide_times);
        blPreciseExposureBean.setUp_loading_times(up_loading_times);
        blPreciseExposureBean.setUp_slide_times(up_slide_times);
        blPreciseExposureBean.setPage_code(page_code);
        blPreciseExposureBean.setTab_name(tab_name);
        blPreciseExposureBean.setBusiness_id(business_id);
        blPreciseExposureBean.setReferrer_code(referrer_code);
        blPreciseExposureBean.setReferrer_id(referrer_id);
        blPreciseExposureBean.setExposure_cards(exposure_cards);
        blPreciseExposureBean.setIs_exposure(is_exposure);
        blPreciseExposureBean.setFilter(filter);
        blPreciseExposureBean.setQuery(query);
        blPreciseExposureBean.setDevice_os_type(device_os_type);
        blPreciseExposureBean.setDevice_model(device_model);
        blPreciseExposureBean.setDevice_id(device_id == null|| device_id =="" ? device_id : device_idfv);
        blPreciseExposureBean.setDevice_android_id(device_android_id);
        blPreciseExposureBean.setDevice_idfv(device_idfv);
        blPreciseExposureBean.setGm_nginx_time_date(gm_nginx_time_date);
        blPreciseExposureBean.setGm_nginx_time_day(gm_nginx_time_day);
        blPreciseExposureBean.setCreate_time_date(create_time_date);
        blPreciseExposureBean.setCreate_time_day(create_time_day);
        return BeanReflectUtil.setNullValue(blPreciseExposureBean);
    }

    /**
    * Function: filterBlPreciseExposureBean
    * Reason: 筛选数据
    * Date: 2019/12/7 下午7:57
    *
    * @author liuzhe
    * @since JDK 1.8
    */
    public Boolean filterBlPreciseExposureBean(BlPreciseExposureBean blPreciseExposureBean) throws Exception {

        String app_code = blPreciseExposureBean.getApp_code();
        String is_exposure = blPreciseExposureBean.getIs_exposure();
        String app_version = blPreciseExposureBean.getApp_version();
        String page_code = blPreciseExposureBean.getPage_code();

        //清洗掉app_code不等于gengmei_user与is_exposure不等于1的

        //1.5 Home页精准曝光触发两次
        //问题描述：在7.7.70','7.7.71','7.7.72','7.7.75','7.7.76','7.8.0','7.8.1' (7.7.70--7.9.0)版本中的首页精准曝光会触发两次，经确认，需要去除page_name='home'
        //1.6 品类聚合页的精准曝光问题
        //问题描述：品类聚合页的精准曝光没做，但是数据中却有精准曝光、而且有问题，因此过滤掉，目前还不能确定什么版本可以解决，先暂时根据page_name过滤掉page_name='category'

        List<String> app_version_list = Arrays.asList("7.7.70","7.7.71","7.7.72","7.7.75","7.7.76","7.8.0","7.8.1");
        String[] version = app_version.split(".");
        if(!"gengmei_user".equals(app_code) || !"1".equals(is_exposure)) {
            return false;
        } else if(app_version_list.contains(app_version) && "home".equals(page_code)) {
            return false;
        } else if("category".equals(page_code) && "7".equals(version[0]) && Integer.parseInt(version[1]) < 14 ) {
            return false;
        }
        return true;
    }

    @Test
    public void getBlPreciseExposureBeanTest() {
        BlPreciseExposureEtl blPreciseExposureEtl = new BlPreciseExposureEtl();
//        String json = "{\"create_at\":\"1575134961\",\"gm_nginx_timestamp\":1575134961.718,\"user_id\":\"31665831\",\"version\":\"110\",\"params\":{\"down_loading_times\":0,\"up_slide_times\":0,\"is_popup\":\"0\",\"exposure_cards\":[{\"absolute_position\":\"0\",\"transaction_type\":\"\",\"card_content_type\":\"function_entrance\",\"relative_position\":\"0\",\"card_id\":2},{\"absolute_position\":\"1\",\"transaction_type\":\"\",\"card_content_type\":\"function_entrance\",\"relative_position\":\"1\",\"card_id\":2},{\"absolute_position\":\"2\",\"transaction_type\":\"\",\"card_content_type\":\"function_entrance\",\"relative_position\":\"2\",\"card_id\":2},{\"absolute_position\":\"3\",\"transaction_type\":\"\",\"card_content_type\":\"function_entrance\",\"relative_position\":\"3\",\"card_id\":2},{\"absolute_position\":\"4\",\"transaction_type\":\"\",\"card_content_type\":\"function_entrance\",\"relative_position\":\"4\",\"card_id\":2}],\"tab_name\":\"\",\"down_slide_times\":0,\"page_name\":\"home\",\"up_loading_times\":0,\"is_exposure\":\"1\",\"referrer\":\"\",\"business_id\":\"\",\"referrer_id\":\"\"},\"app_session_id\":\"FE675C8B-4FD4-4FC6-9EC7-415F715A750B\",\"app\":{\"version\":\"7.18.2\",\"grey_type\":\"{\\\"report_result\\\":0,\\\"face_detect_result\\\":\\\"B\\\",\\\"home\\\":\\\"0\\\",\\\"post_detail\\\":\\\"0\\\",\\\"video_steep\\\":1,\\\"face_scan\\\":0}\",\"current_city_id\":\"nanjing\",\"name\":\"gengmei_user\",\"user_type\":{\"config_type\":1},\"serial_id\":12,\"channel\":\"AppStore\"},\"gm_nginx_key\":1,\"device\":{\"idfv\":\"5F193A07-781F-4EF1-86B4-452251307081\",\"sys_version\":\"13.2.3\",\"lng\":118.93133562169,\"is_WiFi\":\"0\",\"manufacturer\":\"Apple\",\"device_id\":\"F88745FE-DF54-4639-B7E2-28554C7DFAAF\",\"device_type\":\"ios\",\"ip\":\"10.190.42.125\",\"idfa\":\"F88745FE-DF54-4639-B7E2-28554C7DFAAF\",\"lat\":32.121287439102,\"model\":\"iPhone8,2\"},\"type\":\"page_precise_exposure\"}";
//        String json = "{\"gm_nginx_key\":1,\"version\":\"205\",\"params\":{\"up_slide_times\":\"2\",\"down_loading_times\":\"0\",\"exposure_cards\":\"[{\\\"card_id\\\":\\\"16449302\\\",\\\"card_source_type\\\":\\\"doris\\\",\\\"card_content_type\\\":\\\"diary\\\",\\\"card_type\\\":\\\"card\\\",absolute_position\\\":\\\"0\\\",\\\"relative_position\\\":\\\"0\\\"}]\",\"up_loading_times\":\"0\",\"is_exposure\":\"1\",\"tab_name\":\"精选\",\"page_name\":\"home\",\"business_id\":\"\",\"referrer\":\"\",\"referrer_id\":\"\",\"down_slide_times\":\"1\"},\"app_session_id\":\"f3d24a27-27f0-4545-b132-51030765cf49\",\"gm_nginx_timestamp\":1546307958.444,\"create_at\":\"1546307958\",\"type\":\"home_choiceness_card_exposure\",\"device\":{\"is_WiFi\":\"1\",\"ip\":\"192.168.1.100\",\"manufacturer\":\"vivo\",\"device_type\":\"android\",\"lat\":\"0.0\",\"device_id\":\"863208034156179\",\"lng\":\"0.0\"},\"app\":{\"channel\":\"vivo\",\"user_type\":{\"config_type\":\"1\"},\"serial_id\":6,\"current_city_id\":\"worldwide\",\"name\":\"gengmei_user\",\"version\":\"7.7.36\"},\"user_id\":\"\"}";
        String json = "{\"create_at\":\"1576128422\",\"gm_nginx_timestamp\":1576128422.463,\"user_id\":\"31038796\",\"version\":\"110\",\"params\":{\"down_loading_times\":1,\"up_slide_times\":5,\"exposure_cards\":[{\"absolute_position\":0,\"result_status\":\"1\",\"card_content_type\":\"service\",\"transaction_type\":\"[\\\"-1\\\",\\\"-1\\\",\\\"-1\\\"]\",\"card_type\":\"card\",\"card_source_type\":\"[\\\"\\\",\\\"\\\",\\\"\\\"]\",\"relative_position\":0,\"card_id\":\"[\\\"5821997\\\",\\\"5762189\\\",\\\"5671097\\\"]\"},{\"absolute_position\":1,\"card_content_type\":\"wiki_collect\",\"card_type\":\"card\",\"relative_position\":1,\"wiki_word\":{},\"card_id\":\"127\"},{\"absolute_position\":2,\"transaction_type\":\"\",\"card_type\":\"card\",\"card_content_type\":\"diary\",\"relative_position\":3,\"card_id\":\"15337295\"},{\"absolute_position\":3,\"transaction_type\":\"\",\"card_type\":\"card\",\"card_content_type\":\"diary\",\"relative_position\":4,\"card_id\":\"15635897\"},{\"absolute_position\":4,\"transaction_type\":\"\",\"card_type\":\"card\",\"card_content_type\":\"diary\",\"relative_position\":5,\"card_id\":\"16082820\"},{\"absolute_position\":4,\"transaction_type\":\"\",\"card_type\":\"card\",\"card_content_type\":\"diary\",\"relative_position\":5,\"card_id\":\"16082820\"},{\"absolute_position\":5,\"transaction_type\":\"\",\"card_type\":\"card\",\"card_content_type\":\"answer\",\"relative_position\":4,\"card_id\":\"699299\"},{\"absolute_position\":6,\"transaction_type\":\"\",\"card_type\":\"card\",\"card_content_type\":\"article\",\"relative_position\":5,\"card_id\":\"19589790\"},{\"absolute_position\":7,\"transaction_type\":\"\",\"card_type\":\"card\",\"card_content_type\":\"diary\",\"relative_position\":6,\"card_id\":\"15764401\"},{\"absolute_position\":8,\"transaction_type\":\"\",\"card_type\":\"card\",\"card_content_type\":\"diary\",\"relative_position\":4,\"card_id\":\"15633799\"},{\"absolute_position\":9,\"transaction_type\":\"\",\"card_type\":\"card\",\"card_content_type\":\"diary\",\"relative_position\":5,\"card_id\":\"16622540\"},{\"absolute_position\":10,\"transaction_type\":\"\",\"card_type\":\"card\",\"card_content_type\":\"answer\",\"relative_position\":6,\"card_id\":\"699573\"},{\"absolute_position\":11,\"transaction_type\":\"\",\"card_type\":\"card\",\"card_content_type\":\"answer\",\"relative_position\":4,\"card_id\":\"686812\"},{\"absolute_position\":12,\"transaction_type\":\"\",\"card_type\":\"card\",\"card_content_type\":\"diary\",\"relative_position\":5,\"card_id\":\"15328675\"},{\"absolute_position\":13,\"transaction_type\":\"\",\"card_type\":\"card\",\"card_content_type\":\"diary\",\"relative_position\":6,\"card_id\":\"11201557\"},{\"absolute_position\":14,\"transaction_type\":\"\",\"card_type\":\"card\",\"card_content_type\":\"answer\",\"relative_position\":4,\"card_id\":\"700888\"},{\"absolute_position\":15,\"transaction_type\":\"\",\"card_type\":\"card\",\"card_content_type\":\"answer\",\"relative_position\":5,\"card_id\":\"706569\"}],\"tab_name\":\"综合\",\"down_slide_times\":8,\"query\":\"玻尿酸\",\"up_loading_times\":0,\"is_exposure\":1,\"referrer\":\"search_home\",\"business_id\":\"\",\"page_name\":\"search_result_more\",\"referrer_id\":\"\"},\"app_session_id\":\"559D8BA2-7FC1-402C-BB12-F860EFA26925\",\"app\":{\"user_type\":{\"config_type\":1},\"current_city_id\":\"chengdu\",\"version\":\"7.7.60\",\"name\":\"gengmei_user\",\"serial_id\":14,\"channel\":\"AppStore\"},\"gm_nginx_key\":1,\"device\":{\"idfv\":\"CD8D7E3B-B833-49EE-B509-6B9F1B3963B9\",\"lng\":104.07933463616,\"is_WiFi\":\"0\",\"manufacturer\":\"Apple\",\"ip\":\"10.187.49.153\",\"device_id\":\"4A0275C1-4734-404A-93DD-BAA272401A27\",\"device_type\":\"ios\",\"lat\":30.654052050073,\"idfa\":\"4A0275C1-4734-404A-93DD-BAA272401A27\"},\"type\":\"page_precise_exposure\"}";
        BlPreciseExposureBean blPreciseExposureBean = null;
        try {
            blPreciseExposureBean = blPreciseExposureEtl.mapBlPreciseExposureBean(json);
        } catch (Exception e) {
            e.printStackTrace();
        }
        System.out.println(blPreciseExposureBean.toString());
    }

    @Test
    public void filterBlPreciseExposureBeanTest() {
        BlPreciseExposureEtl blPreciseExposureEtl = new BlPreciseExposureEtl();
//        String json = "{\"create_at\":\"1575134961\",\"gm_nginx_timestamp\":1575134961.718,\"user_id\":\"31665831\",\"version\":\"110\",\"params\":{\"down_loading_times\":0,\"up_slide_times\":0,\"is_popup\":\"0\",\"exposure_cards\":[{\"absolute_position\":\"0\",\"transaction_type\":\"\",\"card_content_type\":\"function_entrance\",\"relative_position\":\"0\",\"card_id\":2},{\"absolute_position\":\"1\",\"transaction_type\":\"\",\"card_content_type\":\"function_entrance\",\"relative_position\":\"1\",\"card_id\":2},{\"absolute_position\":\"2\",\"transaction_type\":\"\",\"card_content_type\":\"function_entrance\",\"relative_position\":\"2\",\"card_id\":2},{\"absolute_position\":\"3\",\"transaction_type\":\"\",\"card_content_type\":\"function_entrance\",\"relative_position\":\"3\",\"card_id\":2},{\"absolute_position\":\"4\",\"transaction_type\":\"\",\"card_content_type\":\"function_entrance\",\"relative_position\":\"4\",\"card_id\":2}],\"tab_name\":\"\",\"down_slide_times\":0,\"page_name\":\"home\",\"up_loading_times\":0,\"is_exposure\":\"1\",\"referrer\":\"\",\"business_id\":\"\",\"referrer_id\":\"\"},\"app_session_id\":\"FE675C8B-4FD4-4FC6-9EC7-415F715A750B\",\"app\":{\"version\":\"7.18.2\",\"grey_type\":\"{\\\"report_result\\\":0,\\\"face_detect_result\\\":\\\"B\\\",\\\"home\\\":\\\"0\\\",\\\"post_detail\\\":\\\"0\\\",\\\"video_steep\\\":1,\\\"face_scan\\\":0}\",\"current_city_id\":\"nanjing\",\"name\":\"gengmei_user\",\"user_type\":{\"config_type\":1},\"serial_id\":12,\"channel\":\"AppStore\"},\"gm_nginx_key\":1,\"device\":{\"idfv\":\"5F193A07-781F-4EF1-86B4-452251307081\",\"sys_version\":\"13.2.3\",\"lng\":118.93133562169,\"is_WiFi\":\"0\",\"manufacturer\":\"Apple\",\"device_id\":\"F88745FE-DF54-4639-B7E2-28554C7DFAAF\",\"device_type\":\"ios\",\"ip\":\"10.190.42.125\",\"idfa\":\"F88745FE-DF54-4639-B7E2-28554C7DFAAF\",\"lat\":32.121287439102,\"model\":\"iPhone8,2\"},\"type\":\"page_precise_exposure\"}";
        String json = "{\"gm_nginx_key\":1,\"version\":\"205\",\"params\":{\"up_slide_times\":\"2\",\"down_loading_times\":\"0\",\"exposure_cards\":\"[{\\\"card_id\\\":\\\"16449302\\\",\\\"card_source_type\\\":\\\"doris\\\",\\\"card_content_type\\\":\\\"diary\\\",\\\"card_type\\\":\\\"card\\\",absolute_position\\\":\\\"0\\\",\\\"relative_position\\\":\\\"0\\\"}]\",\"up_loading_times\":\"0\",\"is_exposure\":\"1\",\"tab_name\":\"精选\",\"page_name\":\"home\",\"business_id\":\"\",\"referrer\":\"\",\"referrer_id\":\"\",\"down_slide_times\":\"1\"},\"app_session_id\":\"f3d24a27-27f0-4545-b132-51030765cf49\",\"gm_nginx_timestamp\":1546307958.444,\"create_at\":\"1546307958\",\"type\":\"home_choiceness_card_exposure\",\"device\":{\"is_WiFi\":\"1\",\"ip\":\"192.168.1.100\",\"manufacturer\":\"vivo\",\"device_type\":\"android\",\"lat\":\"0.0\",\"device_id\":\"863208034156179\",\"lng\":\"0.0\"},\"app\":{\"channel\":\"vivo\",\"user_type\":{\"config_type\":\"1\"},\"serial_id\":6,\"current_city_id\":\"worldwide\",\"name\":\"gengmei_user\",\"version\":\"7.7.36\"},\"user_id\":\"\"}";
        BlPreciseExposureBean blPreciseExposureBean = null;
        Boolean flag = null;
        try {
            blPreciseExposureBean = blPreciseExposureEtl.mapBlPreciseExposureBean(json);
            flag = blPreciseExposureEtl.filterBlPreciseExposureBean(blPreciseExposureBean);
        } catch (Exception e) {
            e.printStackTrace();
        }
        System.out.println(blPreciseExposureBean.getIs_exposure());
        System.out.println(flag);
    }
}
