package com.gmei.kafka;


import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.Producer;
import org.apache.kafka.clients.producer.ProducerRecord;

import java.util.Properties;

public class MyProducter {
    public static void main(String[] args) {
        // 构造一个java.util.Properties对象
        Properties props = new Properties();
        // 指定bootstrap.servers属性。必填，无默认值。用于创建向kafka broker服务器的连接。
        props.put("bootstrap.servers", "localhost:9092");
        // 指定key.serializer属性。必填，无默认值。被发送到broker端的任何消息的格式都必须是字节数组。
        // 因此消息的各个组件都必须首先做序列化，然后才能发送到broker。该参数就是为消息的key做序列化只用的。
        props.put("key.serializer", "org.apache.kafka.common.serialization.StringSerializer");
        // 指定value.serializer属性。必填，无默认值。和key.serializer类似。此被用来对消息体即消息value部分做序列化。
        // 将消息value部分转换成字节数组。
        props.put("value.serializer", "org.apache.kafka.common.serialization.StringSerializer");
        //acks参数用于控制producer生产消息的持久性（durability）。参数可选值，0、1、-1（all）。
        props.put("acks", "-1");
        //props.put(ProducerConfig.ACKS_CONFIG, "1");
        //在producer内部自动实现了消息重新发送。默认值0代表不进行重试。
        props.put("retries", 3);
        //props.put(ProducerConfig.RETRIES_CONFIG, 3);
        //调优producer吞吐量和延时性能指标都有非常重要作用。默认值16384即16KB。
        props.put("batch.size", 16384);
//        props.put("batch.size", 323840);
        //props.put(ProducerConfig.BATCH_SIZE_CONFIG, 323840);
        //控制消息发送延时行为的，该参数默认值是0。表示消息需要被立即发送，无须关系batch是否被填满。
//        props.put("linger.ms", 10);
        props.put("linger.ms", 0);
        //props.put(ProducerConfig.LINGER_MS_CONFIG, 10);
        //指定了producer端用于缓存消息的缓冲区的大小，单位是字节，默认值是33554432即32M。
        props.put("buffer.memory", 16384);
//        props.put("buffer.memory", 33554432);
        //props.put(ProducerConfig.BUFFER_MEMORY_CONFIG, 33554432);
        props.put("max.block.ms", 1000);
//        props.put("max.block.ms", 3000);
        //props.put(ProducerConfig.MAX_BLOCK_MS_CONFIG, 3000);
        //设置producer段是否压缩消息，默认值是none。即不压缩消息。GZIP、Snappy、LZ4
        //props.put("compression.type", "none");
        //props.put(ProducerConfig.COMPRESSION_TYPE_CONFIG, "none");
        //该参数用于控制producer发送请求的大小。producer端能够发送的最大消息大小。
        //props.put("max.request.size", 10485760);
        //props.put(ProducerConfig.MAX_REQUEST_SIZE_CONFIG, 10485760);
        //producer发送请求给broker后，broker需要在规定时间范围内将处理结果返还给producer。默认30s
        //props.put("request.timeout.ms", 60000);
        //props.put(ProducerConfig.REQUEST_TIMEOUT_MS_CONFIG, 60000);
//            Properties props = new Properties();
//            props.setProperty("metadata.broker.list","10.10.10.100:9090");
//            props.setProperty("serializer.class","kafka.serializer.StringEncoder");
//            props.put("request.required.acks","1");
//            ProducerConfig config = new ProducerConfig(props);
        //创建生产这对象
        Producer<String, String> producer = new KafkaProducer<String, String>(props);
        String json = "{\"create_at\":\"1579242641\",\"gm_nginx_timestamp\":1579242640.509,\"user_id\":\"\",\"version\":\"147\",\"params\":{\"down_loading_times\":0,\"up_slide_times\":0,\"is_exposure\":\"1\",\"up_loading_times\":0,\"referrer_link\":[\"home\",\"search_home\"],\"tab_name\":\"综合\",\"down_slide_times\":0,\"query\":\"腹݄製¥FxGo6d9bEuoXH5IXDhEW¥\uD83D\uDC50開˙\uD83D\uDC49【Fаceu】\uD83D\uDC48，就能送我一张“发”卡，急急急！快来㠍佧，有机会额外得10000元葒枹\uD83E\uDDE7️，除夕再分5亿奨鑫\uD83D\uDCB0！\",\"filter\":\"\",\"referrer_id\":\"\",\"referrer\":\"search_home\",\"business_id\":\"\",\"page_name\":\"search_result_more\",\"exposure_cards\":[{\"cpc_referer\":\"1\",\"relative_position\":0,\"transaction_type\":\"\",\"card_type\":\"card\",\"absolute_position\":0,\"card_content_type\":\"answer\",\"card_id\":\"517789\"},{\"cpc_referer\":\"1\",\"relative_position\":1,\"transaction_type\":\"\",\"card_type\":\"card\",\"absolute_position\":1,\"card_content_type\":\"answer\",\"card_id\":\"541639\"},{\"cpc_referer\":\"1\",\"relative_position\":2,\"is_cpc\":0,\"transaction_type\":\"-1\",\"card_type\":\"card\",\"absolute_position\":2,\"card_content_type\":\"diary\",\"card_id\":16858137},{\"is_cpc\":1,\"result_status\":\"1\",\"card_id\":\"5856326\",\"cpc_referer\":\"2\",\"transaction_type\":\"-1\",\"card_type\":\"card\",\"relative_position\":0,\"card_content_type\":\"service\",\"absolute_position\":0},{\"is_cpc\":0,\"result_status\":\"1\",\"card_id\":\"5820784\",\"cpc_referer\":\"2\",\"transaction_type\":\"-1\",\"card_type\":\"card\",\"relative_position\":0,\"card_content_type\":\"service\",\"absolute_position\":0},{\"is_cpc\":1,\"result_status\":\"1\",\"card_id\":\"5776196\",\"cpc_referer\":\"2\",\"transaction_type\":\"-1\",\"card_type\":\"card\",\"relative_position\":0,\"card_content_type\":\"service\",\"absolute_position\":1},{\"is_cpc\":0,\"result_status\":\"1\",\"card_id\":\"5825049\",\"cpc_referer\":\"2\",\"transaction_type\":\"-1\",\"card_type\":\"card\",\"relative_position\":0,\"card_content_type\":\"service\",\"absolute_position\":1}]},\"app_session_id\":\"1e75a090-15a9-4ba5-81c0-c124adc7e752\",\"app\":{\"version\":\"7.22.1\",\"grey_type\":\"{\\\"post_detail\\\": \\\"0\\\", \\\"search_gray\\\": false, \\\"search_result_welfare\\\": false, \\\"face_detect_result\\\": \\\"B\\\", \\\"home\\\": \\\"0\\\", \\\"face_scan\\\": 0, \\\"launch_gray\\\": false, \\\"video_steep\\\": 1, \\\"report_result\\\": 0}\",\"current_city_id\":\"xianning\",\"user_type\":{\"config_type\":\"1\"},\"name\":\"gengmei_user\",\"serial_id\":52,\"channel\":\"vivo\"},\"gm_nginx_key\":1,\"device\":{\"android_device_id\":\"androidid_cf3ae256f301e962\",\"sys_version\":\"8.1.0\",\"lng\":\"114.060301\",\"is_WiFi\":\"1\",\"lat\":\"29.534923\",\"device_id\":\"866934039264497\",\"manufacturer\":\"vivo\",\"net_type\":\"wifi\",\"device_type\":\"android\",\"ip\":\"192.168.1.2\",\"model\":\"vivo X20A\"},\"type\":\"page_precise_exposure\"}";
//        String json = "{\"create_at\":\"1576854504\",\"gm_nginx_timestamp\":1579165739.724,\"user_id\":\"\",\"version\":\"110\",\"params\":{\"down_loading_times\":0,\"up_slide_times\":0,\"is_popup\":\"0\",\"exposure_cards\":[{\"absolute_position\":\"0\",\"transaction_type\":\"\",\"card_content_type\":\"function_entrance\",\"relative_position\":\"0\",\"card_id\":2},{\"absolute_position\":\"0\",\"target_name\":\"\",\"transaction_type\":\"-1\",\"card_type\":\"card\",\"card_content_type\":\"gadget\",\"relative_position\":\"\",\"card_id\":923},{\"absolute_position\":\"1\",\"transaction_type\":\"\",\"card_content_type\":\"function_entrance\",\"relative_position\":\"1\",\"card_id\":2},{\"absolute_position\":\"2\",\"transaction_type\":\"\",\"card_content_type\":\"function_entrance\",\"relative_position\":\"2\",\"card_id\":2},{\"target_name\":\"鼻部-双旦大促-banner\",\"absolute_position\":\"2\",\"card_content_type \":\"新专题聚合\",\"transaction_type\":\"operation\",\"card_type\":\"card\",\"relative_position\":\"\",\"in_page_pos\":\"top\",\"card_id\":46},{\"absolute_position\":\"3\",\"transaction_type\":\"\",\"card_content_type\":\"function_entrance\",\"relative_position\":\"3\",\"card_id\":2},{\"absolute_position\":\"4\",\"transaction_type\":\"\",\"card_content_type\":\"function_entrance\",\"relative_position\":\"4\",\"card_id\":2}],\"tab_name\":\"\",\"down_slide_times\":0,\"page_name\":\"home\",\"up_loading_times\":0,\"is_exposure\":\"1\",\"referrer\":\"\",\"business_id\":\"\",\"referrer_id\":\"\"},\"app_session_id\":\"CCA64F08-C9F1-47FE-87ED-2B2993ADD067\",\"app\":{\"name\":\"gengmei_user\",\"grey_type\":\"{\\n  \\\"report_result\\\" : 0,\\n  \\\"face_detect_result\\\" : \\\"B\\\",\\n  \\\"home\\\" : \\\"0\\\",\\n  \\\"post_detail\\\" : \\\"0\\\",\\n  \\\"video_steep\\\" : 0,\\n  \\\"face_scan\\\" : 0\\n}\",\"current_city_id\":\"worldwide\",\"version\":\"7.19.1\",\"user_type\":{\"config_type\":1},\"serial_id\":75,\"channel\":\"App Store\"},\"gm_nginx_key\":1,\"device\":{\"idfv\":\"EB72DED5-75C3-410E-A759-388261BD232B\",\"sys_version\":\"13.3\",\"lng\":0,\"is_WiFi\":\"1\",\"manufacturer\":\"Apple\",\"device_id\":\"EB72DED5-75C3-410E-A759-388261BD232B\",\"lat\":0,\"ip\":\"192.168.0.167\",\"idfa\":\"00000000-0000-0000-0000-000000000000\",\"device_type\":\"ios\",\"model\":\"iPhone9,3\"},\"type\":\"page_precise_exposure\"}";
//        String json = "{\"create_at\":\"1578102778\",\"gm_nginx_timestamp\":1578102780.541,\"user_id\":\"32085659\",\"version\":\"147\",\"params\":{\"down_loading_times\":0,\"business_id\":\"\",\"exposure_cards\":[{\"is_cpc\":1,\"result_status\":\"1\",\"card_id\":\"5754050\",\"absolute_position\":0,\"transaction_type\":\"-1\",\"card_type\":\"card\",\"relative_position\":0,\"card_content_type\":\"service\",\"cpc_referer\":\"0\"},{\"is_cpc\":1,\"result_status\":\"1\",\"card_id\":\"5760019\",\"absolute_position\":1,\"transaction_type\":\"-1\",\"card_type\":\"card\",\"relative_position\":1,\"card_content_type\":\"service\",\"cpc_referer\":\"0\"},{\"is_cpc\":1,\"result_status\":\"1\",\"card_id\":\"5833115\",\"absolute_position\":2,\"transaction_type\":\"-1\",\"card_type\":\"card\",\"relative_position\":2,\"card_content_type\":\"service\",\"cpc_referer\":\"0\"}],\"up_loading_times\":0,\"referrer_link\":[\"home\",\"search_home\"],\"tab_name\":\"美购\",\"down_slide_times\":0,\"query\":\"眼综合\",\"filter\":\"综合排序\",\"is_exposure\":\"1\",\"referrer\":\"search_result_more\",\"up_slide_times\":0,\"referrer_id\":\"\",\"page_name\":\"search_result_welfare\"},\"app_session_id\":\"dc92c61b-f9bf-4378-8ca1-e6c0d9bee116\",\"app\":{\"version\":\"7.20.1\",\"grey_type\":\"{\\\"video_steep\\\":0,\\\"post_detail\\\":\\\"0\\\",\\\"face_detect_result\\\":\\\"B\\\",\\\"home\\\":\\\"0\\\",\\\"face_scan\\\":0,\\\"report_result\\\":0}\",\"current_city_id\":\"jincheng\",\"user_type\":{\"config_type\":\"1\"},\"name\":\"gengmei_user\",\"serial_id\":25,\"channel\":\"oppo\"},\"gm_nginx_key\":1,\"device\":{\"android_device_id\":\"androidid_c60514a82b1f4f68\",\"sys_version\":\"7.1.1\",\"lng\":\"112.31146\",\"is_WiFi\":\"0\",\"lat\":\"35.622659\",\"device_id\":\"861271049370690\",\"manufacturer\":\"OPPO\",\"net_type\":\"4G\",\"device_type\":\"android\",\"ip\":\"10.102.127.227\",\"model\":\"OPPOA83\"},\"type\":\"page_precise_exposure\"}";
//        String json = "{\"create_at\":\"1577447031\",\"gm_nginx_timestamp\":1577447032.059,\"user_id\":\"\",\"version\":\"147\",\"params\":{\"down_loading_times\":0,\"up_slide_times\":0,\"is_popup\":0,\"exposure_cards\":[{\"absolute_position\":0,\"transaction_type\":\"\",\"relative_position\":0,\"card_content_type\":\"function_entrance\",\"card_id\":1},{\"absolute_position\":1,\"transaction_type\":\"\",\"relative_position\":0,\"card_content_type\":\"function_entrance\",\"card_id\":1},{\"absolute_position\":2,\"transaction_type\":\"\",\"relative_position\":0,\"card_content_type\":\"function_entrance\",\"card_id\":1},{\"absolute_position\":3,\"transaction_type\":\"\",\"relative_position\":0,\"card_content_type\":\"function_entrance\",\"card_id\":1},{\"absolute_position\":4,\"transaction_type\":\"\",\"relative_position\":0,\"card_content_type\":\"function_entrance\",\"card_id\":1},{\"target_name\":\"\",\"relative_position\":0,\"transaction_type\":\"-1\",\"card_type\":\"card\",\"absolute_position\":0,\"card_content_type\":\"gadget\",\"card_id\":923},{\"target_name\":\"眼部双旦-banner\",\"relative_position\":0,\"in_page_pos\":\"top\",\"transaction_type\":\"operation\",\"card_type\":\"card\",\"absolute_position\":1,\"card_content_type \":\"新专题聚合\",\"card_id\":38},{\"target_name\":\"鼻部-双旦大促-banner\",\"relative_position\":0,\"in_page_pos\":\"top\",\"transaction_type\":\"operation\",\"card_type\":\"card\",\"absolute_position\":2,\"card_content_type \":\"新专题聚合\",\"card_id\":46},{\"absolute_position\":0,\"transaction_type\":\"\",\"relative_position\":0,\"card_content_type\":\"function_entrance\",\"card_id\":1},{\"absolute_position\":1,\"transaction_type\":\"\",\"relative_position\":0,\"card_content_type\":\"function_entrance\",\"card_id\":1},{\"absolute_position\":2,\"transaction_type\":\"\",\"relative_position\":0,\"card_content_type\":\"function_entrance\",\"card_id\":1},{\"absolute_position\":3,\"transaction_type\":\"\",\"relative_position\":0,\"card_content_type\":\"function_entrance\",\"card_id\":1},{\"absolute_position\":4,\"transaction_type\":\"\",\"relative_position\":0,\"card_content_type\":\"function_entrance\",\"card_id\":1},{\"target_name\":\"\",\"relative_position\":0,\"transaction_type\":\"-1\",\"card_type\":\"card\",\"absolute_position\":0,\"card_content_type\":\"gadget\",\"card_id\":923},{\"target_name\":\"12.26社区\",\"relative_position\":0,\"transaction_type\":\"operation\",\"card_type\":\"card\",\"in_page_pos\":\"top\",\"card_content_type \":\"指定网页\",\"absolute_position\":3},{\"target_name\":\"吸脂填充-双旦\",\"relative_position\":0,\"in_page_pos\":\"top\",\"transaction_type\":\"operation\",\"card_type\":\"card\",\"absolute_position\":4,\"card_content_type \":\"新专题聚合\",\"card_id\":42},{\"target_name\":\"美肤三针双旦-banner\",\"relative_position\":0,\"in_page_pos\":\"top\",\"transaction_type\":\"operation\",\"card_type\":\"card\",\"absolute_position\":5,\"card_content_type \":\"新专题聚合\",\"card_id\":39},{\"target_name\":\"轮廓双旦banner\",\"relative_position\":0,\"in_page_pos\":\"top\",\"transaction_type\":\"operation\",\"card_type\":\"card\",\"absolute_position\":6,\"card_content_type \":\"新专题聚合\",\"card_id\":36},{\"target_name\":\"齿科-双旦大促-banner\",\"relative_position\":0,\"in_page_pos\":\"top\",\"transaction_type\":\"operation\",\"card_type\":\"card\",\"absolute_position\":7,\"card_content_type \":\"新专题聚合\",\"card_id\":41}],\"tab_name\":\"\",\"down_slide_times\":0,\"page_name\":\"home\",\"up_loading_times\":0,\"referrer_id\":\"\",\"referrer\":\"\",\"is_exposure\":\"1\",\"business_id\":\"\"},\"app_session_id\":\"168871fb-1471-43ac-b4da-e07009d88be7\",\"app\":{\"version\":\"7.19.2\",\"grey_type\":\"{\\\"video_steep\\\": 1, \\\"post_detail\\\": \\\"0\\\", \\\"face_detect_result\\\": \\\"B\\\", \\\"home\\\": \\\"0\\\", \\\"face_scan\\\": 0, \\\"report_result\\\": 0}\",\"current_city_id\":\"\",\"user_type\":{\"config_type\":\"1\"},\"name\":\"gengmei_user\",\"serial_id\":31,\"channel\":\"yiba5202\"},\"gm_nginx_key\":1,\"device\":{\"android_device_id\":\"androidid_80a2a60d59729bda\",\"sys_version\":\"8.0.0\",\"lng\":\"0.0\",\"is_WiFi\":\"0\",\"lat\":\"0.0\",\"device_id\":\"869712034003715\",\"manufacturer\":\"HUAWEI\",\"net_type\":\"4G\",\"device_type\":\"android\",\"ip\":\"10.138.25.16\",\"model\":\"LDN-AL20\"},\"type\":\"page_precise_exposure\"}";
//        String json = "{\"create_at\":\"1577364648\",\"gm_nginx_timestamp\":1577364646.542,\"user_id\":\"\",\"version\":\"147\",\"params\":{\"down_loading_times\":0,\"up_slide_times\":0,\"is_popup\":0,\"exposure_cards\":[{\"absolute_position\":0,\"transaction_type\":\"\",\"relative_position\":0,\"card_content_type\":\"function_entrance\",\"card_id\":2},{\"absolute_position\":1,\"transaction_type\":\"\",\"relative_position\":0,\"card_content_type\":\"function_entrance\",\"card_id\":2},{\"absolute_position\":2,\"transaction_type\":\"\",\"relative_position\":0,\"card_content_type\":\"function_entrance\",\"card_id\":2},{\"absolute_position\":3,\"transaction_type\":\"\",\"relative_position\":0,\"card_content_type\":\"function_entrance\",\"card_id\":2},{\"absolute_position\":4,\"transaction_type\":\"\",\"relative_position\":0,\"card_content_type\":\"function_entrance\",\"card_id\":2},{\"target_name\":\"\",\"relative_position\":0,\"transaction_type\":\"-1\",\"card_type\":\"card\",\"absolute_position\":0,\"card_content_type\":\"gadget\",\"card_id\":923},{\"target_name\":\"12月新人专场\",\"relative_position\":0,\"in_page_pos\":\"top\",\"transaction_type\":\"operation\",\"card_type\":\"card\",\"absolute_position\":0,\"card_content_type\":\"福利专题列表\",\"card_id\":6377},{\"target_name\":\"双旦大促-主会场-华西\",\"relative_position\":0,\"in_page_pos\":\"top\",\"transaction_type\":\"operation\",\"card_type\":\"card\",\"absolute_position\":1,\"card_content_type\":\"福利专题列表\",\"card_id\":6565},{\"target_name\":\"眼部双旦-banner\",\"relative_position\":0,\"in_page_pos\":\"top\",\"transaction_type\":\"operation\",\"card_type\":\"card\",\"absolute_position\":2,\"card_content_type\":\"新专题聚合\",\"card_id\":38},{\"target_name\":\"鼻部-双旦大促-banner\",\"relative_position\":0,\"in_page_pos\":\"top\",\"transaction_type\":\"operation\",\"card_type\":\"card\",\"absolute_position\":3,\"card_content_type\":\"新专题聚合\",\"card_id\":46},{\"target_name\":\"12.26社区\",\"relative_position\":0,\"transaction_type\":\"operation\",\"card_type\":\"card\",\"in_page_pos\":\"top\",\"card_content_type\":\"指定网页\",\"absolute_position\":4},{\"target_name\":\"吸脂填充-双旦\",\"relative_position\":0,\"in_page_pos\":\"top\",\"transaction_type\":\"operation\",\"card_type\":\"card\",\"absolute_position\":5,\"card_content_type\":\"新专题聚合\",\"card_id\":42},{\"target_name\":\"美肤三针双旦-banner\",\"relative_position\":0,\"in_page_pos\":\"top\",\"transaction_type\":\"operation\",\"card_type\":\"card\",\"absolute_position\":6,\"card_content_type\":\"新专题聚合\",\"card_id\":39},{\"target_name\":\"轮廓双旦banner\",\"relative_position\":0,\"in_page_pos\":\"top\",\"transaction_type\":\"operation\",\"card_type\":\"card\",\"absolute_position\":7,\"card_content_type\":\"新专题聚合\",\"card_id\":36},{\"target_name\":\"12月新人专场\",\"relative_position\":0,\"in_page_pos\":\"top\",\"transaction_type\":\"operation\",\"card_type\":\"card\",\"absolute_position\":0,\"card_content_type\":\"福利专题列表\",\"card_id\":6377},{\"target_name\":\"双旦大促-主会场-华西\",\"relative_position\":0,\"in_page_pos\":\"top\",\"transaction_type\":\"operation\",\"card_type\":\"card\",\"absolute_position\":1,\"card_content_type\":\"福利专题列表\",\"card_id\":6565},{\"target_name\":\"眼部双旦-banner\",\"relative_position\":0,\"in_page_pos\":\"top\",\"transaction_type\":\"operation\",\"card_type\":\"card\",\"absolute_position\":2,\"card_content_type\":\"新专题聚合\",\"card_id\":38},{\"target_name\":\"鼻部-双旦大促-banner\",\"relative_position\":0,\"in_page_pos\":\"top\",\"transaction_type\":\"operation\",\"card_type\":\"card\",\"absolute_position\":3,\"card_content_type\":\"新专题聚合\",\"card_id\":46},{\"target_name\":\"12.26社区\",\"relative_position\":0,\"transaction_type\":\"operation\",\"card_type\":\"card\",\"in_page_pos\":\"top\",\"card_content_type\":\"指定网页\",\"absolute_position\":4},{\"target_name\":\"吸脂填充-双旦\",\"relative_position\":0,\"in_page_pos\":\"top\",\"transaction_type\":\"operation\",\"card_type\":\"card\",\"absolute_position\":5,\"card_content_type\":\"新专题聚合\",\"card_id\":42},{\"target_name\":\"美肤三针双旦-banner\",\"relative_position\":0,\"in_page_pos\":\"top\",\"transaction_type\":\"operation\",\"card_type\":\"card\",\"absolute_position\":6,\"card_content_type\":\"新专题聚合\",\"card_id\":39},{\"target_name\":\"轮廓双旦banner\",\"relative_position\":0,\"in_page_pos\":\"top\",\"transaction_type\":\"operation\",\"card_type\":\"card\",\"absolute_position\":7,\"card_content_type\":\"新专题聚合\",\"card_id\":36},{\"target_name\":\"12月新人专场\",\"relative_position\":0,\"in_page_pos\":\"top\",\"transaction_type\":\"operation\",\"card_type\":\"card\",\"absolute_position\":0,\"card_content_type\":\"福利专题列表\",\"card_id\":6377},{\"target_name\":\"双旦大促-主会场-华西\",\"relative_position\":0,\"in_page_pos\":\"top\",\"transaction_type\":\"operation\",\"card_type\":\"card\",\"absolute_position\":1,\"card_content_type\":\"福利专题列表\",\"card_id\":6565},{\"target_name\":\"眼部双旦-banner\",\"relative_position\":0,\"in_page_pos\":\"top\",\"transaction_type\":\"operation\",\"card_type\":\"card\",\"absolute_position\":2,\"card_content_type\":\"新专题聚合\",\"card_id\":38}],\"tab_name\":\"\",\"down_slide_times\":0,\"page_name\":\"home\",\"up_loading_times\":0,\"referrer_id\":\"\",\"referrer\":\"\",\"is_exposure\":\"1\",\"business_id\":\"\"},\"app_session_id\":\"6d167db8-147d-4ded-b7a8-0d9f176f91a1\",\"app\":{\"version\":\"7.19.2\",\"grey_type\":\"unknown\",\"current_city_id\":\"chongqing\",\"user_type\":{},\"name\":\"gengmei_user\",\"serial_id\":1,\"channel\":\"huawei\"},\"gm_nginx_key\":1,\"device\":{\"android_device_id\":\"androidid_99a0301553dc4f12\",\"sys_version\":\"10\",\"lng\":\"106.56958\",\"is_WiFi\":\"1\",\"lat\":\"29.680635\",\"device_id\":\"864674045613095\",\"manufacturer\":\"HUAWEI\",\"net_type\":\"wifi\",\"device_type\":\"android\",\"ip\":\"192.168.0.100\",\"model\":\"VOG-AL00\"},\"type\":\"page_precise_exposure\"}";
//        String json = "{\"create_at\":\"1577324083\",\"gm_nginx_timestamp\":1577324083.74,\"user_id\":\"32339790\",\"version\":\"110\",\"params\":{\"down_loading_times\":0,\"up_slide_times\":13,\"exposure_cards\":[{\"absolute_position\":\"23\",\"transaction_type\":\"\",\"card_type\":\"card\",\"card_content_type\":\"answer\",\"relative_position\":\"0\",\"card_id\":\"689089\"},{\"absolute_position\":\"26\",\"transaction_type\":\"\",\"relative_position\":\"3\",\"card_content_type\":\"search_query\",\"in_page_pos\":\"related_search\",\"card_id\":[\"注射美容\",\"硅胶丰额头\",\"祛颊脂垫\",\"胶原蛋白填充垫下巴\",\"面部不对称改善\",\"膨体丰额头\"]},{\"absolute_position\":\"27\",\"cpc_referer\":1,\"relative_position\":\"1\",\"transaction_type\":\"-1\",\"card_type\":\"card\",\"is_cpc\":0,\"card_content_type\":\"diary\",\"card_id\":15804523},{\"absolute_position\":\"28\",\"transaction_type\":\"\",\"card_type\":\"card\",\"card_content_type\":\"article\",\"relative_position\":\"2\",\"card_id\":\"19514087\"},{\"absolute_position\":\"29\",\"transaction_type\":\"\",\"card_type\":\"card\",\"card_content_type\":\"answer\",\"relative_position\":\"3\",\"card_id\":\"696977\"},{\"absolute_position\":\"30\",\"transaction_type\":\"\",\"card_type\":\"card\",\"card_content_type\":\"answer\",\"relative_position\":\"4\",\"card_id\":\"686606\"},{\"absolute_position\":\"33\",\"cpc_referer\":1,\"relative_position\":\"4\",\"transaction_type\":\"-1\",\"card_type\":\"card\",\"is_cpc\":0,\"card_content_type\":\"diary\",\"card_id\":15965971},{\"absolute_position\":\"34\",\"transaction_type\":\"\",\"card_type\":\"card\",\"card_content_type\":\"article\",\"relative_position\":\"2\",\"card_id\":\"19515896\"},{\"absolute_position\":\"35\",\"transaction_type\":\"\",\"card_type\":\"card\",\"card_content_type\":\"answer\",\"relative_position\":\"3\",\"card_id\":\"700587\"},{\"absolute_position\":\"36\",\"transaction_type\":\"\",\"card_type\":\"card\",\"card_content_type\":\"answer\",\"relative_position\":\"4\",\"card_id\":\"700403\"},{\"absolute_position\":\"39\",\"transaction_type\":\"\",\"relative_position\":\"3\",\"card_content_type\":\"search_query\",\"in_page_pos\":\"related_search\",\"card_id\":[\"长下巴矫正\",\"激光溶脂瘦脸\",\"额头\",\"人工骨垫下巴\",\"下巴截骨前移\",\"玻尿酸丰耳垂\"]},{\"absolute_position\":\"40\",\"cpc_referer\":1,\"relative_position\":\"4\",\"transaction_type\":\"-1\",\"card_type\":\"card\",\"is_cpc\":0,\"card_content_type\":\"diary\",\"card_id\":15953555}],\"tab_name\":\"综合\",\"down_slide_times\":1,\"query\":\"瘦脸针\",\"up_loading_times\":1,\"is_exposure\":\"1\",\"referrer\":\"search_home\",\"business_id\":\"\",\"page_name\":\"search_result_more\",\"referrer_id\":\"\"},\"app_session_id\":\"5A18488E-0965-45EE-B35A-BE82266B785B\",\"app\":{\"version\":\"7.19.1\",\"grey_type\":\"{\\\"report_result\\\":0,\\\"face_detect_result\\\":\\\"B\\\",\\\"home\\\":\\\"0\\\",\\\"post_detail\\\":\\\"0\\\",\\\"video_steep\\\":1,\\\"face_scan\\\":0}\",\"current_city_id\":\"qingdao\",\"name\":\"gengmei_user\",\"user_type\":{\"config_type\":1},\"serial_id\":14,\"channel\":\"AppStore\"},\"gm_nginx_key\":1,\"device\":{\"idfv\":\"F7B0BC42-DCDD-4AE8-A0A1-C205233A94A4\",\"sys_version\":\"12.4\",\"lng\":120.38120711884,\"is_WiFi\":\"0\",\"manufacturer\":\"Apple\",\"device_id\":\"BD96C788-434E-46EB-898C-DF2941882425\",\"device_type\":\"ios\",\"ip\":\"10.171.24.14\",\"idfa\":\"BD96C788-434E-46EB-898C-DF2941882425\",\"lat\":36.08928448005,\"model\":\"iPhone11,6\"},\"type\":\"page_precise_exposure\"}";
//        String json = "{\"create_at\":\"1577275915\",\"gm_nginx_timestamp\":1577275916.509,\"user_id\":\"32368787\",\"version\":\"147\",\"params\":{\"down_loading_times\":0,\"up_slide_times\":0,\"is_exposure\":\"1\",\"exposure_cards\":[{\"absolute_position\":0,\"transaction_type\":\"\",\"card_type\":\"card\",\"relative_position\":0,\"card_content_type\":\"banner\",\"card_id\":\"\"},{\"cpc_referer\":\"2\",\"relative_position\":0,\"absolute_position\":0,\"transaction_type\":\"-1\",\"card_type\":\"card\",\"card_content_type\":\"service\",\"result_status\":\"1\",\"card_id\":\"5785839\"},{\"cpc_referer\":\"2\",\"relative_position\":0,\"absolute_position\":1,\"transaction_type\":\"-1\",\"card_type\":\"card\",\"card_content_type\":\"service\",\"result_status\":\"1\",\"card_id\":\"5785492\"},{\"cpc_referer\":\"2\",\"relative_position\":0,\"absolute_position\":2,\"transaction_type\":\"-1\",\"card_type\":\"card\",\"card_content_type\":\"service\",\"result_status\":\"1\",\"card_id\":\"5742979\"},{\"cpc_referer\":\"2\",\"relative_position\":0,\"absolute_position\":3,\"transaction_type\":\"-1\",\"card_type\":\"card\",\"card_content_type\":\"service\",\"result_status\":\"1\",\"card_id\":\"5750757\"},{\"cpc_referer\":\"1\",\"relative_position\":0,\"transaction_type\":\"\",\"card_type\":\"card\",\"absolute_position\":0,\"card_content_type\":\"answer\",\"card_id\":\"332510\"},{\"cpc_referer\":\"1\",\"relative_position\":1,\"transaction_type\":\"\",\"card_type\":\"card\",\"absolute_position\":1,\"card_content_type\":\"answer\",\"card_id\":\"307094\"},{\"cpc_referer\":\"1\",\"relative_position\":2,\"is_cpc\":0,\"transaction_type\":\"-1\",\"card_type\":\"card\",\"absolute_position\":2,\"card_content_type\":\"user_post\",\"card_id\":70366}],\"tab_name\":\"综合\",\"down_slide_times\":0,\"query\":\"魔镜\",\"filter\":\"\",\"referrer_id\":\"\",\"referrer\":\"search_home\",\"up_loading_times\":0,\"business_id\":\"\",\"page_name\":\"search_result_more\"},\"app_session_id\":\"7c55ad0f-a0a8-46c8-ad21-bd9f3f12449f\",\"app\":{\"version\":\"7.19.2\",\"grey_type\":\"{\\\"video_steep\\\":0,\\\"post_detail\\\":\\\"0\\\",\\\"face_detect_result\\\":\\\"B\\\",\\\"home\\\":\\\"0\\\",\\\"face_scan\\\":0,\\\"report_result\\\":0}\",\"current_city_id\":\"xining\",\"user_type\":{\"config_type\":\"1\"},\"name\":\"gengmei_user\",\"serial_id\":32,\"channel\":\"guangdiantongand05\"},\"gm_nginx_key\":1,\"device\":{\"android_device_id\":\"androidid_2117151825754036\",\"sys_version\":\"9\",\"lng\":\"101.689229\",\"is_WiFi\":\"1\",\"lat\":\"36.944768\",\"device_id\":\"865787042243564\",\"manufacturer\":\"Xiaomi\",\"net_type\":\"wifi\",\"device_type\":\"android\",\"ip\":\"192.168.0.10\",\"model\":\"RedmiNote7Pro\"},\"type\":\"page_precise_exposure\"}";
//        String json = "{\"create_at\":\"1576355745\",\"gm_nginx_timestamp\":1577283386.396,\"user_id\":\"30374524\",\"version\":\"110\",\"params\":{\"down_loading_times\":0,\"up_slide_times\":0,\"is_popup\":\"0\",\"exposure_cards\":[{\"absolute_position\":\"0\",\"transaction_type\":\"\",\"card_content_type\":\"function_entrance\",\"relative_position\":\"0\",\"card_id\":2},{\"absolute_position\":\"0\",\"target_name\":\"\",\"transaction_type\":\"-1\",\"card_type\":\"card\",\"card_content_type\":\"gadget\",\"relative_position\":\"\",\"card_id\":916},{\"absolute_position\":\"1\",\"transaction_type\":\"\",\"card_content_type\":\"function_entrance\",\"relative_position\":\"1\",\"card_id\":2},{\"target_name\":\"双12大促-主会场\",\"absolute_position\":\"1\",\"card_content_type\":\"指定网页\",\"transaction_type\":\"operation\",\"card_type\":\"card\",\"relative_position\":\"\",\"in_page_pos\":\"top\",\"card_id\":null},{\"absolute_position\":\"2\",\"transaction_type\":\"\",\"card_content_type\":\"function_entrance\",\"relative_position\":\"2\",\"card_id\":2},{\"absolute_position\":\"3\",\"transaction_type\":\"\",\"card_content_type\":\"function_entrance\",\"relative_position\":\"3\",\"card_id\":2},{\"absolute_position\":\"4\",\"transaction_type\":\"\",\"card_content_type\":\"function_entrance\",\"relative_position\":\"4\",\"card_id\":2}],\"tab_name\":\"\",\"down_slide_times\":0,\"page_name\":\"home\",\"up_loading_times\":0,\"is_exposure\":\"1\",\"referrer\":\"\",\"business_id\":\"\",\"referrer_id\":\"\"},\"app_session_id\":\"386FA2C1-F140-408A-BC05-7085446D6A18\",\"app\":{\"name\":\"gengmei_user\",\"grey_type\":\"{\\\"report_result\\\":0,\\\"face_detect_result\\\":\\\"B\\\",\\\"home\\\":\\\"0\\\",\\\"post_detail\\\":\\\"0\\\",\\\"video_steep\\\":1,\\\"face_scan\\\":0}\",\"current_city_id\":\"weifang\",\"version\":\"7.19.1\",\"user_type\":{\"config_type\":1},\"serial_id\":1,\"channel\":\"AppStore\"},\"gm_nginx_key\":1,\"device\":{\"idfv\":\"D4BC83F7-82DE-42A2-8B51-61841D3572B4\",\"sys_version\":\"12.4.1\",\"lng\":0,\"is_WiFi\":\"1\",\"lat\":0,\"device_id\":\"D4BC83F7-82DE-42A2-8B51-61841D3572B4\",\"idfa\":\"00000000-0000-0000-0000-000000000000\",\"ip\":\"192.168.0.101\",\"device_type\":\"ios\",\"manufacturer\":\"Apple\",\"model\":\"iPhone10,2\"},\"type\":\"page_precise_exposure\"}";

//        String json = "{\"create_at\":\"1576128422\",\"gm_nginx_timestamp\":1576128422.463,\"user_id\":\"31038796\",\"version\":\"110\",\"params\":{\"down_loading_times\":1,\"up_slide_times\":5,\"exposure_cards\":[{\"absolute_position\":0,\"result_status\":\"1\",\"card_content_type\":\"service\",\"transaction_type\":\"[\\\"-1\\\",\\\"-1\\\",\\\"-1\\\"]\",\"card_type\":\"card\",\"card_source_type\":\"[\\\"\\\",\\\"\\\",\\\"\\\"]\",\"relative_position\":0,\"card_id\":\"[\\\"5821997\\\",\\\"5762189\\\",\\\"5671097\\\"]\"},{\"absolute_position\":1,\"card_content_type\":\"wiki_collect\",\"card_type\":\"card\",\"relative_position\":1,\"wiki_word\":{},\"card_id\":\"127\"},{\"absolute_position\":2,\"transaction_type\":\"\",\"card_type\":\"card\",\"card_content_type\":\"diary\",\"relative_position\":3,\"card_id\":\"15337295\"},{\"absolute_position\":3,\"transaction_type\":\"\",\"card_type\":\"card\",\"card_content_type\":\"diary\",\"relative_position\":4,\"card_id\":\"15635897\"},{\"absolute_position\":4,\"transaction_type\":\"\",\"card_type\":\"card\",\"card_content_type\":\"diary\",\"relative_position\":5,\"card_id\":\"16082820\"},{\"absolute_position\":4,\"transaction_type\":\"\",\"card_type\":\"card\",\"card_content_type\":\"diary\",\"relative_position\":5,\"card_id\":\"16082820\"},{\"absolute_position\":5,\"transaction_type\":\"\",\"card_type\":\"card\",\"card_content_type\":\"answer\",\"relative_position\":4,\"card_id\":\"699299\"},{\"absolute_position\":6,\"transaction_type\":\"\",\"card_type\":\"card\",\"card_content_type\":\"article\",\"relative_position\":5,\"card_id\":\"19589790\"},{\"absolute_position\":7,\"transaction_type\":\"\",\"card_type\":\"card\",\"card_content_type\":\"diary\",\"relative_position\":6,\"card_id\":\"15764401\"},{\"absolute_position\":8,\"transaction_type\":\"\",\"card_type\":\"card\",\"card_content_type\":\"diary\",\"relative_position\":4,\"card_id\":\"15633799\"},{\"absolute_position\":9,\"transaction_type\":\"\",\"card_type\":\"card\",\"card_content_type\":\"diary\",\"relative_position\":5,\"card_id\":\"16622540\"},{\"absolute_position\":10,\"transaction_type\":\"\",\"card_type\":\"card\",\"card_content_type\":\"answer\",\"relative_position\":6,\"card_id\":\"699573\"},{\"absolute_position\":11,\"transaction_type\":\"\",\"card_type\":\"card\",\"card_content_type\":\"answer\",\"relative_position\":4,\"card_id\":\"686812\"},{\"absolute_position\":12,\"transaction_type\":\"\",\"card_type\":\"card\",\"card_content_type\":\"diary\",\"relative_position\":5,\"card_id\":\"15328675\"},{\"absolute_position\":13,\"transaction_type\":\"\",\"card_type\":\"card\",\"card_content_type\":\"diary\",\"relative_position\":6,\"card_id\":\"11201557\"},{\"absolute_position\":14,\"transaction_type\":\"\",\"card_type\":\"card\",\"card_content_type\":\"answer\",\"relative_position\":4,\"card_id\":\"700888\"},{\"absolute_position\":15,\"transaction_type\":\"\",\"card_type\":\"card\",\"card_content_type\":\"answer\",\"relative_position\":5,\"card_id\":\"706569\"}],\"tab_name\":\"综合\",\"down_slide_times\":8,\"query\":\"玻尿酸\",\"up_loading_times\":0,\"is_exposure\":1,\"referrer\":\"search_home\",\"business_id\":\"\",\"page_name\":\"search_result_more\",\"referrer_id\":\"\"},\"app_session_id\":\"559D8BA2-7FC1-402C-BB12-F860EFA26925\",\"app\":{\"user_type\":{\"config_type\":1},\"current_city_id\":\"chengdu\",\"version\":\"7.7.60\",\"name\":\"gengmei_user\",\"serial_id\":14,\"channel\":\"AppStore\"},\"gm_nginx_key\":1,\"device\":{\"idfv\":\"CD8D7E3B-B833-49EE-B509-6B9F1B3963B9\",\"lng\":104.07933463616,\"is_WiFi\":\"0\",\"manufacturer\":\"Apple\",\"ip\":\"10.187.49.153\",\"device_id\":\"4A0275C1-4734-404A-93DD-BAA272401A27\",\"device_type\":\"ios\",\"lat\":30.654052050073,\"idfa\":\"4A0275C1-4734-404A-93DD-BAA272401A27\"},\"type\":\"page_precise_exposure\"}";
//        String json = "{\"create_at\":\"1575135041\",\"gm_nginx_timestamp\":1575135040.498,\"user_id\":\"\",\"version\":\"147\",\"params\":{\"down_loading_times\":0,\"up_slide_times\":6,\"is_exposure\":\"1\",\"exposure_cards\":[{\"absolute_position\":0,\"relative_position\":0,\"card_type\":\"card\",\"wiki_word\":[\"项目档案:1\",\"手术锦囊:2\",\"相近项目:3\"],\"card_content_type\":\"wiki_item\",\"card_id\":\"7\"},{\"cpc_referer\":\"1\",\"relative_position\":0,\"transaction_type\":\"\",\"card_type\":\"card\",\"absolute_position\":0,\"card_content_type\":\"answer\",\"card_id\":\"684889\"},{\"cpc_referer\":\"1\",\"relative_position\":1,\"transaction_type\":\"\",\"card_type\":\"card\",\"absolute_position\":1,\"card_content_type\":\"answer\",\"card_id\":\"692624\"},{\"cpc_referer\":\"1\",\"relative_position\":2,\"is_cpc\":0,\"transaction_type\":\"-1\",\"card_type\":\"card\",\"absolute_position\":2,\"card_content_type\":\"user_post\",\"card_id\":66263},{\"cpc_referer\":\"1\",\"relative_position\":3,\"is_cpc\":0,\"transaction_type\":\"-1\",\"card_type\":\"card\",\"absolute_position\":3,\"card_content_type\":\"user_post\",\"card_id\":66263},{\"cpc_referer\":\"1\",\"relative_position\":4,\"is_cpc\":0,\"transaction_type\":\"-1\",\"card_type\":\"card\",\"absolute_position\":4,\"card_content_type\":\"diary\",\"card_id\":15329391},{\"cpc_referer\":\"1\",\"relative_position\":4,\"transaction_type\":\"\",\"card_type\":\"card\",\"absolute_position\":5,\"card_content_type\":\"article\",\"card_id\":\"19507071\"},{\"cpc_referer\":\"1\",\"relative_position\":5,\"transaction_type\":\"\",\"card_type\":\"card\",\"absolute_position\":6,\"card_content_type\":\"answer\",\"card_id\":\"518138\"},{\"cpc_referer\":\"1\",\"relative_position\":4,\"transaction_type\":\"\",\"card_type\":\"card\",\"absolute_position\":7,\"card_content_type\":\"answer\",\"card_id\":\"684319\"},{\"cpc_referer\":\"1\",\"relative_position\":5,\"is_cpc\":0,\"transaction_type\":\"-1\",\"card_type\":\"card\",\"absolute_position\":8,\"card_content_type\":\"user_post\",\"card_id\":69002}],\"tab_name\":\"综合\",\"down_slide_times\":0,\"query\":\"纹眉\",\"filter\":\"\",\"referrer_id\":\"\",\"referrer\":\"search_home\",\"up_loading_times\":0,\"business_id\":\"\",\"page_name\":\"search_result_more\"},\"app_session_id\":\"424bcbcf-3b6e-4331-89b3-9fcd0c7bfbaf\",\"app\":{\"version\":\"7.18.4\",\"grey_type\":\"{\\\"video_steep\\\":1,\\\"post_detail\\\":\\\"0\\\",\\\"face_detect_result\\\":\\\"B\\\",\\\"home\\\":\\\"0\\\",\\\"face_scan\\\":0,\\\"report_result\\\":0}\",\"current_city_id\":\"chongqing\",\"user_type\":{\"config_type\":\"1\"},\"name\":\"gengmei_user\",\"serial_id\":35,\"channel\":\"huawei\"},\"gm_nginx_key\":1,\"device\":{\"android_device_id\":\"androidid_b49fb6a87b10bad0\",\"sys_version\":\"9\",\"lng\":\"106.618722\",\"is_WiFi\":\"0\",\"lat\":\"29.720561\",\"device_id\":\"861198041466947\",\"manufacturer\":\"HUAWEI\",\"net_type\":\"4G\",\"device_type\":\"android\",\"ip\":\"192.168.3.3\",\"model\":\"LYA-AL00\"},\"type\":\"page_precise_exposure\"}";

        //生成消息
        try {
            boolean flag = true;
            while (flag) {
                //发送消息
//                    producer.send(new ProducerRecord<String, String>("test", Integer.toString(1), Integer.toString(2)));

//                    String message=getDate("dim_sigtyp","seqnum","code","name");
//                    KeyedMessage<String, String> data = new KeyedMessage<String, String>("test3",message);
                // 构造待发送的消息对象ProduceRecord的对象，指定消息要发送到的topic主题，分区以及对应的key和value键值对。
                // 注意，分区和key信息可以不用指定，由kafka自行确定目标分区。
//                ProducerRecord<String, String> producerRecord = new ProducerRecord<String, String>("test",
//                        Integer.toString("row"), Integer.toString("{\"@raw\":\"{\\\"create_at\\\":\\\"1575129599\\\",\\\"gm_nginx_timestamp\\\":1575129600.382,\\\"user_id\\\":\\\"\\\",\\\"version\\\":\\\"147\\\",\\\"params\\\":{\\\"down_loading_times\\\":0,\\\"up_slide_times\\\":0,\\\"is_popup\\\":0,\\\"exposure_cards\\\":[{\\\"absolute_position\\\":0,\\\"transaction_type\\\":\\\"\\\",\\\"relative_position\\\":0,\\\"card_content_type\\\":\\\"function_entrance\\\",\\\"card_id\\\":1},{\\\"absolute_position\\\":1,\\\"transaction_type\\\":\\\"\\\",\\\"relative_position\\\":0,\\\"card_content_type\\\":\\\"function_entrance\\\",\\\"card_id\\\":1},{\\\"absolute_position\\\":2,\\\"transaction_type\\\":\\\"\\\",\\\"relative_position\\\":0,\\\"card_content_type\\\":\\\"function_entrance\\\",\\\"card_id\\\":1},{\\\"absolute_position\\\":3,\\\"transaction_type\\\":\\\"\\\",\\\"relative_position\\\":0,\\\"card_content_type\\\":\\\"function_entrance\\\",\\\"card_id\\\":1},{\\\"absolute_position\\\":4,\\\"transaction_type\\\":\\\"\\\",\\\"relative_position\\\":0,\\\"card_content_type\\\":\\\"function_entrance\\\",\\\"card_id\\\":1}],\\\"tab_name\\\":\\\"\\\",\\\"down_slide_times\\\":0,\\\"page_name\\\":\\\"home\\\",\\\"up_loading_times\\\":0,\\\"referrer_id\\\":\\\"\\\",\\\"referrer\\\":\\\"\\\",\\\"is_exposure\\\":\\\"1\\\",\\\"business_id\\\":\\\"\\\"},\\\"app_session_id\\\":\\\"cb2cf436-183a-4f4c-a3ac-0f8f54759f37\\\",\\\"app\\\":{\\\"version\\\":\\\"7.19.0\\\",\\\"grey_type\\\":\\\"{\\\\\\\"video_steep\\\\\\\": 0, \\\\\\\"post_detail\\\\\\\": \\\\\\\"0\\\\\\\", \\\\\\\"face_detect_result\\\\\\\": \\\\\\\"B\\\\\\\", \\\\\\\"home\\\\\\\": \\\\\\\"0\\\\\\\", \\\\\\\"face_scan\\\\\\\": 0, \\\\\\\"report_result\\\\\\\": 0}\\\",\\\"current_city_id\\\":\\\"zibo\\\",\\\"user_type\\\":{\\\"config_type\\\":\\\"1\\\"},\\\"name\\\":\\\"gengmei_user\\\",\\\"serial_id\\\":14,\\\"channel\\\":\\\"xiaomi\\\"},\\\"gm_nginx_key\\\":1,\\\"device\\\":{\\\"android_device_id\\\":\\\"androidid_e645aab7a96734d6\\\",\\\"sys_version\\\":\\\"9\\\",\\\"lng\\\":\\\"117.901306\\\",\\\"is_WiFi\\\":\\\"0\\\",\\\"lat\\\":\\\"36.658066\\\",\\\"device_id\\\":\\\"863976043011292\\\",\\\"manufacturer\\\":\\\"Xiaomi\\\",\\\"net_type\\\":\\\"4G\\\",\\\"device_type\\\":\\\"android\\\",\\\"ip\\\":\\\"10.117.57.93\\\",\\\"model\\\":\\\"MI 8\\\"},\\\"type\\\":\\\"page_precise_exposure\\\"}\"}\n"));
                // 调用kafkaProduce的send方法发送消息
                ProducerRecord<String, String> producerRecord = new ProducerRecord<String, String>("test",
//                "raw", "{\"@raw\":\"{\"gm_nginx_key\":2,\"version\":\"110\",\"params\":{\"up_slide_times\":0,\"down_loading_times\":0,\"exposure_cards\":{},\"up_loading_times\":0,\"is_exposure\":1,\"tab_name\":\"精选\",\"referrer_id\":\"\",\"down_slide_times\":0,\"referrer\":\"\",\"page_name\":\"home\",\"business_id\":\"\"},\"app_session_id\":\"C3280044-5C8E-459D-AE6C-8E26BBACD6C9\",\"gm_nginx_timestamp\":1546307958.631,\"create_at\":\"1546307958\",\"app\":{\"channel\":\"AppStore\",\"version\":\"7.7.35\",\"serial_id\":42,\"current_city_id\":\"worldwide\",\"name\":\"gengmei_user\",\"user_type\":{}},\"device\":{\"is_WiFi\":\"0\",\"device_type\":\"ios\",\"device_id\":\"DE8EA66A-BDE9-47CD-9795-24E444F5BC17\",\"lng\":0,\"lat\":0,\"ip\":\"10.156.100.97\",\"manufacturer\":\"Apple\",\"idfa\":\"DE8EA66A-BDE9-47CD-9795-24E444F5BC17\",\"idfv\":\"352A6D64-17CA-4520-831A-2CE9507631D8\"},\"user_id\":\"30864538\",\"type\":\"home_choiceness_card_exposure\"}\"}");
//                        "test","{\"gm_nginx_key\":2,\"version\":\"110\",\"params\":{\"up_slide_times\":0,\"down_loading_times\":0,\"exposure_cards\":{},\"up_loading_times\":0,\"is_exposure\":1,\"tab_name\":\"精选\",\"referrer_id\":\"\",\"down_slide_times\":0,\"referrer\":\"\",\"page_name\":\"home\",\"business_id\":\"\"},\"app_session_id\":\"C3280044-5C8E-459D-AE6C-8E26BBACD6C9\",\"gm_nginx_timestamp\":1546307958.631,\"create_at\":\"1546307958\",\"app\":{\"channel\":\"AppStore\",\"version\":\"7.7.35\",\"serial_id\":42,\"current_city_id\":\"worldwide\",\"name\":\"gengmei_user\",\"user_type\":{}},\"device\":{\"is_WiFi\":\"0\",\"device_type\":\"ios\",\"device_id\":\"DE8EA66A-BDE9-47CD-9795-24E444F5BC17\",\"lng\":0,\"lat\":0,\"ip\":\"10.156.100.97\",\"manufacturer\":\"Apple\",\"idfa\":\"DE8EA66A-BDE9-47CD-9795-24E444F5BC17\",\"idfv\":\"352A6D64-17CA-4520-831A-2CE9507631D8\"},\"user_id\":\"30864538\",\"type\":\"home_choiceness_card_exposure\"}");
                 "test", json);
                producer.send(producerRecord);

                Thread.sleep(20000);
                System.out.println("======================");
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
        producer.close();
    }
}



