package com.gmei.cache;

import com.gmei.bean.ml.MlPreciseExposureBean;
import com.gmei.bean.ml.MlPreciseExposureDetailBean;
import com.gmei.jdbc.MysqlJdbcMl;

import java.util.ArrayList;
import java.util.List;

/**
 * ClassName: MlPreciseExposureDetailDao
 * Function:
 * Reason: ml_c_et_pe_preciseexposuredetail_dimen_d_rt数据下发操作类
 * Date: 2020/04/22 上午11:35
 *
 * @author liuzhe
 * @since JDK 1.8
 */
public class MlPreciseExposureDetailDao {
    private MysqlJdbcMl mysqlJdbcMl;
    private String sql;
    private String sinkJdbcUrl;
    private String sinkTableName;

    public MlPreciseExposureDetailDao(String sinkJdbcUrl, String sinkTableName) {
        this.sinkJdbcUrl = sinkJdbcUrl;
        this.sinkTableName = sinkTableName;
        this.mysqlJdbcMl = MysqlJdbcMl.getInstance(sinkJdbcUrl);
    }

    /**
     * Function: insertMlPreciseExposure
     * Reason: 批量向表中插入数据
     * Date: 2020/04/22 下午5:38
     *
     * @author liuzhe
     * @since JDK 1.8
     */
    public void insertMlPreciseExposureBatch(ArrayList<MlPreciseExposureDetailBean> mlPreciseExposureDetailBeanList) throws Exception {
        List<List<Object>> mlPreciseExposureDetailBeanParams = new ArrayList();
        for (MlPreciseExposureDetailBean mlPreciseExposureDetailBean : mlPreciseExposureDetailBeanList) {
            sql = "insert into " + sinkTableName + "\n" +
                    "  (day_id,\n" +
                    "   action,\n" +
                    "   app_code,\n" +
                    "   page_code,\n" +
                    "   page_name,\n" +
                    "   tab_name,\n" +
                    "   business_id,\n" +
                    "   referrer_code,\n" +
                    "   referrer_name,\n" +
                    "   referrer_id,\n" +
                    "   card_id,\n" +
                    "   card_name,\n" +
                    "   card_content_type,\n" +
                    "   card_content_type_name,\n" +
                    "   card_type,\n" +
                    "   card_type_name,\n" +
                    "   is_cpc,\n" +
                    "   cpc_referer,\n" +
                    "   transaction_type,\n" +
                    "   transaction_type_name,\n" +
                    "   filter,\n" +
                    "   query,\n" +
                    "   app_version,\n" +
                    "   user_id,\n" +
                    "   device_id,\n" +
                    "   device_os_type,\n" +
                    "   current_city_id,\n" +
                    "   current_city_name,\n" +
                    "   current_province_id,\n" +
                    "   current_province_name,\n" +
                    "   current_country_id,\n" +
                    "   current_country_name,\n" +
                    "   current_region_id,\n" +
                    "   current_region_name,\n" +
                    "   create_time_date,\n" +
                    "   create_time_day,\n" +
                    "   gm_nginx_time_date,\n" +
                    "   gm_nginx_time_day,\n" +
                    "   preciseexposure_num)\n" +
                    "values\n" +
                    "  (?,\n" +
                    "   ?,\n" +
                    "   ?,\n" +
                    "   ?,\n" +
                    "   ?,\n" +
                    "   ?,\n" +
                    "   ?,\n" +
                    "   ?,\n" +
                    "   ?,\n" +
                    "   ?,\n" +
                    "   ?,\n" +
                    "   ?,\n" +
                    "   ?,\n" +
                    "   ?,\n" +
                    "   ?,\n" +
                    "   ?,\n" +
                    "   ?,\n" +
                    "   ?,\n" +
                    "   ?,\n" +
                    "   ?,\n" +
                    "   ?,\n" +
                    "   ?,\n" +
                    "   ?,\n" +
                    "   ?,\n" +
                    "   ?,\n" +
                    "   ?,\n" +
                    "   ?,\n" +
                    "   ?,\n" +
                    "   ?,\n" +
                    "   ?,\n" +
                    "   ?,\n" +
                    "   ?,\n" +
                    "   ?,\n" +
                    "   ?,\n" +
                    "   ?,\n" +
                    "   ?,\n" +
                    "   ?,\n" +
                    "   ?,\n" +
                    "   ?)";

            List<Object> params = new ArrayList<Object>();
            params.add(mlPreciseExposureDetailBean.getGm_nginx_time_day());
            params.add(mlPreciseExposureDetailBean.getAction());
            params.add(mlPreciseExposureDetailBean.getApp_code());
            params.add(mlPreciseExposureDetailBean.getPage_code());
            params.add(mlPreciseExposureDetailBean.getPage_name());
            params.add(mlPreciseExposureDetailBean.getTab_name());
            params.add(mlPreciseExposureDetailBean.getBusiness_id());
            params.add(mlPreciseExposureDetailBean.getReferrer_code());
            params.add(mlPreciseExposureDetailBean.getReferrer_name());
            params.add(mlPreciseExposureDetailBean.getReferrer_id());
            params.add(mlPreciseExposureDetailBean.getCard_id());
            params.add(mlPreciseExposureDetailBean.getCard_name());
            params.add(mlPreciseExposureDetailBean.getCard_content_type());
            params.add(mlPreciseExposureDetailBean.getCard_content_type_name());
            params.add(mlPreciseExposureDetailBean.getCard_type());
            params.add(mlPreciseExposureDetailBean.getCard_type_name());
            params.add(mlPreciseExposureDetailBean.getIs_cpc());
            params.add(mlPreciseExposureDetailBean.getCpc_referer());
            params.add(mlPreciseExposureDetailBean.getTransaction_type());
            params.add(mlPreciseExposureDetailBean.getTransaction_type_name());
            params.add(mlPreciseExposureDetailBean.getFilter());
            params.add(mlPreciseExposureDetailBean.getQuery());
            params.add(mlPreciseExposureDetailBean.getApp_version());
            params.add(mlPreciseExposureDetailBean.getUser_id());
            params.add(mlPreciseExposureDetailBean.getDevice_id());
            params.add(mlPreciseExposureDetailBean.getDevice_os_type());
            params.add(mlPreciseExposureDetailBean.getCurrent_city_id());
            params.add(mlPreciseExposureDetailBean.getCurrent_city_name());
            params.add(mlPreciseExposureDetailBean.getCurrent_province_id());
            params.add(mlPreciseExposureDetailBean.getCurrent_province_name());
            params.add(mlPreciseExposureDetailBean.getCurrent_country_id());
            params.add(mlPreciseExposureDetailBean.getCurrent_country_name());
            params.add(mlPreciseExposureDetailBean.getCurrent_region_id());
            params.add(mlPreciseExposureDetailBean.getCurrent_region_name());
            params.add(mlPreciseExposureDetailBean.getCreate_time_date());
            params.add(mlPreciseExposureDetailBean.getCreate_time_day());
            params.add(mlPreciseExposureDetailBean.getGm_nginx_time_date());
            params.add(mlPreciseExposureDetailBean.getGm_nginx_time_day());
            params.add(mlPreciseExposureDetailBean.getPreciseexposure_num());
            mlPreciseExposureDetailBeanParams.add(params);
        }

//        System.out.println(params.toString());
        mysqlJdbcMl.updateBatch(sql, mlPreciseExposureDetailBeanParams);
    }
}
