package com.gmei.function;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import org.apache.commons.lang3.StringUtils;
import org.apache.flink.streaming.api.collector.selector.OutputSelector;

import java.util.ArrayList;
import java.util.List;

/**
 * ClassName: BlMaiDianOutputSelector
 * Function:
 * Reason: BL层数据选择器
 * Date: 2019/12/7 上午11:01
 *
 * @author liuzhe
 * @since JDK 1.8
 */
public class BlMaiDianOutputSelector implements OutputSelector<String> {
    @Override
    public Iterable<String> select(String s) {
        List<String> output = new ArrayList<String>();
        JSONObject jsonObject = JSON.parseObject(s);
        String action = jsonObject.getString("type");
//        System.out.println(s);
        if ("home_choiceness_card_exposure".equals(action) || "page_precise_exposure".equals(action)) {
            output.add("et_pe");
        } else if ("page_view".equals(action)) {
            output.add("et_le");
        } else if (StringUtils.containsIgnoreCase(action,"click")) {
            output.add("et_ck");
        } else {
            output.add("et_ot");
        }
        return output;
    }
}
