package com.gmei.function;

import com.gmei.bean.bl.BlPreciseExposureBean;
import org.apache.flink.streaming.api.functions.AssignerWithPeriodicWatermarks;
import org.apache.flink.streaming.api.watermark.Watermark;

import javax.annotation.Nullable;

/**
 * ClassName: BlPreciseExposureWatermark
 * Function: TODO ADD FUNCTION.
 * Reason: TODO ADD REASON.
 * Date: 2020/1/8 下午8:40
 *
 * @author liuzhe
 * @since JDK 1.8
 */
public class BlPreciseExposureWatermark implements AssignerWithPeriodicWatermarks<BlPreciseExposureBean> {
    private final long maxOutOfOrderness = 10000;
    private long currentMaxTimestamp;
    @Override
    public long extractTimestamp(BlPreciseExposureBean blPreciseExposureBean, long l) {
//        Double timestampDouble = Double.parseDouble(blPreciseExposureBean.getGm_nginx_timestamp());
//        long timestamp = new Double(timestampDouble * 1000).longValue();
        Double timestampDouble = Double.parseDouble(blPreciseExposureBean.getGm_nginx_timestamp()) * 1000;
        long timestamp = timestampDouble.longValue();
        currentMaxTimestamp = Math.max(timestamp, currentMaxTimestamp);
        return timestamp;
    }

    @Nullable
    @Override
    public Watermark getCurrentWatermark() {
        return new Watermark(currentMaxTimestamp - maxOutOfOrderness);
    }
}
