package com.gmei.function;

import com.gmei.bean.dim.DimCity;
import com.gmei.bean.dim.DimCardContentType;
import com.gmei.bean.ml.MlPreciseExposureBean;
import com.gmei.bean.dim.DimPageType;
import com.gmei.bean.dim.DimTable;
import com.gmei.cache.DimTableCallable;
import com.gmei.cache.SimpleCacheService;
import com.gmei.utils.DimTableList;
import com.google.common.base.Function;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.streaming.api.functions.async.ResultFuture;
import org.apache.flink.streaming.api.functions.async.RichAsyncFunction;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;

/**
 * ClassName: DimRichAsyncFunction
 * Function:
 * Reason: ML层维度关联器（异步调用）
 * Date: 2019/12/7 上午11:01
 *
 * @author liuzhe
 * @since JDK 1.8
 */
public class DimRichAsyncFunction extends RichAsyncFunction<MlPreciseExposureBean, MlPreciseExposureBean> {
    public static final SimpleCacheService<String, DimCity> dimCityCache = new SimpleCacheService<>(2000, 24);
    public static final SimpleCacheService<String, DimTable> dimCardTypeCache = new SimpleCacheService<>(2000, 24);
    public static final SimpleCacheService<String, DimTable> dimTransactionTypeCache = new SimpleCacheService<>(2000, 24);
    public static final SimpleCacheService<String, DimPageType> dimPageTypeCache = new SimpleCacheService<>(2000, 24);
    public static final SimpleCacheService<String, DimCardContentType> dimCardContentTypeCache = new SimpleCacheService<>(2000, 24);

    public String dimJdbcUrl;

    public DimRichAsyncFunction(String dimJdbcUrl) {
        this.dimJdbcUrl = dimJdbcUrl;
    }

    @Override
    public void open(Configuration parameters) throws Exception {
        super.open(parameters);
        initDimTable();
    }

    @Override
    public void asyncInvoke(MlPreciseExposureBean mlPreciseExposureBean, ResultFuture<MlPreciseExposureBean> resultFuture) throws Exception {
        String current_city_id = mlPreciseExposureBean.getCurrent_city_id();
        String page_code = mlPreciseExposureBean.getPage_code();
        String referrer_code = mlPreciseExposureBean.getReferrer_code();
        String card_type = mlPreciseExposureBean.getCard_type();
        String card_content_type = mlPreciseExposureBean.getCard_content_type();
        String transaction_type= mlPreciseExposureBean.getTransaction_type();
        String gm_nginx_time_day = mlPreciseExposureBean.getGm_nginx_time_day();


        //刷新一次缓存
//        if(gm_nginx_time_day != null){
//            if(gm_nginx_time_day.compareTo(gm_nginx_time_day) < 0){
//                dimCityCache.clearCache();
//                dimCardTypeCache.clearCache();
//                dimTransactionTypeCache.clearCache();
//                dimPageTypeCache.clearCache();
//                dimCardContentTypeCache.clearCache();
//                initDimTable();
//            }
//        }

        //1.8 城市字段问题
        //问题描述：城市id为数字tagid的修正为正确的拼音,还加了过滤重复的数据
        //解决方案：dimCityCache缓存中的key既有城市ID又有城市TAGID，获取到城市对象后将正确的城市ID填充到Current_city_id中
        if (current_city_id != null) {
            DimCity dimCity = dimCityCache.getValue(current_city_id, new DimTableCallable(current_city_id, DimTableList.DIM_CITY.getTableName(), dimJdbcUrl));
            if (dimCity != null) {
                if (dimCity.getName() == null) {
                    dimCityCache.invalidate(current_city_id);
                } else {
                    mlPreciseExposureBean.setCurrent_city_id(dimCity.getCode());
                    mlPreciseExposureBean.setCurrent_city_name(dimCity.getName());
                    mlPreciseExposureBean.setCurrent_province_id(dimCity.getParent_province_code());
                    mlPreciseExposureBean.setCurrent_province_name(dimCity.getParent_province_name());
                    mlPreciseExposureBean.setCurrent_country_id(dimCity.getParent_country_code());
                    mlPreciseExposureBean.setCurrent_country_name(dimCity.getParent_country_name());
                    mlPreciseExposureBean.setCurrent_region_id(dimCity.getParent_region_code());
                    mlPreciseExposureBean.setCurrent_region_name(dimCity.getParent_region_name());
                }
            }
        }
        if (page_code != null) {
            DimPageType dimPageType = dimPageTypeCache.getValue(page_code, new DimTableCallable(page_code, DimTableList.DIM_PAGE_TYPE.getTableName(), dimJdbcUrl));
            if (dimPageType != null) {
                if (dimPageType.getName() == null) {
                    dimPageTypeCache.invalidate(page_code);
                } else {
                    mlPreciseExposureBean.setPage_name(dimPageType.getName());
                }
            }
        }
        if (referrer_code != null) {
            DimPageType dimReferrerType = dimPageTypeCache.getValue(referrer_code, new DimTableCallable(referrer_code, DimTableList.DIM_PAGE_TYPE.getTableName(), dimJdbcUrl));
            if (dimReferrerType != null) {
                if (dimReferrerType.getName() == null) {
                    dimPageTypeCache.invalidate(referrer_code);
                } else {
                    mlPreciseExposureBean.setReferrer_name(dimReferrerType.getName());
                }
            }
        }
        if (card_content_type != null) {
            DimCardContentType dimCardContentType = dimCardContentTypeCache.getValue(card_content_type, new DimTableCallable(card_content_type, DimTableList.DIM_CARD_CONTENT_TYPE.getTableName(), dimJdbcUrl));
            if (dimCardContentType != null) {
                if (dimCardContentType.getName() == null) {
                    dimCardContentTypeCache.invalidate(card_content_type);
                } else {
                    mlPreciseExposureBean.setCard_content_type(dimCardContentType.getNew_code());
                    mlPreciseExposureBean.setCard_content_type_name(dimCardContentType.getName());
                }
            }
        }
        if (card_type != null) {
            DimTable dimCardType = dimCardTypeCache.getValue(card_type, new DimTableCallable(card_type, DimTableList.DIM_CARD_TYPE.getTableName(), dimJdbcUrl));
            if (dimCardType != null) {
                if (dimCardType.getName() == null) {
                    dimCardTypeCache.invalidate(card_type);
                } else {
                    mlPreciseExposureBean.setCard_type_name(dimCardType.getName());
                }
            }
        }
        if (transaction_type != null) {
            DimTable dimTransactionType = dimTransactionTypeCache.getValue(transaction_type, new DimTableCallable(transaction_type, DimTableList.DIM_TRANSACTION_TYPE.getTableName(), dimJdbcUrl));
            if (dimTransactionType != null) {
                if (dimTransactionType.getName() == null) {
                    dimTransactionTypeCache.invalidate(transaction_type);
                } else {
                    mlPreciseExposureBean.setTransaction_type_name(dimTransactionType.getName());
                }
            }
        }
//        System.out.println(mlPreciseExposureBean);
        resultFuture.complete(Collections.singleton(mlPreciseExposureBean));
    }

    /**
    * Function: initDimTable
    * Reason: dim码表缓存初始化
    * Date: 2019/12/25 下午5:16
    *
    * @author liuzhe
    * @since JDK 1.8
    */
    public void initDimTable() throws Exception {
        ExecutorService es = Executors.newFixedThreadPool(DimTableList.values().length);

        Future dimCityFuture = es.submit(new DimTableCallable(null, DimTableList.DIM_CITY.getTableName(), dimJdbcUrl));
        Future dimCardTypeFuture = es.submit(new DimTableCallable(null, DimTableList.DIM_CARD_TYPE.getTableName(), dimJdbcUrl));
        Future dimCardContentTypeFuture = es.submit(new DimTableCallable(null, DimTableList.DIM_CARD_CONTENT_TYPE.getTableName(), dimJdbcUrl));
        Future dimPageTypeFuture = es.submit(new DimTableCallable(null, DimTableList.DIM_PAGE_TYPE.getTableName(), dimJdbcUrl));
        Future dimTransactionTypeFuture = es.submit(new DimTableCallable(null, DimTableList.DIM_TRANSACTION_TYPE.getTableName(), dimJdbcUrl));
        ArrayList<DimCity> dimCityList  = (ArrayList<DimCity>) dimCityFuture.get();
        ArrayList<DimTable> dimCardTypeList  = (ArrayList<DimTable>) dimCardTypeFuture.get();
        ArrayList<DimCardContentType> dimCardContentList  = (ArrayList<DimCardContentType>) dimCardContentTypeFuture.get();
        ArrayList<DimPageType> dimPageTypeList  = (ArrayList<DimPageType>) dimPageTypeFuture.get();
        ArrayList<DimTable> dimTransactionTypeList  = (ArrayList<DimTable>) dimTransactionTypeFuture.get();
        ImmutableMap<String, DimCity> dimCityCodeMap = Maps.uniqueIndex(dimCityList, new Function<DimCity, String>() {
            @Override
            public String apply(DimCity dimCity) {
                return dimCity.getCode();
            }
        });
        ImmutableMap<String, DimCity> dimCityTagMap = Maps.uniqueIndex(dimCityList, new Function<DimCity, String>() {
            @Override
            public String apply(DimCity dimCity) {
                return dimCity.getPk();
            }
        });
        ImmutableMap<String, DimTable> dimCardTypeMap = Maps.uniqueIndex(dimCardTypeList, new Function<DimTable, String>() {
            @Override
            public String apply(DimTable dimTable) {
                return dimTable.getCode();
            }
        });
        ImmutableMap<String, DimCardContentType> dimCardContentMap = Maps.uniqueIndex(dimCardContentList, new Function<DimCardContentType, String>() {
            @Override
            public String apply(DimCardContentType dimTableTransForm) {
                return dimTableTransForm.getCode();
            }
        });
        ImmutableMap<String, DimPageType> dimPageTypeMap = Maps.uniqueIndex(dimPageTypeList, new Function<DimPageType, String>() {
            @Override
            public String apply(DimPageType dimPageType) {
                return dimPageType.getCode();
            }
        });
        ImmutableMap<String, DimTable> dimTransactionTypeMap = Maps.uniqueIndex(dimTransactionTypeList, new Function<DimTable, String>() {
            @Override
            public String apply(DimTable dimTable) {
                return dimTable.getCode();
            }
        });
        dimCityCache.putValues(dimCityCodeMap); //根据city_id匹配城市
        dimCityCache.putValues(dimCityTagMap); //根据tag_id匹配城市
        dimCardTypeCache.putValues(dimCardTypeMap);
        dimCardContentTypeCache.putValues(dimCardContentMap);
        dimPageTypeCache.putValues(dimPageTypeMap);
        dimTransactionTypeCache.putValues(dimTransactionTypeMap);
        System.out.println("dimCityCache:"+dimCityCache.cacheSize());
        System.out.println("dimCardTypeCache:"+dimCardTypeCache.cacheSize());
        System.out.println("dimCardContentTypeCache:"+dimCardContentTypeCache.cacheSize());
        System.out.println("dimPageTypeCache:"+dimPageTypeCache.cacheSize());
        System.out.println("dimTransactionTypeCache:"+dimTransactionTypeCache.cacheSize());
    }
}
