package com.gmei.function;

import com.gmei.bean.bl.BlPreciseExposureBean;
import com.gmei.bean.bl.BlPreciseExposureParamsExposureCardsBean;
import com.gmei.bean.ml.MlPreciseExposureDetailBean;
import com.gmei.utils.BeanReflectUtil;
import org.apache.flink.api.common.functions.FlatMapFunction;
import org.apache.flink.util.Collector;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

/**
 * ClassName: MlpreciseExposureDetailFlatMapFunction
 * Function:
 * Reason: ML层明细数据清洗转换器（一对多）
 * Date: 2020/04/22 上午11:01
 *
 * @author liuzhe
 * @since JDK 1.8
 */
public class MlpreciseExposureDetailFlatMapFunction implements FlatMapFunction<BlPreciseExposureBean, MlPreciseExposureDetailBean> {
    @Override
    public void flatMap(BlPreciseExposureBean blPreciseExposureBean, Collector<MlPreciseExposureDetailBean> collector) throws Exception {
        ArrayList<MlPreciseExposureDetailBean> mlPreciseExposureDetailBeanList = flatmapBlPreciseExposure(blPreciseExposureBean);
//        System.out.println("MlpreciseExposureFlatMapFunction" + blPreciseExposureBean);
        for (MlPreciseExposureDetailBean mlPreciseExposureDetailBean : mlPreciseExposureDetailBeanList) {
            collector.collect(mlPreciseExposureDetailBean);
        }
    }

    /**
    * Function: flatmapBlPreciseExposure
    * Reason: 数据爆炸（LATERAL VIEW EXPLODE）
    * Date: 2019/12/25 下午5:14
    *
    * @author liuzhe
    * @since JDK 1.8
    */
    public ArrayList<MlPreciseExposureDetailBean> flatmapBlPreciseExposure(BlPreciseExposureBean blPreciseExposureBean) throws Exception {
        ArrayList<BlPreciseExposureParamsExposureCardsBean> exposure_cards = blPreciseExposureBean.getExposure_cards();
        String app_version = blPreciseExposureBean.getApp_version();
        String device_os_type = blPreciseExposureBean.getDevice_os_type();
        ArrayList<MlPreciseExposureDetailBean> mlPreciseExposureDetailBeanDetailList = new ArrayList<>();
        for(BlPreciseExposureParamsExposureCardsBean exposureCardsBean: exposure_cards) {
            String card_id = exposureCardsBean.getCard_id();
            String card_content_type = exposureCardsBean.getCard_content_type();
            String card_type = exposureCardsBean.getCard_type();
            String card_name = exposureCardsBean.getCard_name();
            String target_name = exposureCardsBean.getTarget_name();
            String is_cpc = exposureCardsBean.getIs_cpc();
            String cpc_referer = exposureCardsBean.getCpc_referer();
            String absolute_position = exposureCardsBean.getAbsolute_position();
            String relative_position = exposureCardsBean.getRelative_position();
            String transaction_type = exposureCardsBean.getTransaction_type();

            //1.3 绝对位置和相对位置位置错误
            //问题描述：在'7.7.35','7.7.36' android的绝对位置和相对位置写反
            if("android".equals(device_os_type) && ("7.7.35".equals(app_version) || "7.7.36".equals(app_version))) {
                String change = absolute_position;
                absolute_position = relative_position;
                relative_position = change;
            }

            //1.10 banner、豆腐块、icon、搜索词和功能区入口的card_type参数问题
            //问题描述：当卡片类型为豆腐块、icon、banner、搜索词和功能区入口的时候的时候正确的card_type的参数值被赋给了card_content_type（banner、icon、gadget、search_query、function_entrance）
            List<String> card_content_type_list = Arrays.asList("banner","icon","gadget","search_query","function_entrance");
            if (card_content_type_list.contains(card_content_type)) {
                card_type = card_content_type;
                card_content_type = null;
            }
            if ("search_query".equals(card_type)) {
                card_type = "search_word";
            }

            //1.14 百科卡片曝光新增参数wiki_type
            //问题：从7.19.0版本开始，百科卡片曝光,新增了wiki_type参数

            //1.12 card_content_type的qa值应该被换成q_a
            if ("qa".equals(card_content_type)) {
                card_content_type = card_content_type.replace("qa","q_a");
            }
            //card_type为card的标准码值为common_card,数据中为card
            if("card".equals(card_type)) {
                card_type = "common_card";
            }
            //card_type为banner的标准码值为common_banner,数据中为banner
            if("banner".equals(card_type)) {
                card_type = "common_banner";
            }
            //card_type为video的标准码值为video_card,数据中为video
            if("video".equals(card_type)) {
                card_type = "video_card";
            }

            //1.16 初期的搜索词曝光业务类型运营有promote,operating字段，需要修正为operation
            if("promote".equals(transaction_type) || "operating".equals(transaction_type)) {
                transaction_type = "operation";
            }

            MlPreciseExposureDetailBean mlPreciseExposureDetailBean = new MlPreciseExposureDetailBean();
            mlPreciseExposureDetailBean.setDay_id(blPreciseExposureBean.getDay_id());
            mlPreciseExposureDetailBean.setUser_id(blPreciseExposureBean.getUser_id());
            mlPreciseExposureDetailBean.setAction(blPreciseExposureBean.getAction());

            mlPreciseExposureDetailBean.setPage_code(blPreciseExposureBean.getPage_code());

            mlPreciseExposureDetailBean.setTab_name(blPreciseExposureBean.getTab_name());
            mlPreciseExposureDetailBean.setBusiness_id(blPreciseExposureBean.getBusiness_id());
            mlPreciseExposureDetailBean.setReferrer_code(blPreciseExposureBean.getReferrer_code());

            mlPreciseExposureDetailBean.setReferrer_id(blPreciseExposureBean.getReferrer_id());

            mlPreciseExposureDetailBean.setCard_id(card_id);
            mlPreciseExposureDetailBean.setCard_content_type(card_content_type);

            //1.13 target_name与card_name的参数的统一
            //问题描述：将target_name参数的值赋给card_name
            mlPreciseExposureDetailBean.setCard_name(card_name == null ? target_name : card_name);

            mlPreciseExposureDetailBean.setCard_type(card_type);
            mlPreciseExposureDetailBean.setIs_cpc(is_cpc);
            mlPreciseExposureDetailBean.setCpc_referer(cpc_referer);
//            mlPreciseExposureDetailBean.setAbsolute_position(absolute_position);
//            mlPreciseExposureDetailBean.setRelative_position(relative_position);
            mlPreciseExposureDetailBean.setTransaction_type(transaction_type);

            mlPreciseExposureDetailBean.setFilter(blPreciseExposureBean.getFilter());
            mlPreciseExposureDetailBean.setQuery(blPreciseExposureBean.getQuery());
//            mlPreciseExposureDetailBean.setChannel_id(blPreciseExposureBean.getApp_channel());
            mlPreciseExposureDetailBean.setApp_version(blPreciseExposureBean.getApp_version());
            mlPreciseExposureDetailBean.setCurrent_city_id(blPreciseExposureBean.getApp_current_city_id());

            mlPreciseExposureDetailBean.setApp_code(blPreciseExposureBean.getApp_code());
            mlPreciseExposureDetailBean.setDevice_os_type(blPreciseExposureBean.getDevice_os_type());
            mlPreciseExposureDetailBean.setDevice_id(blPreciseExposureBean.getDevice_id());
            mlPreciseExposureDetailBean.setCreate_time_date(blPreciseExposureBean.getCreate_time_date());
            mlPreciseExposureDetailBean.setCreate_time_day(blPreciseExposureBean.getCreate_time_day());
            mlPreciseExposureDetailBean.setGm_nginx_time_date(blPreciseExposureBean.getGm_nginx_time_date());
            mlPreciseExposureDetailBean.setGm_nginx_time_day(blPreciseExposureBean.getGm_nginx_time_day());
            mlPreciseExposureDetailBean.setPreciseexposure_num(1);

            //1.11 transaction_type的空值需要被修正
            //问题描述：transaction_type='' 需要替换为NULL
            mlPreciseExposureDetailBeanDetailList.add(BeanReflectUtil.setNullValue(mlPreciseExposureDetailBean));
        }
        return mlPreciseExposureDetailBeanDetailList;
    }
}
