package com.gmei.sink;

import com.gmei.bean.ml.MlPreciseExposureDetailBean;
import com.gmei.cache.MlPreciseExposureDetailDao;
import com.gmei.jdbc.MysqlJdbcMl;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.streaming.api.functions.sink.RichSinkFunction;

import java.sql.Connection;
import java.util.ArrayList;

/**
 * ClassName: MlPreciseExposureMysqlSink
 * Function:
 * Reason: 数据下发mysql
 * Date: 2019/12/16 下午6:45
 *
 * @author liuzhe
 * @since JDK 1.8
 */
public class MlPreciseExposureDetailMysqlSink extends RichSinkFunction<ArrayList<MlPreciseExposureDetailBean>> {

    private MysqlJdbcMl mysqlJdbcMl;
    private Connection conn;
    private MlPreciseExposureDetailDao mlPreciseExposureDetailDao;
    private int maxRetry = 1;
    private long retryTime = 3000;
    private String sinkJdbcUrl;
    private String sinkTableName;

    public MlPreciseExposureDetailMysqlSink(String sinkJdbcUrl, String sinkTableName) {
        this.sinkJdbcUrl = sinkJdbcUrl;
        this.sinkTableName = sinkTableName;
    }

    @Override
    public void open(Configuration parameters) throws Exception {
        super.open(parameters);
        mysqlJdbcMl = MysqlJdbcMl.getInstance(sinkJdbcUrl);
        mlPreciseExposureDetailDao = new MlPreciseExposureDetailDao(sinkJdbcUrl, sinkTableName);
        conn = mysqlJdbcMl.getConnection();
    }

    @Override
    public void invoke(ArrayList<MlPreciseExposureDetailBean> value, Context context) throws Exception {

        try {
            conn.setAutoCommit(false);
            mlPreciseExposureDetailDao.insertMlPreciseExposureBatch(value);
            conn.commit();
        } catch (Exception e) {
            conn.rollback();
            int numRetry = 1;
            Exception lastException = e;
            while (numRetry <= maxRetry) {
                try {
                    numRetry ++;
                    Thread.sleep(retryTime);
                    mysqlJdbcMl.close(conn, null, null);
                    conn = mysqlJdbcMl.getConnection();
                    conn.setAutoCommit(false);
                    mlPreciseExposureDetailDao.insertMlPreciseExposureBatch(value);
                    conn.commit();
                } catch (Exception e1) {
                    conn.rollback();
                    lastException = e1;
                    continue;
                }
                return;
            }
            throw lastException;
        }
    }

    @Override
    public void close() throws Exception {
        super.close();
        mysqlJdbcMl.close(conn, null, null);
    }
}
