INSERT OVERWRITE TABLE ML_C_ET_PE_PRECISEEXPOSURE_DIMEN_D PARTITION (PARTITION_DAY = '${partition_day}')
SELECT T8.JSON, --原始日志
       T8.APP, --APP字段（MAP）
       T8.PARAMS, --埋点参数字段(MAP)
       T8.DEVICE, --埋点device字段(MAP)
       T8.GM_NGINX_KEY,
       T8.CREATE_TIMESTAMP, --时间戳
       T8.GM_NGINX_TIMESTAMP, --服务端接收时间戳
       T8.VERSION, --版本信息
       T8.APP_SESSION_ID, --客户端回话id
       T8.APP_SERIAL_ID, --埋点序列id
       T8.APP_USER_TYPE, --app用户类型
       T8.CHANNEL_ID, --渠道id
       T8.CURRENT_CITY_ID, --当前城市id
       T8.APP_CODE, --app名称
       T8.APP_VERSION, --app版本
       T8.APP_GREY_TYPE, --灰度组
       T8.USER_ID, --用户id
       T8.DEVICE_ID, --设备id
       T8.DEVICE_MANUFACTURER, --设备制造商
       T8.DEVICE_OS_TYPE, --设备类型
       T8.DEVICE_MODEL, --设备型号
       T8.DEVICE_SYS_VERSION, --设备系统版本
       T8.DEVICE_NET_TYPE, --设备网络类型
       T8.DEVICE_ANDROID_ID, --设备安卓ID
       T8.DEVICE_IP, --设备IP
       T8.DEVICE_IDFV, --设备IDFV
       T8.DEVICE_IDFA, --设备IDFA
       T8.LOCATION, --位置
       T8.ACTION, --事件名称
       T8.PAGE_CODE, --页面名称
       T8.BUSINESS_ID, --业务ID
       T8.TAB_CODE, --tab编码
       T8.REFERRER_CODE, --上级页面编码
       T8.REFERRER_ID, --上级页面ID
       T8.UP_LOADING_TIMES, --上拉加载次数
       T8.DOWN_LOADING_TIMES, --下拉加载次数
       T8.UP_SLIDE_TIMES, --上拉滑动次数
       T8.DOWN_SLIDE_TIMES, --下拉滑动次数
       T8.IS_EXPOSURE, --是否曝光
       T8.EXPOSURE_CARDS, --曝光所有卡片
       T8.MODULE_ID, --模块id
       T8.MODULE_TYPE, --模块类型，豆腐块才有该参数
       T8.CARD_ID, --卡片ID
       T8.CARD_TYPE, --卡片类型
       NVL(T8.CARD_NAME,T8.QUERY) CARD_NAME, --卡片名称
       T8.CARD_CONTENT_TYPE, --卡片内容类型
       T8.TRANSACTION_TYPE,
       T8.IS_CPC, --是否cpc计费
       T8.CPC_REFERER, --cpc_referer值
       T8.ABSOLUTE_POSITION, --绝对位置
       T8.RELATIVE_POSITION, --相对位置
       T8.FILTER, --筛选条件
       NVL(T12.NEW_CODE,T8.GRID) AS PAGE_POSITION, --卡片上的业务区域
       T8.RESULT_STATUS, --结果状态
       T8.URL, --跳转链接
       T8.CURRENT_POSITION, --点击icon在第几屏
       T8.TOTAL_POSITION, --总共有几屏
       T8.WIKI_WORD, --wiki卡片上的关键字
       T8.GM_NGINX_TIME_DATE, --服务端接收时间
       T8.GM_NGINX_TIME_DAY, --服务端接收日期
       T8.CREATE_TIME_DATE, --时间戳格式化后的时间
       T8.CREATE_TIME_DAY, --时间戳格式化后的日期
       T8.DOCTOR_ID, --医生ID
       T9.HOSPITAL_ID, --医院ID
       T9.BUSINESS_PARTNER_ID, --商务ID
       T10.MERCHANT_ID, --商户ID
       T11.MERCHANT_DOCTOR_ID, --机构管理者ID
       'pe' AS EVENT_TYPE,--事件类型
       1 AS PRECISEEXPOSURE_NUM
FROM (SELECT T3.*,
             CASE
                 WHEN T3.CARD_CONTENT_TYPE = 'service' THEN
                     T4.DOCTOR_ID
                 WHEN T3.CARD_CONTENT_TYPE = 'doctor' THEN
                     T3.CARD_ID
                 WHEN T3.CARD_CONTENT_TYPE = 'hospital' THEN
                     T5.DOCTOR_ID
                 WHEN T3.CARD_CONTENT_TYPE = 'diary' THEN
                     T6.DOCTOR_ID
                 WHEN T3.CARD_CONTENT_TYPE = 'topic' THEN
                     T7.DOCTOR_ID
                 ELSE
                     NULL
                 END AS DOCTOR_ID
      FROM (SELECT T2.JSON AS JSON, --原始日志
                   T2.APP AS APP, --APP字段（MAP）
                   T2.PARAMS AS PARAMS, --埋点参数字段(MAP)
                   T2.DEVICE AS DEVICE, --埋点device字段(MAP)
                   T2.GM_NGINX_KEY AS GM_NGINX_KEY,
                   T2.CREATE_TIMESTAMP AS CREATE_TIMESTAMP, --时间戳
                   T2.GM_NGINX_TIMESTAMP AS GM_NGINX_TIMESTAMP, --服务端接收时间戳
                   T2.VERSION AS VERSION, --版本信息
                   T2.APP_SESSION_ID AS APP_SESSION_ID, --客户端回话id
                   T2.APP_SERIAL_ID AS APP_SERIAL_ID, --埋点序列id
                   T2.APP_USER_TYPE AS APP_USER_TYPE, --app用户类型
                   T2.APP_CHANNEL AS CHANNEL_ID, --渠道id
                   T2.APP_CURRENT_CITY_ID AS CURRENT_CITY_ID, --当前城市id
                   T2.APP_NAME AS APP_CODE, --app名称
                   T2.APP_VERSION AS APP_VERSION, --app版本
                   T2.APP_GREY_TYPE AS APP_GREY_TYPE, --灰度组
                   T2.USER_ID AS USER_ID, --用户id
                   T2.DEVICE_ID AS DEVICE_ID, --设备id
                   T2.DEVICE_MANUFACTURER AS DEVICE_MANUFACTURER, --设备制造商
                   T2.DEVICE_TYPE AS DEVICE_OS_TYPE, --设备类型
                   T2.DEVICE_MODEL AS DEVICE_MODEL, --设备型号
                   T2.DEVICE_SYS_VERSION AS DEVICE_SYS_VERSION, --设备系统版本
                   T2.DEVICE_NET_TYPE AS DEVICE_NET_TYPE, --设备网络类型
                   T2.DEVICE_ANDROID_ID AS DEVICE_ANDROID_ID, --设备安卓ID
                   T2.DEVICE_IP AS DEVICE_IP, --设备IP
                   T2.DEVICE_IDFV AS DEVICE_IDFV, --设备IDFV
                   T2.DEVICE_IDFA AS DEVICE_IDFA, --设备IDFA
                   ARRAY(T2.DEVICE_LAT, T2.DEVICE_LNG) AS LOCATION, --位置
                   T2.TYPE AS ACTION, --事件名称
                   T2.PARAMS_PAGE_NAME AS PAGE_CODE, --页面名称
                   T2.PARAMS_BUSINESS_ID AS BUSINESS_ID, --业务ID
                   T2.PARAMS_TAB_NAME AS TAB_CODE, --tab编码
                   T2.PARAMS_REFERRER AS REFERRER_CODE, --上级页面编码
                   T2.PARAMS_REFERRER_ID AS REFERRER_ID, --上级页面ID
                   T2.PARAMS_UP_LOADING_TIMES AS UP_LOADING_TIMES, --上拉加载次数
                   T2.PARAMS_DOWN_LOADING_TIMES AS DOWN_LOADING_TIMES, --下拉加载次数
                   T2.PARAMS_UP_SLIDE_TIMES AS UP_SLIDE_TIMES, --上拉滑动次数
                   T2.PARAMS_DOWN_SLIDE_TIMES AS DOWN_SLIDE_TIMES, --下拉滑动次数
                   T2.PARAMS_IS_EXPOSURE AS IS_EXPOSURE, --是否曝光
                   T2.PARAMS_EXPOSURE_CARDS AS EXPOSURE_CARDS, --曝光所有卡片
                   T2.MODULE_ID AS MODULE_ID, --模块id
                   T2.MODULE_TYPE AS MODULE_TYPE, --模块类型，豆腐块才有该参数
                   STRING(CARD_ID) AS CARD_ID, --卡片ID
                   T2.CARD_TYPE AS CARD_TYPE, --卡片类型
                   T2.CARD_NAME AS CARD_NAME, --卡片名称
                   T2.CARD_CONTENT_TYPE AS CARD_CONTENT_TYPE, --卡片内容类型
                   T2.TRANSACTION_TYPE_LIST [ POS ] AS TRANSACTION_TYPE,
                   T2.PARAMS_QUERY AS QUERY, --搜索词
                   T2.IS_CPC AS IS_CPC, --是否cpc计费
                   T2.CPC_REFERER AS CPC_REFERER, --cpc_referer值
                   T2.ABSOLUTE_POSITION AS ABSOLUTE_POSITION, --绝对位置
                   T2.RELATIVE_POSITION AS RELATIVE_POSITION, --相对位置
                   T2.FILTER AS FILTER, --筛选条件
                   T2.IN_PAGE_POS AS PAGE_POSITION, --卡片上的业务区域
                   T2.RESULT_STATUS AS RESULT_STATUS, --结果状态
                   T2.URL AS URL, --跳转链接
                   T2.GRID AS GRID, --那个区域（a、b、c、d，目前线上最多四张图片）
                   T2.CURRENT_POSITION AS CURRENT_POSITION, --点击icon在第几屏
                   T2.TOTAL_POSITION AS TOTAL_POSITION, --总共有几屏
                   T2.WIKI_WORD AS WIKI_WORD, --wiki卡片上的关键字
                   T2.GM_NGINX_TIME_DATE AS GM_NGINX_TIME_DATE, --服务端接收时间
                   T2.GM_NGINX_TIME_DAY AS GM_NGINX_TIME_DAY, --服务端接收日期
                   T2.CREATE_TIME_DATE AS CREATE_TIME_DATE, --时间戳格式化后的时间
                   T2.CREATE_TIME_DAY AS CREATE_TIME_DAY --时间戳格式化后的日期
            FROM (SELECT T1.JSON,
                         T1.GM_NGINX_KEY,
                         T1.VERSION,
                         T1.PARAMS,
                         T1.APP_SESSION_ID,
                         T1.GM_NGINX_TIMESTAMP,
                         T1.CREATE_TIMESTAMP,
                         T1.APP,
                         T1.DEVICE,
                         T1.USER_ID,
                         T1.TYPE,
                         T1.PARAMS_DOWN_LOADING_TIMES,
                         T1.PARAMS_UP_LOADING_TIMES,
                         T1.PARAMS_DOWN_SLIDE_TIMES,
                         T1.PARAMS_UP_SLIDE_TIMES,
                         T1.PARAMS_PAGE_NAME,
                         T1.PARAMS_TAB_NAME,
                         T1.PARAMS_BUSINESS_ID,
                         T1.PARAMS_REFERRER,
                         T1.PARAMS_REFERRER_ID,
                         T1.PARAMS_EXPOSURE_CARDS,
                         T1.PARAMS_IS_EXPOSURE,
                         T1.PARAMS_QUERY,
                         T1.APP_GREY_TYPE,
                         T1.APP_CHANNEL,
                         T1.APP_VERSION,
                         T1.APP_SERIAL_ID,
                         T1.APP_CURRENT_CITY_ID,
                         T1.APP_NAME,
                         T1.APP_USER_TYPE,
                         T1.DEVICE_TYPE,
                         T1.DEVICE_MODEL,
                         T1.DEVICE_SYS_VERSION,
                         T1.DEVICE_NET_TYPE,
                         T1.DEVICE_ID,
                         T1.DEVICE_ANDROID_ID,
                         T1.DEVICE_LNG,
                         T1.DEVICE_LAT,
                         T1.DEVICE_IP,
                         T1.DEVICE_MANUFACTURER,
                         T1.DEVICE_IDFV,
                         T1.DEVICE_IDFA,
                         T1.GM_NGINX_TIME_DATE,
                         T1.GM_NGINX_TIME_DAY,
                         T1.CREATE_TIME_DATE,
                         T1.CREATE_TIME_DAY,
                         RESULT_CARD, --将card_id拼成数组形式['1001']
                         CASE
                             WHEN INSTR(TRIM(GET_JSON_OBJECT(RESULT_CARD,
                                                             "$.card_id")),
                                        '[') = 1 AND
                                  INSTR(TRIM(GET_JSON_OBJECT(RESULT_CARD,
                                                             "$.card_id")),
                                        ']') =
                                  LENGTH(TRIM(GET_JSON_OBJECT(RESULT_CARD,
                                                              "$.card_id"))) THEN
                                 JSON_SPLIT(TRIM(GET_JSON_OBJECT(RESULT_CARD,
                                                                 "$.card_id")))
                             ELSE
                                 ARRAY(IF(TRIM(GET_JSON_OBJECT(RESULT_CARD,
                                                               "$.card_id")) = '',
                                          NULL,
                                          TRIM(GET_JSON_OBJECT(RESULT_CARD,
                                                               "$.card_id"))))
                             END AS CARD_ID_LIST, --将transaction_type拼成数组的形式['-1']
                         CASE
                             WHEN INSTR(TRIM(GET_JSON_OBJECT(RESULT_CARD,
                                                             "$.transaction_type")),
                                        '[') = 1 AND
                                  INSTR(TRIM(GET_JSON_OBJECT(RESULT_CARD,
                                                             "$.transaction_type")),
                                        ']') =
                                  LENGTH(TRIM(GET_JSON_OBJECT(RESULT_CARD,
                                                              "$.transaction_type"))) THEN
                                 JSON_SPLIT(TRIM(GET_JSON_OBJECT(RESULT_CARD,
                                                                 "$.transaction_type")))
                             ELSE
                                 ARRAY(IF(TRIM(GET_JSON_OBJECT(RESULT_CARD,
                                                               "$.transaction_type")) = '',
                                          NULL,
                                          TRIM(GET_JSON_OBJECT(RESULT_CARD,
                                                               "$.transaction_type"))))
                             END AS TRANSACTION_TYPE_LIST, --card_content_type为'banner','icon','gadget','search_query','function_entrance'置空，切为qa替换称q_a
                         CASE
                             WHEN TRIM(GET_JSON_OBJECT(RESULT_CARD,
                                                       "$.card_content_type")) IN
                                  ('banner',
                                   'static_banner' 'icon',
                                   'gadget',
                                   'search_query',
                                   'function_entrance') THEN
                                 NULL
                             WHEN TRIM(GET_JSON_OBJECT(RESULT_CARD,
                                                       "$.card_content_type")) = 'qa' THEN
                                 'q_a'
                             ELSE
                                 IF(TRIM(GET_JSON_OBJECT(RESULT_CARD,
                                                         "$.card_content_type")) = '',
                                    NULL,
                                    TRIM(GET_JSON_OBJECT(RESULT_CARD,
                                                         "$.card_content_type")))
                             END AS CARD_CONTENT_TYPE, --card_content_type为'banner','icon','gadget','search_query','function_entrance' card_type取值为card_content_type
                         --切当card_content_type为search_query时card_type为search_word
                         CASE
                             WHEN TRIM(GET_JSON_OBJECT(RESULT_CARD,
                                                       "$.card_content_type")) IN
                                  ('static_banner',
                                   'icon',
                                   'gadget',
                                   'function_entrance') THEN
                                 IF(TRIM(GET_JSON_OBJECT(RESULT_CARD,
                                                         "$.card_content_type")) = '',
                                    NULL,
                                    TRIM(GET_JSON_OBJECT(RESULT_CARD,
                                                         "$.card_content_type")))
                             WHEN TRIM(GET_JSON_OBJECT(RESULT_CARD,
                                                       "$.card_content_type")) =
                                  'search_query' THEN
                                 'search_word'
                             WHEN TRIM(GET_JSON_OBJECT(RESULT_CARD,
                                                       "$.card_content_type")) =
                                  'banner' THEN
                                 'common_banner'
                             WHEN TRIM(GET_JSON_OBJECT(RESULT_CARD,
                                                       "$.card_type")) =
                                  'card' THEN
                                 'common_card'
                             WHEN TRIM(GET_JSON_OBJECT(RESULT_CARD,
                                                       "$.card_type")) =
                                  'video' THEN
                                 'video_card'
                             ELSE
                                 IF(TRIM(GET_JSON_OBJECT(RESULT_CARD,
                                                         "$.card_type")) = '',
                                    NULL,
                                    TRIM(GET_JSON_OBJECT(RESULT_CARD,
                                                         "$.card_type")))
                             END AS CARD_TYPE, --当版本为7.7.35和7.7.36的时候相对位置转换成绝对位置
                         CASE
                             WHEN T1.DEVICE_TYPE = 'android' AND
                                  T1.APP_VERSION IN ('7.7.35', '7.7.36') THEN
                                 IF(TRIM(GET_JSON_OBJECT(RESULT_CARD,
                                                         "$.relative_position")) = '',
                                    NULL,
                                    TRIM(GET_JSON_OBJECT(RESULT_CARD,
                                                         "$.relative_position")))
                             ELSE
                                 IF(TRIM(GET_JSON_OBJECT(RESULT_CARD,
                                                         "$.absolute_position")) = '',
                                    NULL,
                                    TRIM(GET_JSON_OBJECT(RESULT_CARD,
                                                         "$.absolute_position")))
                             END AS ABSOLUTE_POSITION, --当版本为7.7.35和7.7.36的时候绝对位置转换成相对位置
                         CASE
                             WHEN T1.DEVICE_TYPE = 'android' AND
                                  T1.APP_VERSION IN ('7.7.35', '7.7.36') THEN
                                 IF(TRIM(GET_JSON_OBJECT(RESULT_CARD,
                                                         "$.absolute_position")) = '',
                                    NULL,
                                    TRIM(GET_JSON_OBJECT(RESULT_CARD,
                                                         "$.absolute_position")))
                             ELSE
                                 IF(TRIM(GET_JSON_OBJECT(RESULT_CARD,
                                                         "$.relative_position")) = '',
                                    NULL,
                                    TRIM(GET_JSON_OBJECT(RESULT_CARD,
                                                         "$.relative_position")))
                             END AS RELATIVE_POSITION, --result_status先取exposure_cards 再选params
                         CASE
                             WHEN IF(TRIM(GET_JSON_OBJECT(RESULT_CARD,
                                                          "$.result_status")) = '',
                                     NULL,
                                     TRIM(GET_JSON_OBJECT(RESULT_CARD,
                                                          "$.result_status"))) IS NULL AND
                                  IF(TRIM(GET_JSON_OBJECT(TO_JSON(T1.PARAMS),
                                                          "$.result_status")) = '',
                                     NULL,
                                     TRIM(GET_JSON_OBJECT(TO_JSON(T1.PARAMS),
                                                          "$.result_status"))) IS NOT NULL THEN
                                 IF(TRIM(GET_JSON_OBJECT(TO_JSON(T1.PARAMS),
                                                         "$.result_status")) = '',
                                    NULL,
                                    TRIM(GET_JSON_OBJECT(TO_JSON(T1.PARAMS),
                                                         "$.result_status")))
                             ELSE
                                 IF(TRIM(GET_JSON_OBJECT(RESULT_CARD,
                                                         "$.result_status")) = '',
                                    NULL,
                                    TRIM(GET_JSON_OBJECT(RESULT_CARD,
                                                         "$.result_status")))
                             END AS RESULT_STATUS, --filter和filer_f的参数统一
                         CASE
                             WHEN T1.PARAMS_FILTER IS NOT NULL AND
                                  IF(TRIM(GET_JSON_OBJECT(RESULT_CARD,
                                                          "$.filter_f")) = '',
                                     NULL,
                                     TRIM(GET_JSON_OBJECT(RESULT_CARD,
                                                          "$.filter_f"))) IS NULL THEN
                                 T1.PARAMS_FILTER
                             WHEN T1.PARAMS_FILTER IS NULL AND
                                  IF(TRIM(GET_JSON_OBJECT(RESULT_CARD,
                                                          "$.filter_f")) = '',
                                     NULL,
                                     TRIM(GET_JSON_OBJECT(RESULT_CARD,
                                                          "$.filter_f"))) IS NULL THEN
                                 NULL
                             ELSE
                                 IF(TRIM(GET_JSON_OBJECT(RESULT_CARD,
                                                         "$.filter_f")) = '',
                                    NULL,
                                    TRIM(GET_JSON_OBJECT(RESULT_CARD,
                                                         "$.filter_f")))
                             END AS FILTER, --if(trim(get_json_object(result_card,"$.filter_f"))='',NULL,trim(get_json_object(result_card,"$.filter_f"))) as filter_f,
                         IF(TRIM(GET_JSON_OBJECT(RESULT_CARD, "$.is_cpc")) = '',
                            NULL,
                            TRIM(GET_JSON_OBJECT(RESULT_CARD, "$.is_cpc"))) AS IS_CPC,
                         IF(TRIM(GET_JSON_OBJECT(RESULT_CARD,
                                                 "$.cpc_referer")) = '',
                            NULL,
                            TRIM(GET_JSON_OBJECT(RESULT_CARD,
                                                 "$.cpc_referer"))) AS CPC_REFERER,
                         IF(TRIM(GET_JSON_OBJECT(RESULT_CARD,
                                                 "$.in_page_pos")) = '',
                            NULL,
                            TRIM(GET_JSON_OBJECT(RESULT_CARD,
                                                 "$.in_page_pos"))) AS IN_PAGE_POS,
                         IF(TRIM(GET_JSON_OBJECT(RESULT_CARD,
                                                 "$.sec_tab_name")) = '',
                            NULL,
                            TRIM(GET_JSON_OBJECT(RESULT_CARD,
                                                 "$.sec_tab_name"))) AS SEC_TAB_NAME, --二级页面名称
                         --非正常卡片通用参数（banner 豆腐块 icon）
                         IF(TRIM(GET_JSON_OBJECT(RESULT_CARD,
                                                 "$.module_id")) = '',
                            NULL,
                            TRIM(GET_JSON_OBJECT(RESULT_CARD,
                                                 "$.module_id"))) AS MODULE_ID, --模块id
                         --target_name与card_name的参数统一
                         CASE
                             WHEN IF(TRIM(GET_JSON_OBJECT(RESULT_CARD,
                                                          "$.card_name ")) = '',
                                     NULL,
                                     TRIM(GET_JSON_OBJECT(RESULT_CARD,
                                                          "$.card_name "))) IS NULL AND
                                  IF(TRIM(GET_JSON_OBJECT(RESULT_CARD,
                                                          "$.target_name")) = '',
                                     NULL,
                                     TRIM(GET_JSON_OBJECT(RESULT_CARD,
                                                          "$.target_name"))) IS NOT NULL THEN
                                 IF(TRIM(GET_JSON_OBJECT(RESULT_CARD,
                                                         "$.target_name")) = '',
                                    NULL,
                                    TRIM(GET_JSON_OBJECT(RESULT_CARD,
                                                         "$.target_name")))
                             WHEN IF(TRIM(GET_JSON_OBJECT(RESULT_CARD,
                                                          "$.card_name ")) = '',
                                     NULL,
                                     TRIM(GET_JSON_OBJECT(RESULT_CARD,
                                                          "$.card_name "))) IS NULL AND
                                  IF(TRIM(GET_JSON_OBJECT(RESULT_CARD,
                                                          "$.target_name")) = '',
                                     NULL,
                                     TRIM(GET_JSON_OBJECT(RESULT_CARD,
                                                          "$.target_name"))) IS NULL THEN
                                 NULL
                             ELSE
                                 IF(TRIM(GET_JSON_OBJECT(RESULT_CARD,
                                                         "$.card_name ")) = '',
                                    NULL,
                                    TRIM(GET_JSON_OBJECT(RESULT_CARD,
                                                         "$.card_name ")))
                             END AS CARD_NAME,
                         IF(TRIM(GET_JSON_OBJECT(RESULT_CARD, "$.url")) = '',
                            NULL,
                            TRIM(GET_JSON_OBJECT(RESULT_CARD, "$.url"))) AS URL, --跳转链接
                         --豆腐块额外参数
                         IF(TRIM(GET_JSON_OBJECT(RESULT_CARD,
                                                 "$.module_type")) = '',
                            NULL,
                            TRIM(GET_JSON_OBJECT(RESULT_CARD,
                                                 "$.module_type"))) AS MODULE_TYPE, --模块类型
                         IF(TRIM(GET_JSON_OBJECT(RESULT_CARD, "$.grid")) = '',
                            NULL,
                            TRIM(GET_JSON_OBJECT(RESULT_CARD, "$.grid"))) AS GRID, --区域 （a、b、c、d，目前线上最多四张图片）
                         --icon的额外参数
                         IF(TRIM(GET_JSON_OBJECT(RESULT_CARD,
                                                 "$.total_position")) = '',
                            NULL,
                            TRIM(GET_JSON_OBJECT(RESULT_CARD,
                                                 "$.total_position"))) AS TOTAL_POSITION, --总共有几屏
                         IF(TRIM(GET_JSON_OBJECT(RESULT_CARD,
                                                 "$.current_position")) = '',
                            NULL,
                            TRIM(GET_JSON_OBJECT(RESULT_CARD,
                                                 "$.current_position"))) AS CURRENT_POSITION, --icon在第几屏
                         --百科卡片独有的参数
                         IF(TRIM(GET_JSON_OBJECT(RESULT_CARD,
                                                 "$.wiki_word")) = '',
                            NULL,
                            TRIM(GET_JSON_OBJECT(RESULT_CARD,
                                                 "$.wiki_word"))) AS WIKI_WORD --wiki关键字

                  FROM (SELECT T.JSON,
                               T.GM_NGINX_KEY,
                               T.VERSION,
                               T.PARAMS,
                               T.APP_SESSION_ID,
                               T.GM_NGINX_TIMESTAMP,
                               T.CREATE_TIMESTAMP,
                               T.APP,
                               T.DEVICE,
                               T.USER_ID,
                               T.TYPE,
                               T.PARAMS_DOWN_LOADING_TIMES,
                               T.PARAMS_DOWN_SLIDE_TIMES,
                               T.PARAMS_UP_LOADING_TIMES,
                               T.PARAMS_UP_SLIDE_TIMES,
                               T.PARAMS_PAGE_NAME,
                               IF(T.PARAMS_PAGE_NAME RLIKE
                                  'search_result_',
                                  NULL,
                                  T.PARAMS_TAB_NAME) AS PARAMS_TAB_NAME,
                               T.PARAMS_BUSINESS_ID,
                               T.PARAMS_REFERRER,
                               T.PARAMS_REFERRER_ID,
                               T.PARAMS_EXPOSURE_CARDS,
                               STRING(T.PARAMS_IS_EXPOSURE) PARAMS_IS_EXPOSURE,
                               T.PARAMS_FILTER,
                               T.PARAMS_QUERY,
                               T.APP_GREY_TYPE,
                               T.APP_CHANNEL,
                               T.APP_VERSION,
                               T.APP_SERIAL_ID,
                               T.APP_CURRENT_CITY_ID,
                               T.APP_NAME,
                               T.APP_USER_TYPE,
                               T.DEVICE_IS_WIFI,
                               T.DEVICE_TYPE,
                               T.DEVICE_MODEL,
                               T.DEVICE_SYS_VERSION,
                               T.DEVICE_NET_TYPE,
                               T.DEVICE_ID,
                               T.DEVICE_ANDROID_ID,
                               T.DEVICE_LNG,
                               T.DEVICE_LAT,
                               T.DEVICE_IP,
                               T.DEVICE_MANUFACTURER,
                               T.DEVICE_IDFV,
                               T.DEVICE_IDFA,
                               T.GM_NGINX_TIME_DATE,
                               T.GM_NGINX_TIME_DAY,
                               T.CREATE_TIME_DATE,
                               T.CREATE_TIME_DAY
                        FROM BL.BL_ET_MG_PRECISEEXPOSURE_INC_D T
                        WHERE T.PARTITION_DAY = '${partition_day}'
                          AND STRING(T.PARAMS_IS_EXPOSURE) = '1'
                          AND (CASE
                                   WHEN ((INT(SPLIT(T.APP_VERSION, '\\.') [ 0 ]) = 7 AND
                                          INT(SPLIT(T.APP_VERSION, '\\.') [ 1 ]) = 7 AND
                                          INT(SPLIT(T.APP_VERSION, '\\.') [ 2 ]) >= 70) OR
                                         (INT(SPLIT(T.APP_VERSION, '\\.') [ 0 ]) = 7 AND
                                          INT(SPLIT(T.APP_VERSION, '\\.') [ 1 ]) = 8)) AND
                                        T.PARAMS_PAGE_NAME = 'home' THEN
                                           T.PARAMS_PAGE_NAME <> 'home'
                                   WHEN T.PARAMS_PAGE_NAME = 'category' AND
                                        (INT(SPLIT(T.APP_VERSION, '\\.') [ 0 ]) = 7 AND
                                         INT(SPLIT(T.APP_VERSION, '\\.') [ 1 ]) < 14) THEN
                                           T.PARAMS_PAGE_NAME <> 'category'
                                   ELSE
                                           1 = 1
                            END)) T1 LATERAL VIEW EXPLODE(T1.PARAMS_EXPOSURE_CARDS) CARD AS RESULT_CARD) T2 LATERAL VIEW POSEXPLODE(T2.CARD_ID_LIST) CARD1 AS POS,
                                                                                                                                                              CARD_ID) T3 --美购 card_id = service_id

               LEFT JOIN (SELECT T.SERVICE_ID, T.DOCTOR_ID
                          FROM BL.BL_PT_SV_SERVICEINFO_D T
                          WHERE T.PARTITION_DAY = '${partition_day}') T4
                         ON T3.CARD_ID = T4.SERVICE_ID --医院 card_id=hospital_id

               LEFT JOIN (SELECT T.DOCTOR_ID,
                                 T.DOCTOR_TYPE,
                                 T.HOSPITAL_ID,
                                 T.BUSINESS_PARTNER_ID
                          FROM BL.BL_CT_DT_DOCTORINFO_D T
                          WHERE T.PARTITION_DAY = '${partition_day}'
                            AND DOCTOR_TYPE = '1') T5
                         ON T3.CARD_ID = T5.HOSPITAL_ID --日记本 card_id=diary_id

               LEFT JOIN (SELECT T.DIARY_ID, T.ORIGINAL_DOCTOR_ID AS DOCTOR_ID
                          FROM BL.BL_OP_CO_DIARYINFO_D T
                          WHERE T.PARTITION_DAY = '${partition_day}') T6
                         ON T3.CARD_ID = T6.DIARY_ID --日记贴 card_id=topic_id

               LEFT JOIN (SELECT T7_1.TOPIC_ID, T7_2.DOCTOR_ID
                          FROM (SELECT T.TOPIC_ID, T.DIARY_ID
                                FROM BL.BL_OP_CO_TOPICINFO_D T
                                WHERE T.PARTITION_DAY = '${partition_day}'
                                  AND T.TABLE_TYPE IN ('topic', 'article')) T7_1
                                   LEFT JOIN (SELECT T.DIARY_ID,
                                                     T.ORIGINAL_DOCTOR_ID AS DOCTOR_ID
                                              FROM BL.BL_OP_CO_DIARYINFO_D T
                                              WHERE T.PARTITION_DAY = '${partition_day}') T7_2
                                             ON T7_1.DIARY_ID = T7_2.DIARY_ID) T7
                         ON T3.CARD_ID = T7.TOPIC_ID) T8
         LEFT JOIN (SELECT T.DOCTOR_ID           AS DOCTOR_ID,
                           T.DOCTOR_TYPE         AS DOCTOR_TYPE,
                           T.HOSPITAL_ID         AS HOSPITAL_ID,
                           T.BUSINESS_PARTNER_ID AS BUSINESS_PARTNER_ID
                    FROM BL.BL_CT_DT_DOCTORINFO_D T
                    WHERE T.PARTITION_DAY = '${partition_day}') T9
                   ON T8.DOCTOR_ID = T9.DOCTOR_ID
         LEFT JOIN (SELECT T.DOCTOR_ID AS DOCTOR_ID, T.MERCHANT_ID AS MERCHANT_ID
                    FROM BL.BL_CT_MC_MERCHANTDOCTORRELATION_D T
                    WHERE T.PARTITION_DAY = '${partition_day}') T10
                   ON T9.DOCTOR_ID = T10.DOCTOR_ID
         LEFT JOIN (SELECT T.MERCHANT_ID AS MERCHANT_ID,
                           T.DOCTOR_ID   AS MERCHANT_DOCTOR_ID
                    FROM BL.BL_CT_MC_MERCHANTINFO_D T
                    WHERE T.PARTITION_DAY = '${partition_day}') T11
                   ON T10.MERCHANT_ID = T11.MERCHANT_ID
         LEFT JOIN (SELECT T.CODE, T.NEW_CODE
                    FROM DIM.DIM_PAGE_POSITION_TRANSFORM T) T12
                   ON T8.PAGE_POSITION = T12.CODE;