package com.gmei.cache;

import com.gmei.bean.dim.DimCity;
import com.gmei.bean.dim.DimPageType;
import com.gmei.bean.dim.DimTable;
import com.gmei.utils.DimTableList;
import org.junit.Test;

import java.util.ArrayList;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;

public class DimTableDaoTest {

    @Test
    public void findAllDimTableTest() {
//        DimTableDao dimTableDao = new DimTableDao();
//        ArrayList<DimTable> dimTableList;
//        try {
//            dimTableList = dimTableDao.findAllDimTable("dim_city");
//            for (DimTable dimTable : dimTableList)
//            System.out.println(dimTable);
//        } catch (Exception e) {
//            e.printStackTrace();
//        }

        SimpleCacheService<String, DimCity> dimCityCache = null;
        DimTableCallable dimTableCallable = new DimTableCallable(null, DimTableList.DIM_CITY.getTableName(), null);
        ExecutorService es = Executors.newFixedThreadPool(2);
        Future future = es.submit(dimTableCallable);
        try {
            ArrayList<DimCity> dimCityList = (ArrayList<DimCity>) future.get();
            for (DimCity dimCity : dimCityList) {
                System.out.println(dimCity);
            }
        } catch (InterruptedException e) {
            e.printStackTrace();
        } catch (ExecutionException e) {
            e.printStackTrace();
        }
    }

    @Test
    public void findDimTableByCodeTest() {
//        DimTableDao dimTableDao = new DimTableDao();
//        DimTable dimTable;
//        try {
//            dimTable = dimTableDao.findDimTableByCode("dim_city", "beijing");
//            System.out.println(dimTable);
//        } catch (Exception e) {
//            e.printStackTrace();
//        }

        SimpleCacheService<String, DimCity> dimCityCache = null;
        DimTableCallable dimCityCallable = new DimTableCallable("beijing", DimTableList.DIM_CITY.getTableName(), null);
        DimTableCallable dimPageTypeCallable = new DimTableCallable("home", DimTableList.DIM_PAGE_TYPE.getTableName(), null);
        DimTableCallable dimCardContentTypeCallable = new DimTableCallable("diary", DimTableList.DIM_CARD_CONTENT_TYPE.getTableName(), null);
        ExecutorService es = Executors.newFixedThreadPool(3);
        Future future1 = es.submit(dimCityCallable);
        Future future2 = es.submit(dimPageTypeCallable);
        Future future3 = es.submit(dimCardContentTypeCallable);

        System.out.println("start");
        try {
            DimCity dimCity = (DimCity)future1.get();
            DimPageType dimPageType = (DimPageType) future2.get();
            DimTable dimCardContentType = (DimTable)future3.get();
            System.out.println(dimCity);
            System.out.println(dimPageType);
            System.out.println(dimCardContentType);
        } catch (InterruptedException e) {
            e.printStackTrace();
        } catch (ExecutionException e) {
            e.printStackTrace();
        }
    }

    @Test
    public void findCacheTest() {

        SimpleCacheService<String, DimCity> dimCityCache = new SimpleCacheService<>(2000, 24);
        DimTableCallable dimCityCallable = new DimTableCallable("beijing", DimTableList.DIM_CITY.getTableName(), null);
        ExecutorService es = Executors.newFixedThreadPool(2);
        Future future1 = es.submit(dimCityCallable);
        DimCity dimCity = null;
        try {
            dimCity = (DimCity)future1.get();
        } catch (InterruptedException e) {
            e.printStackTrace();
        } catch (ExecutionException e) {
            e.printStackTrace();
        }
//        dimCityCache.putValue("beijing",dimCity);
        DimCity dimCityCacheValue = null;
        try {
            dimCityCacheValue = dimCityCache.getValue("beijing", new DimTableCallable<DimCity>("beijing", DimTableList.DIM_CITY.getTableName(), null));
        } catch (Exception e) {
            dimCityCacheValue = null;
            e.printStackTrace();
        }
        System.out.println(dimCityCacheValue);

//        ExecutorService es = Executors.newFixedThreadPool(2);
//        Future future = es.submit(dimTableCallable);
//        System.out.println("start");
//        try {
//            DimCity dimCity = (DimCity)future.get();
//            System.out.println(dimCity);
//        } catch (InterruptedException e) {
//            e.printStackTrace();
//        } catch (ExecutionException e) {
//            e.printStackTrace();
//        }
    }

}
