package com.gmei.etl;

import com.gmei.bean.bl.BlPreciseExposureBean;
import com.gmei.bean.bl.BlPreciseExposureParamsExposureCardsBean;
import com.gmei.bean.dim.DimCity;
import com.gmei.bean.ml.MlPreciseExposureBean;
import com.gmei.cache.SimpleCacheService;
import com.gmei.jdbc.MysqlJdbcDim;
import com.gmei.utils.BeanReflectUtil;
import org.junit.Test;

import java.io.Serializable;
import java.sql.Connection;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

/**
 * ClassName: BlPreciseExposureEtl
 * Function: TODO ADD FUNCTION.
 * Reason: TODO ADD REASON.
 * Date: 2019/12/4 下午4:58
 *
 * @author liuzhe
 * @since JDK 1.8
 */
public class MlPreciseExposureEtl implements Serializable {

    /**
    * Function: flatmapMlPreciseExposureBean
    * Reason: 数据一对多
    * Date: 2019/12/7 下午7:57
    *
    * @author liuzhe
    * @since JDK 1.8
    */
    public ArrayList<MlPreciseExposureBean> flatmapMlPreciseExposureBean (BlPreciseExposureBean blPreciseExposureBean) throws Exception {
        ArrayList<BlPreciseExposureParamsExposureCardsBean> exposure_cards = blPreciseExposureBean.getExposure_cards();
        String app_version = blPreciseExposureBean.getApp_version();
        String device_os_type = blPreciseExposureBean.getDevice_os_type();
        ArrayList<MlPreciseExposureBean> mlPreciseExposureBeanList = new ArrayList<>();
        for(BlPreciseExposureParamsExposureCardsBean exposureCardsBean: exposure_cards) {
            String card_id = exposureCardsBean.getCard_id();
            String card_content_type = exposureCardsBean.getCard_content_type();
            String card_type = exposureCardsBean.getCard_type();
            String is_cpc = exposureCardsBean.getIs_cpc();
            String cpc_referer = exposureCardsBean.getCpc_referer();
            String absolute_position = exposureCardsBean.getAbsolute_position();
            String relative_position = exposureCardsBean.getRelative_position();
            String transaction_type = exposureCardsBean.getTransaction_type();

            //1.3 绝对位置和相对位置位置错误
            //问题描述：在'7.7.35','7.7.36' android的绝对位置和相对位置写反
            if("android".equals(device_os_type) && ("7.7.35".equals(app_version) || "7.7.36".equals(app_version))) {
                String change = absolute_position;
                absolute_position = relative_position;
                relative_position = change;
            }

            //1.10 banner、豆腐块、icon、搜索词和功能区入口的card_type参数问题
            //问题描述：当卡片类型为豆腐块、icon、banner、搜索词和功能区入口的时候的时候正确的card_type的参数值被赋给了card_content_type（banner、icon、gadget、search_query、function_entrance）
            List<String> card_content_type_list = Arrays.asList("banner","icon","gadget","search_query","function_entrance");
            if (card_content_type_list.contains(card_content_type)) {
                card_type = card_content_type;
                card_content_type = null;
            }
            if ("search_query".equals(card_content_type)) {
                card_type = "search_word";
            }

            //1.12 card_content_type的qa值应该被换成q_a
            card_content_type = card_content_type.replace("qa","q_a");

            //1.13 target_name与card_name的参数的统一
            //问题描述：将target_name参数的值赋给card_name
            //1.14 百科卡片曝光新增参数wiki_type
            //问题：从7.19.0版本开始，百科卡片曝光,新增了wiki_type参数


            MlPreciseExposureBean mlPreciseExposureBean = new MlPreciseExposureBean();
            mlPreciseExposureBean.setUser_id(blPreciseExposureBean.getUser_id());
            mlPreciseExposureBean.setAction(blPreciseExposureBean.getAction());

            mlPreciseExposureBean.setPage_code(blPreciseExposureBean.getPage_code());

            mlPreciseExposureBean.setTab_name(blPreciseExposureBean.getTab_name());
            mlPreciseExposureBean.setBusiness_id(blPreciseExposureBean.getBusiness_id());
            mlPreciseExposureBean.setReferrer_code(blPreciseExposureBean.getReferrer_code());

            mlPreciseExposureBean.setReferrer_id(blPreciseExposureBean.getReferrer_id());

            mlPreciseExposureBean.setCard_id(card_id);
            mlPreciseExposureBean.setCard_content_type(card_content_type);

            mlPreciseExposureBean.setCard_type(card_type);
            mlPreciseExposureBean.setIs_cpc(is_cpc);
            mlPreciseExposureBean.setCpc_referer(cpc_referer);
//            mlPreciseExposureBean.setAbsolute_position(absolute_position);
//            mlPreciseExposureBean.setRelative_position(relative_position);
            mlPreciseExposureBean.setTransaction_type(transaction_type);

//            mlPreciseExposureBean.setApp_channel(blPreciseExposureBean.getApp_channel());
            mlPreciseExposureBean.setApp_version(blPreciseExposureBean.getApp_version());
            mlPreciseExposureBean.setCurrent_city_id(blPreciseExposureBean.getApp_current_city_id());
            mlPreciseExposureBean.setApp_code(blPreciseExposureBean.getApp_code());
            mlPreciseExposureBean.setDevice_os_type(blPreciseExposureBean.getDevice_os_type());
            mlPreciseExposureBean.setDevice_id(blPreciseExposureBean.getDevice_id());
            mlPreciseExposureBean.setCreate_time_day(blPreciseExposureBean.getCreate_time_day());
            mlPreciseExposureBean.setPreciseexposure_num(1);

            //1.11 transaction_type的空值需要被修正
            //问题描述：transaction_type='' 需要替换为NULL
            mlPreciseExposureBeanList.add(BeanReflectUtil.setNullValue(mlPreciseExposureBean));
        }
        return mlPreciseExposureBeanList;
    }

    /**
     * Function: groupByFields
     * Reason: groupBy字段
     * Date: 2019/12/7 下午7:57
     *
     * @author liuzhe
     * @since JDK 1.8
     */
    public Object groupByFields(MlPreciseExposureBean mlPreciseExposureBean) {
        ArrayList groupByFields = new ArrayList();
        groupByFields.add(mlPreciseExposureBean.getUser_id());
        groupByFields.add(mlPreciseExposureBean.getAction());
        groupByFields.add(mlPreciseExposureBean.getApp_code());
        groupByFields.add(mlPreciseExposureBean.getTab_name());
        groupByFields.add(mlPreciseExposureBean.getBusiness_id());
        groupByFields.add(mlPreciseExposureBean.getReferrer_code());
        groupByFields.add(mlPreciseExposureBean.getReferrer_id());
        groupByFields.add(mlPreciseExposureBean.getCard_id());
        groupByFields.add(mlPreciseExposureBean.getCard_content_type());
        groupByFields.add(mlPreciseExposureBean.getCard_type());
        groupByFields.add(mlPreciseExposureBean.getIs_cpc());
        groupByFields.add(mlPreciseExposureBean.getCpc_referer());
//                groupByFields.add(mlPreciseExposureBean.getAbsolute_position());
//                groupByFields.add(mlPreciseExposureBean.getRelative_position());
        groupByFields.add(mlPreciseExposureBean.getTransaction_type());
        groupByFields.add(mlPreciseExposureBean.getFilter());
        groupByFields.add(mlPreciseExposureBean.getQuery());
//        groupByFields.add(mlPreciseExposureBean.getApp_channel());
        groupByFields.add(mlPreciseExposureBean.getApp_version());
        groupByFields.add(mlPreciseExposureBean.getCurrent_city_id());
        groupByFields.add(mlPreciseExposureBean.getApp_code());
        groupByFields.add(mlPreciseExposureBean.getDevice_os_type());
        groupByFields.add(mlPreciseExposureBean.getDevice_id());
        groupByFields.add(mlPreciseExposureBean.getCreate_time_day());
        return groupByFields;
    }

    public MlPreciseExposureBean leftJoinDimTable(MlPreciseExposureBean mlPreciseExposureBean, String field, Object dim) {
        SimpleCacheService<String, Object> dimCityCache;

//        CityInfo cityInfo = cityInfoCache.getValue(city_id, new CityCallable(city_id));
        dimCityCache = new SimpleCacheService<>(2000, 24);
//        dimCityCache.putValue(code, new DimCity(code, pk, name, memo));

//        Object dimCity = dimCityCache.getValue(field, new DimCityCallable(field, "single"));
//        mlPreciseExposureBean.setCityId2(cityInfo.getCity_id(),cityInfo.getId());

//        BeanReflectUtil.setFieldValue(mlPreciseExposureBean, field, dimCity.getCode());
        return mlPreciseExposureBean;
    }

    private ArrayList<DimCity> findAllCity() throws Exception{
        String sinkJdbcUrl = "";
        MysqlJdbcDim mysqlJdbcDim = MysqlJdbcDim.getInstance(sinkJdbcUrl);
        Connection connection ;
//        connection = mysqlJdbcDim.getConnection();
        String sql = "select code, pk, name, memo from dim_city";
        ArrayList<DimCity> dimCityList = new ArrayList<>();
        ResultSet resultSet = null;
        try {
            resultSet = mysqlJdbcDim.query(sql);
            while (resultSet.next()){
                DimCity dim_city = new DimCity();
                dim_city.setCode(resultSet.getString(0));
                dim_city.setPk(resultSet.getString(1));
                dim_city.setName(resultSet.getString(2));
                dim_city.setMemo(resultSet.getString(3));
                dimCityList.add(dim_city);
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
        resultSet.close();
        return dimCityList;
    }

    @Test
    public void flatmapMlPreciseExposureBeanTest() {
        BlPreciseExposureEtl blPreciseExposureEtl = new BlPreciseExposureEtl();
        MlPreciseExposureEtl mlPreciseExposureEtl = new MlPreciseExposureEtl();

//        String json = "{\"create_at\":\"1575134961\",\"gm_nginx_timestamp\":1575134961.718,\"user_id\":\"31665831\",\"version\":\"110\",\"params\":{\"down_loading_times\":0,\"up_slide_times\":0,\"is_popup\":\"0\",\"exposure_cards\":[{\"absolute_position\":\"0\",\"transaction_type\":\"\",\"card_content_type\":\"function_entrance\",\"relative_position\":\"0\",\"card_id\":2},{\"absolute_position\":\"1\",\"transaction_type\":\"\",\"card_content_type\":\"function_entrance\",\"relative_position\":\"1\",\"card_id\":2},{\"absolute_position\":\"2\",\"transaction_type\":\"\",\"card_content_type\":\"function_entrance\",\"relative_position\":\"2\",\"card_id\":2},{\"absolute_position\":\"3\",\"transaction_type\":\"\",\"card_content_type\":\"function_entrance\",\"relative_position\":\"3\",\"card_id\":2},{\"absolute_position\":\"4\",\"transaction_type\":\"\",\"card_content_type\":\"function_entrance\",\"relative_position\":\"4\",\"card_id\":2}],\"tab_name\":\"\",\"down_slide_times\":0,\"page_name\":\"home\",\"up_loading_times\":0,\"is_exposure\":\"1\",\"referrer\":\"\",\"business_id\":\"\",\"referrer_id\":\"\"},\"app_session_id\":\"FE675C8B-4FD4-4FC6-9EC7-415F715A750B\",\"app\":{\"version\":\"7.18.2\",\"grey_type\":\"{\\\"report_result\\\":0,\\\"face_detect_result\\\":\\\"B\\\",\\\"home\\\":\\\"0\\\",\\\"post_detail\\\":\\\"0\\\",\\\"video_steep\\\":1,\\\"face_scan\\\":0}\",\"current_city_id\":\"nanjing\",\"name\":\"gengmei_user\",\"user_type\":{\"config_type\":1},\"serial_id\":12,\"channel\":\"AppStore\"},\"gm_nginx_key\":1,\"device\":{\"idfv\":\"5F193A07-781F-4EF1-86B4-452251307081\",\"sys_version\":\"13.2.3\",\"lng\":118.93133562169,\"is_WiFi\":\"0\",\"manufacturer\":\"Apple\",\"device_id\":\"F88745FE-DF54-4639-B7E2-28554C7DFAAF\",\"device_type\":\"ios\",\"ip\":\"10.190.42.125\",\"idfa\":\"F88745FE-DF54-4639-B7E2-28554C7DFAAF\",\"lat\":32.121287439102,\"model\":\"iPhone8,2\"},\"type\":\"page_precise_exposure\"}";
//        String json = "{\"gm_nginx_key\":1,\"version\":\"205\",\"params\":{\"up_slide_times\":\"2\",\"down_loading_times\":\"0\",\"exposure_cards\":\"[{\\\"card_id\\\":\\\"16449302\\\",\\\"card_source_type\\\":\\\"doris\\\",\\\"card_content_type\\\":\\\"diary\\\",\\\"card_type\\\":\\\"card\\\",absolute_position\\\":\\\"0\\\",\\\"relative_position\\\":\\\"0\\\"}]\",\"up_loading_times\":\"0\",\"is_exposure\":\"1\",\"tab_name\":\"精选\",\"page_name\":\"home\",\"business_id\":\"\",\"referrer\":\"\",\"referrer_id\":\"\",\"down_slide_times\":\"1\"},\"app_session_id\":\"f3d24a27-27f0-4545-b132-51030765cf49\",\"gm_nginx_timestamp\":1546307958.444,\"create_at\":\"1546307958\",\"type\":\"home_choiceness_card_exposure\",\"device\":{\"is_WiFi\":\"1\",\"ip\":\"192.168.1.100\",\"manufacturer\":\"vivo\",\"device_type\":\"android\",\"lat\":\"0.0\",\"device_id\":\"863208034156179\",\"lng\":\"0.0\"},\"app\":{\"channel\":\"vivo\",\"user_type\":{\"config_type\":\"1\"},\"serial_id\":6,\"current_city_id\":\"worldwide\",\"name\":\"gengmei_user\",\"version\":\"7.7.36\"},\"user_id\":\"\"}";
        String json = "{\"create_at\":\"1575135041\",\"gm_nginx_timestamp\":1575135040.498,\"user_id\":\"\",\"version\":\"147\",\"params\":{\"down_loading_times\":0,\"up_slide_times\":6,\"is_exposure\":\"1\",\"exposure_cards\":[{\"absolute_position\":0,\"relative_position\":0,\"card_type\":\"card\",\"wiki_word\":[\"项目档案:1\",\"手术锦囊:2\",\"相近项目:3\"],\"card_content_type\":\"qa\",\"card_id\":\"7\"},{\"cpc_referer\":\"1\",\"relative_position\":0,\"transaction_type\":\"\",\"card_type\":\"card\",\"absolute_position\":0,\"card_content_type\":\"answer\",\"card_id\":\"684889\"},{\"cpc_referer\":\"1\",\"relative_position\":1,\"transaction_type\":\"\",\"card_type\":\"card\",\"absolute_position\":1,\"card_content_type\":\"answer\",\"card_id\":\"692624\"},{\"cpc_referer\":\"1\",\"relative_position\":2,\"is_cpc\":0,\"transaction_type\":\"-1\",\"card_type\":\"card\",\"absolute_position\":2,\"card_content_type\":\"user_post\",\"card_id\":66263},{\"cpc_referer\":\"1\",\"relative_position\":3,\"is_cpc\":0,\"transaction_type\":\"-1\",\"card_type\":\"card\",\"absolute_position\":3,\"card_content_type\":\"user_post\",\"card_id\":70670},{\"cpc_referer\":\"1\",\"relative_position\":4,\"is_cpc\":0,\"transaction_type\":\"-1\",\"card_type\":\"card\",\"absolute_position\":4,\"card_content_type\":\"diary\",\"card_id\":15329391},{\"cpc_referer\":\"1\",\"relative_position\":4,\"transaction_type\":\"\",\"card_type\":\"card\",\"absolute_position\":5,\"card_content_type\":\"article\",\"card_id\":\"19507071\"},{\"cpc_referer\":\"1\",\"relative_position\":5,\"transaction_type\":\"\",\"card_type\":\"card\",\"absolute_position\":6,\"card_content_type\":\"answer\",\"card_id\":\"518138\"},{\"cpc_referer\":\"1\",\"relative_position\":4,\"transaction_type\":\"\",\"card_type\":\"card\",\"absolute_position\":7,\"card_content_type\":\"answer\",\"card_id\":\"684319\"},{\"cpc_referer\":\"1\",\"relative_position\":5,\"is_cpc\":0,\"transaction_type\":\"-1\",\"card_type\":\"card\",\"absolute_position\":8,\"card_content_type\":\"user_post\",\"card_id\":69002}],\"tab_name\":\"综合\",\"down_slide_times\":0,\"query\":\"纹眉\",\"filter\":\"\",\"referrer_id\":\"\",\"referrer\":\"search_home\",\"up_loading_times\":0,\"business_id\":\"\",\"page_name\":\"search_result_more\"},\"app_session_id\":\"424bcbcf-3b6e-4331-89b3-9fcd0c7bfbaf\",\"app\":{\"version\":\"7.18.4\",\"grey_type\":\"{\\\"video_steep\\\":1,\\\"post_detail\\\":\\\"0\\\",\\\"face_detect_result\\\":\\\"B\\\",\\\"home\\\":\\\"0\\\",\\\"face_scan\\\":0,\\\"report_result\\\":0}\",\"current_city_id\":\"chongqing\",\"user_type\":{\"config_type\":\"1\"},\"name\":\"gengmei_user\",\"serial_id\":35,\"channel\":\"huawei\"},\"gm_nginx_key\":1,\"device\":{\"android_device_id\":\"androidid_b49fb6a87b10bad0\",\"sys_version\":\"9\",\"lng\":\"106.618722\",\"is_WiFi\":\"0\",\"lat\":\"29.720561\",\"device_id\":\"861198041466947\",\"manufacturer\":\"HUAWEI\",\"net_type\":\"4G\",\"device_type\":\"android\",\"ip\":\"192.168.3.3\",\"model\":\"LYA-AL00\"},\"type\":\"page_precise_exposure\"}";
        BlPreciseExposureBean blPreciseExposureBean = null;
        ArrayList<MlPreciseExposureBean> mlPreciseExposureBeanList;
        Boolean flag = null;
        System.out.println(json);
        try {
            blPreciseExposureBean = blPreciseExposureEtl.mapBlPreciseExposureBean(json);
            mlPreciseExposureBeanList = mlPreciseExposureEtl.flatmapMlPreciseExposureBean(blPreciseExposureBean);
            for (MlPreciseExposureBean mlPreciseExposureBean : mlPreciseExposureBeanList) {
                System.out.println(mlPreciseExposureBean.toString());
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
    }
}
